/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.history.CleanableHistoricCaseInstanceReport;
import org.camunda.bpm.engine.history.CleanableHistoricCaseInstanceReportResult;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class CleanableHistoricCaseInstanceReportServiceTest
extends AbstractRestServiceTest {
    private static final String EXAMPLE_CD_ID = "anId";
    private static final String EXAMPLE_CD_KEY = "aKey";
    private static final String EXAMPLE_CD_NAME = "aName";
    private static final int EXAMPLE_CD_VERSION = 42;
    private static final int EXAMPLE_TTL = 5;
    private static final long EXAMPLE_FINISHED_CI_COUNT = 10L;
    private static final long EXAMPLE_CLEANABLE_CI_COUNT = 5L;
    private static final String EXAMPLE_TENANT_ID = "aTenantId";
    protected static final String ANOTHER_EXAMPLE_CD_ID = "anotherCaseDefId";
    protected static final String ANOTHER_EXAMPLE_CD_KEY = "anotherCaseDefKey";
    protected static final String ANOTHER_EXAMPLE_TENANT_ID = "anotherTenantId";
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORY_URL = "/rest-test/history/case-definition";
    protected static final String HISTORIC_REPORT_URL = "/rest-test/history/case-definition/cleanable-case-instance-report";
    protected static final String HISTORIC_REPORT_COUNT_URL = "/rest-test/history/case-definition/cleanable-case-instance-report/count";
    private CleanableHistoricCaseInstanceReport historicCaseInstanceReport;

    @Before
    public void setUpRuntimeData() {
        this.setupHistoryReportMock();
    }

    private void setupHistoryReportMock() {
        CleanableHistoricCaseInstanceReport report = (CleanableHistoricCaseInstanceReport)Mockito.mock(CleanableHistoricCaseInstanceReport.class);
        Mockito.when((Object)report.caseDefinitionIdIn(new String[]{org.mockito.Matchers.anyString()})).thenReturn((Object)report);
        Mockito.when((Object)report.caseDefinitionKeyIn(new String[]{org.mockito.Matchers.anyString()})).thenReturn((Object)report);
        CleanableHistoricCaseInstanceReportResult reportResult = (CleanableHistoricCaseInstanceReportResult)Mockito.mock(CleanableHistoricCaseInstanceReportResult.class);
        Mockito.when((Object)reportResult.getCaseDefinitionId()).thenReturn((Object)EXAMPLE_CD_ID);
        Mockito.when((Object)reportResult.getCaseDefinitionKey()).thenReturn((Object)EXAMPLE_CD_KEY);
        Mockito.when((Object)reportResult.getCaseDefinitionName()).thenReturn((Object)EXAMPLE_CD_NAME);
        Mockito.when((Object)reportResult.getCaseDefinitionVersion()).thenReturn((Object)42);
        Mockito.when((Object)reportResult.getHistoryTimeToLive()).thenReturn((Object)5);
        Mockito.when((Object)reportResult.getFinishedCaseInstanceCount()).thenReturn((Object)10L);
        Mockito.when((Object)reportResult.getCleanableCaseInstanceCount()).thenReturn((Object)5L);
        Mockito.when((Object)reportResult.getTenantId()).thenReturn((Object)EXAMPLE_TENANT_ID);
        CleanableHistoricCaseInstanceReportResult anotherReportResult = (CleanableHistoricCaseInstanceReportResult)Mockito.mock(CleanableHistoricCaseInstanceReportResult.class);
        Mockito.when((Object)anotherReportResult.getCaseDefinitionId()).thenReturn((Object)ANOTHER_EXAMPLE_CD_ID);
        Mockito.when((Object)anotherReportResult.getCaseDefinitionKey()).thenReturn((Object)ANOTHER_EXAMPLE_CD_KEY);
        Mockito.when((Object)anotherReportResult.getCaseDefinitionName()).thenReturn((Object)"cdName");
        Mockito.when((Object)anotherReportResult.getCaseDefinitionVersion()).thenReturn((Object)33);
        Mockito.when((Object)anotherReportResult.getHistoryTimeToLive()).thenReturn(null);
        Mockito.when((Object)anotherReportResult.getFinishedCaseInstanceCount()).thenReturn((Object)13L);
        Mockito.when((Object)anotherReportResult.getCleanableCaseInstanceCount()).thenReturn((Object)0L);
        Mockito.when((Object)anotherReportResult.getTenantId()).thenReturn((Object)ANOTHER_EXAMPLE_TENANT_ID);
        ArrayList<CleanableHistoricCaseInstanceReportResult> mocks = new ArrayList<CleanableHistoricCaseInstanceReportResult>();
        mocks.add(reportResult);
        mocks.add(anotherReportResult);
        Mockito.when((Object)report.list()).thenReturn(mocks);
        Mockito.when((Object)report.count()).thenReturn((Object)mocks.size());
        this.historicCaseInstanceReport = report;
        Mockito.when((Object)processEngine.getHistoryService().createCleanableHistoricCaseInstanceReport()).thenReturn((Object)this.historicCaseInstanceReport);
    }

    @Test
    public void testGetReport() {
        RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_REPORT_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicCaseInstanceReport});
        ((CleanableHistoricCaseInstanceReport)inOrder.verify((Object)this.historicCaseInstanceReport)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicCaseInstanceReport});
    }

    @Test
    public void testReportRetrieval() {
        Response response = (Response)RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_REPORT_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicCaseInstanceReport});
        ((CleanableHistoricCaseInstanceReport)inOrder.verify((Object)this.historicCaseInstanceReport)).list();
        String content = response.asString();
        List reportResults = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be two report results returned.", (long)2L, (long)reportResults.size());
        Assert.assertNotNull(reportResults.get(0));
        String returnedDefinitionId = JsonPath.from((String)content).getString("[0].caseDefinitionId");
        String returnedDefinitionKey = JsonPath.from((String)content).getString("[0].caseDefinitionKey");
        String returnedDefinitionName = JsonPath.from((String)content).getString("[0].caseDefinitionName");
        int returnedDefinitionVersion = JsonPath.from((String)content).getInt("[0].caseDefinitionVersion");
        int returnedTTL = JsonPath.from((String)content).getInt("[0].historyTimeToLive");
        long returnedFinishedCount = JsonPath.from((String)content).getLong("[0].finishedCaseInstanceCount");
        long returnedCleanableCount = JsonPath.from((String)content).getLong("[0].cleanableCaseInstanceCount");
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        Assert.assertEquals((Object)EXAMPLE_CD_ID, (Object)returnedDefinitionId);
        Assert.assertEquals((Object)EXAMPLE_CD_KEY, (Object)returnedDefinitionKey);
        Assert.assertEquals((Object)EXAMPLE_CD_NAME, (Object)returnedDefinitionName);
        Assert.assertEquals((long)42L, (long)returnedDefinitionVersion);
        Assert.assertEquals((long)5L, (long)returnedTTL);
        Assert.assertEquals((long)10L, (long)returnedFinishedCount);
        Assert.assertEquals((long)5L, (long)returnedCleanableCount);
        Assert.assertEquals((Object)EXAMPLE_TENANT_ID, (Object)returnedTenantId);
    }

    @Test
    public void testMissingAuthorization() {
        String message = "not authorized";
        Mockito.when((Object)this.historicCaseInstanceReport.list()).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)message), new Object[0]).when().get(HISTORIC_REPORT_URL, new Object[0]);
    }

    @Test
    public void testQueryByDefinitionId() {
        RestAssured.given().queryParam("caseDefinitionIdIn", new Object[]{"anId,anotherCaseDefId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_REPORT_URL, new Object[0]);
        ((CleanableHistoricCaseInstanceReport)Mockito.verify((Object)this.historicCaseInstanceReport)).caseDefinitionIdIn(new String[]{EXAMPLE_CD_ID, ANOTHER_EXAMPLE_CD_ID});
        ((CleanableHistoricCaseInstanceReport)Mockito.verify((Object)this.historicCaseInstanceReport)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicCaseInstanceReport});
    }

    @Test
    public void testQueryByDefinitionKey() {
        RestAssured.given().queryParam("caseDefinitionKeyIn", new Object[]{"aKey,anotherCaseDefKey"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_REPORT_URL, new Object[0]);
        ((CleanableHistoricCaseInstanceReport)Mockito.verify((Object)this.historicCaseInstanceReport)).caseDefinitionKeyIn(new String[]{EXAMPLE_CD_KEY, ANOTHER_EXAMPLE_CD_KEY});
        ((CleanableHistoricCaseInstanceReport)Mockito.verify((Object)this.historicCaseInstanceReport)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicCaseInstanceReport});
    }

    @Test
    public void testQueryByTenantId() {
        RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId,anotherTenantId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_REPORT_URL, new Object[0]);
        ((CleanableHistoricCaseInstanceReport)Mockito.verify((Object)this.historicCaseInstanceReport)).tenantIdIn(new String[]{EXAMPLE_TENANT_ID, ANOTHER_EXAMPLE_TENANT_ID});
        ((CleanableHistoricCaseInstanceReport)Mockito.verify((Object)this.historicCaseInstanceReport)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicCaseInstanceReport});
    }

    @Test
    public void testQueryWithoutTenantId() {
        RestAssured.given().queryParam("withoutTenantId", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_REPORT_URL, new Object[0]);
        ((CleanableHistoricCaseInstanceReport)Mockito.verify((Object)this.historicCaseInstanceReport)).withoutTenantId();
        ((CleanableHistoricCaseInstanceReport)Mockito.verify((Object)this.historicCaseInstanceReport)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicCaseInstanceReport});
    }

    @Test
    public void testQueryCompact() {
        RestAssured.given().queryParam("compact", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_REPORT_URL, new Object[0]);
        ((CleanableHistoricCaseInstanceReport)Mockito.verify((Object)this.historicCaseInstanceReport)).compact();
        ((CleanableHistoricCaseInstanceReport)Mockito.verify((Object)this.historicCaseInstanceReport)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicCaseInstanceReport});
    }

    @Test
    public void testFullQuery() {
        RestAssured.given().params(this.getCompleteQueryParameters()).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_REPORT_URL, new Object[0]);
        this.verifyQueryParameterInvocations();
        ((CleanableHistoricCaseInstanceReport)Mockito.verify((Object)this.historicCaseInstanceReport)).list();
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", CoreMatchers.equalTo((Object)2), new Object[0]).when().get(HISTORIC_REPORT_COUNT_URL, new Object[0]);
        ((CleanableHistoricCaseInstanceReport)Mockito.verify((Object)this.historicCaseInstanceReport)).count();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicCaseInstanceReport});
    }

    @Test
    public void testFullQueryCount() {
        RestAssured.given().params(this.getCompleteQueryParameters()).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("count", CoreMatchers.equalTo((Object)2), new Object[0]).when().get(HISTORIC_REPORT_COUNT_URL, new Object[0]);
        this.verifyQueryParameterInvocations();
        ((CleanableHistoricCaseInstanceReport)Mockito.verify((Object)this.historicCaseInstanceReport)).count();
    }

    @Test
    public void testOrderByFinishedCaseInstanceAsc() {
        RestAssured.given().queryParam("sortBy", new Object[]{"finished"}).queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_REPORT_URL, new Object[0]);
        ((CleanableHistoricCaseInstanceReport)Mockito.verify((Object)this.historicCaseInstanceReport)).orderByFinished();
        ((CleanableHistoricCaseInstanceReport)Mockito.verify((Object)this.historicCaseInstanceReport)).asc();
        ((CleanableHistoricCaseInstanceReport)Mockito.verify((Object)this.historicCaseInstanceReport)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicCaseInstanceReport});
    }

    @Test
    public void testOrderByFinishedCaseInstanceDesc() {
        RestAssured.given().queryParam("sortBy", new Object[]{"finished"}).queryParam("sortOrder", new Object[]{"desc"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_REPORT_URL, new Object[0]);
        ((CleanableHistoricCaseInstanceReport)Mockito.verify((Object)this.historicCaseInstanceReport)).orderByFinished();
        ((CleanableHistoricCaseInstanceReport)Mockito.verify((Object)this.historicCaseInstanceReport)).desc();
        ((CleanableHistoricCaseInstanceReport)Mockito.verify((Object)this.historicCaseInstanceReport)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicCaseInstanceReport});
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORIC_REPORT_URL, new Object[0]);
    }

    @Test
    public void testInvalidSortingOptions() {
        this.executeAndVerifySorting("anInvalidSortByOption", "asc", Response.Status.BAD_REQUEST);
        this.executeAndVerifySorting("finished", "anInvalidSortOrderOption", Response.Status.BAD_REQUEST);
    }

    protected void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(HISTORIC_REPORT_URL, new Object[0]);
    }

    protected Map<String, Object> getCompleteQueryParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("caseDefinitionIdIn", "anId,anotherCaseDefId");
        parameters.put("caseDefinitionKeyIn", "aKey,anotherCaseDefKey");
        parameters.put("tenantIdIn", "aTenantId,anotherTenantId");
        parameters.put("withoutTenantId", true);
        parameters.put("compact", true);
        return parameters;
    }

    protected void verifyQueryParameterInvocations() {
        ((CleanableHistoricCaseInstanceReport)Mockito.verify((Object)this.historicCaseInstanceReport)).caseDefinitionIdIn(new String[]{EXAMPLE_CD_ID, ANOTHER_EXAMPLE_CD_ID});
        ((CleanableHistoricCaseInstanceReport)Mockito.verify((Object)this.historicCaseInstanceReport)).caseDefinitionKeyIn(new String[]{EXAMPLE_CD_KEY, ANOTHER_EXAMPLE_CD_KEY});
        ((CleanableHistoricCaseInstanceReport)Mockito.verify((Object)this.historicCaseInstanceReport)).tenantIdIn(new String[]{EXAMPLE_TENANT_ID, ANOTHER_EXAMPLE_TENANT_ID});
        ((CleanableHistoricCaseInstanceReport)Mockito.verify((Object)this.historicCaseInstanceReport)).withoutTenantId();
        ((CleanableHistoricCaseInstanceReport)Mockito.verify((Object)this.historicCaseInstanceReport)).compact();
    }
}

