/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import io.restassured.RestAssured;
import io.restassured.response.Response;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.batch.history.HistoricBatchQuery;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.history.batch.HistoricBatchDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.JsonPathUtil;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class HistoricBatchRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORIC_BATCH_RESOURCE_URL = "/rest-test/history/batch";
    protected static final String HISTORIC_SINGLE_BATCH_RESOURCE_URL = "/rest-test/history/batch/{id}";
    protected HistoryService historyServiceMock;
    protected HistoricBatchQuery queryMock;

    @Before
    public void setUpHistoricBatchQueryMock() {
        HistoricBatch historicBatchMock = MockProvider.createMockHistoricBatch();
        this.queryMock = (HistoricBatchQuery)Mockito.mock(HistoricBatchQuery.class);
        Mockito.when((Object)this.queryMock.batchId((String)org.mockito.Matchers.eq((Object)"aBatchId"))).thenReturn((Object)this.queryMock);
        Mockito.when((Object)this.queryMock.singleResult()).thenReturn((Object)historicBatchMock);
        this.historyServiceMock = (HistoryService)Mockito.mock(HistoryService.class);
        Mockito.when((Object)this.historyServiceMock.createHistoricBatchQuery()).thenReturn((Object)this.queryMock);
        Mockito.when((Object)processEngine.getHistoryService()).thenReturn((Object)this.historyServiceMock);
    }

    @Test
    public void testGetHistoricBatch() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aBatchId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_SINGLE_BATCH_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.queryMock});
        ((HistoricBatchQuery)inOrder.verify((Object)this.queryMock)).batchId("aBatchId");
        ((HistoricBatchQuery)inOrder.verify((Object)this.queryMock)).singleResult();
        inOrder.verifyNoMoreInteractions();
        this.verifyHistoricBatchJson(response.asString());
    }

    @Test
    public void testGetNonExistingHistoricBatch() {
        String nonExistingId = "nonExistingId";
        HistoricBatchQuery historicBatchQuery = (HistoricBatchQuery)Mockito.mock(HistoricBatchQuery.class);
        Mockito.when((Object)historicBatchQuery.batchId(nonExistingId)).thenReturn((Object)historicBatchQuery);
        Mockito.when((Object)historicBatchQuery.singleResult()).thenReturn(null);
        Mockito.when((Object)this.historyServiceMock.createHistoricBatchQuery()).thenReturn((Object)historicBatchQuery);
        RestAssured.given().pathParam("id", (Object)nonExistingId).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)("Historic batch with id '" + nonExistingId + "' does not exist")), new Object[0]).when().get(HISTORIC_SINGLE_BATCH_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void deleteHistoricBatch() {
        RestAssured.given().pathParam("id", (Object)"aBatchId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(HISTORIC_SINGLE_BATCH_RESOURCE_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.historyServiceMock)).deleteHistoricBatch((String)org.mockito.Matchers.eq((Object)"aBatchId"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historyServiceMock});
    }

    @Test
    public void deleteNonExistingHistoricBatch() {
        String nonExistingId = "nonExistingId";
        ((HistoryService)Mockito.doThrow((Throwable)new BadUserRequestException("Historic batch for id '" + nonExistingId + "' cannot be found")).when((Object)this.historyServiceMock)).deleteHistoricBatch((String)org.mockito.Matchers.eq((Object)nonExistingId));
        RestAssured.given().pathParam("id", (Object)nonExistingId).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)("Unable to delete historic batch with id '" + nonExistingId + "'")), new Object[0]).when().delete(HISTORIC_SINGLE_BATCH_RESOURCE_URL, new Object[0]);
    }

    protected void verifyHistoricBatchJson(String historicBatchJson) {
        HistoricBatchDto historicBatch = (HistoricBatchDto)JsonPathUtil.from(historicBatchJson).getObject("", HistoricBatchDto.class);
        Assert.assertNotNull((String)"The returned historic batch should not be null.", (Object)historicBatch);
        Assert.assertEquals((Object)"aBatchId", (Object)historicBatch.getId());
        Assert.assertEquals((Object)"aBatchType", (Object)historicBatch.getType());
        Assert.assertEquals((long)10L, (long)historicBatch.getTotalJobs());
        Assert.assertEquals((long)11L, (long)historicBatch.getBatchJobsPerSeed());
        Assert.assertEquals((long)12L, (long)historicBatch.getInvocationsPerBatchJob());
        Assert.assertEquals((Object)"aSeedJobDefinitionId", (Object)historicBatch.getSeedJobDefinitionId());
        Assert.assertEquals((Object)"aMonitorJobDefinitionId", (Object)historicBatch.getMonitorJobDefinitionId());
        Assert.assertEquals((Object)"aBatchJobDefinitionId", (Object)historicBatch.getBatchJobDefinitionId());
        Assert.assertEquals((Object)"aTenantId", (Object)historicBatch.getTenantId());
        Assert.assertEquals((Object)"userId", (Object)historicBatch.getCreateUserId());
        Assert.assertEquals((Object)DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_BATCH_START_TIME), (Object)historicBatch.getStartTime());
        Assert.assertEquals((Object)DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_BATCH_END_TIME), (Object)historicBatch.getEndTime());
        Assert.assertEquals((Object)DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_BATCH_REMOVAL_TIME), (Object)historicBatch.getRemovalTime());
    }
}

