/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.history.HistoricJobLogQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.OrderingBuilder;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.fest.assertions.Assertions;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class HistoricJobLogRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORIC_JOB_LOG_RESOURCE_URL = "/rest-test/history/job-log";
    protected static final String HISTORIC_JOB_LOG_COUNT_RESOURCE_URL = "/rest-test/history/job-log/count";
    protected static final long JOB_LOG_QUERY_MAX_PRIORITY = Long.MAX_VALUE;
    protected static final long JOB_LOG_QUERY_MIN_PRIORITY = Long.MIN_VALUE;
    protected HistoricJobLogQuery mockedQuery;

    @Before
    public void setUpRuntimeData() {
        this.mockedQuery = this.setUpMockHistoricJobLogQuery(MockProvider.createMockHistoricJobLogs());
    }

    protected HistoricJobLogQuery setUpMockHistoricJobLogQuery(List<HistoricJobLog> mockedHistoricJogLogs) {
        HistoricJobLogQuery mockedhistoricJobLogQuery = (HistoricJobLogQuery)Mockito.mock(HistoricJobLogQuery.class);
        Mockito.when((Object)mockedhistoricJobLogQuery.list()).thenReturn(mockedHistoricJogLogs);
        Mockito.when((Object)mockedhistoricJobLogQuery.count()).thenReturn((Object)mockedHistoricJogLogs.size());
        Mockito.when((Object)processEngine.getHistoryService().createHistoricJobLogQuery()).thenReturn((Object)mockedhistoricJobLogQuery);
        return mockedhistoricJobLogQuery;
    }

    @Test
    public void testEmptyQuery() {
        String queryKey = "";
        RestAssured.given().queryParam("processDefinitionKey", new Object[]{queryKey}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_JOB_LOG_RESOURCE_URL, new Object[0]);
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testNoParametersQuery() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_JOB_LOG_RESOURCE_URL, new Object[0]);
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testNoParametersQueryAsPost() {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_JOB_LOG_RESOURCE_URL, new Object[0]);
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testInvalidSortingOptions() {
        this.executeAndVerifySorting("anInvalidSortByOption", "asc", Response.Status.BAD_REQUEST);
        this.executeAndVerifySorting("definitionId", "anInvalidSortOrderOption", Response.Status.BAD_REQUEST);
    }

    protected void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(HISTORIC_JOB_LOG_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"processDefinitionId"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORIC_JOB_LOG_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORIC_JOB_LOG_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSortingParameters() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("timestamp", "asc", Response.Status.OK);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByTimestamp();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("timestamp", "desc", Response.Status.OK);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByTimestamp();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("jobId", "asc", Response.Status.OK);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByJobId();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("jobId", "desc", Response.Status.OK);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByJobId();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("jobDefinitionId", "asc", Response.Status.OK);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByJobDefinitionId();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("jobDefinitionId", "desc", Response.Status.OK);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByJobDefinitionId();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("jobDueDate", "asc", Response.Status.OK);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByJobDueDate();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("jobDueDate", "desc", Response.Status.OK);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByJobDueDate();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("jobRetries", "asc", Response.Status.OK);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByJobRetries();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("jobRetries", "desc", Response.Status.OK);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByJobRetries();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("activityId", "asc", Response.Status.OK);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByActivityId();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("activityId", "desc", Response.Status.OK);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByActivityId();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("executionId", "asc", Response.Status.OK);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByExecutionId();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("executionId", "desc", Response.Status.OK);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByExecutionId();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processInstanceId", "asc", Response.Status.OK);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceId();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processInstanceId", "desc", Response.Status.OK);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceId();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processDefinitionId", "asc", Response.Status.OK);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionId();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processDefinitionId", "desc", Response.Status.OK);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionId();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processDefinitionKey", "asc", Response.Status.OK);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionKey();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processDefinitionKey", "desc", Response.Status.OK);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionKey();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("deploymentId", "asc", Response.Status.OK);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByDeploymentId();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("deploymentId", "desc", Response.Status.OK);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByDeploymentId();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("occurrence", "asc", Response.Status.OK);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderPartiallyByOccurrence();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("occurrence", "desc", Response.Status.OK);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderPartiallyByOccurrence();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("jobPriority", "asc", Response.Status.OK);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByJobPriority();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("jobPriority", "desc", Response.Status.OK);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByJobPriority();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "asc", Response.Status.OK);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "desc", Response.Status.OK);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
    }

    @Test
    public void testSecondarySortingAsPost() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        HashMap<String, List<Map<String, Object>>> json = new HashMap<String, List<Map<String, Object>>>();
        json.put("sorting", OrderingBuilder.create().orderBy("processInstanceId").desc().orderBy("timestamp").asc().getJson());
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_JOB_LOG_RESOURCE_URL, new Object[0]);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceId();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByTimestamp();
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
    }

    @Test
    public void testSuccessfulPagination() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_JOB_LOG_RESOURCE_URL, new Object[0]);
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, maxResults);
    }

    @Test
    public void testMissingFirstResultParameter() {
        int maxResults = 10;
        RestAssured.given().queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_JOB_LOG_RESOURCE_URL, new Object[0]);
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).listPage(0, maxResults);
    }

    @Test
    public void testMissingMaxResultsParameter() {
        int firstResult = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_JOB_LOG_RESOURCE_URL, new Object[0]);
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, Integer.MAX_VALUE);
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(HISTORIC_JOB_LOG_COUNT_RESOURCE_URL, new Object[0]);
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testQueryCountForPost() {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().body("count", Matchers.equalTo((Object)1), new Object[0]).when().post(HISTORIC_JOB_LOG_COUNT_RESOURCE_URL, new Object[0]);
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testSimpleHistoricJobLogQuery() {
        String processInstanceId = "aProcInstId";
        Response response = (Response)RestAssured.given().queryParam("processInstanceId", new Object[]{processInstanceId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_JOB_LOG_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).processInstanceId(processInstanceId);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List logs = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one historic job log returned.", (long)1L, (long)logs.size());
        Assert.assertNotNull((String)"The returned historic job log should not be null.", logs.get(0));
        this.verifyHistoricJobLogEntries(content);
    }

    @Test
    public void testSimpleHistoricJobLogQueryAsPost() {
        String processInstanceId = "aProcInstId";
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("processInstanceId", processInstanceId);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_JOB_LOG_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).processInstanceId(processInstanceId);
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List logs = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one historic job log returned.", (long)1L, (long)logs.size());
        Assert.assertNotNull((String)"The returned historic job log should not be null.", logs.get(0));
        this.verifyHistoricJobLogEntries(content);
    }

    protected void verifyHistoricJobLogEntries(String content) {
        String returnedId = JsonPath.from((String)content).getString("[0].id");
        String returnedTimestamp = JsonPath.from((String)content).getString("[0].timestamp");
        String returnedRemovalTime = JsonPath.from((String)content).getString("[0].removalTime");
        String returnedJobId = JsonPath.from((String)content).getString("[0].jobId");
        String returnedJobDueDate = JsonPath.from((String)content).getString("[0].jobDueDate");
        int returnedJobRetries = JsonPath.from((String)content).getInt("[0].jobRetries");
        long returnedJobPriority = JsonPath.from((String)content).getLong("[0].jobPriority");
        String returnedJobExceptionMessage = JsonPath.from((String)content).getString("[0].jobExceptionMessage");
        String returnedJobDefinitionId = JsonPath.from((String)content).getString("[0].jobDefinitionId");
        String returnedJobDefinitionType = JsonPath.from((String)content).getString("[0].jobDefinitionType");
        String returnedJobDefinitionConfiguration = JsonPath.from((String)content).getString("[0].jobDefinitionConfiguration");
        String returnedActivityId = JsonPath.from((String)content).getString("[0].activityId");
        String returnedExecutionId = JsonPath.from((String)content).getString("[0].executionId");
        String returnedProcessInstanceId = JsonPath.from((String)content).getString("[0].processInstanceId");
        String returnedProcessDefinitionId = JsonPath.from((String)content).getString("[0].processDefinitionId");
        String returnedProcessDefinitionKey = JsonPath.from((String)content).getString("[0].processDefinitionKey");
        String returnedDeploymentId = JsonPath.from((String)content).getString("[0].deploymentId");
        String returnedRootProcessInstanceId = JsonPath.from((String)content).getString("[0].rootProcessInstanceId");
        boolean returnedCreationLog = JsonPath.from((String)content).getBoolean("[0].creationLog");
        boolean returnedFailureLog = JsonPath.from((String)content).getBoolean("[0].failureLog");
        boolean returnedSuccessLog = JsonPath.from((String)content).getBoolean("[0].successLog");
        boolean returnedDeletionLog = JsonPath.from((String)content).getBoolean("[0].deletionLog");
        Assert.assertEquals((Object)"aHistoricJobLogId", (Object)returnedId);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_HISTORIC_JOB_LOG_TIMESTAMP, (Object)returnedTimestamp);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_HISTORIC_JOB_LOG_REMOVAL_TIME, (Object)returnedRemovalTime);
        Assert.assertEquals((Object)"aJobId", (Object)returnedJobId);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_HISTORIC_JOB_LOG_JOB_DUE_DATE, (Object)returnedJobDueDate);
        Assert.assertEquals((long)5L, (long)returnedJobRetries);
        Assert.assertEquals((long)2147483689L, (long)returnedJobPriority);
        Assert.assertEquals((Object)"aJobExceptionMsg", (Object)returnedJobExceptionMessage);
        Assert.assertEquals((Object)"aJobDefId", (Object)returnedJobDefinitionId);
        Assert.assertEquals((Object)"aJobDefType", (Object)returnedJobDefinitionType);
        Assert.assertEquals((Object)"aJobDefConfig", (Object)returnedJobDefinitionConfiguration);
        Assert.assertEquals((Object)"anActId", (Object)returnedActivityId);
        Assert.assertEquals((Object)"anExecId", (Object)returnedExecutionId);
        Assert.assertEquals((Object)"aProcInstId", (Object)returnedProcessInstanceId);
        Assert.assertEquals((Object)"aProcDefId", (Object)returnedProcessDefinitionId);
        Assert.assertEquals((Object)"aProcDefKey", (Object)returnedProcessDefinitionKey);
        Assert.assertEquals((Object)"aDeploymentId", (Object)returnedDeploymentId);
        Assert.assertEquals((Object)"aRootProcInstId", (Object)returnedRootProcessInstanceId);
        Assert.assertEquals((Object)true, (Object)returnedCreationLog);
        Assert.assertEquals((Object)true, (Object)returnedFailureLog);
        Assert.assertEquals((Object)true, (Object)returnedSuccessLog);
        Assert.assertEquals((Object)true, (Object)returnedDeletionLog);
    }

    @Test
    public void testStringParameters() {
        Map<String, String> stringQueryParameters = this.getCompleteStringQueryParameters();
        RestAssured.given().queryParams(stringQueryParameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_JOB_LOG_RESOURCE_URL, new Object[0]);
        this.verifyStringParameterQueryInvocations();
    }

    @Test
    public void testStringParametersAsPost() {
        Map<String, String> stringQueryParameters = this.getCompleteStringQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(stringQueryParameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_JOB_LOG_RESOURCE_URL, new Object[0]);
        this.verifyStringParameterQueryInvocations();
    }

    protected Map<String, String> getCompleteStringQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("logId", "aHistoricJobLogId");
        parameters.put("jobId", "aJobId");
        parameters.put("jobExceptionMessage", "aJobExceptionMsg");
        parameters.put("jobDefinitionId", "aJobDefId");
        parameters.put("jobDefinitionType", "aJobDefConfig");
        parameters.put("jobDefinitionConfiguration", "aJobDefConfig");
        parameters.put("processInstanceId", "aProcInstId");
        parameters.put("processDefinitionId", "aProcDefId");
        parameters.put("processDefinitionKey", "aProcDefKey");
        parameters.put("deploymentId", "aDeploymentId");
        return parameters;
    }

    protected void verifyStringParameterQueryInvocations() {
        Map<String, String> stringQueryParameters = this.getCompleteStringQueryParameters();
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).logId(stringQueryParameters.get("logId"));
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).jobId(stringQueryParameters.get("jobId"));
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).jobExceptionMessage(stringQueryParameters.get("jobExceptionMessage"));
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).jobDefinitionId(stringQueryParameters.get("jobDefinitionId"));
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).jobDefinitionType(stringQueryParameters.get("jobDefinitionType"));
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).jobDefinitionConfiguration(stringQueryParameters.get("jobDefinitionConfiguration"));
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceId(stringQueryParameters.get("processInstanceId"));
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionId(stringQueryParameters.get("processDefinitionId"));
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionKey(stringQueryParameters.get("processDefinitionKey"));
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).deploymentId(stringQueryParameters.get("deploymentId"));
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testListParameters() {
        String anActId = "anActId";
        String anotherActId = "anotherActId";
        String anExecutionId = "anExecutionId";
        String anotherExecutionId = "anotherExecutionId";
        RestAssured.given().queryParam("activityIdIn", new Object[]{anActId + "," + anotherActId}).queryParam("executionIdIn", new Object[]{anExecutionId + "," + anotherExecutionId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_JOB_LOG_RESOURCE_URL, new Object[0]);
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).activityIdIn(new String[]{anActId, anotherActId});
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).executionIdIn(new String[]{anExecutionId, anotherExecutionId});
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testListParametersAsPost() {
        String anActId = "anActId";
        String anotherActId = "anotherActId";
        String anExecutionId = "anExecutionId";
        String anotherExecutionId = "anotherExecutionId";
        HashMap<String, List<String>> json = new HashMap<String, List<String>>();
        json.put("activityIdIn", Arrays.asList(anActId, anotherActId));
        json.put("executionIdIn", Arrays.asList(anExecutionId, anotherExecutionId));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_JOB_LOG_RESOURCE_URL, new Object[0]);
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).activityIdIn(new String[]{anActId, anotherActId});
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).executionIdIn(new String[]{anExecutionId, anotherExecutionId});
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testBooleanParameters() {
        Map<String, Boolean> params = this.getCompleteBooleanQueryParameters();
        RestAssured.given().queryParams(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_JOB_LOG_RESOURCE_URL, new Object[0]);
        this.verifyBooleanParameterQueryInvocations();
    }

    @Test
    public void testBooleanParametersAsPost() {
        Map<String, Boolean> params = this.getCompleteBooleanQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_JOB_LOG_RESOURCE_URL, new Object[0]);
        this.verifyBooleanParameterQueryInvocations();
    }

    protected Map<String, Boolean> getCompleteBooleanQueryParameters() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("creationLog", true);
        parameters.put("failureLog", true);
        parameters.put("successLog", true);
        parameters.put("deletionLog", true);
        return parameters;
    }

    protected void verifyBooleanParameterQueryInvocations() {
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).creationLog();
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).failureLog();
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).successLog();
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).deletionLog();
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testIntegerParameters() {
        Map<String, Object> params = this.getCompleteIntegerQueryParameters();
        RestAssured.given().queryParams(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_JOB_LOG_RESOURCE_URL, new Object[0]);
        this.verifyIntegerParameterQueryInvocations();
    }

    @Test
    public void testIntegerParametersAsPost() {
        Map<String, Object> params = this.getCompleteIntegerQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_JOB_LOG_RESOURCE_URL, new Object[0]);
        this.verifyIntegerParameterQueryInvocations();
    }

    protected Map<String, Object> getCompleteIntegerQueryParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("jobPriorityLowerThanOrEquals", Long.MAX_VALUE);
        parameters.put("jobPriorityHigherThanOrEquals", Long.MIN_VALUE);
        return parameters;
    }

    protected void verifyIntegerParameterQueryInvocations() {
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).jobPriorityLowerThanOrEquals(Long.MAX_VALUE);
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).jobPriorityHigherThanOrEquals(Long.MIN_VALUE);
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testTenantIdListParameter() {
        this.mockedQuery = this.setUpMockHistoricJobLogQuery(this.createMockHistoricJobLogsTwoTenants());
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId,anotherTenantId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_JOB_LOG_RESOURCE_URL, new Object[0]);
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List jobLogs = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)jobLogs).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testTenantIdListPostParameter() {
        this.mockedQuery = this.setUpMockHistoricJobLogQuery(this.createMockHistoricJobLogsTwoTenants());
        HashMap<String, String[]> queryParameters = new HashMap<String, String[]>();
        queryParameters.put("tenantIdIn", "aTenantId,anotherTenantId".split(","));
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_JOB_LOG_RESOURCE_URL, new Object[0]);
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((HistoricJobLogQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List jobLogs = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)jobLogs).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    private List<HistoricJobLog> createMockHistoricJobLogsTwoTenants() {
        return Arrays.asList(MockProvider.createMockHistoricJobLog("aTenantId"), MockProvider.createMockHistoricJobLog("anotherTenantId"));
    }
}

