/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstanceQuery;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.OrderingBuilder;
import org.camunda.bpm.engine.rest.util.QueryParamUtils;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.fest.assertions.Assertions;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class HistoricTaskInstanceRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORIC_TASK_INSTANCE_RESOURCE_URL = "/rest-test/history/task";
    protected static final String HISTORIC_TASK_INSTANCE_COUNT_RESOURCE_URL = "/rest-test/history/task/count";
    protected HistoricTaskInstanceQuery mockedQuery;

    @Before
    public void setUpRuntimeData() {
        this.mockedQuery = this.setUpMockHistoricTaskInstanceQuery(MockProvider.createMockHistoricTaskInstances());
    }

    private HistoricTaskInstanceQuery setUpMockHistoricTaskInstanceQuery(List<HistoricTaskInstance> mockedHistoricTaskInstances) {
        this.mockedQuery = (HistoricTaskInstanceQuery)Mockito.mock(HistoricTaskInstanceQuery.class);
        Mockito.when((Object)this.mockedQuery.list()).thenReturn(mockedHistoricTaskInstances);
        Mockito.when((Object)this.mockedQuery.count()).thenReturn((Object)mockedHistoricTaskInstances.size());
        Mockito.when((Object)processEngine.getHistoryService().createHistoricTaskInstanceQuery()).thenReturn((Object)this.mockedQuery);
        return this.mockedQuery;
    }

    @Test
    public void testEmptyQuery() {
        String queryKey = "";
        RestAssured.given().queryParam("processInstanceId", new Object[]{queryKey}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testNoParametersQuery() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testNoParametersQueryAsPost() {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testInvalidSortingOptions() {
        this.executeAndVerifySorting("anInvalidSortByOption", "asc", Response.Status.BAD_REQUEST);
        this.executeAndVerifySorting("processInstanceId", "anInvalidSortOrderOption", Response.Status.BAD_REQUEST);
    }

    protected void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSortingParameters() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("taskId", "asc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTaskId();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("taskId", "desc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTaskId();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("activityInstanceId", "asc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByHistoricActivityInstanceId();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("activityInstanceId", "desc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByHistoricActivityInstanceId();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processDefinitionId", "asc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionId();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processDefinitionId", "desc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionId();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processInstanceId", "asc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceId();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processInstanceId", "desc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceId();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("executionId", "asc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByExecutionId();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("executionId", "desc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByExecutionId();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("duration", "asc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByHistoricTaskInstanceDuration();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("duration", "desc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByHistoricTaskInstanceDuration();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("endTime", "asc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByHistoricTaskInstanceEndTime();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("endTime", "desc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByHistoricTaskInstanceEndTime();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("startTime", "asc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByHistoricActivityInstanceStartTime();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("startTime", "desc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByHistoricActivityInstanceStartTime();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("taskName", "asc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTaskName();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("taskName", "desc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTaskName();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("taskDescription", "asc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTaskDescription();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("taskDescription", "desc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTaskDescription();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("assignee", "asc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTaskAssignee();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("assignee", "desc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTaskAssignee();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("owner", "asc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTaskOwner();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("owner", "desc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTaskOwner();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("dueDate", "asc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTaskDueDate();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("dueDate", "desc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTaskDueDate();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("followUpDate", "asc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTaskFollowUpDate();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("followUpDate", "desc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTaskFollowUpDate();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("deleteReason", "asc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByDeleteReason();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("deleteReason", "desc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByDeleteReason();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("taskDefinitionKey", "asc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTaskDefinitionKey();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("taskDefinitionKey", "desc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTaskDefinitionKey();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("priority", "asc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTaskPriority();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("priority", "desc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTaskPriority();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseDefinitionId", "asc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseDefinitionId();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseDefinitionId", "desc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseDefinitionId();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseInstanceId", "asc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseInstanceId();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseInstanceId", "desc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseInstanceId();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseExecutionId", "asc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseExecutionId();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseExecutionId", "desc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseExecutionId();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "asc", Response.Status.OK);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
    }

    @Test
    public void testSecondarySortingAsPost() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        HashMap<String, List<Map<String, Object>>> json = new HashMap<String, List<Map<String, Object>>>();
        json.put("sorting", OrderingBuilder.create().orderBy("owner").desc().orderBy("priority").asc().getJson());
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTaskOwner();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTaskPriority();
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
    }

    @Test
    public void testSuccessfulPagination() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, maxResults);
    }

    @Test
    public void testMissingFirstResultParameter() {
        int maxResults = 10;
        RestAssured.given().queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(0, maxResults);
    }

    @Test
    public void testMissingMaxResultsParameter() {
        int firstResult = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, Integer.MAX_VALUE);
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(HISTORIC_TASK_INSTANCE_COUNT_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testQueryCountForPost() {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().body("count", Matchers.equalTo((Object)1), new Object[0]).when().post(HISTORIC_TASK_INSTANCE_COUNT_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testSimpleHistoricTaskInstanceQuery() {
        Response response = (Response)RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one historic task instance returned.", (long)1L, (long)instances.size());
        Assert.assertNotNull((String)"The returned historic task instance should not be null.", instances.get(0));
        this.verifyHistoricTaskInstanceEntries(content);
    }

    @Test
    public void testSimpleHistoricTaskInstanceQueryAsPost() {
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricTaskInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one historic task instance returned.", (long)1L, (long)instances.size());
        Assert.assertNotNull((String)"The returned historic task instance should not be null.", instances.get(0));
        this.verifyHistoricTaskInstanceEntries(content);
    }

    @Test
    public void testQueryByTaskId() {
        String taskId = "aHistoricTaskInstanceId";
        RestAssured.given().queryParam("taskId", new Object[]{taskId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskId(taskId);
    }

    @Test
    public void testQueryByTaskIdAsPost() {
        String taskId = "aHistoricTaskInstanceId";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("taskId", taskId);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskId(taskId);
    }

    @Test
    public void testQueryByProcessInstanceId() {
        String processInstanceId = "aProcInstId";
        RestAssured.given().queryParam("processInstanceId", new Object[]{processInstanceId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceId(processInstanceId);
    }

    @Test
    public void testQueryByProcessInstanceIdAsPost() {
        String processInstanceId = "aProcInstId";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processInstanceId", processInstanceId);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceId(processInstanceId);
    }

    @Test
    public void testQueryByProcessInstanceBusinessKey() {
        String processInstanceBusinessKey = "aBusinessKey";
        RestAssured.given().queryParam("processInstanceBusinessKey", new Object[]{processInstanceBusinessKey}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceBusinessKey(processInstanceBusinessKey);
    }

    @Test
    public void testQueryByProcessInstanceBusinessKeyAsPost() {
        String processInstanceBusinessKey = "aBusinessKey";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processInstanceBusinessKey", processInstanceBusinessKey);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceBusinessKey(processInstanceBusinessKey);
    }

    @Test
    public void testQueryByProcessInstanceBusinessKeyLike() {
        String processInstanceBusinessKeyLike = "aBusinessKey";
        RestAssured.given().queryParam("processInstanceBusinessKeyLike", new Object[]{processInstanceBusinessKeyLike}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceBusinessKeyLike(processInstanceBusinessKeyLike);
    }

    @Test
    public void testQueryByProcessInstanceBusinessKeyLikeAsPost() {
        String processInstanceBusinessKeyLike = "aBusinessKey";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processInstanceBusinessKeyLike", processInstanceBusinessKeyLike);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceBusinessKeyLike(processInstanceBusinessKeyLike);
    }

    @Test
    public void testQueryByProcessInstanceBusinessKeyIn() {
        RestAssured.given().queryParam("processInstanceBusinessKeyIn", new Object[]{QueryParamUtils.arrayAsCommaSeperatedList("aBusinessKey", "anotherBusinessKey")}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceBusinessKeyIn(new String[]{"aBusinessKey", "anotherBusinessKey"});
    }

    @Test
    public void testQueryByProcessInstanceBusinessKeyInAsPost() {
        String businessKey1 = "aBusinessKey";
        String businessKey2 = "anotherBusinessKey";
        ArrayList<String> processInstanceBusinessKeyIn = new ArrayList<String>();
        processInstanceBusinessKeyIn.add(businessKey1);
        processInstanceBusinessKeyIn.add(businessKey2);
        HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
        params.put("processInstanceBusinessKeyIn", processInstanceBusinessKeyIn);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceBusinessKeyIn(new String[]{businessKey1, businessKey2});
    }

    @Test
    public void testQueryByExecutionId() {
        String executionId = "anExecId";
        RestAssured.given().queryParam("executionId", new Object[]{executionId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).executionId(executionId);
    }

    @Test
    public void testQueryByExecutionIdAsPost() {
        String executionId = "anExecId";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("executionId", executionId);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).executionId(executionId);
    }

    @Test
    public void testQueryByActivityInstanceId() {
        String activityInstanceId = "anActInstId";
        RestAssured.given().queryParam("activityInstanceIdIn", new Object[]{activityInstanceId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).activityInstanceIdIn(new String[]{activityInstanceId});
    }

    @Test
    public void testQueryByActivityInstanceIdAsPost() {
        String activityInstanceId = "anActInstId";
        ArrayList<String> activityInstanceIds = new ArrayList<String>();
        activityInstanceIds.add(activityInstanceId);
        HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
        params.put("activityInstanceIdIn", activityInstanceIds);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).activityInstanceIdIn(new String[]{activityInstanceId});
    }

    @Test
    public void testQueryByActivityInstanceIds() {
        String activityInstanceId = "anActInstId";
        String anotherActivityInstanceId = "anotherActivityInstanceId";
        RestAssured.given().queryParam("activityInstanceIdIn", new Object[]{activityInstanceId + "," + anotherActivityInstanceId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).activityInstanceIdIn(new String[]{activityInstanceId, anotherActivityInstanceId});
    }

    @Test
    public void testQueryByActivityInstanceIdsAsPost() {
        String activityInstanceId = "anActInstId";
        String anotherActivityInstanceId = "anotherActivityInstanceId";
        ArrayList<String> activityInstanceIds = new ArrayList<String>();
        activityInstanceIds.add(activityInstanceId);
        activityInstanceIds.add(anotherActivityInstanceId);
        HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
        params.put("activityInstanceIdIn", activityInstanceIds);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).activityInstanceIdIn(new String[]{activityInstanceId, anotherActivityInstanceId});
    }

    @Test
    public void testQueryByProcessDefinitionId() {
        String processDefinitionId = "aProcDefId";
        RestAssured.given().queryParam("processDefinitionId", new Object[]{processDefinitionId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionId(processDefinitionId);
    }

    @Test
    public void testQueryByProcessDefinitionIdAsPost() {
        String processDefinitionId = "aProcDefId";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processDefinitionId", processDefinitionId);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionId(processDefinitionId);
    }

    @Test
    public void testQueryByProcessDefinitionKey() {
        String processDefinitionKey = "aProcDefKey";
        RestAssured.given().queryParam("processDefinitionKey", new Object[]{processDefinitionKey}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionKey(processDefinitionKey);
    }

    @Test
    public void testQueryByProcessDefinitionKeyAsPost() {
        String processDefinitionKey = "aProcDefKey";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processDefinitionKey", processDefinitionKey);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionKey(processDefinitionKey);
    }

    @Test
    public void testQueryByProcessDefinitionName() {
        String processDefinitionName = "aProcDefName";
        RestAssured.given().queryParam("processDefinitionName", new Object[]{processDefinitionName}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionName(processDefinitionName);
    }

    @Test
    public void testQueryByProcessDefinitionNameAsPost() {
        String processDefinitionName = "aProcDefName";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processDefinitionName", processDefinitionName);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionName(processDefinitionName);
    }

    @Test
    public void testQueryByTaskName() {
        String taskName = "aTaskName";
        RestAssured.given().queryParam("taskName", new Object[]{taskName}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskName(taskName);
    }

    @Test
    public void testQueryByTaskNameAsPost() {
        String taskName = "aTaskName";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("taskName", taskName);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskName(taskName);
    }

    @Test
    public void testQueryByTaskNameLike() {
        String taskNameLike = "aTaskNameLike";
        RestAssured.given().queryParam("taskNameLike", new Object[]{taskNameLike}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskNameLike(taskNameLike);
    }

    @Test
    public void testQueryByTaskNameLikeAsPost() {
        String taskNameLike = "aTaskNameLike";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("taskNameLike", taskNameLike);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskNameLike(taskNameLike);
    }

    @Test
    public void testQueryByTaskDescription() {
        String taskDescription = "aDescription";
        RestAssured.given().queryParam("taskDescription", new Object[]{taskDescription}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskDescription(taskDescription);
    }

    @Test
    public void testQueryByTaskDescriptionAsPost() {
        String taskDescription = "aDescription";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("taskDescription", taskDescription);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskDescription(taskDescription);
    }

    @Test
    public void testQueryByTaskDescriptionLike() {
        String taskDescriptionLike = "aTaskDescriptionLike";
        RestAssured.given().queryParam("taskDescriptionLike", new Object[]{taskDescriptionLike}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskDescriptionLike(taskDescriptionLike);
    }

    @Test
    public void testQueryByTaskDescriptionLikeAsPost() {
        String taskDescriptionLike = "aTaskDescriptionLike";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("taskDescriptionLike", taskDescriptionLike);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskDescriptionLike(taskDescriptionLike);
    }

    @Test
    public void testQueryByTaskDefinitionKey() {
        String taskDefinitionKey = "aTaskDefinitionKey";
        RestAssured.given().queryParam("taskDefinitionKey", new Object[]{taskDefinitionKey}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskDefinitionKey(taskDefinitionKey);
    }

    @Test
    public void testQueryByTaskDefinitionKeyAsPost() {
        String taskDefinitionKey = "aTaskDefinitionKey";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("taskDefinitionKey", taskDefinitionKey);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskDefinitionKey(taskDefinitionKey);
    }

    @Test
    public void testQueryByTaskDeleteReason() {
        String taskDeleteReason = "aDeleteReason";
        RestAssured.given().queryParam("taskDeleteReason", new Object[]{taskDeleteReason}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskDeleteReason(taskDeleteReason);
    }

    @Test
    public void testQueryByTaskDeleteReasonAsPost() {
        String taskDeleteReason = "aDeleteReason";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("taskDeleteReason", taskDeleteReason);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskDeleteReason(taskDeleteReason);
    }

    @Test
    public void testQueryByTaskDeleteReasonLike() {
        String taskDeleteReasonLike = "aTaskDeleteReasonLike";
        RestAssured.given().queryParam("taskDeleteReasonLike", new Object[]{taskDeleteReasonLike}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskDeleteReasonLike(taskDeleteReasonLike);
    }

    @Test
    public void testQueryByTaskDeleteReasonLikeAsPost() {
        String taskDeleteReasonLike = "aTaskDeleteReasonLike";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("taskDeleteReasonLike", taskDeleteReasonLike);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskDeleteReasonLike(taskDeleteReasonLike);
    }

    @Test
    public void testQueryByTaskAssignee() {
        String taskAssignee = "anAssignee";
        RestAssured.given().queryParam("taskAssignee", new Object[]{taskAssignee}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskAssignee(taskAssignee);
    }

    @Test
    public void testQueryByTaskAssigneeAsPost() {
        String taskAssignee = "anAssignee";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("taskAssignee", taskAssignee);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskAssignee(taskAssignee);
    }

    @Test
    public void testQueryByTaskAssigneeLike() {
        String taskAssigneeLike = "aTaskAssigneeLike";
        RestAssured.given().queryParam("taskAssigneeLike", new Object[]{taskAssigneeLike}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskAssigneeLike(taskAssigneeLike);
    }

    @Test
    public void testQueryByTaskAssigneeLikeAsPost() {
        String taskAssigneeLike = "aTaskAssigneeLike";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("taskAssigneeLike", taskAssigneeLike);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskAssigneeLike(taskAssigneeLike);
    }

    @Test
    public void testQueryByTaskOwner() {
        String taskOwner = "anOwner";
        RestAssured.given().queryParam("taskOwner", new Object[]{taskOwner}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskOwner(taskOwner);
    }

    @Test
    public void testQueryByTaskOwnerAsPost() {
        String taskOwner = "anOwner";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("taskOwner", taskOwner);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskOwner(taskOwner);
    }

    @Test
    public void testQueryByTaskOwnerLike() {
        String taskOwnerLike = "aTaskOwnerLike";
        RestAssured.given().queryParam("taskOwnerLike", new Object[]{taskOwnerLike}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskOwnerLike(taskOwnerLike);
    }

    @Test
    public void testQueryByTaskOwnerLikeAsPost() {
        String taskOwnerLike = "aTaskOwnerLike";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("taskOwnerLike", taskOwnerLike);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskOwnerLike(taskOwnerLike);
    }

    @Test
    public void testQueryByTaskPriority() {
        int taskPriority = 60;
        RestAssured.given().queryParam("taskPriority", new Object[]{taskPriority}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskPriority(Integer.valueOf(taskPriority));
    }

    @Test
    public void testQueryByTaskPriorityAsPost() {
        int taskPriority = 60;
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("taskPriority", taskPriority);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskPriority(Integer.valueOf(taskPriority));
    }

    @Test
    public void testQueryByAssigned() {
        RestAssured.given().queryParam("assigned", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskAssigned();
    }

    @Test
    public void testQueryByAssignedAsPost() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("assigned", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskAssigned();
    }

    @Test
    public void testQueryByWithCandidateGroups() {
        RestAssured.given().queryParam("withCandidateGroups", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).withCandidateGroups();
    }

    @Test
    public void testQueryByWithCandidateGroupsAsPost() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("withCandidateGroups", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).withCandidateGroups();
    }

    @Test
    public void testQueryByWithoutCandidateGroups() {
        RestAssured.given().queryParam("withoutCandidateGroups", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).withoutCandidateGroups();
    }

    @Test
    public void testQueryByWithoutCandidateGroupsAsPost() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("withoutCandidateGroups", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).withoutCandidateGroups();
    }

    @Test
    public void testQueryByUnassigned() {
        RestAssured.given().queryParam("unassigned", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskUnassigned();
    }

    @Test
    public void testQueryByUnassignedAsPost() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("unassigned", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskUnassigned();
    }

    @Test
    public void testQueryByFinished() {
        RestAssured.given().queryParam("finished", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).finished();
    }

    @Test
    public void testQueryByFinishedAsPost() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("finished", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).finished();
    }

    @Test
    public void testQueryByUnfinished() {
        RestAssured.given().queryParam("unfinished", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).unfinished();
    }

    @Test
    public void testQueryByUnfinishedAsPost() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("unfinished", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).unfinished();
    }

    @Test
    public void testQueryByProcessFinished() {
        RestAssured.given().queryParam("processFinished", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processFinished();
    }

    @Test
    public void testQueryByProcessFinishedAsPost() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("processFinished", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processFinished();
    }

    @Test
    public void testQueryByProcessUnfinished() {
        RestAssured.given().queryParam("processUnfinished", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processUnfinished();
    }

    @Test
    public void testQueryByProcessUnfinishedAsPost() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("processUnfinished", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processUnfinished();
    }

    @Test
    public void testQueryByTaskParentTaskId() {
        String taskParentTaskId = "aParentTaskId";
        RestAssured.given().queryParam("taskParentTaskId", new Object[]{taskParentTaskId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskParentTaskId(taskParentTaskId);
    }

    @Test
    public void testQueryByTaskParentTaskIdAsPost() {
        String taskParentTaskId = "aParentTaskId";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("taskParentTaskId", taskParentTaskId);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskParentTaskId(taskParentTaskId);
    }

    @Test
    public void testQueryByTaskDueDate() {
        String due = MockProvider.EXAMPLE_HISTORIC_TASK_INST_DUE_DATE;
        RestAssured.given().queryParam("taskDueDate", new Object[]{due}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskDueDate(DateTimeUtil.parseDate((String)due));
    }

    @Test
    public void testQueryByTaskDueDateAsPost() {
        String due = MockProvider.EXAMPLE_HISTORIC_TASK_INST_DUE_DATE;
        HashMap<String, Date> params = new HashMap<String, Date>();
        params.put("taskDueDate", DateTimeUtil.parseDate((String)due));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskDueDate(DateTimeUtil.parseDate((String)due));
    }

    @Test
    public void testQueryByTaskDueDateBefore() {
        String due = MockProvider.EXAMPLE_HISTORIC_TASK_INST_DUE_DATE;
        RestAssured.given().queryParam("taskDueDateBefore", new Object[]{due}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskDueBefore(DateTimeUtil.parseDate((String)due));
    }

    @Test
    public void testQueryByTaskDueDateBeforeAsPost() {
        String due = MockProvider.EXAMPLE_HISTORIC_TASK_INST_DUE_DATE;
        HashMap<String, Date> params = new HashMap<String, Date>();
        params.put("taskDueDateBefore", DateTimeUtil.parseDate((String)due));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskDueBefore(DateTimeUtil.parseDate((String)due));
    }

    @Test
    public void testQueryByTaskDueDateAfter() {
        String due = MockProvider.EXAMPLE_HISTORIC_TASK_INST_DUE_DATE;
        RestAssured.given().queryParam("taskDueDateAfter", new Object[]{due}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskDueAfter(DateTimeUtil.parseDate((String)due));
    }

    @Test
    public void testQueryByTaskDueDateAfterAsPost() {
        String due = MockProvider.EXAMPLE_HISTORIC_TASK_INST_DUE_DATE;
        HashMap<String, Date> params = new HashMap<String, Date>();
        params.put("taskDueDateAfter", DateTimeUtil.parseDate((String)due));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskDueAfter(DateTimeUtil.parseDate((String)due));
    }

    @Test
    public void testQueryByTaskFollowUpDate() {
        String followUp = MockProvider.EXAMPLE_HISTORIC_TASK_INST_FOLLOW_UP_DATE;
        RestAssured.given().queryParam("taskFollowUpDate", new Object[]{followUp}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskFollowUpDate(DateTimeUtil.parseDate((String)followUp));
    }

    @Test
    public void testQueryByTaskFollowUpDateAsPost() {
        String followUp = MockProvider.EXAMPLE_HISTORIC_TASK_INST_FOLLOW_UP_DATE;
        HashMap<String, Date> params = new HashMap<String, Date>();
        params.put("taskFollowUpDate", DateTimeUtil.parseDate((String)followUp));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskFollowUpDate(DateTimeUtil.parseDate((String)followUp));
    }

    @Test
    public void testQueryByTaskFollowUpDateBefore() {
        String followUp = MockProvider.EXAMPLE_HISTORIC_TASK_INST_FOLLOW_UP_DATE;
        RestAssured.given().queryParam("taskFollowUpDateBefore", new Object[]{followUp}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskFollowUpBefore(DateTimeUtil.parseDate((String)followUp));
    }

    @Test
    public void testQueryByTaskFollowUpDateBeforeAsPost() {
        String followUp = MockProvider.EXAMPLE_HISTORIC_TASK_INST_FOLLOW_UP_DATE;
        HashMap<String, Date> params = new HashMap<String, Date>();
        params.put("taskFollowUpDateBefore", DateTimeUtil.parseDate((String)followUp));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskFollowUpBefore(DateTimeUtil.parseDate((String)followUp));
    }

    @Test
    public void testQueryByTaskFollowUpDateAfter() {
        String followUp = MockProvider.EXAMPLE_HISTORIC_TASK_INST_FOLLOW_UP_DATE;
        RestAssured.given().queryParam("taskFollowUpDateAfter", new Object[]{followUp}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskFollowUpAfter(DateTimeUtil.parseDate((String)followUp));
    }

    @Test
    public void testQueryByTaskFollowUpDateAfterAsPost() {
        String followUp = MockProvider.EXAMPLE_HISTORIC_TASK_INST_FOLLOW_UP_DATE;
        HashMap<String, Date> params = new HashMap<String, Date>();
        params.put("taskFollowUpDateAfter", DateTimeUtil.parseDate((String)followUp));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskFollowUpAfter(DateTimeUtil.parseDate((String)followUp));
    }

    @Test
    public void testQueryByStartedBefore() {
        String startedBefore = MockProvider.EXAMPLE_HISTORIC_TASK_INST_START_TIME;
        RestAssured.given().queryParam("startedBefore", new Object[]{startedBefore}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).startedBefore(DateTimeUtil.parseDate((String)startedBefore));
    }

    @Test
    public void testQueryByStartedBeforeAsPost() {
        String startedBefore = MockProvider.EXAMPLE_HISTORIC_TASK_INST_START_TIME;
        HashMap<String, Date> params = new HashMap<String, Date>();
        params.put("startedBefore", DateTimeUtil.parseDate((String)startedBefore));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).startedBefore(DateTimeUtil.parseDate((String)startedBefore));
    }

    @Test
    public void testQueryByStartedAfter() {
        String startedAfter = MockProvider.EXAMPLE_HISTORIC_TASK_INST_START_TIME;
        RestAssured.given().queryParam("startedAfter", new Object[]{startedAfter}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).startedAfter(DateTimeUtil.parseDate((String)startedAfter));
    }

    @Test
    public void testQueryByStartedAfterAsPost() {
        String startedAfter = MockProvider.EXAMPLE_HISTORIC_TASK_INST_START_TIME;
        HashMap<String, Date> params = new HashMap<String, Date>();
        params.put("startedAfter", DateTimeUtil.parseDate((String)startedAfter));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).startedAfter(DateTimeUtil.parseDate((String)startedAfter));
    }

    @Test
    public void testQueryByFinishedBefore() {
        String finishedBefore = MockProvider.EXAMPLE_HISTORIC_TASK_INST_END_TIME;
        RestAssured.given().queryParam("finishedBefore", new Object[]{finishedBefore}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).finishedBefore(DateTimeUtil.parseDate((String)finishedBefore));
    }

    @Test
    public void testQueryByFinishedBeforeAsPost() {
        String finishedBefore = MockProvider.EXAMPLE_HISTORIC_TASK_INST_END_TIME;
        HashMap<String, Date> params = new HashMap<String, Date>();
        params.put("finishedBefore", DateTimeUtil.parseDate((String)finishedBefore));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).finishedBefore(DateTimeUtil.parseDate((String)finishedBefore));
    }

    @Test
    public void testQueryByFinishedAfter() {
        String finishedAfter = MockProvider.EXAMPLE_HISTORIC_TASK_INST_END_TIME;
        RestAssured.given().queryParam("finishedAfter", new Object[]{finishedAfter}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).finishedAfter(DateTimeUtil.parseDate((String)finishedAfter));
    }

    @Test
    public void testQueryByFinishedAfterAsPost() {
        String finishedAfter = MockProvider.EXAMPLE_HISTORIC_TASK_INST_END_TIME;
        HashMap<String, Date> params = new HashMap<String, Date>();
        params.put("finishedAfter", DateTimeUtil.parseDate((String)finishedAfter));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).finishedAfter(DateTimeUtil.parseDate((String)finishedAfter));
    }

    @Test
    public void testQueryByTaskVariable() {
        String variableParameter;
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableParameter = variableName + "_eq_" + variableValue;
        RestAssured.given().queryParam("taskVariables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskVariableValueEquals(variableName, (Object)variableValue);
    }

    @Test
    public void testQueryByTaskVariableAsPost() {
        String variableName = "varName";
        String variableValue = "varValue";
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", variableName);
        variableJson.put("operator", "eq");
        variableJson.put("value", variableValue);
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> params = new HashMap<String, ArrayList<HashMap<String, String>>>();
        params.put("taskVariables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskVariableValueEquals(variableName, (Object)variableValue);
    }

    @Test
    public void testQueryByInvalidTaskVariable() {
        String invalidComparator = "anInvalidComparator";
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_" + invalidComparator + "_" + variableValue;
        RestAssured.given().queryParam("taskVariables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("Invalid variable comparator specified: " + invalidComparator)), new Object[0]).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        queryValue = "invalidFormattedVariableQuery";
        RestAssured.given().queryParam("taskVariables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"variable query parameter has to have format KEY_OPERATOR_VALUE"), new Object[0]).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testQueryByInvalidTaskVariableAsPost() {
        String invalidComparator = "anInvalidComparator";
        String variableName = "varName";
        String variableValue = "varValue";
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", variableName);
        variableJson.put("operator", invalidComparator);
        variableJson.put("value", variableValue);
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> params = new HashMap<String, ArrayList<HashMap<String, String>>>();
        params.put("taskVariables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("Invalid variable comparator specified: " + invalidComparator)), new Object[0]).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testQueryByProcessVariable() {
        String variableParameter;
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableParameter = variableName + "_eq_" + variableValue;
        RestAssured.given().queryParam("processVariables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processVariableValueEquals(variableName, (Object)variableValue);
        queryValue = variableName + "_gt_" + variableValue;
        RestAssured.given().queryParam("processVariables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processVariableValueGreaterThan(variableName, (Object)variableValue);
        queryValue = variableName + "_gteq_" + variableValue;
        RestAssured.given().queryParam("processVariables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processVariableValueGreaterThanOrEquals(variableName, (Object)variableValue);
        queryValue = variableName + "_lt_" + variableValue;
        RestAssured.given().queryParam("processVariables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processVariableValueLessThan(variableName, (Object)variableValue);
        queryValue = variableName + "_lteq_" + variableValue;
        RestAssured.given().queryParam("processVariables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processVariableValueLessThanOrEquals(variableName, (Object)variableValue);
        queryValue = variableName + "_like_" + variableValue;
        RestAssured.given().queryParam("processVariables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processVariableValueLike(variableName, (Object)variableValue);
        queryValue = variableName + "_neq_" + variableValue;
        RestAssured.given().queryParam("processVariables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processVariableValueNotEquals(variableName, (Object)variableValue);
    }

    @Test
    public void testQueryByProcessVariableAsPost() {
        String variableName = "varName";
        String variableValue = "varValue";
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", variableName);
        variableJson.put("operator", "eq");
        variableJson.put("value", variableValue);
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> params = new HashMap<String, ArrayList<HashMap<String, String>>>();
        params.put("processVariables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processVariableValueEquals(variableName, (Object)variableValue);
    }

    @Test
    public void testQueryByInvalidProcessVariable() {
        String invalidComparator = "anInvalidComparator";
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_" + invalidComparator + "_" + variableValue;
        RestAssured.given().queryParam("processVariables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("Invalid process variable comparator specified: " + invalidComparator)), new Object[0]).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        queryValue = "invalidFormattedVariableQuery";
        RestAssured.given().queryParam("processVariables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"variable query parameter has to have format KEY_OPERATOR_VALUE"), new Object[0]).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testQueryByInvalidProcessVariableAsPost() {
        String invalidComparator = "anInvalidComparator";
        String variableName = "varName";
        String variableValue = "varValue";
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", variableName);
        variableJson.put("operator", invalidComparator);
        variableJson.put("value", variableValue);
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> params = new HashMap<String, ArrayList<HashMap<String, String>>>();
        params.put("processVariables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("Invalid process variable comparator specified: " + invalidComparator)), new Object[0]).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testQueryByCaseDefinitionId() {
        String caseDefinitionId = "aCaseDefinitionId";
        RestAssured.given().queryParam("caseDefinitionId", new Object[]{caseDefinitionId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseDefinitionId(caseDefinitionId);
    }

    @Test
    public void testQueryByCaseDefinitionIdAsPost() {
        String caseDefinitionId = "aCaseDefinitionId";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("caseDefinitionId", caseDefinitionId);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseDefinitionId(caseDefinitionId);
    }

    @Test
    public void testQueryByCaseDefinitionKey() {
        String caseDefinitionKey = "aCaseDefKey";
        RestAssured.given().queryParam("caseDefinitionKey", new Object[]{caseDefinitionKey}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseDefinitionKey(caseDefinitionKey);
    }

    @Test
    public void testQueryByCaseDefinitionKeyAsPost() {
        String caseDefinitionKey = "aCaseDefKey";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("caseDefinitionKey", caseDefinitionKey);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseDefinitionKey(caseDefinitionKey);
    }

    @Test
    public void testQueryByCaseDefinitionName() {
        String caseDefinitionName = "aCaseDefName";
        RestAssured.given().queryParam("caseDefinitionName", new Object[]{caseDefinitionName}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseDefinitionName(caseDefinitionName);
    }

    @Test
    public void testQueryByCaseDefinitionNameAsPost() {
        String caseDefinitionName = "aCaseDefName";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("caseDefinitionName", caseDefinitionName);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseDefinitionName(caseDefinitionName);
    }

    @Test
    public void testQueryByCaseInstanceId() {
        String caseInstanceId = "aCaseInstanceId";
        RestAssured.given().queryParam("caseInstanceId", new Object[]{caseInstanceId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceId(caseInstanceId);
    }

    @Test
    public void testQueryByCaseInstanceIdAsPost() {
        String caseInstanceId = "aCaseInstanceId";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("caseInstanceId", caseInstanceId);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceId(caseInstanceId);
    }

    @Test
    public void testQueryByCaseExecutionId() {
        String caseExecutionId = "aCaseExecutionId";
        RestAssured.given().queryParam("caseExecutionId", new Object[]{caseExecutionId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseExecutionId(caseExecutionId);
    }

    @Test
    public void testQueryByCaseExecutionIdAsPost() {
        String caseExecutionId = "aCaseExecutionId";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("caseExecutionId", caseExecutionId);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseExecutionId(caseExecutionId);
    }

    @Test
    public void testTenantIdListParameter() {
        this.mockedQuery = this.setUpMockHistoricTaskInstanceQuery(this.createMockHistoricTaskInstancesTwoTenants());
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId,anotherTenantId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List executions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)executions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testTenantIdListPostParameter() {
        this.mockedQuery = this.setUpMockHistoricTaskInstanceQuery(this.createMockHistoricTaskInstancesTwoTenants());
        HashMap<String, String[]> queryParameters = new HashMap<String, String[]>();
        queryParameters.put("tenantIdIn", "aTenantId,anotherTenantId".split(","));
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List executions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)executions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testQueryTaskInvolvedUser() {
        String taskInvolvedUser = "aUserId";
        RestAssured.given().queryParam("taskInvolvedUser", new Object[]{taskInvolvedUser}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskInvolvedUser(taskInvolvedUser);
    }

    @Test
    public void testQueryTaskInvolvedGroup() {
        String taskInvolvedGroup = "aGroupId";
        RestAssured.given().queryParam("taskInvolvedGroup", new Object[]{taskInvolvedGroup}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskInvolvedGroup(taskInvolvedGroup);
    }

    @Test
    public void testQueryTaskHadCandidateUser() {
        String taskHadCandidateUser = "cUserId";
        RestAssured.given().queryParam("taskHadCandidateUser", new Object[]{taskHadCandidateUser}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskHadCandidateUser(taskHadCandidateUser);
    }

    @Test
    public void testQueryTaskHadCandidateGroup() {
        String taskHadCandidateGroup = "cGroupId";
        RestAssured.given().queryParam("taskHadCandidateGroup", new Object[]{taskHadCandidateGroup}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskHadCandidateGroup(taskHadCandidateGroup);
    }

    @Test
    public void testQueryByTaskDefinitionKeyIn() {
        String taskDefinitionKey1 = "aTaskDefinitionKey";
        String taskDefinitionKey2 = "anotherTaskDefinitionKey";
        RestAssured.given().queryParam("taskDefinitionKeyIn", new Object[]{taskDefinitionKey1 + "," + taskDefinitionKey2}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskDefinitionKeyIn(new String[]{taskDefinitionKey1, taskDefinitionKey2});
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testQueryByTaskDefinitionKeyInAsPost() {
        String taskDefinitionKey1 = "aTaskDefinitionKey";
        String taskDefinitionKey2 = "anotherTaskDefinitionKey";
        ArrayList<String> taskDefinitionKeys = new ArrayList<String>();
        taskDefinitionKeys.add(taskDefinitionKey1);
        taskDefinitionKeys.add(taskDefinitionKey2);
        HashMap<String, ArrayList<String>> queryParameters = new HashMap<String, ArrayList<String>>();
        queryParameters.put("taskDefinitionKeyIn", taskDefinitionKeys);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_TASK_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskDefinitionKeyIn(new String[]{taskDefinitionKey1, taskDefinitionKey2});
        ((HistoricTaskInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    private List<HistoricTaskInstance> createMockHistoricTaskInstancesTwoTenants() {
        return Arrays.asList(MockProvider.createMockHistoricTaskInstance("aTenantId"), MockProvider.createMockHistoricTaskInstance("anotherTenantId"));
    }

    protected void verifyHistoricTaskInstanceEntries(String content) {
        String returnedId = JsonPath.from((String)content).getString("[0].id");
        String returnedProcessDefinitionKey = JsonPath.from((String)content).getString("[0].processDefinitionKey");
        String returnedProcessDefinitionId = JsonPath.from((String)content).getString("[0].processDefinitionId");
        String returnedProcessInstanceId = JsonPath.from((String)content).getString("[0].processInstanceId");
        String returnedExecutionId = JsonPath.from((String)content).getString("[0].executionId");
        String returnedActivityInstanceId = JsonPath.from((String)content).getString("[0].activityInstanceId");
        String returnedName = JsonPath.from((String)content).getString("[0].name");
        String returnedDescription = JsonPath.from((String)content).getString("[0].description");
        String returnedDeleteReason = JsonPath.from((String)content).getString("[0].deleteReason");
        String returnedOwner = JsonPath.from((String)content).getString("[0].owner");
        String returnedAssignee = JsonPath.from((String)content).getString("[0].assignee");
        Date returnedStartTime = DateTimeUtil.parseDate((String)JsonPath.from((String)content).getString("[0].startTime"));
        Date returnedEndTime = DateTimeUtil.parseDate((String)JsonPath.from((String)content).getString("[0].endTime"));
        Long returnedDurationInMillis = JsonPath.from((String)content).getLong("[0].duration");
        String returnedTaskDefinitionKey = JsonPath.from((String)content).getString("[0].taskDefinitionKey");
        int returnedPriority = JsonPath.from((String)content).getInt("[0].priority");
        String returnedParentTaskId = JsonPath.from((String)content).getString("[0].parentTaskId");
        Date returnedDue = DateTimeUtil.parseDate((String)JsonPath.from((String)content).getString("[0].due"));
        Date returnedFollow = DateTimeUtil.parseDate((String)JsonPath.from((String)content).getString("[0].followUp"));
        String returnedCaseDefinitionKey = JsonPath.from((String)content).getString("[0].caseDefinitionKey");
        String returnedCaseDefinitionId = JsonPath.from((String)content).getString("[0].caseDefinitionId");
        String returnedCaseInstanceId = JsonPath.from((String)content).getString("[0].caseInstanceId");
        String returnedCaseExecutionId = JsonPath.from((String)content).getString("[0].caseExecutionId");
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        Date returnedRemovalTime = DateTimeUtil.parseDate((String)JsonPath.from((String)content).getString("[0].removalTime"));
        String returnedRootProcessInstanceId = JsonPath.from((String)content).getString("[0].rootProcessInstanceId");
        Assert.assertEquals((Object)"aHistoricTaskInstanceId", (Object)returnedId);
        Assert.assertEquals((Object)"aProcInstId", (Object)returnedProcessInstanceId);
        Assert.assertEquals((Object)"anActInstId", (Object)returnedActivityInstanceId);
        Assert.assertEquals((Object)"anExecId", (Object)returnedExecutionId);
        Assert.assertEquals((Object)"aProcDefId", (Object)returnedProcessDefinitionId);
        Assert.assertEquals((Object)"aProcDefKey", (Object)returnedProcessDefinitionKey);
        Assert.assertEquals((Object)"aName", (Object)returnedName);
        Assert.assertEquals((Object)"aDescription", (Object)returnedDescription);
        Assert.assertEquals((Object)"aDeleteReason", (Object)returnedDeleteReason);
        Assert.assertEquals((Object)"anOwner", (Object)returnedOwner);
        Assert.assertEquals((Object)"anAssignee", (Object)returnedAssignee);
        Assert.assertEquals((Object)DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_TASK_INST_START_TIME), (Object)returnedStartTime);
        Assert.assertEquals((Object)DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_TASK_INST_END_TIME), (Object)returnedEndTime);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_HISTORIC_TASK_INST_DURATION, (Object)returnedDurationInMillis);
        Assert.assertEquals((Object)"aTaskDefinitionKey", (Object)returnedTaskDefinitionKey);
        Assert.assertEquals((long)60L, (long)returnedPriority);
        Assert.assertEquals((Object)DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_TASK_INST_DUE_DATE), (Object)returnedDue);
        Assert.assertEquals((Object)DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_TASK_INST_FOLLOW_UP_DATE), (Object)returnedFollow);
        Assert.assertEquals((Object)"aParentTaskId", (Object)returnedParentTaskId);
        Assert.assertEquals((Object)"aCaseDefinitionKey", (Object)returnedCaseDefinitionKey);
        Assert.assertEquals((Object)"aCaseDefinitionId", (Object)returnedCaseDefinitionId);
        Assert.assertEquals((Object)"aCaseInstanceId", (Object)returnedCaseInstanceId);
        Assert.assertEquals((Object)"aCaseExecutionId", (Object)returnedCaseExecutionId);
        Assert.assertEquals((Object)"aTenantId", (Object)returnedTenantId);
        Assert.assertEquals((Object)DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_TASK_INST_REMOVAL_TIME), (Object)returnedRemovalTime);
        Assert.assertEquals((Object)"aRootProcInstId", (Object)returnedRootProcessInstanceId);
    }
}

