/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.spi.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.FilterService;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.variable.ValueTypeResolverImpl;
import org.camunda.bpm.engine.rest.spi.ProcessEngineProvider;
import org.camunda.bpm.engine.variable.type.ValueTypeResolver;
import org.mockito.Mockito;

public class MockedProcessEngineProvider
implements ProcessEngineProvider {
    private static ProcessEngine cachedDefaultProcessEngine;
    private static Map<String, ProcessEngine> cachedEngines;

    public void resetEngines() {
        cachedDefaultProcessEngine = null;
        cachedEngines = new HashMap<String, ProcessEngine>();
    }

    private ProcessEngine mockProcessEngine(String engineName) {
        ProcessEngine engine = (ProcessEngine)Mockito.mock(ProcessEngine.class);
        Mockito.when((Object)engine.getName()).thenReturn((Object)engineName);
        this.mockServices(engine);
        this.mockProcessEngineConfiguration(engine);
        return engine;
    }

    private void mockServices(ProcessEngine engine) {
        RepositoryService repoService = (RepositoryService)Mockito.mock(RepositoryService.class);
        IdentityService identityService = (IdentityService)Mockito.mock(IdentityService.class);
        TaskService taskService = (TaskService)Mockito.mock(TaskService.class);
        RuntimeService runtimeService = (RuntimeService)Mockito.mock(RuntimeService.class);
        FormService formService = (FormService)Mockito.mock(FormService.class);
        HistoryService historyService = (HistoryService)Mockito.mock(HistoryService.class);
        ManagementService managementService = (ManagementService)Mockito.mock(ManagementService.class);
        CaseService caseService = (CaseService)Mockito.mock(CaseService.class);
        FilterService filterService = (FilterService)Mockito.mock(FilterService.class);
        ExternalTaskService externalTaskService = (ExternalTaskService)Mockito.mock(ExternalTaskService.class);
        Mockito.when((Object)engine.getRepositoryService()).thenReturn((Object)repoService);
        Mockito.when((Object)engine.getIdentityService()).thenReturn((Object)identityService);
        Mockito.when((Object)engine.getTaskService()).thenReturn((Object)taskService);
        Mockito.when((Object)engine.getRuntimeService()).thenReturn((Object)runtimeService);
        Mockito.when((Object)engine.getFormService()).thenReturn((Object)formService);
        Mockito.when((Object)engine.getHistoryService()).thenReturn((Object)historyService);
        Mockito.when((Object)engine.getManagementService()).thenReturn((Object)managementService);
        Mockito.when((Object)engine.getCaseService()).thenReturn((Object)caseService);
        Mockito.when((Object)engine.getFilterService()).thenReturn((Object)filterService);
        Mockito.when((Object)engine.getExternalTaskService()).thenReturn((Object)externalTaskService);
    }

    protected void mockProcessEngineConfiguration(ProcessEngine engine) {
        ProcessEngineConfiguration configuration = (ProcessEngineConfiguration)Mockito.mock(ProcessEngineConfiguration.class);
        Mockito.when((Object)configuration.getValueTypeResolver()).thenReturn((Object)this.mockValueTypeResolver());
        Mockito.when((Object)engine.getProcessEngineConfiguration()).thenReturn((Object)configuration);
    }

    protected ValueTypeResolver mockValueTypeResolver() {
        return new ValueTypeResolverImpl();
    }

    public ProcessEngine getDefaultProcessEngine() {
        if (cachedDefaultProcessEngine == null) {
            cachedDefaultProcessEngine = this.mockProcessEngine("default");
        }
        return cachedDefaultProcessEngine;
    }

    public ProcessEngine getProcessEngine(String name) {
        if (name.equals("aNonExistingEngineName")) {
            return null;
        }
        if (name.equals("default")) {
            return this.getDefaultProcessEngine();
        }
        if (cachedEngines.get(name) == null) {
            ProcessEngine mock = this.mockProcessEngine(name);
            cachedEngines.put(name, mock);
        }
        return cachedEngines.get(name);
    }

    public Set<String> getProcessEngineNames() {
        HashSet<String> result = new HashSet<String>();
        result.add("default");
        result.add("anotherEngineName");
        return result;
    }

    static {
        cachedEngines = new HashMap<String, ProcessEngine>();
    }
}

