/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.converter;

import java.util.ArrayList;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.BatchPermissions;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.camunda.bpm.engine.authorization.ProcessInstancePermissions;
import org.camunda.bpm.engine.authorization.Resources;

public class PermissionConverter {
    public static Permission[] getPermissionsForNames(String[] names, int resourceType) {
        Permission[] permissions = new Permission[names.length];
        for (int i = 0; i < names.length; ++i) {
            permissions[i] = PermissionConverter.getPermissionForName(names[i], resourceType);
        }
        return permissions;
    }

    public static String[] getNamesForPermissions(Authorization authorization, Permission[] permissions) {
        int type = authorization.getAuthorizationType();
        if ((type == 0 || type == 1) && authorization.isEveryPermissionGranted()) {
            return new String[]{Permissions.ALL.getName()};
        }
        if (type == 2 && authorization.isEveryPermissionRevoked()) {
            return new String[]{Permissions.ALL.getName()};
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Permission permission : permissions) {
            String name = permission.getName();
            if (name.equals(Permissions.NONE.getName()) || name.equals(Permissions.ALL.getName())) continue;
            names.add(name);
        }
        return names.toArray(new String[names.size()]);
    }

    public static Permission getPermissionForName(String name, int resourceType) {
        if (resourceType == Resources.BATCH.resourceType()) {
            return BatchPermissions.forName((String)name);
        }
        if (resourceType == Resources.PROCESS_DEFINITION.resourceType()) {
            return ProcessDefinitionPermissions.forName((String)name);
        }
        if (resourceType == Resources.PROCESS_INSTANCE.resourceType()) {
            return ProcessInstancePermissions.forName((String)name);
        }
        return Permissions.forName((String)name);
    }
}

