/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.converter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.spi.PermissionProvider;

public class PermissionConverter {
    public static Permission[] getPermissionsForNames(String[] names, int resourceType) {
        Permission[] permissions = new Permission[names.length];
        for (int i = 0; i < names.length; ++i) {
            permissions[i] = PermissionConverter.getPermissionProvider().getPermissionForName(names[i], resourceType);
        }
        return permissions;
    }

    public static String[] getNamesForPermissions(Authorization authorization, Permission[] permissions) {
        int type = authorization.getAuthorizationType();
        if ((type == 0 || type == 1) && authorization.isEveryPermissionGranted()) {
            return new String[]{Permissions.ALL.getName()};
        }
        if (type == 2 && authorization.isEveryPermissionRevoked()) {
            return new String[]{Permissions.ALL.getName()};
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Permission permission : permissions) {
            String name = permission.getName();
            if (name.equals(Permissions.NONE.getName()) || name.equals(Permissions.ALL.getName())) continue;
            names.add(name);
        }
        return names.toArray(new String[names.size()]);
    }

    public static PermissionProvider getPermissionProvider() {
        ServiceLoader<PermissionProvider> serviceLoader = ServiceLoader.load(PermissionProvider.class);
        Iterator<PermissionProvider> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            PermissionProvider provider = iterator.next();
            return provider;
        }
        throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, "Could not find an implementation of the " + PermissionProvider.class + " - SPI");
    }
}

