/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.pwpolicy.PasswordPolicyChecker;
import org.camunda.bpm.engine.impl.pwpolicy.PasswordPolicyException;
import org.camunda.bpm.engine.pwpolicy.PasswordPolicy;
import org.camunda.bpm.engine.rest.PasswordPolicyRestService;
import org.camunda.bpm.engine.rest.dto.passwordPolicy.PasswordDto;
import org.camunda.bpm.engine.rest.dto.passwordPolicy.PasswordPolicyDto;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;

public class PasswordPolicyRestServiceImpl
extends AbstractRestProcessEngineAware
implements PasswordPolicyRestService {
    public PasswordPolicyRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public PasswordPolicyDto getPasswordPolicy() {
        PasswordPolicy policy = ((ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration()).getPasswordPolicy();
        return PasswordPolicyDto.fromPasswordPolicyRules(policy.getRules());
    }

    @Override
    public Response checkPassword(PasswordDto password) {
        PasswordPolicy policy = ((ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration()).getPasswordPolicy();
        try {
            PasswordPolicyChecker.checkPassword((PasswordPolicy)policy, (String)password.getPassword());
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (PasswordPolicyException e) {
            return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).entity((Object)PasswordPolicyDto.fromPasswordPolicyRules(e.getPolicyRules())).build();
        }
    }
}

