/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.helper.variable.EqualsPrimitiveValue;
import org.camunda.bpm.engine.rest.util.OrderingBuilder;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ExecutionQuery;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class ExecutionRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String EXECUTION_QUERY_URL = "/rest-test/execution";
    protected static final String EXECUTION_COUNT_QUERY_URL = "/rest-test/execution/count";
    private ExecutionQuery mockedQuery;

    @Before
    public void setUpRuntimeData() {
        this.mockedQuery = this.setUpMockExecutionQuery(this.createMockExecutionList());
    }

    private ExecutionQuery setUpMockExecutionQuery(List<Execution> mockedExecutions) {
        ExecutionQuery sampleExecutionQuery = (ExecutionQuery)Mockito.mock(ExecutionQuery.class);
        Mockito.when((Object)sampleExecutionQuery.list()).thenReturn(mockedExecutions);
        Mockito.when((Object)sampleExecutionQuery.count()).thenReturn((Object)mockedExecutions.size());
        Mockito.when((Object)processEngine.getRuntimeService().createExecutionQuery()).thenReturn((Object)sampleExecutionQuery);
        return sampleExecutionQuery;
    }

    private List<Execution> createMockExecutionList() {
        ArrayList<Execution> mocks = new ArrayList<Execution>();
        mocks.add(MockProvider.createMockExecution());
        return mocks;
    }

    @Test
    public void testInvalidVariableRequests() {
        String invalidComparator = "anInvalidComparator";
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_" + invalidComparator + "_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("Invalid variable comparator specified: " + invalidComparator)), new Object[0]).when().get(EXECUTION_QUERY_URL, new Object[0]);
        RestAssured.given().queryParam("processVariables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("Invalid process variable comparator specified: " + invalidComparator)), new Object[0]).when().get(EXECUTION_QUERY_URL, new Object[0]);
        queryValue = "invalidFormattedVariableQuery";
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"variable query parameter has to have format KEY_OPERATOR_VALUE"), new Object[0]).when().get(EXECUTION_QUERY_URL, new Object[0]);
        RestAssured.given().queryParam("processVariables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"variable query parameter has to have format KEY_OPERATOR_VALUE"), new Object[0]).when().get(EXECUTION_QUERY_URL, new Object[0]);
    }

    @Test
    public void testInvalidSortingOptions() {
        this.executeAndVerifySorting("anInvalidSortByOption", "asc", Response.Status.BAD_REQUEST);
        this.executeAndVerifySorting("definitionId", "anInvalidSortOrderOption", Response.Status.BAD_REQUEST);
    }

    protected void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(EXECUTION_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"definitionId"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(EXECUTION_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(EXECUTION_QUERY_URL, new Object[0]);
    }

    @Test
    public void testExecutionRetrieval() {
        String queryKey = "key";
        Response response = (Response)RestAssured.given().queryParam("processDefinitionKey", new Object[]{queryKey}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EXECUTION_QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((ExecutionQuery)inOrder.verify((Object)this.mockedQuery)).processDefinitionKey(queryKey);
        ((ExecutionQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List executions = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one execution returned.", (long)1L, (long)executions.size());
        Assert.assertNotNull((String)"There should be one execution returned", executions.get(0));
        String returnedExecutionId = JsonPath.from((String)content).getString("[0].id");
        Boolean returnedIsEnded = JsonPath.from((String)content).getBoolean("[0].ended");
        String returnedProcessInstanceId = JsonPath.from((String)content).getString("[0].processInstanceId");
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        Assert.assertEquals((Object)"anExecutionId", (Object)returnedExecutionId);
        Assert.assertEquals((Object)false, (Object)returnedIsEnded);
        Assert.assertEquals((Object)"aProcInstId", (Object)returnedProcessInstanceId);
        Assert.assertEquals((Object)"aTenantId", (Object)returnedTenantId);
    }

    @Test
    public void testIncompleteExecution() {
        this.setUpMockExecutionQuery(this.createIncompleteMockExecutions());
        Response response = (Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EXECUTION_QUERY_URL, new Object[0]);
        String content = response.asString();
        String returnedProcessInstanceId = JsonPath.from((String)content).getString("[0].processInstanceId");
        Assert.assertNull((String)"Should be null, as it is also null in the original execution on the server.", (Object)returnedProcessInstanceId);
    }

    private List<Execution> createIncompleteMockExecutions() {
        ArrayList<Execution> mocks = new ArrayList<Execution>();
        Execution mockExecution = (Execution)Mockito.mock(Execution.class);
        Mockito.when((Object)mockExecution.getId()).thenReturn((Object)"anExecutionId");
        mocks.add(mockExecution);
        return mocks;
    }

    @Test
    public void testNoParametersQuery() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EXECUTION_QUERY_URL, new Object[0]);
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testAdditionalParametersExcludingVariables() {
        Map<String, String> queryParameters = this.getCompleteQueryParameters();
        RestAssured.given().queryParams(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EXECUTION_QUERY_URL, new Object[0]);
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceBusinessKey(queryParameters.get("businessKey"));
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceId(queryParameters.get("processInstanceId"));
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionKey(queryParameters.get("processDefinitionKey"));
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionId(queryParameters.get("processDefinitionId"));
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).activityId(queryParameters.get("activityId"));
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).signalEventSubscriptionName(queryParameters.get("signalEventSubscriptionName"));
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).messageEventSubscriptionName(queryParameters.get("messageEventSubscriptionName"));
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).active();
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).suspended();
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).incidentId(queryParameters.get("incidentId"));
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).incidentMessage(queryParameters.get("incidentMessage"));
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).incidentMessageLike(queryParameters.get("incidentMessageLike"));
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).incidentType(queryParameters.get("incidentType"));
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    private Map<String, String> getCompleteQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("businessKey", "aBusinessKey");
        parameters.put("processInstanceId", "aProcInstId");
        parameters.put("processDefinitionKey", "aProcDefKey");
        parameters.put("processDefinitionId", "aProcDefId");
        parameters.put("activityId", "anActivityId");
        parameters.put("signalEventSubscriptionName", "anEventName");
        parameters.put("messageEventSubscriptionName", "aMessageName");
        parameters.put("suspended", "true");
        parameters.put("active", "true");
        parameters.put("incidentId", "incId");
        parameters.put("incidentType", "incType");
        parameters.put("incidentMessage", "incMessage");
        parameters.put("incidentMessageLike", "incMessageLike");
        return parameters;
    }

    @Test
    public void testVariableParameters() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_eq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EXECUTION_QUERY_URL, new Object[0]);
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName, (Object)variableValue);
        queryValue = variableName + "_gt_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EXECUTION_QUERY_URL, new Object[0]);
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).variableValueGreaterThan(variableName, (Object)variableValue);
        queryValue = variableName + "_gteq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EXECUTION_QUERY_URL, new Object[0]);
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).variableValueGreaterThanOrEqual(variableName, (Object)variableValue);
        queryValue = variableName + "_lt_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EXECUTION_QUERY_URL, new Object[0]);
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLessThan(variableName, (Object)variableValue);
        queryValue = variableName + "_lteq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EXECUTION_QUERY_URL, new Object[0]);
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLessThanOrEqual(variableName, (Object)variableValue);
        queryValue = variableName + "_like_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EXECUTION_QUERY_URL, new Object[0]);
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLike(variableName, variableValue);
        queryValue = variableName + "_neq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EXECUTION_QUERY_URL, new Object[0]);
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals(variableName, (Object)variableValue);
    }

    @Test
    public void testProcessVariableParameters() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_eq_" + variableValue;
        RestAssured.given().queryParam("processVariables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EXECUTION_QUERY_URL, new Object[0]);
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).processVariableValueEquals(variableName, (Object)variableValue);
        queryValue = variableName + "_neq_" + variableValue;
        RestAssured.given().queryParam("processVariables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EXECUTION_QUERY_URL, new Object[0]);
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).processVariableValueNotEquals(variableName, (Object)variableValue);
    }

    @Test
    public void testMultipleVariableParameters() {
        String variableName1 = "varName";
        String variableValue1 = "varValue";
        String variableParameter1 = variableName1 + "_eq_" + variableValue1;
        String variableName2 = "anotherVarName";
        String variableValue2 = "anotherVarValue";
        String variableParameter2 = variableName2 + "_neq_" + variableValue2;
        String queryValue = variableParameter1 + "," + variableParameter2;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EXECUTION_QUERY_URL, new Object[0]);
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName1, (Object)variableValue1);
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals(variableName2, (Object)variableValue2);
    }

    @Test
    public void testMultipleProcessVariableParameters() {
        String variableName1 = "varName";
        String variableValue1 = "varValue";
        String variableParameter1 = variableName1 + "_eq_" + variableValue1;
        String variableName2 = "anotherVarName";
        String variableValue2 = "anotherVarValue";
        String variableParameter2 = variableName2 + "_neq_" + variableValue2;
        String queryValue = variableParameter1 + "," + variableParameter2;
        RestAssured.given().queryParam("processVariables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EXECUTION_QUERY_URL, new Object[0]);
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).processVariableValueEquals(variableName1, (Object)variableValue1);
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).processVariableValueNotEquals(variableName2, (Object)variableValue2);
    }

    @Test
    public void testMultipleVariableParametersAsPost() {
        String variableName = "varName";
        String variableValue = "varValue";
        String anotherVariableName = "anotherVarName";
        Integer anotherVariableValue = 30;
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", variableName);
        variableJson.put("operator", "eq");
        variableJson.put("value", variableValue);
        HashMap<String, Object> anotherVariableJson = new HashMap<String, Object>();
        anotherVariableJson.put("name", anotherVariableName);
        anotherVariableJson.put("operator", "neq");
        anotherVariableJson.put("value", anotherVariableValue);
        ArrayList<HashMap<String, Object>> variables = new ArrayList<HashMap<String, Object>>();
        variables.add(variableJson);
        variables.add(anotherVariableJson);
        HashMap<String, ArrayList<HashMap<String, Object>>> json = new HashMap<String, ArrayList<HashMap<String, Object>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(EXECUTION_QUERY_URL, new Object[0]);
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName, (Object)variableValue);
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals((String)org.mockito.Matchers.eq((Object)anotherVariableName), org.mockito.Matchers.argThat((Matcher)EqualsPrimitiveValue.numberValue(anotherVariableValue)));
    }

    @Test
    public void testMultipleProcessVariableParametersAsPost() {
        String variableName = "varName";
        String variableValue = "varValue";
        String anotherVariableName = "anotherVarName";
        Integer anotherVariableValue = 30;
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", variableName);
        variableJson.put("operator", "eq");
        variableJson.put("value", variableValue);
        HashMap<String, Object> anotherVariableJson = new HashMap<String, Object>();
        anotherVariableJson.put("name", anotherVariableName);
        anotherVariableJson.put("operator", "neq");
        anotherVariableJson.put("value", anotherVariableValue);
        ArrayList<HashMap<String, Object>> variables = new ArrayList<HashMap<String, Object>>();
        variables.add(variableJson);
        variables.add(anotherVariableJson);
        HashMap<String, ArrayList<HashMap<String, Object>>> json = new HashMap<String, ArrayList<HashMap<String, Object>>>();
        json.put("processVariables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(EXECUTION_QUERY_URL, new Object[0]);
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).processVariableValueEquals(variableName, (Object)variableValue);
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).processVariableValueNotEquals((String)org.mockito.Matchers.eq((Object)anotherVariableName), org.mockito.Matchers.argThat((Matcher)EqualsPrimitiveValue.numberValue(anotherVariableValue)));
    }

    @Test
    public void testCompletePostParameters() {
        Map<String, String> queryParameters = this.getCompleteQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(EXECUTION_QUERY_URL, new Object[0]);
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceBusinessKey(queryParameters.get("businessKey"));
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceId(queryParameters.get("processInstanceId"));
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionKey(queryParameters.get("processDefinitionKey"));
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionId(queryParameters.get("processDefinitionId"));
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).activityId(queryParameters.get("activityId"));
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).signalEventSubscriptionName(queryParameters.get("signalEventSubscriptionName"));
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).messageEventSubscriptionName(queryParameters.get("messageEventSubscriptionName"));
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).active();
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).suspended();
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).incidentId(queryParameters.get("incidentId"));
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).incidentMessage(queryParameters.get("incidentMessage"));
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).incidentMessageLike(queryParameters.get("incidentMessageLike"));
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).incidentType(queryParameters.get("incidentType"));
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testTenantIdListParameter() {
        this.mockedQuery = this.setUpMockExecutionQuery(this.createMockExecutionsTwoTenants());
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId,anotherTenantId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EXECUTION_QUERY_URL, new Object[0]);
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List executions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)executions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testTenantIdListPostParameter() {
        this.mockedQuery = this.setUpMockExecutionQuery(this.createMockExecutionsTwoTenants());
        HashMap<String, String[]> queryParameters = new HashMap<String, String[]>();
        queryParameters.put("tenantIdIn", "aTenantId,anotherTenantId".split(","));
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(EXECUTION_QUERY_URL, new Object[0]);
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List executions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)executions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    private List<Execution> createMockExecutionsTwoTenants() {
        return Arrays.asList(MockProvider.createMockExecution("aTenantId"), MockProvider.createMockExecution("anotherTenantId"));
    }

    @Test
    public void testSortingParameters() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("instanceId", "asc", Response.Status.OK);
        ((ExecutionQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceId();
        ((ExecutionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("definitionKey", "desc", Response.Status.OK);
        ((ExecutionQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionKey();
        ((ExecutionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("definitionId", "asc", Response.Status.OK);
        ((ExecutionQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionId();
        ((ExecutionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "asc", Response.Status.OK);
        ((ExecutionQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((ExecutionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
    }

    @Test
    public void testSecondarySortingAsPost() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        HashMap<String, List<Map<String, Object>>> json = new HashMap<String, List<Map<String, Object>>>();
        json.put("sorting", OrderingBuilder.create().orderBy("definitionKey").desc().orderBy("instanceId").asc().getJson());
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(EXECUTION_QUERY_URL, new Object[0]);
        ((ExecutionQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionKey();
        ((ExecutionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        ((ExecutionQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceId();
        ((ExecutionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
    }

    @Test
    public void testSuccessfulPagination() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EXECUTION_QUERY_URL, new Object[0]);
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, maxResults);
    }

    @Test
    public void testMissingFirstResultParameter() {
        int maxResults = 10;
        RestAssured.given().queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EXECUTION_QUERY_URL, new Object[0]);
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).listPage(0, maxResults);
    }

    @Test
    public void testMissingMaxResultsParameter() {
        int firstResult = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EXECUTION_QUERY_URL, new Object[0]);
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, Integer.MAX_VALUE);
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(EXECUTION_COUNT_QUERY_URL, new Object[0]);
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testQueryCountForPost() {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().post(EXECUTION_COUNT_QUERY_URL, new Object[0]);
        ((ExecutionQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }
}

