/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import io.restassured.RestAssured;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.List;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.history.HistoricCaseActivityStatistics;
import org.camunda.bpm.engine.history.HistoricCaseActivityStatisticsQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class HistoricCaseActivityStatisticsRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORY_URL = "/rest-test/history";
    protected static final String HISTORIC_CASE_ACTIVITY_STATISTICS_URL = "/rest-test/history/case-definition/{id}/statistics";
    protected static HistoricCaseActivityStatisticsQuery historicCaseActivityStatisticsQuery;

    @BeforeClass
    public static void setUpRuntimeData() {
        List<HistoricCaseActivityStatistics> mocks = MockProvider.createMockHistoricCaseActivityStatistics();
        historicCaseActivityStatisticsQuery = (HistoricCaseActivityStatisticsQuery)Mockito.mock(HistoricCaseActivityStatisticsQuery.class);
        Mockito.when((Object)processEngine.getHistoryService().createHistoricCaseActivityStatisticsQuery((String)Matchers.eq((Object)"aCaseDefnitionId"))).thenReturn((Object)historicCaseActivityStatisticsQuery);
        Mockito.when((Object)historicCaseActivityStatisticsQuery.list()).thenReturn(mocks);
    }

    @Test
    public void testHistoricCaseActivityStatisticsRetrieval() {
        RestAssured.given().pathParam("id", (Object)"aCaseDefnitionId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("$.size()", org.hamcrest.Matchers.is((Object)2), new Object[0]).body("id", org.hamcrest.Matchers.hasItems((Object[])new String[]{"anActivity", "anotherActivity"}), new Object[0]).when().get(HISTORIC_CASE_ACTIVITY_STATISTICS_URL, new Object[0]);
    }

    @Test
    public void testSimpleTaskQuery() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aCaseDefnitionId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_ACTIVITY_STATISTICS_URL, new Object[0]);
        String content = response.asString();
        List result = JsonPath.from((String)content).getList("");
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertNotNull(result.get(0));
        Assert.assertNotNull(result.get(1));
        String id = JsonPath.from((String)content).getString("[0].id");
        long available = JsonPath.from((String)content).getLong("[0].available");
        long active = JsonPath.from((String)content).getLong("[0].active");
        long completed = JsonPath.from((String)content).getLong("[0].completed");
        long disabled = JsonPath.from((String)content).getLong("[0].disabled");
        long enabled = JsonPath.from((String)content).getLong("[0].enabled");
        long terminated = JsonPath.from((String)content).getLong("[0].terminated");
        Assert.assertEquals((Object)"anActivity", (Object)id);
        Assert.assertEquals((long)123L, (long)available);
        Assert.assertEquals((long)124L, (long)active);
        Assert.assertEquals((long)125L, (long)completed);
        Assert.assertEquals((long)126L, (long)disabled);
        Assert.assertEquals((long)127L, (long)enabled);
        Assert.assertEquals((long)128L, (long)terminated);
        id = JsonPath.from((String)content).getString("[1].id");
        available = JsonPath.from((String)content).getLong("[1].available");
        active = JsonPath.from((String)content).getLong("[1].active");
        completed = JsonPath.from((String)content).getLong("[1].completed");
        disabled = JsonPath.from((String)content).getLong("[1].disabled");
        enabled = JsonPath.from((String)content).getLong("[1].enabled");
        terminated = JsonPath.from((String)content).getLong("[1].terminated");
        Assert.assertEquals((Object)"anotherActivity", (Object)id);
        Assert.assertEquals((long)129L, (long)available);
        Assert.assertEquals((long)130L, (long)active);
        Assert.assertEquals((long)131L, (long)completed);
        Assert.assertEquals((long)132L, (long)disabled);
        Assert.assertEquals((long)133L, (long)enabled);
        Assert.assertEquals((long)134L, (long)terminated);
    }
}

