/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import junit.framework.TestCase;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.history.HistoricExternalTaskLog;
import org.camunda.bpm.engine.history.HistoricExternalTaskLogQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.OrderingBuilder;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class HistoricExternalTaskLogRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_URL = "/rest-test/history/external-task-log";
    protected static final String HISTORIC_EXTERNAL_TASK_LOG_COUNT_RESOURCE_URL = "/rest-test/history/external-task-log/count";
    protected static final long EXTERNAL_TASK_LOG_QUERY_MAX_PRIORITY = Long.MAX_VALUE;
    protected static final long EXTERNAL_TASK_LOG_QUERY_MIN_PRIORITY = Long.MIN_VALUE;
    protected HistoricExternalTaskLogQuery mockedQuery;

    @Before
    public void setUpRuntimeData() throws IOException {
        this.mockedQuery = this.setUpMockHistoricExternalTaskLogQuery(MockProvider.createMockHistoricExternalTaskLogs());
    }

    protected HistoricExternalTaskLogQuery setUpMockHistoricExternalTaskLogQuery(List<HistoricExternalTaskLog> mockedHistoricExternalTaskLogs) {
        HistoricExternalTaskLogQuery mockedHistoricExternalTaskLogQuery = (HistoricExternalTaskLogQuery)Mockito.mock(HistoricExternalTaskLogQuery.class);
        Mockito.when((Object)mockedHistoricExternalTaskLogQuery.list()).thenReturn(mockedHistoricExternalTaskLogs);
        Mockito.when((Object)mockedHistoricExternalTaskLogQuery.count()).thenReturn((Object)mockedHistoricExternalTaskLogs.size());
        Mockito.when((Object)processEngine.getHistoryService().createHistoricExternalTaskLogQuery()).thenReturn((Object)mockedHistoricExternalTaskLogQuery);
        return mockedHistoricExternalTaskLogQuery;
    }

    @Test
    public void testEmptyQuery() {
        String queryKey = "";
        RestAssured.given().queryParam("processDefinitionKey", new Object[]{queryKey}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_URL, new Object[0]);
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testNoParametersQuery() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_URL, new Object[0]);
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testNoParametersQueryAsPost() {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_URL, new Object[0]);
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testInvalidSortingOptions() {
        this.executeAndVerifySorting("anInvalidSortByOption", "asc", Response.Status.BAD_REQUEST);
        this.executeAndVerifySorting("definitionId", "anInvalidSortOrderOption", Response.Status.BAD_REQUEST);
    }

    protected void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"processDefinitionId"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSortingParameters() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("timestamp", "asc", Response.Status.OK);
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByTimestamp();
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("timestamp", "desc", Response.Status.OK);
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByTimestamp();
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("externalTaskId", "asc", Response.Status.OK);
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByExternalTaskId();
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("externalTaskId", "desc", Response.Status.OK);
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByExternalTaskId();
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("topicName", "asc", Response.Status.OK);
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByTopicName();
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("topicName", "desc", Response.Status.OK);
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByTopicName();
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("workerId", "asc", Response.Status.OK);
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByWorkerId();
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("workerId", "desc", Response.Status.OK);
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByWorkerId();
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("retries", "asc", Response.Status.OK);
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByRetries();
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("retries", "desc", Response.Status.OK);
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByRetries();
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("priority", "asc", Response.Status.OK);
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByPriority();
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("priority", "desc", Response.Status.OK);
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByPriority();
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("activityId", "asc", Response.Status.OK);
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByActivityId();
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("activityId", "desc", Response.Status.OK);
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByActivityId();
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("activityInstanceId", "asc", Response.Status.OK);
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByActivityInstanceId();
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("activityInstanceId", "desc", Response.Status.OK);
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByActivityInstanceId();
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("executionId", "asc", Response.Status.OK);
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByExecutionId();
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("executionId", "desc", Response.Status.OK);
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByExecutionId();
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processInstanceId", "asc", Response.Status.OK);
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceId();
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processInstanceId", "desc", Response.Status.OK);
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceId();
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processDefinitionId", "asc", Response.Status.OK);
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionId();
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processDefinitionId", "desc", Response.Status.OK);
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionId();
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processDefinitionKey", "asc", Response.Status.OK);
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionKey();
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processDefinitionKey", "desc", Response.Status.OK);
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionKey();
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "asc", Response.Status.OK);
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "desc", Response.Status.OK);
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
    }

    @Test
    public void testSecondarySortingAsPost() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        HashMap<String, List<Map<String, Object>>> json = new HashMap<String, List<Map<String, Object>>>();
        json.put("sorting", OrderingBuilder.create().orderBy("processInstanceId").desc().orderBy("timestamp").asc().getJson());
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_URL, new Object[0]);
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceId();
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByTimestamp();
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
    }

    @Test
    public void testSuccessfulPagination() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_URL, new Object[0]);
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, maxResults);
    }

    @Test
    public void testMissingFirstResultParameter() {
        int maxResults = 10;
        RestAssured.given().queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_URL, new Object[0]);
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).listPage(0, maxResults);
    }

    @Test
    public void testMissingMaxResultsParameter() {
        int firstResult = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_URL, new Object[0]);
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, Integer.MAX_VALUE);
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(HISTORIC_EXTERNAL_TASK_LOG_COUNT_RESOURCE_URL, new Object[0]);
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testQueryCountForPost() {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().body("count", Matchers.equalTo((Object)1), new Object[0]).when().post(HISTORIC_EXTERNAL_TASK_LOG_COUNT_RESOURCE_URL, new Object[0]);
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testSimpleHistoricExternalTaskLogQuery() {
        String processInstanceId = "aProcInstId";
        Response response = (Response)RestAssured.given().queryParam("processInstanceId", new Object[]{processInstanceId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).processInstanceId(processInstanceId);
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List logs = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one historic externalTask log returned.", (long)1L, (long)logs.size());
        TestCase.assertNotNull((String)"The returned historic externalTask log should not be null.", logs.get(0));
        String returnedId = JsonPath.from((String)content).getString("[0].id");
        String returnedTimestamp = JsonPath.from((String)content).getString("[0].timestamp");
        String returnedExternalTaskId = JsonPath.from((String)content).getString("[0].externalTaskId");
        String returnedExternalTaskTopicName = JsonPath.from((String)content).getString("[0].topicName");
        String returnedExternalTaskWorkerId = JsonPath.from((String)content).getString("[0].workerId");
        int returnedRetries = JsonPath.from((String)content).getInt("[0].retries");
        long returnedPriority = JsonPath.from((String)content).getLong("[0].priority");
        String returnedErrorMessage = JsonPath.from((String)content).getString("[0].errorMessage");
        String returnedActivityId = JsonPath.from((String)content).getString("[0].activityId");
        String returnedActivityInstanceId = JsonPath.from((String)content).getString("[0].activityInstanceId");
        String returnedExecutionId = JsonPath.from((String)content).getString("[0].executionId");
        String returnedProcessInstanceId = JsonPath.from((String)content).getString("[0].processInstanceId");
        String returnedProcessDefinitionId = JsonPath.from((String)content).getString("[0].processDefinitionId");
        String returnedProcessDefinitionKey = JsonPath.from((String)content).getString("[0].processDefinitionKey");
        boolean returnedCreationLog = JsonPath.from((String)content).getBoolean("[0].creationLog");
        boolean returnedFailureLog = JsonPath.from((String)content).getBoolean("[0].failureLog");
        boolean returnedSuccessLog = JsonPath.from((String)content).getBoolean("[0].successLog");
        boolean returnedDeletionLog = JsonPath.from((String)content).getBoolean("[0].deletionLog");
        Assert.assertEquals((Object)"aHistoricExternalTaskLogId", (Object)returnedId);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_HISTORIC_EXTERNAL_TASK_LOG_TIMESTAMP, (Object)returnedTimestamp);
        Assert.assertEquals((Object)"anExternalTaskId", (Object)returnedExternalTaskId);
        Assert.assertEquals((Object)"aTopicName", (Object)returnedExternalTaskTopicName);
        Assert.assertEquals((Object)"aWorkerId", (Object)returnedExternalTaskWorkerId);
        Assert.assertEquals((long)5L, (long)returnedRetries);
        Assert.assertEquals((long)2147483689L, (long)returnedPriority);
        Assert.assertEquals((Object)"aEXTERNAL_TASKExceptionMsg", (Object)returnedErrorMessage);
        Assert.assertEquals((Object)"anActId", (Object)returnedActivityId);
        Assert.assertEquals((Object)"anActInstanceId", (Object)returnedActivityInstanceId);
        Assert.assertEquals((Object)"anExecId", (Object)returnedExecutionId);
        Assert.assertEquals((Object)"aProcInstId", (Object)returnedProcessInstanceId);
        Assert.assertEquals((Object)"aProcDefId", (Object)returnedProcessDefinitionId);
        Assert.assertEquals((Object)"aProcDefKey", (Object)returnedProcessDefinitionKey);
        Assert.assertEquals((Object)true, (Object)returnedCreationLog);
        Assert.assertEquals((Object)true, (Object)returnedFailureLog);
        Assert.assertEquals((Object)true, (Object)returnedSuccessLog);
        Assert.assertEquals((Object)true, (Object)returnedDeletionLog);
    }

    @Test
    public void testSimpleHistoricExternalTaskLogQueryAsPost() {
        String processInstanceId = "aProcInstId";
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("processInstanceId", processInstanceId);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).processInstanceId(processInstanceId);
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List logs = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one historic externalTask log returned.", (long)1L, (long)logs.size());
        TestCase.assertNotNull((String)"The returned historic externalTask log should not be null.", logs.get(0));
        String returnedId = JsonPath.from((String)content).getString("[0].id");
        String returnedTimestamp = JsonPath.from((String)content).getString("[0].timestamp");
        String returnedRemovalTime = JsonPath.from((String)content).getString("[0].removalTime");
        String returnedExternalTaskId = JsonPath.from((String)content).getString("[0].externalTaskId");
        String returnedExternalTaskTopicName = JsonPath.from((String)content).getString("[0].topicName");
        String returnedExternalTaskWorkerId = JsonPath.from((String)content).getString("[0].workerId");
        int returnedRetries = JsonPath.from((String)content).getInt("[0].retries");
        long returnedPriority = JsonPath.from((String)content).getLong("[0].priority");
        String returnedErrorMessage = JsonPath.from((String)content).getString("[0].errorMessage");
        String returnedActivityId = JsonPath.from((String)content).getString("[0].activityId");
        String returnedActivityInstanceId = JsonPath.from((String)content).getString("[0].activityInstanceId");
        String returnedExecutionId = JsonPath.from((String)content).getString("[0].executionId");
        String returnedProcessInstanceId = JsonPath.from((String)content).getString("[0].processInstanceId");
        String returnedProcessDefinitionId = JsonPath.from((String)content).getString("[0].processDefinitionId");
        String returnedProcessDefinitionKey = JsonPath.from((String)content).getString("[0].processDefinitionKey");
        String returnedRootProcessInstanceId = JsonPath.from((String)content).getString("[0].rootProcessInstanceId");
        boolean returnedCreationLog = JsonPath.from((String)content).getBoolean("[0].creationLog");
        boolean returnedFailureLog = JsonPath.from((String)content).getBoolean("[0].failureLog");
        boolean returnedSuccessLog = JsonPath.from((String)content).getBoolean("[0].successLog");
        boolean returnedDeletionLog = JsonPath.from((String)content).getBoolean("[0].deletionLog");
        Assert.assertEquals((Object)"aHistoricExternalTaskLogId", (Object)returnedId);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_HISTORIC_EXTERNAL_TASK_LOG_TIMESTAMP, (Object)returnedTimestamp);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_HISTORIC_EXTERNAL_TASK_LOG_REMOVAL_TIME, (Object)returnedRemovalTime);
        Assert.assertEquals((Object)"anExternalTaskId", (Object)returnedExternalTaskId);
        Assert.assertEquals((Object)"aTopicName", (Object)returnedExternalTaskTopicName);
        Assert.assertEquals((Object)"aWorkerId", (Object)returnedExternalTaskWorkerId);
        Assert.assertEquals((long)5L, (long)returnedRetries);
        Assert.assertEquals((long)2147483689L, (long)returnedPriority);
        Assert.assertEquals((Object)"aEXTERNAL_TASKExceptionMsg", (Object)returnedErrorMessage);
        Assert.assertEquals((Object)"anActId", (Object)returnedActivityId);
        Assert.assertEquals((Object)"anActInstanceId", (Object)returnedActivityInstanceId);
        Assert.assertEquals((Object)"anExecId", (Object)returnedExecutionId);
        Assert.assertEquals((Object)"aProcInstId", (Object)returnedProcessInstanceId);
        Assert.assertEquals((Object)"aProcDefId", (Object)returnedProcessDefinitionId);
        Assert.assertEquals((Object)"aProcDefKey", (Object)returnedProcessDefinitionKey);
        Assert.assertEquals((Object)"aRootProcInstId", (Object)returnedRootProcessInstanceId);
        Assert.assertEquals((Object)true, (Object)returnedCreationLog);
        Assert.assertEquals((Object)true, (Object)returnedFailureLog);
        Assert.assertEquals((Object)true, (Object)returnedSuccessLog);
        Assert.assertEquals((Object)true, (Object)returnedDeletionLog);
    }

    @Test
    public void testStringParameters() {
        Map<String, String> stringQueryParameters = this.getCompleteStringQueryParameters();
        RestAssured.given().queryParams(stringQueryParameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_URL, new Object[0]);
        this.verifyStringParameterQueryInvocations();
    }

    @Test
    public void testStringParametersAsPost() {
        Map<String, String> stringQueryParameters = this.getCompleteStringQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(stringQueryParameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_URL, new Object[0]);
        this.verifyStringParameterQueryInvocations();
    }

    protected Map<String, String> getCompleteStringQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("logId", "aHistoricExternalTaskLogId");
        parameters.put("externalTaskId", "anExternalTaskId");
        parameters.put("topicName", "aTopicName");
        parameters.put("workerId", "aWorkerId");
        parameters.put("errorMessage", "aEXTERNAL_TASKExceptionMsg");
        parameters.put("processInstanceId", "aProcInstId");
        parameters.put("processDefinitionId", "aProcDefId");
        parameters.put("processDefinitionKey", "aProcDefKey");
        return parameters;
    }

    protected void verifyStringParameterQueryInvocations() {
        Map<String, String> stringQueryParameters = this.getCompleteStringQueryParameters();
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).logId(stringQueryParameters.get("logId"));
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).externalTaskId(stringQueryParameters.get("externalTaskId"));
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).topicName(stringQueryParameters.get("topicName"));
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).workerId(stringQueryParameters.get("workerId"));
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).errorMessage(stringQueryParameters.get("errorMessage"));
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceId(stringQueryParameters.get("processInstanceId"));
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionId(stringQueryParameters.get("processDefinitionId"));
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionKey(stringQueryParameters.get("processDefinitionKey"));
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testListParameters() {
        String anActId = "anActId";
        String anotherActId = "anotherActId";
        String anActInstId = "anActInstId";
        String anotherActInstId = "anotherActInstId";
        String anExecutionId = "anExecutionId";
        String anotherExecutionId = "anotherExecutionId";
        RestAssured.given().queryParam("activityIdIn", new Object[]{anActId + "," + anotherActId}).queryParam("activityInstanceIdIn", new Object[]{anActInstId + "," + anotherActInstId}).queryParam("executionIdIn", new Object[]{anExecutionId + "," + anotherExecutionId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_URL, new Object[0]);
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).activityIdIn(new String[]{anActId, anotherActId});
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).activityInstanceIdIn(new String[]{anActInstId, anotherActInstId});
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).executionIdIn(new String[]{anExecutionId, anotherExecutionId});
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testListParametersAsPost() {
        String anActId = "anActId";
        String anotherActId = "anotherActId";
        String anActInstId = "anActInstId";
        String anotherActInstId = "anotherActInstId";
        String anExecutionId = "anExecutionId";
        String anotherExecutionId = "anotherExecutionId";
        HashMap<String, List<String>> json = new HashMap<String, List<String>>();
        json.put("activityIdIn", Arrays.asList(anActId, anotherActId));
        json.put("activityInstanceIdIn", Arrays.asList(anActInstId, anotherActInstId));
        json.put("executionIdIn", Arrays.asList(anExecutionId, anotherExecutionId));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_URL, new Object[0]);
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).activityIdIn(new String[]{anActId, anotherActId});
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).activityInstanceIdIn(new String[]{anActInstId, anotherActInstId});
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).executionIdIn(new String[]{anExecutionId, anotherExecutionId});
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testBooleanParameters() {
        Map<String, Boolean> params = this.getCompleteBooleanQueryParameters();
        RestAssured.given().queryParams(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_URL, new Object[0]);
        this.verifyBooleanParameterQueryInvocations();
    }

    @Test
    public void testBooleanParametersAsPost() {
        Map<String, Boolean> params = this.getCompleteBooleanQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_URL, new Object[0]);
        this.verifyBooleanParameterQueryInvocations();
    }

    protected Map<String, Boolean> getCompleteBooleanQueryParameters() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("creationLog", true);
        parameters.put("failureLog", true);
        parameters.put("successLog", true);
        parameters.put("deletionLog", true);
        return parameters;
    }

    protected void verifyBooleanParameterQueryInvocations() {
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).creationLog();
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).failureLog();
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).successLog();
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).deletionLog();
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testIntegerParameters() {
        Map<String, Object> params = this.getCompleteIntegerQueryParameters();
        RestAssured.given().queryParams(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_URL, new Object[0]);
        this.verifyIntegerParameterQueryInvocations();
    }

    @Test
    public void testIntegerParametersAsPost() {
        Map<String, Object> params = this.getCompleteIntegerQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_URL, new Object[0]);
        this.verifyIntegerParameterQueryInvocations();
    }

    protected Map<String, Object> getCompleteIntegerQueryParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("priorityLowerThanOrEquals", Long.MAX_VALUE);
        parameters.put("priorityHigherThanOrEquals", Long.MIN_VALUE);
        return parameters;
    }

    protected void verifyIntegerParameterQueryInvocations() {
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).priorityLowerThanOrEquals(Long.MAX_VALUE);
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).priorityHigherThanOrEquals(Long.MIN_VALUE);
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testTenantIdListParameter() {
        this.mockedQuery = this.setUpMockHistoricExternalTaskLogQuery(this.createMockHistoricExternalTaskLogsTwoTenants());
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId,anotherTenantId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_URL, new Object[0]);
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List externalTaskLogs = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)externalTaskLogs).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testTenantIdListPostParameter() {
        this.mockedQuery = this.setUpMockHistoricExternalTaskLogQuery(this.createMockHistoricExternalTaskLogsTwoTenants());
        HashMap<String, String[]> queryParameters = new HashMap<String, String[]>();
        queryParameters.put("tenantIdIn", "aTenantId,anotherTenantId".split(","));
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_URL, new Object[0]);
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((HistoricExternalTaskLogQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List externalTaskLogs = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)externalTaskLogs).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    private List<HistoricExternalTaskLog> createMockHistoricExternalTaskLogsTwoTenants() {
        return Arrays.asList(MockProvider.createMockHistoricExternalTaskLog("aTenantId"), MockProvider.createMockHistoricExternalTaskLog("anotherTenantId"));
    }
}

