/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.history.UserOperationLogEntryDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class UserOperationLogRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String USER_OPERATION_LOG_RESOURCE_URL = "/rest-test/history/user-operation";
    protected static final String USER_OPERATION_LOG_COUNT_RESOURCE_URL = "/rest-test/history/user-operation/count";
    protected UserOperationLogQuery queryMock;

    @Before
    public void setUpMock() {
        List<UserOperationLogEntry> entries = MockProvider.createUserOperationLogEntries();
        this.queryMock = (UserOperationLogQuery)Mockito.mock(UserOperationLogQuery.class);
        Mockito.when((Object)this.queryMock.list()).thenReturn(entries);
        Mockito.when((Object)this.queryMock.listPage(org.mockito.Matchers.anyInt(), org.mockito.Matchers.anyInt())).thenReturn(entries);
        Mockito.when((Object)this.queryMock.count()).thenReturn((Object)entries.size());
        Mockito.when((Object)processEngine.getHistoryService().createUserOperationLogQuery()).thenReturn((Object)this.queryMock);
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(USER_OPERATION_LOG_COUNT_RESOURCE_URL, new Object[0]);
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).count();
    }

    @Test
    public void testEmptyQuery() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(USER_OPERATION_LOG_RESOURCE_URL, new Object[0]);
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock, (VerificationMode)Mockito.never())).deploymentId(org.mockito.Matchers.anyString());
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock, (VerificationMode)Mockito.never())).processDefinitionId(org.mockito.Matchers.anyString());
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock, (VerificationMode)Mockito.never())).processDefinitionKey(org.mockito.Matchers.anyString());
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock, (VerificationMode)Mockito.never())).processInstanceId(org.mockito.Matchers.anyString());
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock, (VerificationMode)Mockito.never())).executionId(org.mockito.Matchers.anyString());
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock, (VerificationMode)Mockito.never())).caseDefinitionId(org.mockito.Matchers.anyString());
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock, (VerificationMode)Mockito.never())).caseInstanceId(org.mockito.Matchers.anyString());
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock, (VerificationMode)Mockito.never())).caseExecutionId(org.mockito.Matchers.anyString());
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock, (VerificationMode)Mockito.never())).taskId(org.mockito.Matchers.anyString());
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock, (VerificationMode)Mockito.never())).jobId(org.mockito.Matchers.anyString());
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock, (VerificationMode)Mockito.never())).jobDefinitionId(org.mockito.Matchers.anyString());
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock, (VerificationMode)Mockito.never())).batchId(org.mockito.Matchers.anyString());
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock, (VerificationMode)Mockito.never())).userId(org.mockito.Matchers.anyString());
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock, (VerificationMode)Mockito.never())).operationId(org.mockito.Matchers.anyString());
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock, (VerificationMode)Mockito.never())).externalTaskId(org.mockito.Matchers.anyString());
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock, (VerificationMode)Mockito.never())).operationType(org.mockito.Matchers.anyString());
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock, (VerificationMode)Mockito.never())).entityType(org.mockito.Matchers.anyString());
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock, (VerificationMode)Mockito.never())).category(org.mockito.Matchers.anyString());
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock, (VerificationMode)Mockito.never())).property(org.mockito.Matchers.anyString());
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock, (VerificationMode)Mockito.never())).afterTimestamp((Date)org.mockito.Matchers.any(Date.class));
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock, (VerificationMode)Mockito.never())).beforeTimestamp((Date)org.mockito.Matchers.any(Date.class));
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock, (VerificationMode)Mockito.never())).orderByTimestamp();
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock, (VerificationMode)Mockito.never())).asc();
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock, (VerificationMode)Mockito.never())).desc();
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).list();
    }

    @Test
    public void testQueryParameter() {
        Response response = (Response)RestAssured.given().queryParam("deploymentId", new Object[]{"a-deployment-id"}).queryParam("processDefinitionId", new Object[]{"1"}).queryParam("processDefinitionKey", new Object[]{"6"}).queryParam("processInstanceId", new Object[]{"2"}).queryParam("executionId", new Object[]{"3"}).queryParam("caseDefinitionId", new Object[]{"x"}).queryParam("caseInstanceId", new Object[]{"y"}).queryParam("caseExecutionId", new Object[]{"z"}).queryParam("taskId", new Object[]{"4"}).queryParam("jobId", new Object[]{"7"}).queryParam("jobDefinitionId", new Object[]{"8"}).queryParam("batchId", new Object[]{"aBatchId"}).queryParam("userId", new Object[]{"icke"}).queryParam("operationId", new Object[]{"5"}).queryParam("externalTaskId", new Object[]{"1"}).queryParam("operationType", new Object[]{"Claim"}).queryParam("entityType", new Object[]{"Task"}).queryParam("entityTypeIn", new Object[]{"Task,Variable"}).queryParam("category", new Object[]{"TaskWorker"}).queryParam("categoryIn", new Object[]{"TaskWorker,Operator"}).queryParam("property", new Object[]{"owner"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(USER_OPERATION_LOG_RESOURCE_URL, new Object[0]);
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).deploymentId("a-deployment-id");
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).processDefinitionId("1");
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).processDefinitionKey("6");
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).processInstanceId("2");
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).executionId("3");
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).caseDefinitionId("x");
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).caseInstanceId("y");
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).caseExecutionId("z");
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).taskId("4");
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).jobId("7");
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).jobDefinitionId("8");
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).batchId("aBatchId");
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).userId("icke");
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).operationId("5");
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).externalTaskId("1");
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).operationType("Claim");
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).entityType("Task");
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).entityTypeIn(new String[]{"Task", "Variable"});
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).category("TaskWorker");
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).categoryIn(new String[]{"TaskWorker", "Operator"});
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).property("owner");
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).list();
        String json = response.asString();
        UserOperationLogEntryDto actual = (UserOperationLogEntryDto)JsonPath.from((String)json).getObject("[0]", UserOperationLogEntryDto.class);
        Assert.assertEquals((Object)"userOpLogId", (Object)actual.getId());
        Assert.assertEquals((Object)"aDeploymentId", (Object)actual.getDeploymentId());
        Assert.assertEquals((Object)"aProcDefId", (Object)actual.getProcessDefinitionId());
        Assert.assertEquals((Object)"aKey", (Object)actual.getProcessDefinitionKey());
        Assert.assertEquals((Object)"aProcInstId", (Object)actual.getProcessInstanceId());
        Assert.assertEquals((Object)"anExecutionId", (Object)actual.getExecutionId());
        Assert.assertEquals((Object)"aCaseDefnitionId", (Object)actual.getCaseDefinitionId());
        Assert.assertEquals((Object)"aCaseInstId", (Object)actual.getCaseInstanceId());
        Assert.assertEquals((Object)"aCaseExecutionId", (Object)actual.getCaseExecutionId());
        Assert.assertEquals((Object)"anId", (Object)actual.getTaskId());
        Assert.assertEquals((Object)"aJobId", (Object)actual.getJobId());
        Assert.assertEquals((Object)"aJobDefId", (Object)actual.getJobDefinitionId());
        Assert.assertEquals((Object)"aBatchId", (Object)actual.getBatchId());
        Assert.assertEquals((Object)"userId", (Object)actual.getUserId());
        Assert.assertEquals((Object)MockProvider.EXAMPLE_USER_OPERATION_TIMESTAMP, (Object)JsonPath.from((String)json).getString("[0].timestamp"));
        Assert.assertEquals((Object)"opId", (Object)actual.getOperationId());
        Assert.assertEquals((Object)"Claim", (Object)actual.getOperationType());
        Assert.assertEquals((Object)"Task", (Object)actual.getEntityType());
        Assert.assertEquals((Object)"opProperty", (Object)actual.getProperty());
        Assert.assertEquals((Object)"orgValue", (Object)actual.getOrgValue());
        Assert.assertEquals((Object)"newValue", (Object)actual.getNewValue());
    }

    @Test
    public void testQueryAfterTimestamp() {
        RestAssured.given().queryParam("afterTimestamp", new Object[]{MockProvider.EXAMPLE_USER_OPERATION_TIMESTAMP}).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(USER_OPERATION_LOG_RESOURCE_URL, new Object[0]);
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).afterTimestamp(DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_USER_OPERATION_TIMESTAMP));
    }

    @Test
    public void testQueryBeforeTimestamp() {
        RestAssured.given().queryParam("beforeTimestamp", new Object[]{MockProvider.EXAMPLE_USER_OPERATION_TIMESTAMP}).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(USER_OPERATION_LOG_RESOURCE_URL, new Object[0]);
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).beforeTimestamp(DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_USER_OPERATION_TIMESTAMP));
    }

    @Test
    public void testSortByTimestampAscending() {
        RestAssured.given().queryParam("sortBy", new Object[]{"timestamp"}).queryParam("sortOrder", new Object[]{"asc"}).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(USER_OPERATION_LOG_RESOURCE_URL, new Object[0]);
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).orderByTimestamp();
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).asc();
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock, (VerificationMode)Mockito.never())).desc();
    }

    @Test
    public void testSortByTimestampDescending() {
        RestAssured.given().queryParam("sortBy", new Object[]{"timestamp"}).queryParam("sortOrder", new Object[]{"desc"}).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(USER_OPERATION_LOG_RESOURCE_URL, new Object[0]);
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).orderByTimestamp();
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).desc();
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock, (VerificationMode)Mockito.never())).asc();
    }

    @Test
    public void testInvalidSortByParameter() {
        RestAssured.given().queryParam("sortBy", new Object[]{"unknownField"}).queryParam("sortOrder", new Object[]{"desc"}).expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).when().get(USER_OPERATION_LOG_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testPagination() {
        RestAssured.given().queryParam("firstResult", new Object[]{7}).queryParam("maxResults", new Object[]{13}).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(USER_OPERATION_LOG_RESOURCE_URL, new Object[0]);
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).listPage(7, 13);
    }

    @Test
    public void testFirstResultMissing() {
        RestAssured.given().queryParam("maxResults", new Object[]{13}).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(USER_OPERATION_LOG_RESOURCE_URL, new Object[0]);
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).listPage(0, 13);
    }

    @Test
    public void testMaxResultsMissing() {
        RestAssured.given().queryParam("firstResult", new Object[]{7}).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(USER_OPERATION_LOG_RESOURCE_URL, new Object[0]);
        ((UserOperationLogQuery)Mockito.verify((Object)this.queryMock)).listPage(7, Integer.MAX_VALUE);
    }
}

