/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.exception;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.rest.dto.ExceptionDto;
import org.camunda.bpm.engine.rest.exception.ExceptionHandler;
import org.camunda.bpm.engine.rest.exception.ExceptionHandlerHelper;

@Provider
public class ProcessEngineExceptionHandler
implements ExceptionMapper<ProcessEngineException> {
    private static final Logger LOGGER = Logger.getLogger(ExceptionHandler.class.getSimpleName());

    public Response toResponse(ProcessEngineException exception) {
        LOGGER.log(Level.WARNING, this.getStackTrace((Throwable)exception));
        Response.Status responseStatus = ExceptionHandlerHelper.getInstance().getStatus(exception);
        ExceptionDto exceptionDto = ExceptionHandlerHelper.getInstance().fromException((Throwable)exception);
        return Response.status((Response.Status)responseStatus).entity((Object)exceptionDto).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    protected String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }
}

