/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.repository.DecisionDefinitionQuery;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.converter.BooleanConverter;
import org.camunda.bpm.engine.rest.dto.converter.IntegerConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringListConverter;

public class DecisionDefinitionQueryDto
extends AbstractQueryDto<DecisionDefinitionQuery> {
    private static final String SORT_BY_ID_VALUE = "id";
    private static final String SORT_BY_KEY_VALUE = "key";
    private static final String SORT_BY_NAME_VALUE = "name";
    private static final String SORT_BY_VERSION_VALUE = "version";
    private static final String SORT_BY_DEPLOYMENT_ID_VALUE = "deploymentId";
    private static final String SORT_BY_CATEGORY_VALUE = "category";
    private static final String SORT_BY_TENANT_ID = "tenantId";
    private static final String SORT_BY_VERSION_TAG = "versionTag";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String decisionDefinitionId;
    protected List<String> decisionDefinitionIdIn;
    protected String category;
    protected String categoryLike;
    protected String name;
    protected String nameLike;
    protected String deploymentId;
    protected String key;
    protected String keyLike;
    protected String resourceName;
    protected String resourceNameLike;
    protected Integer version;
    protected Boolean latestVersion;
    protected String decisionRequirementsDefinitionId;
    protected String decisionRequirementsDefinitionKey;
    protected Boolean withoutDecisionRequirementsDefinition;
    protected List<String> tenantIds;
    protected Boolean withoutTenantId;
    protected Boolean includeDefinitionsWithoutTenantId;
    private String versionTag;
    private String versionTagLike;

    public DecisionDefinitionQueryDto() {
    }

    public DecisionDefinitionQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="decisionDefinitionId")
    public void setDecisionDefinitionId(String decisionDefinitionId) {
        this.decisionDefinitionId = decisionDefinitionId;
    }

    @CamundaQueryParam(value="decisionDefinitionIdIn", converter=StringListConverter.class)
    public void setDecisionDefinitionIdIn(List<String> decisionDefinitionIdIn) {
        this.decisionDefinitionIdIn = decisionDefinitionIdIn;
    }

    @CamundaQueryParam(value="category")
    public void setCategory(String category) {
        this.category = category;
    }

    @CamundaQueryParam(value="categoryLike")
    public void setCategoryLike(String categoryLike) {
        this.categoryLike = categoryLike;
    }

    @CamundaQueryParam(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @CamundaQueryParam(value="nameLike")
    public void setNameLike(String nameLike) {
        this.nameLike = nameLike;
    }

    @CamundaQueryParam(value="deploymentId")
    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    @CamundaQueryParam(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    @CamundaQueryParam(value="keyLike")
    public void setKeyLike(String keyLike) {
        this.keyLike = keyLike;
    }

    @CamundaQueryParam(value="resourceName")
    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    @CamundaQueryParam(value="resourceNameLike")
    public void setResourceNameLike(String resourceNameLike) {
        this.resourceNameLike = resourceNameLike;
    }

    @CamundaQueryParam(value="version", converter=IntegerConverter.class)
    public void setVersion(Integer version) {
        this.version = version;
    }

    @CamundaQueryParam(value="latestVersion", converter=BooleanConverter.class)
    public void setLatestVersion(Boolean latestVersion) {
        this.latestVersion = latestVersion;
    }

    @CamundaQueryParam(value="decisionRequirementsDefinitionId")
    public void setDecisionRequirementsDefinitionId(String decisionRequirementsDefinitionId) {
        this.decisionRequirementsDefinitionId = decisionRequirementsDefinitionId;
    }

    @CamundaQueryParam(value="decisionRequirementsDefinitionKey")
    public void setDecisionRequirementsDefinitionKey(String decisionRequirementsDefinitionKey) {
        this.decisionRequirementsDefinitionKey = decisionRequirementsDefinitionKey;
    }

    @CamundaQueryParam(value="withoutDecisionRequirementsDefinition", converter=BooleanConverter.class)
    public void setWithoutDecisionRequirementsDefinition(Boolean withoutDecisionRequirementsDefinition) {
        this.withoutDecisionRequirementsDefinition = withoutDecisionRequirementsDefinition;
    }

    @CamundaQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @CamundaQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    @CamundaQueryParam(value="includeDecisionDefinitionsWithoutTenantId", converter=BooleanConverter.class)
    public void setIncludeDecisionDefinitionsWithoutTenantId(Boolean includeDefinitionsWithoutTenantId) {
        this.includeDefinitionsWithoutTenantId = includeDefinitionsWithoutTenantId;
    }

    @CamundaQueryParam(value="versionTag")
    public void setVersionTag(String versionTag) {
        this.versionTag = versionTag;
    }

    @CamundaQueryParam(value="versionTagLike")
    public void setVersionTagLike(String versionTagLike) {
        this.versionTagLike = versionTagLike;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected DecisionDefinitionQuery createNewQuery(ProcessEngine engine) {
        return engine.getRepositoryService().createDecisionDefinitionQuery();
    }

    @Override
    protected void applyFilters(DecisionDefinitionQuery query) {
        if (this.decisionDefinitionId != null) {
            query.decisionDefinitionId(this.decisionDefinitionId);
        }
        if (this.decisionDefinitionIdIn != null && !this.decisionDefinitionIdIn.isEmpty()) {
            query.decisionDefinitionIdIn(this.decisionDefinitionIdIn.toArray(new String[this.decisionDefinitionIdIn.size()]));
        }
        if (this.category != null) {
            query.decisionDefinitionCategory(this.category);
        }
        if (this.categoryLike != null) {
            query.decisionDefinitionCategoryLike(this.categoryLike);
        }
        if (this.name != null) {
            query.decisionDefinitionName(this.name);
        }
        if (this.nameLike != null) {
            query.decisionDefinitionNameLike(this.nameLike);
        }
        if (this.deploymentId != null) {
            query.deploymentId(this.deploymentId);
        }
        if (this.key != null) {
            query.decisionDefinitionKey(this.key);
        }
        if (this.keyLike != null) {
            query.decisionDefinitionKeyLike(this.keyLike);
        }
        if (this.resourceName != null) {
            query.decisionDefinitionResourceName(this.resourceName);
        }
        if (this.resourceNameLike != null) {
            query.decisionDefinitionResourceNameLike(this.resourceNameLike);
        }
        if (this.version != null) {
            query.decisionDefinitionVersion(this.version);
        }
        if (Boolean.TRUE.equals(this.latestVersion)) {
            query.latestVersion();
        }
        if (this.decisionRequirementsDefinitionId != null) {
            query.decisionRequirementsDefinitionId(this.decisionRequirementsDefinitionId);
        }
        if (this.decisionRequirementsDefinitionKey != null) {
            query.decisionRequirementsDefinitionKey(this.decisionRequirementsDefinitionKey);
        }
        if (Boolean.TRUE.equals(this.withoutDecisionRequirementsDefinition)) {
            query.withoutDecisionRequirementsDefinition();
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
        if (Boolean.TRUE.equals(this.includeDefinitionsWithoutTenantId)) {
            query.includeDecisionDefinitionsWithoutTenantId();
        }
        if (this.versionTag != null) {
            query.versionTag(this.versionTag);
        }
        if (this.versionTagLike != null) {
            query.versionTagLike(this.versionTagLike);
        }
    }

    @Override
    protected void applySortBy(DecisionDefinitionQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_CATEGORY_VALUE)) {
            query.orderByDecisionDefinitionCategory();
        } else if (sortBy.equals(SORT_BY_KEY_VALUE)) {
            query.orderByDecisionDefinitionKey();
        } else if (sortBy.equals(SORT_BY_ID_VALUE)) {
            query.orderByDecisionDefinitionId();
        } else if (sortBy.equals(SORT_BY_VERSION_VALUE)) {
            query.orderByDecisionDefinitionVersion();
        } else if (sortBy.equals(SORT_BY_NAME_VALUE)) {
            query.orderByDecisionDefinitionName();
        } else if (sortBy.equals(SORT_BY_DEPLOYMENT_ID_VALUE)) {
            query.orderByDeploymentId();
        } else if (sortBy.equals(SORT_BY_TENANT_ID)) {
            query.orderByTenantId();
        } else if (sortBy.equals(SORT_BY_VERSION_TAG)) {
            query.orderByVersionTag();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_CATEGORY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_KEY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_NAME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_VERSION_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DEPLOYMENT_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_VERSION_TAG);
    }
}

