/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricActivityStatisticsQuery;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.converter.BooleanConverter;
import org.camunda.bpm.engine.rest.dto.converter.DateConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringArrayConverter;

public class HistoricActivityStatisticsQueryDto
extends AbstractQueryDto<HistoricActivityStatisticsQuery> {
    protected static final String SORT_ORDER_ACTIVITY_ID = "activityId";
    protected String processDefinitionId;
    protected Boolean includeCanceled;
    protected Boolean includeFinished;
    protected Boolean includeCompleteScope;
    protected Date startedAfter;
    protected Date startedBefore;
    protected Date finishedAfter;
    protected Date finishedBefore;
    protected String[] processInstanceIdIn;

    public HistoricActivityStatisticsQueryDto(ObjectMapper objectMapper, String processDefinitionId, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
        this.processDefinitionId = processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @CamundaQueryParam(value="canceled", converter=BooleanConverter.class)
    public void setIncludeCanceled(Boolean includeCanceled) {
        this.includeCanceled = includeCanceled;
    }

    @CamundaQueryParam(value="finished", converter=BooleanConverter.class)
    public void setIncludeFinished(Boolean includeFinished) {
        this.includeFinished = includeFinished;
    }

    @CamundaQueryParam(value="completeScope", converter=BooleanConverter.class)
    public void setIncludeCompleteScope(Boolean includeCompleteScope) {
        this.includeCompleteScope = includeCompleteScope;
    }

    @CamundaQueryParam(value="startedAfter", converter=DateConverter.class)
    public void setStartedAfter(Date startedAfter) {
        this.startedAfter = startedAfter;
    }

    @CamundaQueryParam(value="startedBefore", converter=DateConverter.class)
    public void setStartedBefore(Date startedBefore) {
        this.startedBefore = startedBefore;
    }

    @CamundaQueryParam(value="finishedAfter", converter=DateConverter.class)
    public void setFinishedAfter(Date finishedAfter) {
        this.finishedAfter = finishedAfter;
    }

    @CamundaQueryParam(value="finishedBefore", converter=DateConverter.class)
    public void setFinishedBefore(Date finishedBefore) {
        this.finishedBefore = finishedBefore;
    }

    @CamundaQueryParam(value="processInstanceIdIn", converter=StringArrayConverter.class)
    public void setProcessInstanceIdIn(String[] processInstanceIdIn) {
        this.processInstanceIdIn = processInstanceIdIn;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return SORT_ORDER_ACTIVITY_ID.equals(value);
    }

    @Override
    protected HistoricActivityStatisticsQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricActivityStatisticsQuery(this.processDefinitionId);
    }

    @Override
    protected void applyFilters(HistoricActivityStatisticsQuery query) {
        if (this.includeCanceled != null && this.includeCanceled.booleanValue()) {
            query.includeCanceled();
        }
        if (this.includeFinished != null && this.includeFinished.booleanValue()) {
            query.includeFinished();
        }
        if (this.includeCompleteScope != null && this.includeCompleteScope.booleanValue()) {
            query.includeCompleteScope();
        }
        if (this.startedAfter != null) {
            query.startedAfter(this.startedAfter);
        }
        if (this.startedBefore != null) {
            query.startedBefore(this.startedBefore);
        }
        if (this.finishedAfter != null) {
            query.finishedAfter(this.finishedAfter);
        }
        if (this.finishedBefore != null) {
            query.finishedBefore(this.finishedBefore);
        }
        if (this.processInstanceIdIn != null) {
            query.processInstanceIdIn(this.processInstanceIdIn);
        }
    }

    @Override
    protected void applySortBy(HistoricActivityStatisticsQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (SORT_ORDER_ACTIVITY_ID.equals(sortBy)) {
            query.orderByActivityId();
        }
    }
}

