/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.DateTimeUtils;
import org.camunda.bpm.engine.rest.util.OrderingBuilder;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class ExternalTaskRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String EXTERNAL_TASK_QUERY_URL = "/rest-test/external-task";
    protected static final String EXTERNAL_TASK_COUNT_QUERY_URL = "/rest-test/external-task/count";
    public static final long EXTERNAL_TASK_LOW_BOUND_PRIORITY = 3L;
    public static final long EXTERNAL_TASK_HIGH_BOUND_PRIORITY = 4L;
    protected ExternalTaskQuery mockQuery;

    @Before
    public void setUpRuntimeData() {
        this.mockQuery = this.setUpMockExternalTaskQuery(MockProvider.createMockExternalTasks());
    }

    private ExternalTaskQuery setUpMockExternalTaskQuery(List<ExternalTask> mockedTasks) {
        ExternalTaskQuery sampleTaskQuery = (ExternalTaskQuery)Mockito.mock(ExternalTaskQuery.class);
        Mockito.when((Object)sampleTaskQuery.list()).thenReturn(mockedTasks);
        Mockito.when((Object)sampleTaskQuery.count()).thenReturn((Object)mockedTasks.size());
        Mockito.when((Object)processEngine.getExternalTaskService().createExternalTaskQuery()).thenReturn((Object)sampleTaskQuery);
        return sampleTaskQuery;
    }

    @Test
    public void testInvalidDateParameter() {
        RestAssured.given().queryParams("lockExpirationBefore", (Object)"anInvalidDate", new Object[0]).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Cannot set query parameter 'lockExpirationBefore' to value 'anInvalidDate': Cannot convert value \"anInvalidDate\" to java type java.util.Date"), new Object[0]).when().get(EXTERNAL_TASK_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"processInstanceId"}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(EXTERNAL_TASK_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(EXTERNAL_TASK_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSimpleTaskQuery() {
        Response response = (Response)RestAssured.given().header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EXTERNAL_TASK_QUERY_URL, new Object[0]);
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one external task returned.", (long)1L, (long)instances.size());
        Assert.assertNotNull((String)"The returned external task should not be null.", instances.get(0));
        String activityId = JsonPath.from((String)content).getString("[0].activityId");
        String activityInstanceId = JsonPath.from((String)content).getString("[0].activityInstanceId");
        String errorMessage = JsonPath.from((String)content).getString("[0].errorMessage");
        String executionId = JsonPath.from((String)content).getString("[0].executionId");
        String id = JsonPath.from((String)content).getString("[0].id");
        String lockExpirationTime = JsonPath.from((String)content).getString("[0].lockExpirationTime");
        String processDefinitionId = JsonPath.from((String)content).getString("[0].processDefinitionId");
        String processDefinitionKey = JsonPath.from((String)content).getString("[0].processDefinitionKey");
        String processDefinitionVersionTag = JsonPath.from((String)content).getString("[0].processDefinitionVersionTag");
        String processInstanceId = JsonPath.from((String)content).getString("[0].processInstanceId");
        Integer retries = JsonPath.from((String)content).getInt("[0].retries");
        Boolean suspended = JsonPath.from((String)content).getBoolean("[0].suspended");
        String topicName = JsonPath.from((String)content).getString("[0].topicName");
        String workerId = JsonPath.from((String)content).getString("[0].workerId");
        String tenantId = JsonPath.from((String)content).getString("[0].tenantId");
        long priority = JsonPath.from((String)content).getLong("[0].priority");
        String businessKey = JsonPath.from((String)content).getString("[0].businessKey");
        Assert.assertEquals((Object)"anActivity", (Object)activityId);
        Assert.assertEquals((Object)"anActivityInstanceId", (Object)activityInstanceId);
        Assert.assertEquals((Object)"some error", (Object)errorMessage);
        Assert.assertEquals((Object)"anExecutionId", (Object)executionId);
        Assert.assertEquals((Object)"anExternalTaskId", (Object)id);
        Assert.assertEquals((Object)MockProvider.EXTERNAL_TASK_LOCK_EXPIRATION_TIME, (Object)lockExpirationTime);
        Assert.assertEquals((Object)"aProcDefId", (Object)processDefinitionId);
        Assert.assertEquals((Object)"aKey", (Object)processDefinitionKey);
        Assert.assertEquals((Object)"42", (Object)processDefinitionVersionTag);
        Assert.assertEquals((Object)"aProcInstId", (Object)processInstanceId);
        Assert.assertEquals((Object)MockProvider.EXTERNAL_TASK_RETRIES, (Object)retries);
        Assert.assertEquals((Object)true, (Object)suspended);
        Assert.assertEquals((Object)"aTopic", (Object)topicName);
        Assert.assertEquals((Object)"aWorkerId", (Object)workerId);
        Assert.assertEquals((Object)"aTenantId", (Object)tenantId);
        Assert.assertEquals((long)2147484113L, (long)priority);
        Assert.assertEquals((Object)"aKey", (Object)businessKey);
    }

    @Test
    public void testCompleteGETQuery() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("externalTaskId", "someExternalTaskId");
        parameters.put("activityId", "someActivityId");
        parameters.put("lockExpirationBefore", DateTimeUtils.withTimezone("2013-01-23T14:42:42"));
        parameters.put("lockExpirationAfter", DateTimeUtils.withTimezone("2013-01-23T15:52:52"));
        parameters.put("topicName", "someTopic");
        parameters.put("locked", "true");
        parameters.put("notLocked", "true");
        parameters.put("executionId", "someExecutionId");
        parameters.put("processInstanceId", "someProcessInstanceId");
        parameters.put("processInstanceIdIn", "aProcessInstanceId,anotherProcessInstanceId");
        parameters.put("processDefinitionId", "someProcessDefinitionId");
        parameters.put("processDefinitionVersionTag", "someProcessDefinitionVersionTag");
        parameters.put("active", "true");
        parameters.put("suspended", "true");
        parameters.put("withRetriesLeft", "true");
        parameters.put("noRetriesLeft", "true");
        parameters.put("workerId", "someWorkerId");
        parameters.put("priorityHigherThanOrEquals", "3");
        parameters.put("priorityLowerThanOrEquals", "4");
        RestAssured.given().queryParams(parameters).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EXTERNAL_TASK_QUERY_URL, new Object[0]);
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).externalTaskId("someExternalTaskId");
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).activityId("someActivityId");
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).lockExpirationBefore(DateTimeUtil.parseDate((String)DateTimeUtils.withTimezone("2013-01-23T14:42:42")));
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).lockExpirationAfter(DateTimeUtil.parseDate((String)DateTimeUtils.withTimezone("2013-01-23T15:52:52")));
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).topicName("someTopic");
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).locked();
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).notLocked();
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).executionId("someExecutionId");
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).processInstanceId("someProcessInstanceId");
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).processInstanceIdIn(new String[]{"aProcessInstanceId", "anotherProcessInstanceId"});
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).processDefinitionId("someProcessDefinitionId");
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).processDefinitionId("someProcessDefinitionId");
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).active();
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).suspended();
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).withRetriesLeft();
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).noRetriesLeft();
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).workerId("someWorkerId");
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).priorityHigherThanOrEquals(3L);
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).priorityLowerThanOrEquals(4L);
    }

    @Test
    public void testCompletePOSTQuery() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("externalTaskId", "someExternalTaskId");
        parameters.put("activityId", "someActivityId");
        parameters.put("lockExpirationBefore", DateTimeUtils.withTimezone("2013-01-23T14:42:42"));
        parameters.put("lockExpirationAfter", DateTimeUtils.withTimezone("2013-01-23T15:52:52"));
        parameters.put("topicName", "someTopic");
        parameters.put("locked", "true");
        parameters.put("notLocked", "true");
        parameters.put("executionId", "someExecutionId");
        parameters.put("processInstanceId", "someProcessInstanceId");
        parameters.put("processInstanceIdIn", Arrays.asList("aProcessInstanceId", "anotherProcessInstanceId"));
        parameters.put("processDefinitionId", "someProcessDefinitionId");
        parameters.put("active", "true");
        parameters.put("suspended", "true");
        parameters.put("withRetriesLeft", "true");
        parameters.put("noRetriesLeft", "true");
        parameters.put("workerId", "someWorkerId");
        parameters.put("priorityHigherThanOrEquals", "3");
        parameters.put("priorityLowerThanOrEquals", "4");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(EXTERNAL_TASK_QUERY_URL, new Object[0]);
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).externalTaskId("someExternalTaskId");
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).activityId("someActivityId");
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).lockExpirationBefore(DateTimeUtil.parseDate((String)DateTimeUtils.withTimezone("2013-01-23T14:42:42")));
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).lockExpirationAfter(DateTimeUtil.parseDate((String)DateTimeUtils.withTimezone("2013-01-23T15:52:52")));
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).topicName("someTopic");
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).locked();
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).notLocked();
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).executionId("someExecutionId");
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).processInstanceId("someProcessInstanceId");
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).processInstanceIdIn(new String[]{"aProcessInstanceId", "anotherProcessInstanceId"});
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).processDefinitionId("someProcessDefinitionId");
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).active();
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).suspended();
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).withRetriesLeft();
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).noRetriesLeft();
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).workerId("someWorkerId");
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).priorityHigherThanOrEquals(3L);
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).priorityLowerThanOrEquals(4L);
    }

    @Test
    public void testGETQuerySorting() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifyGETSorting("id", "desc", Response.Status.OK);
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).orderById();
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifyGETSorting("lockExpirationTime", "desc", Response.Status.OK);
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).orderByLockExpirationTime();
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifyGETSorting("processInstanceId", "desc", Response.Status.OK);
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).orderByProcessInstanceId();
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifyGETSorting("processDefinitionId", "desc", Response.Status.OK);
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).orderByProcessDefinitionId();
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifyGETSorting("processDefinitionKey", "desc", Response.Status.OK);
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).orderByProcessDefinitionKey();
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifyGETSorting("tenantId", "desc", Response.Status.OK);
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).orderByTenantId();
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifyGETSorting("taskPriority", "desc", Response.Status.OK);
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).orderByPriority();
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifyGETSorting("id", "asc", Response.Status.OK);
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).orderById();
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifyGETSorting("lockExpirationTime", "asc", Response.Status.OK);
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).orderByLockExpirationTime();
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifyGETSorting("processInstanceId", "asc", Response.Status.OK);
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).orderByProcessInstanceId();
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifyGETSorting("processDefinitionId", "asc", Response.Status.OK);
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).orderByProcessDefinitionId();
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifyGETSorting("processDefinitionKey", "asc", Response.Status.OK);
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).orderByProcessDefinitionKey();
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifyGETSorting("tenantId", "asc", Response.Status.OK);
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).orderByTenantId();
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifyGETSorting("taskPriority", "asc", Response.Status.OK);
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).orderByPriority();
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).asc();
    }

    protected void executeAndVerifyGETSorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(EXTERNAL_TASK_QUERY_URL, new Object[0]);
    }

    @Test
    public void testPOSTQuerySorting() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifyPOSTSorting(OrderingBuilder.create().orderBy("processDefinitionKey").desc().orderBy("lockExpirationTime").asc().getJson(), Response.Status.OK);
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).orderByProcessDefinitionKey();
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).desc();
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).orderByLockExpirationTime();
        ((ExternalTaskQuery)inOrder.verify((Object)this.mockQuery)).asc();
    }

    protected void executeAndVerifyPOSTSorting(List<Map<String, Object>> sortingJson, Response.Status expectedStatus) {
        HashMap<String, List<Map<String, Object>>> json = new HashMap<String, List<Map<String, Object>>>();
        json.put("sorting", sortingJson);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(EXTERNAL_TASK_QUERY_URL, new Object[0]);
    }

    @Test
    public void testPaginationGET() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EXTERNAL_TASK_QUERY_URL, new Object[0]);
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).listPage(firstResult, maxResults);
    }

    @Test
    public void testPaginationPOST() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).contentType(POST_JSON_CONTENT_TYPE).body("{}").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(EXTERNAL_TASK_QUERY_URL, new Object[0]);
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).listPage(firstResult, maxResults);
    }

    @Test
    public void testGETQueryCount() {
        RestAssured.given().header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(EXTERNAL_TASK_COUNT_QUERY_URL, new Object[0]);
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).count();
    }

    @Test
    public void testPOSTQueryCount() {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().post(EXTERNAL_TASK_COUNT_QUERY_URL, new Object[0]);
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).count();
    }

    @Test
    public void testQueryByTenantIdListGet() {
        this.mockQuery = this.setUpMockExternalTaskQuery(this.createMockExternalTasksTwoTenants());
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId,anotherTenantId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EXTERNAL_TASK_QUERY_URL, new Object[0]);
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).list();
        String content = response.asString();
        List executions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)executions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testQueryByTenantIdListPost() {
        this.mockQuery = this.setUpMockExternalTaskQuery(this.createMockExternalTasksTwoTenants());
        HashMap<String, String[]> queryParameters = new HashMap<String, String[]>();
        queryParameters.put("tenantIdIn", "aTenantId,anotherTenantId".split(","));
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(EXTERNAL_TASK_QUERY_URL, new Object[0]);
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).list();
        String content = response.asString();
        List executions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)executions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    private List<ExternalTask> createMockExternalTasksTwoTenants() {
        return Arrays.asList(MockProvider.mockExternalTask().buildExternalTask(), MockProvider.mockExternalTask().tenantId("anotherTenantId").buildExternalTask());
    }

    @Test
    public void testQueryByActivityIdListGet() {
        this.mockQuery = this.setUpMockExternalTaskQuery(this.createMockExternalTasksTwoActivityIds());
        Response response = (Response)RestAssured.given().queryParam("activityIdIn", new Object[]{"anActivity,anotherActivity"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EXTERNAL_TASK_QUERY_URL, new Object[0]);
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).activityIdIn(new String[]{"anActivity", "anotherActivity"});
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).list();
        String content = response.asString();
        List executions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)executions).hasSize(2);
        String returnedActivityId1 = JsonPath.from((String)content).getString("[0].activityId");
        String returnedActivityId2 = JsonPath.from((String)content).getString("[1].activityId");
        Assertions.assertThat((String)returnedActivityId1).isEqualTo((Object)"anActivity");
        Assertions.assertThat((String)returnedActivityId2).isEqualTo((Object)"anotherActivity");
    }

    @Test
    public void testQueryByActivityIdListPost() {
        this.mockQuery = this.setUpMockExternalTaskQuery(this.createMockExternalTasksTwoActivityIds());
        HashMap<String, String[]> queryParameters = new HashMap<String, String[]>();
        queryParameters.put("activityIdIn", "anActivity,anotherActivity".split(","));
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(EXTERNAL_TASK_QUERY_URL, new Object[0]);
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).activityIdIn(new String[]{"anActivity", "anotherActivity"});
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).list();
        String content = response.asString();
        List executions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)executions).hasSize(2);
        String returnedActivityId1 = JsonPath.from((String)content).getString("[0].activityId");
        String returnedActivityId2 = JsonPath.from((String)content).getString("[1].activityId");
        Assertions.assertThat((String)returnedActivityId1).isEqualTo((Object)"anActivity");
        Assertions.assertThat((String)returnedActivityId2).isEqualTo((Object)"anotherActivity");
    }

    private List<ExternalTask> createMockExternalTasksTwoActivityIds() {
        return Arrays.asList(MockProvider.mockExternalTask().buildExternalTask(), MockProvider.mockExternalTask().activityId("anotherActivity").buildExternalTask());
    }

    @Test
    public void testQueryByPriorityListGet() {
        this.mockQuery = this.setUpMockExternalTaskQuery(this.createMockedExternalTasksWithPriorities());
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put("priorityHigherThanOrEquals", "3");
        queryParameters.put("priorityLowerThanOrEquals", "4");
        Response response = (Response)RestAssured.given().queryParameters(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EXTERNAL_TASK_QUERY_URL, new Object[0]);
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).priorityHigherThanOrEquals(3L);
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).priorityLowerThanOrEquals(4L);
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).list();
        String content = response.asString();
        List executions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)executions).hasSize(2);
        long prio1 = JsonPath.from((String)content).getLong("[0].priority");
        long prio2 = JsonPath.from((String)content).getLong("[1].priority");
        Assertions.assertThat((long)prio1).isEqualTo(3L);
        Assertions.assertThat((long)prio2).isEqualTo(4L);
    }

    @Test
    public void testQueryByPriorityListPost() {
        this.mockQuery = this.setUpMockExternalTaskQuery(this.createMockedExternalTasksWithPriorities());
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put("priorityHigherThanOrEquals", "3");
        queryParameters.put("priorityLowerThanOrEquals", "4");
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(EXTERNAL_TASK_QUERY_URL, new Object[0]);
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).priorityHigherThanOrEquals(3L);
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).priorityLowerThanOrEquals(4L);
        ((ExternalTaskQuery)Mockito.verify((Object)this.mockQuery)).list();
        String content = response.asString();
        List executions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)executions).hasSize(2);
        long prio1 = JsonPath.from((String)content).getLong("[0].priority");
        long prio2 = JsonPath.from((String)content).getLong("[1].priority");
        Assertions.assertThat((long)prio1).isEqualTo(3L);
        Assertions.assertThat((long)prio2).isEqualTo(4L);
    }

    private List<ExternalTask> createMockedExternalTasksWithPriorities() {
        return Arrays.asList(MockProvider.mockExternalTask().priority(3L).buildExternalTask(), MockProvider.mockExternalTask().priority(4L).buildExternalTask());
    }
}

