/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import java.util.Collections;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.identity.PasswordPolicy;
import org.camunda.bpm.engine.identity.PasswordPolicyResult;
import org.camunda.bpm.engine.impl.identity.PasswordPolicyDigitRuleImpl;
import org.camunda.bpm.engine.impl.identity.PasswordPolicyLengthRuleImpl;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.CoreMatchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class PasswordPolicyServiceQueryTest
extends AbstractRestServiceTest {
    protected static final String QUERY_URL = "/rest-test/identity/password-policy";
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected ProcessEngineConfiguration processEngineConfigurationMock = (ProcessEngineConfiguration)Mockito.mock(ProcessEngineConfiguration.class);
    protected IdentityService identityServiceMock;

    @Before
    public void setUpMocks() {
        this.identityServiceMock = (IdentityService)Mockito.mock(IdentityService.class);
        Mockito.when((Object)processEngine.getProcessEngineConfiguration()).thenReturn((Object)this.processEngineConfigurationMock);
        Mockito.when((Object)processEngine.getIdentityService()).thenReturn((Object)this.identityServiceMock);
    }

    @Test
    public void shouldGetPolicy() {
        Mockito.when((Object)this.processEngineConfigurationMock.isEnablePasswordPolicy()).thenReturn((Object)true);
        PasswordPolicy passwordPolicyMock = (PasswordPolicy)Mockito.mock(PasswordPolicy.class);
        Mockito.when((Object)this.identityServiceMock.getPasswordPolicy()).thenReturn((Object)passwordPolicyMock);
        Mockito.when((Object)passwordPolicyMock.getRules()).thenReturn(Collections.singletonList(new PasswordPolicyDigitRuleImpl(1)));
        RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).body("rules[0].placeholder", CoreMatchers.equalTo((Object)"PASSWORD_POLICY_DIGIT"), new Object[0]).body("rules[0].parameter.minDigit", CoreMatchers.equalTo((Object)"1"), new Object[0]).when().get(QUERY_URL, new Object[0]);
    }

    @Test
    public void shouldReturnNotFound_PasswordPolicyDisabled() {
        Mockito.when((Object)this.processEngineConfigurationMock.isEnablePasswordPolicy()).thenReturn((Object)false);
        RestAssured.given().then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).when().get(QUERY_URL, new Object[0]);
    }

    @Test
    public void shouldCheckInvalidPassword() {
        Mockito.when((Object)this.processEngineConfigurationMock.isEnablePasswordPolicy()).thenReturn((Object)true);
        PasswordPolicyResult passwordPolicyResultMock = (PasswordPolicyResult)Mockito.mock(PasswordPolicyResult.class);
        Mockito.when((Object)this.identityServiceMock.checkPasswordAgainstPolicy(Matchers.anyString())).thenReturn((Object)passwordPolicyResultMock);
        Mockito.when((Object)passwordPolicyResultMock.getFulfilledRules()).thenReturn(Collections.singletonList(new PasswordPolicyDigitRuleImpl(1)));
        Mockito.when((Object)passwordPolicyResultMock.getViolatedRules()).thenReturn(Collections.singletonList(new PasswordPolicyLengthRuleImpl(1)));
        RestAssured.given().header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(Collections.singletonMap("password", "password")).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("rules[0].placeholder", CoreMatchers.equalTo((Object)"PASSWORD_POLICY_DIGIT"), new Object[0]).body("rules[0].parameter.minDigit", CoreMatchers.equalTo((Object)"1"), new Object[0]).body("rules[0].valid", CoreMatchers.equalTo((Object)true), new Object[0]).body("rules[1].placeholder", CoreMatchers.equalTo((Object)"PASSWORD_POLICY_LENGTH"), new Object[0]).body("rules[1].parameter.minLength", CoreMatchers.equalTo((Object)"1"), new Object[0]).body("rules[1].valid", CoreMatchers.equalTo((Object)false), new Object[0]).body("valid", CoreMatchers.equalTo((Object)false), new Object[0]).when().post(QUERY_URL, new Object[0]);
    }

    @Test
    public void shouldCheckValidPassword() {
        Mockito.when((Object)this.processEngineConfigurationMock.isEnablePasswordPolicy()).thenReturn((Object)true);
        PasswordPolicyResult passwordPolicyResultMock = (PasswordPolicyResult)Mockito.mock(PasswordPolicyResult.class);
        Mockito.when((Object)this.identityServiceMock.checkPasswordAgainstPolicy(Matchers.anyString())).thenReturn((Object)passwordPolicyResultMock);
        Mockito.when((Object)passwordPolicyResultMock.getFulfilledRules()).thenReturn(Collections.singletonList(new PasswordPolicyDigitRuleImpl(1)));
        Mockito.when((Object)passwordPolicyResultMock.getViolatedRules()).thenReturn(Collections.emptyList());
        RestAssured.given().header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(Collections.singletonMap("password", "password")).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("valid", CoreMatchers.equalTo((Object)true), new Object[0]).when().post(QUERY_URL, new Object[0]);
    }

    @Test
    public void shouldCheckPasswordAgainstNoPolicy() {
        Mockito.when((Object)this.processEngineConfigurationMock.isEnablePasswordPolicy()).thenReturn((Object)false);
        RestAssured.given().header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(Collections.singletonMap("password", "password")).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).when().post(QUERY_URL, new Object[0]);
    }
}

