/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import junit.framework.TestCase;
import org.camunda.bpm.ProcessApplicationService;
import org.camunda.bpm.application.ProcessApplicationInfo;
import org.camunda.bpm.container.RuntimeContainerDelegate;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.identity.UserQuery;
import org.camunda.bpm.engine.impl.TaskQueryImpl;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.CaseDefinitionQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.task.TaskQueryDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.EqualsList;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.helper.ValueGenerator;
import org.camunda.bpm.engine.rest.helper.variable.EqualsPrimitiveValue;
import org.camunda.bpm.engine.rest.util.DateTimeUtils;
import org.camunda.bpm.engine.rest.util.OrderingBuilder;
import org.camunda.bpm.engine.rest.util.QueryParamUtils;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.task.DelegationState;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TaskRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String TASK_QUERY_URL = "/rest-test/task";
    protected static final String TASK_COUNT_QUERY_URL = "/rest-test/task/count";
    private static final String SAMPLE_VAR_NAME = "varName";
    private static final String SAMPLE_VAR_VALUE = "varValue";
    private TaskQuery mockQuery;

    @Before
    public void setUpRuntimeData() {
        this.mockQuery = this.setUpMockTaskQuery(MockProvider.createMockTasks());
    }

    private TaskQuery setUpMockTaskQuery(List<Task> mockedTasks) {
        TaskQuery sampleTaskQuery = (TaskQuery)Mockito.mock(TaskQueryImpl.class);
        Mockito.when((Object)sampleTaskQuery.list()).thenReturn(mockedTasks);
        Mockito.when((Object)sampleTaskQuery.count()).thenReturn((Object)mockedTasks.size());
        Mockito.when((Object)sampleTaskQuery.taskCandidateGroup(Matchers.anyString())).thenReturn((Object)sampleTaskQuery);
        Mockito.when((Object)processEngine.getTaskService().createTaskQuery()).thenReturn((Object)sampleTaskQuery);
        return sampleTaskQuery;
    }

    @Test
    public void testEmptyQuery() {
        String queryKey = "";
        RestAssured.given().queryParam("name", new Object[]{queryKey}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
    }

    @Test
    public void testInvalidDateParameter() {
        RestAssured.given().queryParams("due", (Object)"anInvalidDate", new Object[0]).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)"Cannot set query parameter 'due' to value 'anInvalidDate': Cannot convert value \"anInvalidDate\" to java type java.util.Date"), new Object[0]).when().get(TASK_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"dueDate"}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(TASK_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(TASK_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSimpleTaskQuery() {
        String queryName = "name";
        Response response = (Response)RestAssured.given().queryParam("name", new Object[]{queryName}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).taskName(queryName);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one task returned.", (long)1L, (long)instances.size());
        Assert.assertNotNull((String)"The returned task should not be null.", instances.get(0));
        String returnedTaskName = JsonPath.from((String)content).getString("[0].name");
        String returnedId = JsonPath.from((String)content).getString("[0].id");
        String returendAssignee = JsonPath.from((String)content).getString("[0].assignee");
        String returnedCreateTime = JsonPath.from((String)content).getString("[0].created");
        String returnedDueDate = JsonPath.from((String)content).getString("[0].due");
        String returnedFollowUpDate = JsonPath.from((String)content).getString("[0].followUp");
        String returnedDelegationState = JsonPath.from((String)content).getString("[0].delegationState");
        String returnedDescription = JsonPath.from((String)content).getString("[0].description");
        String returnedExecutionId = JsonPath.from((String)content).getString("[0].executionId");
        String returnedOwner = JsonPath.from((String)content).getString("[0].owner");
        String returnedParentTaskId = JsonPath.from((String)content).getString("[0].parentTaskId");
        int returnedPriority = JsonPath.from((String)content).getInt("[0].priority");
        String returnedProcessDefinitionId = JsonPath.from((String)content).getString("[0].processDefinitionId");
        String returnedProcessInstanceId = JsonPath.from((String)content).getString("[0].processInstanceId");
        String returnedTaskDefinitionKey = JsonPath.from((String)content).getString("[0].taskDefinitionKey");
        String returnedCaseDefinitionId = JsonPath.from((String)content).getString("[0].caseDefinitionId");
        String returnedCaseInstanceId = JsonPath.from((String)content).getString("[0].caseInstanceId");
        String returnedCaseExecutionId = JsonPath.from((String)content).getString("[0].caseExecutionId");
        boolean returnedSuspensionState = JsonPath.from((String)content).getBoolean("[0].suspended");
        String returnedFormKey = JsonPath.from((String)content).getString("[0].formKey");
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        Assert.assertEquals((Object)"aName", (Object)returnedTaskName);
        Assert.assertEquals((Object)"anId", (Object)returnedId);
        Assert.assertEquals((Object)"anAssignee", (Object)returendAssignee);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_TASK_CREATE_TIME, (Object)returnedCreateTime);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_TASK_DUE_DATE, (Object)returnedDueDate);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_FOLLOW_UP_DATE, (Object)returnedFollowUpDate);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_TASK_DELEGATION_STATE.toString(), (Object)returnedDelegationState);
        Assert.assertEquals((Object)"aDescription", (Object)returnedDescription);
        Assert.assertEquals((Object)"anExecution", (Object)returnedExecutionId);
        Assert.assertEquals((Object)"anOwner", (Object)returnedOwner);
        Assert.assertEquals((Object)"aParentId", (Object)returnedParentTaskId);
        Assert.assertEquals((long)42L, (long)returnedPriority);
        Assert.assertEquals((Object)"aProcDefId", (Object)returnedProcessDefinitionId);
        Assert.assertEquals((Object)"aProcInstId", (Object)returnedProcessInstanceId);
        Assert.assertEquals((Object)"aTaskDefinitionKey", (Object)returnedTaskDefinitionKey);
        Assert.assertEquals((Object)"aCaseDefnitionId", (Object)returnedCaseDefinitionId);
        Assert.assertEquals((Object)"aCaseInstId", (Object)returnedCaseInstanceId);
        Assert.assertEquals((Object)"aCaseExecutionId", (Object)returnedCaseExecutionId);
        Assert.assertEquals((Object)false, (Object)returnedSuspensionState);
        Assert.assertEquals((Object)"aFormKey", (Object)returnedFormKey);
        Assert.assertEquals((Object)"aTenantId", (Object)returnedTenantId);
    }

    @Test
    public void testSimpleHalTaskQuery() {
        String queryName = "name";
        List<User> mockUsers = MockProvider.createMockUsers();
        UserQuery sampleUserQuery = (UserQuery)Mockito.mock(UserQuery.class);
        Mockito.when((Object)sampleUserQuery.listPage(0, 1)).thenReturn(mockUsers);
        Mockito.when((Object)sampleUserQuery.userIdIn(new String[]{"anAssignee"})).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)sampleUserQuery.userIdIn(new String[]{"anOwner"})).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)sampleUserQuery.count()).thenReturn((Object)1L);
        Mockito.when((Object)processEngine.getIdentityService().createUserQuery()).thenReturn((Object)sampleUserQuery);
        List<ProcessDefinition> mockDefinitions = MockProvider.createMockDefinitions();
        ProcessDefinitionQuery sampleProcessDefinitionQuery = (ProcessDefinitionQuery)Mockito.mock(ProcessDefinitionQuery.class);
        Mockito.when((Object)sampleProcessDefinitionQuery.listPage(0, 1)).thenReturn(mockDefinitions);
        Mockito.when((Object)sampleProcessDefinitionQuery.processDefinitionIdIn(new String[]{"aProcDefId"})).thenReturn((Object)sampleProcessDefinitionQuery);
        Mockito.when((Object)sampleProcessDefinitionQuery.count()).thenReturn((Object)1L);
        Mockito.when((Object)processEngine.getRepositoryService().createProcessDefinitionQuery()).thenReturn((Object)sampleProcessDefinitionQuery);
        List<CaseDefinition> mockCaseDefinitions = MockProvider.createMockCaseDefinitions();
        CaseDefinitionQuery sampleCaseDefinitionQuery = (CaseDefinitionQuery)Mockito.mock(CaseDefinitionQuery.class);
        Mockito.when((Object)sampleCaseDefinitionQuery.listPage(0, 1)).thenReturn(mockCaseDefinitions);
        Mockito.when((Object)sampleCaseDefinitionQuery.caseDefinitionIdIn(new String[]{"aCaseDefnitionId"})).thenReturn((Object)sampleCaseDefinitionQuery);
        Mockito.when((Object)sampleCaseDefinitionQuery.count()).thenReturn((Object)1L);
        Mockito.when((Object)processEngine.getRepositoryService().createCaseDefinitionQuery()).thenReturn((Object)sampleCaseDefinitionQuery);
        Mockito.when((Object)processEngine.getManagementService().getProcessApplicationForDeployment("aDeploymentId")).thenReturn((Object)"aProcessApplication");
        ProcessApplicationService processApplicationService = (ProcessApplicationService)Mockito.mock(ProcessApplicationService.class);
        ProcessApplicationInfo appMock = MockProvider.createMockProcessApplicationInfo();
        Mockito.when((Object)processApplicationService.getProcessApplicationInfo("aProcessApplication")).thenReturn((Object)appMock);
        RuntimeContainerDelegate delegate = (RuntimeContainerDelegate)Mockito.mock(RuntimeContainerDelegate.class);
        Mockito.when((Object)delegate.getProcessApplicationService()).thenReturn((Object)processApplicationService);
        RuntimeContainerDelegate.INSTANCE.set(delegate);
        Response response = (Response)RestAssured.given().queryParam("name", new Object[]{queryName}).header("accept", (Object)"application/hal+json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/hal+json").when().get(TASK_QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).taskName(queryName);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("_embedded.task");
        Assert.assertEquals((String)"There should be one task returned.", (long)1L, (long)instances.size());
        Assert.assertNotNull((String)"The returned task should not be null.", instances.get(0));
        Map taskObject = (Map)instances.get(0);
        String returnedTaskName = (String)taskObject.get("name");
        String returnedId = (String)taskObject.get("id");
        String returnedAssignee = (String)taskObject.get("assignee");
        String returnedCreateTime = (String)taskObject.get("created");
        String returnedDueDate = (String)taskObject.get("due");
        String returnedFollowUpDate = (String)taskObject.get("followUp");
        String returnedDelegationState = (String)taskObject.get("delegationState");
        String returnedDescription = (String)taskObject.get("description");
        String returnedExecutionId = (String)taskObject.get("executionId");
        String returnedOwner = (String)taskObject.get("owner");
        String returnedParentTaskId = (String)taskObject.get("parentTaskId");
        int returnedPriority = (Integer)taskObject.get("priority");
        String returnedProcessDefinitionId = (String)taskObject.get("processDefinitionId");
        String returnedProcessInstanceId = (String)taskObject.get("processInstanceId");
        String returnedTaskDefinitionKey = (String)taskObject.get("taskDefinitionKey");
        String returnedCaseDefinitionId = (String)taskObject.get("caseDefinitionId");
        String returnedCaseInstanceId = (String)taskObject.get("caseInstanceId");
        String returnedCaseExecutionId = (String)taskObject.get("caseExecutionId");
        boolean returnedSuspensionState = (Boolean)taskObject.get("suspended");
        String returnedFormKey = (String)taskObject.get("formKey");
        String returnedTenantId = (String)taskObject.get("tenantId");
        Assert.assertEquals((Object)"aName", (Object)returnedTaskName);
        Assert.assertEquals((Object)"anId", (Object)returnedId);
        Assert.assertEquals((Object)"anAssignee", (Object)returnedAssignee);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_TASK_CREATE_TIME, (Object)returnedCreateTime);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_TASK_DUE_DATE, (Object)returnedDueDate);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_FOLLOW_UP_DATE, (Object)returnedFollowUpDate);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_TASK_DELEGATION_STATE.toString(), (Object)returnedDelegationState);
        Assert.assertEquals((Object)"aDescription", (Object)returnedDescription);
        Assert.assertEquals((Object)"anExecution", (Object)returnedExecutionId);
        Assert.assertEquals((Object)"anOwner", (Object)returnedOwner);
        Assert.assertEquals((Object)"aParentId", (Object)returnedParentTaskId);
        Assert.assertEquals((long)42L, (long)returnedPriority);
        Assert.assertEquals((Object)"aProcDefId", (Object)returnedProcessDefinitionId);
        Assert.assertEquals((Object)"aProcInstId", (Object)returnedProcessInstanceId);
        Assert.assertEquals((Object)"aTaskDefinitionKey", (Object)returnedTaskDefinitionKey);
        Assert.assertEquals((Object)"aCaseDefnitionId", (Object)returnedCaseDefinitionId);
        Assert.assertEquals((Object)"aCaseInstId", (Object)returnedCaseInstanceId);
        Assert.assertEquals((Object)"aCaseExecutionId", (Object)returnedCaseExecutionId);
        Assert.assertEquals((Object)false, (Object)returnedSuspensionState);
        Assert.assertEquals((Object)"aTenantId", (Object)returnedTenantId);
        Assert.assertEquals((long)1L, (long)JsonPath.from((String)content).getLong("count"));
        Map selfReference = JsonPath.from((String)content).getMap("_links.self");
        Assert.assertNotNull((Object)selfReference);
        Assert.assertEquals((Object)"/task", selfReference.get("href"));
        List embeddedAssignees = JsonPath.from((String)content).getList("_embedded.assignee");
        Assert.assertEquals((String)"There should be one assignee returned.", (long)1L, (long)embeddedAssignees.size());
        Map embeddedAssignee = (Map)embeddedAssignees.get(0);
        Assert.assertNotNull((String)"The returned assignee should not be null.", (Object)embeddedAssignee);
        Assert.assertEquals((Object)"userId", embeddedAssignee.get("id"));
        Assert.assertEquals((Object)"firstName", embeddedAssignee.get("firstName"));
        Assert.assertEquals((Object)"lastName", embeddedAssignee.get("lastName"));
        Assert.assertEquals((Object)"test@example.org", embeddedAssignee.get("email"));
        List embeddedOwners = JsonPath.from((String)content).getList("_embedded.owner");
        Assert.assertEquals((String)"There should be one owner returned.", (long)1L, (long)embeddedOwners.size());
        Map embeddedOwner = (Map)embeddedOwners.get(0);
        Assert.assertNotNull((String)"The returned owner should not be null.", (Object)embeddedOwner);
        Assert.assertEquals((Object)"userId", embeddedOwner.get("id"));
        Assert.assertEquals((Object)"firstName", embeddedOwner.get("firstName"));
        Assert.assertEquals((Object)"lastName", embeddedOwner.get("lastName"));
        Assert.assertEquals((Object)"test@example.org", embeddedOwner.get("email"));
        List embeddedDefinitions = JsonPath.from((String)content).getList("_embedded.processDefinition");
        Assert.assertEquals((String)"There should be one processDefinition returned.", (long)1L, (long)embeddedDefinitions.size());
        Map embeddedProcessDefinition = (Map)embeddedDefinitions.get(0);
        Assert.assertNotNull((String)"The returned processDefinition should not be null.", (Object)embeddedProcessDefinition);
        Assert.assertEquals((Object)"aProcDefId", embeddedProcessDefinition.get("id"));
        Assert.assertEquals((Object)"aKey", embeddedProcessDefinition.get("key"));
        Assert.assertEquals((Object)"aCategory", embeddedProcessDefinition.get("category"));
        Assert.assertEquals((Object)"aName", embeddedProcessDefinition.get("name"));
        Assert.assertEquals((Object)"aDescription", embeddedProcessDefinition.get("description"));
        Assert.assertEquals((Object)42, embeddedProcessDefinition.get("version"));
        Assert.assertEquals((Object)"aVersionTag", embeddedProcessDefinition.get("versionTag"));
        Assert.assertEquals((Object)"aResourceName", embeddedProcessDefinition.get("resource"));
        Assert.assertEquals((Object)"aDeploymentId", embeddedProcessDefinition.get("deploymentId"));
        Assert.assertEquals((Object)"aResourceName.png", embeddedProcessDefinition.get("diagram"));
        Assert.assertEquals((Object)true, embeddedProcessDefinition.get("suspended"));
        Assert.assertEquals((Object)"http://camunda.org/someContext", embeddedProcessDefinition.get("contextPath"));
        List embeddedCaseDefinitions = JsonPath.from((String)content).getList("_embedded.caseDefinition");
        Assert.assertEquals((String)"There should be one caseDefinition returned.", (long)1L, (long)embeddedCaseDefinitions.size());
        Map embeddedCaseDefinition = (Map)embeddedCaseDefinitions.get(0);
        Assert.assertNotNull((String)"The returned caseDefinition should not be null.", (Object)embeddedCaseDefinition);
        Assert.assertEquals((Object)"aCaseDefnitionId", embeddedCaseDefinition.get("id"));
        Assert.assertEquals((Object)"aCaseDefinitionKey", embeddedCaseDefinition.get("key"));
        Assert.assertEquals((Object)"aCaseDefinitionCategory", embeddedCaseDefinition.get("category"));
        Assert.assertEquals((Object)"aCaseDefinitionName", embeddedCaseDefinition.get("name"));
        Assert.assertEquals((Object)1, embeddedCaseDefinition.get("version"));
        Assert.assertEquals((Object)"aCaseDefinitionResourceName", embeddedCaseDefinition.get("resource"));
        Assert.assertEquals((Object)"aDeploymentId", embeddedCaseDefinition.get("deploymentId"));
        Assert.assertEquals((Object)"http://camunda.org/someContext", embeddedCaseDefinition.get("contextPath"));
    }

    @Test
    public void testNoParametersQuery() {
        RestAssured.given().header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).initializeFormKeys();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockQuery});
    }

    @Test
    public void testAdditionalParametersExcludingVariables() {
        Map<String, String> stringQueryParameters = this.getCompleteStringQueryParameters();
        Map<String, Integer> intQueryParameters = this.getCompleteIntQueryParameters();
        Map<String, Boolean> booleanQueryParameters = this.getCompleteBooleanQueryParameters();
        Map<String, String[]> arrayQueryParameters = this.getCompleteStringArrayQueryParameters();
        RestAssured.given().queryParams(stringQueryParameters).queryParams(intQueryParameters).queryParams(booleanQueryParameters).queryParam("activityInstanceIdIn", new Object[]{QueryParamUtils.arrayAsCommaSeperatedList(arrayQueryParameters.get("activityInstanceIdIn"))}).queryParam("taskDefinitionKeyIn", new Object[]{QueryParamUtils.arrayAsCommaSeperatedList(arrayQueryParameters.get("taskDefinitionKeyIn"))}).queryParam("processDefinitionKeyIn", new Object[]{QueryParamUtils.arrayAsCommaSeperatedList(arrayQueryParameters.get("processDefinitionKeyIn"))}).queryParam("processInstanceBusinessKeyIn", new Object[]{QueryParamUtils.arrayAsCommaSeperatedList(arrayQueryParameters.get("processInstanceBusinessKeyIn"))}).queryParam("tenantIdIn", new Object[]{QueryParamUtils.arrayAsCommaSeperatedList(arrayQueryParameters.get("tenantIdIn"))}).queryParam("assigneeIn", new Object[]{QueryParamUtils.arrayAsCommaSeperatedList(arrayQueryParameters.get("assigneeIn"))}).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        this.verifyIntegerParameterQueryInvocations();
        this.verifyStringParameterQueryInvocations();
        this.verifyBooleanParameterQueryInvocation();
        this.verifyStringArrayParametersInvocations();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).list();
    }

    private void verifyIntegerParameterQueryInvocations() {
        Map<String, Integer> intQueryParameters = this.getCompleteIntQueryParameters();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskMaxPriority(intQueryParameters.get("maxPriority"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskMinPriority(intQueryParameters.get("minPriority"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskPriority(intQueryParameters.get("priority"));
    }

    private Map<String, Integer> getCompleteIntQueryParameters() {
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("maxPriority", 10);
        parameters.put("minPriority", 9);
        parameters.put("priority", 8);
        return parameters;
    }

    private Map<String, String[]> getCompleteStringArrayQueryParameters() {
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        String[] activityInstanceIds = new String[]{"anActivityInstanceId", "anotherActivityInstanceId"};
        String[] taskDefinitionKeys = new String[]{"aTaskDefinitionKey", "anotherTaskDefinitionKey"};
        String[] processDefinitionKeys = new String[]{"aProcessDefinitionKey", "anotherProcessDefinitionKey"};
        String[] processInstanceBusinessKeys = new String[]{"aBusinessKey", "anotherBusinessKey"};
        String[] tenantIds = new String[]{"aTenantId", "anotherTenantId"};
        String[] assigneeIn = new String[]{"userId", "anAssignee"};
        parameters.put("activityInstanceIdIn", activityInstanceIds);
        parameters.put("taskDefinitionKeyIn", taskDefinitionKeys);
        parameters.put("processDefinitionKeyIn", processDefinitionKeys);
        parameters.put("processInstanceBusinessKeyIn", processInstanceBusinessKeys);
        parameters.put("tenantIdIn", tenantIds);
        parameters.put("assigneeIn", assigneeIn);
        return parameters;
    }

    private Map<String, String> getCompleteStringQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("processInstanceBusinessKey", "aBusinessKey");
        parameters.put("processInstanceBusinessKeyLike", "aBusinessKeyLike");
        parameters.put("processDefinitionKey", "aProcDefKey");
        parameters.put("processDefinitionId", "aProcDefId");
        parameters.put("executionId", "anExecId");
        parameters.put("processDefinitionName", "aProcDefName");
        parameters.put("processDefinitionNameLike", "aProcDefNameLike");
        parameters.put("processInstanceId", "aProcInstId");
        parameters.put("assignee", "anAssignee");
        parameters.put("assigneeLike", "anAssigneeLike");
        parameters.put("candidateGroup", "aCandidateGroup");
        parameters.put("candidateUser", "aCandidate");
        parameters.put("includeAssignedTasks", "false");
        parameters.put("taskDefinitionKey", "aTaskDefKey");
        parameters.put("taskDefinitionKeyLike", "aTaskDefKeyLike");
        parameters.put("description", "aDesc");
        parameters.put("descriptionLike", "aDescLike");
        parameters.put("involvedUser", "anInvolvedPerson");
        parameters.put("name", "aName");
        parameters.put("nameNotEqual", "aNameNotEqual");
        parameters.put("nameLike", "aNameLike");
        parameters.put("nameNotLike", "aNameNotLike");
        parameters.put("owner", "anOwner");
        parameters.put("caseDefinitionKey", "aCaseDefKey");
        parameters.put("caseDefinitionId", "aCaseDefId");
        parameters.put("caseDefinitionName", "aCaseDefName");
        parameters.put("caseDefinitionNameLike", "aCaseDefNameLike");
        parameters.put("caseInstanceId", "anCaseInstanceId");
        parameters.put("caseInstanceBusinessKey", "aCaseInstanceBusinessKey");
        parameters.put("caseInstanceBusinessKeyLike", "aCaseInstanceBusinessKeyLike");
        parameters.put("caseExecutionId", "aCaseExecutionId");
        parameters.put("parentTaskId", "aParentTaskId");
        return parameters;
    }

    private Map<String, Boolean> getCompleteBooleanQueryParameters() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("assigned", true);
        parameters.put("unassigned", true);
        parameters.put("active", true);
        parameters.put("suspended", true);
        parameters.put("withoutTenantId", true);
        parameters.put("withCandidateGroups", true);
        parameters.put("withoutCandidateGroups", true);
        parameters.put("withCandidateUsers", true);
        parameters.put("withoutCandidateUsers", true);
        return parameters;
    }

    private void verifyStringParameterQueryInvocations() {
        Map<String, String> stringQueryParameters = this.getCompleteStringQueryParameters();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processInstanceBusinessKey(stringQueryParameters.get("processInstanceBusinessKey"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processInstanceBusinessKeyLike(stringQueryParameters.get("processInstanceBusinessKeyLike"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processDefinitionKey(stringQueryParameters.get("processDefinitionKey"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processDefinitionId(stringQueryParameters.get("processDefinitionId"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).executionId(stringQueryParameters.get("executionId"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processDefinitionName(stringQueryParameters.get("processDefinitionName"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processDefinitionNameLike(stringQueryParameters.get("processDefinitionNameLike"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processInstanceId(stringQueryParameters.get("processInstanceId"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskAssignee(stringQueryParameters.get("assignee"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskAssigneeLike(stringQueryParameters.get("assigneeLike"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskCandidateGroup(stringQueryParameters.get("candidateGroup"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskCandidateUser(stringQueryParameters.get("candidateUser"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskDefinitionKey(stringQueryParameters.get("taskDefinitionKey"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskDefinitionKeyLike(stringQueryParameters.get("taskDefinitionKeyLike"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskDescription(stringQueryParameters.get("description"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskDescriptionLike(stringQueryParameters.get("descriptionLike"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskInvolvedUser(stringQueryParameters.get("involvedUser"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskName(stringQueryParameters.get("name"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskNameNotEqual(stringQueryParameters.get("nameNotEqual"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskNameLike(stringQueryParameters.get("nameLike"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskNameNotLike(stringQueryParameters.get("nameNotLike"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskOwner(stringQueryParameters.get("owner"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).caseDefinitionKey(stringQueryParameters.get("caseDefinitionKey"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).caseDefinitionId(stringQueryParameters.get("caseDefinitionId"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).caseDefinitionName(stringQueryParameters.get("caseDefinitionName"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).caseDefinitionNameLike(stringQueryParameters.get("caseDefinitionNameLike"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).caseInstanceId(stringQueryParameters.get("caseInstanceId"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).caseInstanceBusinessKey(stringQueryParameters.get("caseInstanceBusinessKey"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).caseInstanceBusinessKeyLike(stringQueryParameters.get("caseInstanceBusinessKeyLike"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).caseExecutionId(stringQueryParameters.get("caseExecutionId"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskParentTaskId(stringQueryParameters.get("parentTaskId"));
    }

    private void verifyStringArrayParametersInvocations() {
        Map<String, String[]> stringArrayParameters = this.getCompleteStringArrayQueryParameters();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).activityInstanceIdIn(stringArrayParameters.get("activityInstanceIdIn"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskDefinitionKeyIn(stringArrayParameters.get("taskDefinitionKeyIn"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processDefinitionKeyIn(stringArrayParameters.get("processDefinitionKeyIn"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processInstanceBusinessKeyIn(stringArrayParameters.get("processInstanceBusinessKeyIn"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).tenantIdIn(stringArrayParameters.get("tenantIdIn"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskAssigneeIn(stringArrayParameters.get("assigneeIn"));
    }

    private void verifyBooleanParameterQueryInvocation() {
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskUnassigned();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).active();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).suspended();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).withoutTenantId();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).withCandidateGroups();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).withoutCandidateGroups();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).withCandidateUsers();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).withoutCandidateUsers();
    }

    @Test
    public void testDateParameters() {
        Map<String, String> queryParameters = this.getDateParameters();
        RestAssured.given().queryParams(queryParameters).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).dueAfter((Date)Matchers.any(Date.class));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).dueBefore((Date)Matchers.any(Date.class));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).dueDate((Date)Matchers.any(Date.class));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).followUpAfter((Date)Matchers.any(Date.class));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).followUpBefore((Date)Matchers.any(Date.class));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).followUpBeforeOrNotExistent((Date)Matchers.any(Date.class));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).followUpDate((Date)Matchers.any(Date.class));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskCreatedAfter((Date)Matchers.any(Date.class));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskCreatedBefore((Date)Matchers.any(Date.class));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskCreatedOn((Date)Matchers.any(Date.class));
    }

    @Test
    public void testDateParametersPost() {
        Map<String, String> json = this.getDateParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).dueAfter((Date)Matchers.any(Date.class));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).dueBefore((Date)Matchers.any(Date.class));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).dueDate((Date)Matchers.any(Date.class));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).followUpAfter((Date)Matchers.any(Date.class));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).followUpBefore((Date)Matchers.any(Date.class));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).followUpBeforeOrNotExistent((Date)Matchers.any(Date.class));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).followUpDate((Date)Matchers.any(Date.class));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskCreatedAfter((Date)Matchers.any(Date.class));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskCreatedBefore((Date)Matchers.any(Date.class));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskCreatedOn((Date)Matchers.any(Date.class));
    }

    @Test
    public void testDeprecatedDateParameters() {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put("due", DateTimeUtils.withTimezone("2013-01-23T14:42:44"));
        queryParameters.put("created", DateTimeUtils.withTimezone("2013-01-23T14:42:47"));
        queryParameters.put("followUp", DateTimeUtils.withTimezone("2013-01-23T14:42:50"));
        RestAssured.given().queryParams(queryParameters).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).dueDate((Date)Matchers.any(Date.class));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskCreatedOn((Date)Matchers.any(Date.class));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).followUpDate((Date)Matchers.any(Date.class));
    }

    private Map<String, String> getDateParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dueAfter", DateTimeUtils.withTimezone("2013-01-23T14:42:42"));
        parameters.put("dueBefore", DateTimeUtils.withTimezone("2013-01-23T14:42:43"));
        parameters.put("dueDate", DateTimeUtils.withTimezone("2013-01-23T14:42:44"));
        parameters.put("createdAfter", DateTimeUtils.withTimezone("2013-01-23T14:42:45"));
        parameters.put("createdBefore", DateTimeUtils.withTimezone("2013-01-23T14:42:46"));
        parameters.put("createdOn", DateTimeUtils.withTimezone("2013-01-23T14:42:47"));
        parameters.put("followUpAfter", DateTimeUtils.withTimezone("2013-01-23T14:42:48"));
        parameters.put("followUpBefore", DateTimeUtils.withTimezone("2013-01-23T14:42:49"));
        parameters.put("followUpBeforeOrNotExistent", DateTimeUtils.withTimezone("2013-01-23T14:42:49"));
        parameters.put("followUpDate", DateTimeUtils.withTimezone("2013-01-23T14:42:50"));
        return parameters;
    }

    @Test
    public void testCandidateGroupInList() {
        ArrayList<String> candidateGroups = new ArrayList<String>();
        candidateGroups.add("boss");
        candidateGroups.add("worker");
        String queryParam = (String)candidateGroups.get(0) + "," + (String)candidateGroups.get(1);
        RestAssured.given().queryParams("candidateGroups", (Object)queryParam, new Object[0]).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskCandidateGroupIn((List)Matchers.argThat((Matcher)new EqualsList(candidateGroups)));
    }

    @Test
    public void testDelegationState() {
        RestAssured.given().queryParams("delegationState", (Object)"PENDING", new Object[0]).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskDelegationState(DelegationState.PENDING);
        RestAssured.given().queryParams("delegationState", (Object)"RESOLVED", new Object[0]).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskDelegationState(DelegationState.RESOLVED);
    }

    @Test
    public void testLowerCaseDelegationStateParam() {
        RestAssured.given().queryParams("delegationState", (Object)"resolved", new Object[0]).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskDelegationState(DelegationState.RESOLVED);
    }

    @Test
    public void testSortingParameters() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("dueDate", "desc", Response.Status.OK);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByDueDate();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("followUpDate", "desc", Response.Status.OK);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByFollowUpDate();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("instanceId", "desc", Response.Status.OK);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByProcessInstanceId();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("created", "desc", Response.Status.OK);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByTaskCreateTime();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("id", "desc", Response.Status.OK);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByTaskId();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("priority", "desc", Response.Status.OK);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByTaskPriority();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("executionId", "desc", Response.Status.OK);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByExecutionId();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("assignee", "desc", Response.Status.OK);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByTaskAssignee();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("description", "desc", Response.Status.OK);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByTaskDescription();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("name", "desc", Response.Status.OK);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByTaskName();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("nameCaseInsensitive", "desc", Response.Status.OK);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByTaskNameCaseInsensitive();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("caseInstanceId", "desc", Response.Status.OK);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByCaseInstanceId();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("dueDate", "asc", Response.Status.OK);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByDueDate();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("followUpDate", "asc", Response.Status.OK);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByFollowUpDate();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("instanceId", "asc", Response.Status.OK);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByProcessInstanceId();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("created", "asc", Response.Status.OK);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByTaskCreateTime();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("id", "asc", Response.Status.OK);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByTaskId();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("priority", "asc", Response.Status.OK);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByTaskPriority();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("executionId", "asc", Response.Status.OK);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByExecutionId();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("assignee", "asc", Response.Status.OK);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByTaskAssignee();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("description", "asc", Response.Status.OK);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByTaskDescription();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("name", "asc", Response.Status.OK);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByTaskName();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("nameCaseInsensitive", "asc", Response.Status.OK);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByTaskNameCaseInsensitive();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("caseInstanceId", "asc", Response.Status.OK);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByCaseInstanceId();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("tenantId", "desc", Response.Status.OK);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByTenantId();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("tenantId", "asc", Response.Status.OK);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByTenantId();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).asc();
    }

    protected void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
    }

    protected void executeAndVerifySortingAsPost(List<Map<String, Object>> sortingJson, Response.Status expectedStatus) {
        HashMap<String, List<Map<String, Object>>> json = new HashMap<String, List<Map<String, Object>>>();
        json.put("sorting", sortingJson);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(TASK_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSecondarySortingAsPost() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySortingAsPost(OrderingBuilder.create().orderBy("dueDate").desc().orderBy("caseExecutionId").asc().getJson(), Response.Status.OK);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByDueDate();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).desc();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByCaseExecutionId();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySortingAsPost(OrderingBuilder.create().orderBy("processVariable").desc().parameter("variable", "var").parameter("type", "String").orderBy("executionVariable").asc().parameter("variable", "var2").parameter("type", "Integer").orderBy("taskVariable").desc().parameter("variable", "var3").parameter("type", "Double").orderBy("caseInstanceVariable").asc().parameter("variable", "var4").parameter("type", "Long").orderBy("caseExecutionVariable").desc().parameter("variable", "var5").parameter("type", "Date").getJson(), Response.Status.OK);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByProcessVariable("var", (ValueType)ValueType.STRING);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).desc();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByExecutionVariable("var2", (ValueType)ValueType.INTEGER);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).asc();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByTaskVariable("var3", (ValueType)ValueType.DOUBLE);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).desc();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByCaseInstanceVariable("var4", (ValueType)ValueType.LONG);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).asc();
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).orderByCaseExecutionVariable("var5", (ValueType)ValueType.DATE);
        ((TaskQuery)inOrder.verify((Object)this.mockQuery)).desc();
    }

    @Test
    public void testSuccessfulPagination() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).listPage(firstResult, maxResults);
    }

    @Test
    public void testTaskVariableParameters() {
        String variableName = SAMPLE_VAR_NAME;
        String variableValue = SAMPLE_VAR_VALUE;
        String queryValue = variableName + "_eq_" + variableValue;
        RestAssured.given().queryParam("taskVariables", new Object[]{queryValue}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskVariableValueEquals(variableName, (Object)variableValue);
        Mockito.reset((Object[])new TaskQuery[]{this.mockQuery});
        RestAssured.given().queryParam("taskVariables", new Object[]{queryValue}).queryParam("variableValuesIgnoreCase", new Object[]{true}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableValuesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskVariableValueEquals(variableName, (Object)variableValue);
        Mockito.reset((Object[])new TaskQuery[]{this.mockQuery});
        RestAssured.given().queryParam("taskVariables", new Object[]{queryValue}).queryParam("variableNamesIgnoreCase", new Object[]{true}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableNamesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskVariableValueEquals(variableName, (Object)variableValue);
        Mockito.reset((Object[])new TaskQuery[]{this.mockQuery});
        RestAssured.given().queryParam("taskVariables", new Object[]{queryValue}).queryParam("variableNamesIgnoreCase", new Object[]{true}).queryParam("variableValuesIgnoreCase", new Object[]{true}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableNamesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableValuesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskVariableValueEquals(variableName, (Object)variableValue);
        queryValue = variableName + "_gt_" + variableValue;
        RestAssured.given().queryParam("taskVariables", new Object[]{queryValue}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskVariableValueGreaterThan(variableName, (Object)variableValue);
        queryValue = variableName + "_gteq_" + variableValue;
        RestAssured.given().queryParam("taskVariables", new Object[]{queryValue}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskVariableValueGreaterThanOrEquals(variableName, (Object)variableValue);
        queryValue = variableName + "_lt_" + variableValue;
        RestAssured.given().queryParam("taskVariables", new Object[]{queryValue}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskVariableValueLessThan(variableName, (Object)variableValue);
        queryValue = variableName + "_lteq_" + variableValue;
        RestAssured.given().queryParam("taskVariables", new Object[]{queryValue}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskVariableValueLessThanOrEquals(variableName, (Object)variableValue);
        queryValue = variableName + "_like_" + variableValue;
        RestAssured.given().queryParam("taskVariables", new Object[]{queryValue}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskVariableValueLike(variableName, variableValue);
        Mockito.reset((Object[])new TaskQuery[]{this.mockQuery});
        queryValue = variableName + "_like_" + variableValue;
        RestAssured.given().queryParam("taskVariables", new Object[]{queryValue}).queryParam("variableValuesIgnoreCase", new Object[]{true}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableValuesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskVariableValueLike(variableName, variableValue);
        queryValue = variableName + "_neq_" + variableValue;
        RestAssured.given().queryParam("taskVariables", new Object[]{queryValue}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskVariableValueNotEquals(variableName, (Object)variableValue);
        Mockito.reset((Object[])new TaskQuery[]{this.mockQuery});
        queryValue = variableName + "_neq_" + variableValue;
        RestAssured.given().queryParam("taskVariables", new Object[]{queryValue}).queryParam("variableValuesIgnoreCase", new Object[]{true}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableValuesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskVariableValueNotEquals(variableName, (Object)variableValue);
    }

    @Test
    public void testTaskVariableValueEqualsIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", SAMPLE_VAR_NAME);
        variableJson.put("operator", "eq");
        variableJson.put("value", SAMPLE_VAR_VALUE.toLowerCase());
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("taskVariables", variables);
        json.put("variableValuesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableValuesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskVariableValueEquals(SAMPLE_VAR_NAME, (Object)SAMPLE_VAR_VALUE.toLowerCase());
    }

    @Test
    public void testTaskVariableNameEqualsIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", SAMPLE_VAR_NAME.toLowerCase());
        variableJson.put("operator", "eq");
        variableJson.put("value", SAMPLE_VAR_VALUE);
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("taskVariables", variables);
        json.put("variableNamesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableNamesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskVariableValueEquals(SAMPLE_VAR_NAME.toLowerCase(), (Object)SAMPLE_VAR_VALUE);
        Mockito.reset((Object[])new TaskQuery[]{this.mockQuery});
        json.put("variableValuesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableNamesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableValuesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskVariableValueEquals(SAMPLE_VAR_NAME.toLowerCase(), (Object)SAMPLE_VAR_VALUE);
    }

    @Test
    public void testTaskVariableValueNotEqualsIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", SAMPLE_VAR_NAME);
        variableJson.put("operator", "neq");
        variableJson.put("value", SAMPLE_VAR_VALUE.toLowerCase());
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("taskVariables", variables);
        json.put("variableValuesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableValuesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskVariableValueNotEquals(SAMPLE_VAR_NAME, (Object)SAMPLE_VAR_VALUE.toLowerCase());
    }

    @Test
    public void testTaskVariableValueLikeIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", SAMPLE_VAR_NAME);
        variableJson.put("operator", "like");
        variableJson.put("value", SAMPLE_VAR_VALUE.toLowerCase());
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("taskVariables", variables);
        json.put("variableValuesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableValuesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskVariableValueLike(SAMPLE_VAR_NAME, SAMPLE_VAR_VALUE.toLowerCase());
    }

    @Test
    public void testProcessVariableParameters() {
        String variableName = SAMPLE_VAR_NAME;
        String variableValue = SAMPLE_VAR_VALUE;
        String queryValue = variableName + "_eq_" + variableValue;
        RestAssured.given().queryParam("processVariables", new Object[]{queryValue}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processVariableValueEquals(variableName, (Object)variableValue);
        Mockito.reset((Object[])new TaskQuery[]{this.mockQuery});
        queryValue = variableName + "_eq_" + variableValue;
        RestAssured.given().queryParam("processVariables", new Object[]{queryValue}).queryParam("variableValuesIgnoreCase", new Object[]{true}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableValuesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processVariableValueEquals(variableName, (Object)variableValue);
        Mockito.reset((Object[])new TaskQuery[]{this.mockQuery});
        RestAssured.given().queryParam("processVariables", new Object[]{queryValue}).queryParam("variableNamesIgnoreCase", new Object[]{true}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableNamesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processVariableValueEquals(variableName, (Object)variableValue);
        Mockito.reset((Object[])new TaskQuery[]{this.mockQuery});
        RestAssured.given().queryParam("processVariables", new Object[]{queryValue}).queryParam("variableNamesIgnoreCase", new Object[]{true}).queryParam("variableValuesIgnoreCase", new Object[]{true}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableNamesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableValuesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processVariableValueEquals(variableName, (Object)variableValue);
        queryValue = variableName + "_gt_" + variableValue;
        RestAssured.given().queryParam("processVariables", new Object[]{queryValue}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processVariableValueGreaterThan(variableName, (Object)variableValue);
        queryValue = variableName + "_gteq_" + variableValue;
        RestAssured.given().queryParam("processVariables", new Object[]{queryValue}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processVariableValueGreaterThanOrEquals(variableName, (Object)variableValue);
        queryValue = variableName + "_lt_" + variableValue;
        RestAssured.given().queryParam("processVariables", new Object[]{queryValue}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processVariableValueLessThan(variableName, (Object)variableValue);
        queryValue = variableName + "_lteq_" + variableValue;
        RestAssured.given().queryParam("processVariables", new Object[]{queryValue}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processVariableValueLessThanOrEquals(variableName, (Object)variableValue);
        queryValue = variableName + "_like_" + variableValue;
        RestAssured.given().queryParam("processVariables", new Object[]{queryValue}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processVariableValueLike(variableName, variableValue);
        Mockito.reset((Object[])new TaskQuery[]{this.mockQuery});
        queryValue = variableName + "_like_" + variableValue;
        RestAssured.given().queryParam("processVariables", new Object[]{queryValue}).queryParam("variableValuesIgnoreCase", new Object[]{true}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableValuesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processVariableValueLike(variableName, variableValue);
        queryValue = variableName + "_neq_" + variableValue;
        RestAssured.given().queryParam("processVariables", new Object[]{queryValue}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processVariableValueNotEquals(variableName, (Object)variableValue);
        Mockito.reset((Object[])new TaskQuery[]{this.mockQuery});
        queryValue = variableName + "_neq_" + variableValue;
        RestAssured.given().queryParam("processVariables", new Object[]{queryValue}).queryParam("variableValuesIgnoreCase", new Object[]{true}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableValuesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processVariableValueNotEquals(variableName, (Object)variableValue);
    }

    @Test
    public void testProcessVariableValueEqualsIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", SAMPLE_VAR_NAME);
        variableJson.put("operator", "eq");
        variableJson.put("value", SAMPLE_VAR_VALUE.toLowerCase());
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("processVariables", variables);
        json.put("variableValuesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableValuesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processVariableValueEquals(SAMPLE_VAR_NAME, (Object)SAMPLE_VAR_VALUE.toLowerCase());
    }

    @Test
    public void testProcessVariableNameEqualsIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", SAMPLE_VAR_NAME.toLowerCase());
        variableJson.put("operator", "eq");
        variableJson.put("value", SAMPLE_VAR_VALUE);
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("processVariables", variables);
        json.put("variableNamesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableNamesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processVariableValueEquals(SAMPLE_VAR_NAME.toLowerCase(), (Object)SAMPLE_VAR_VALUE);
        Mockito.reset((Object[])new TaskQuery[]{this.mockQuery});
        json.put("variableValuesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableNamesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableValuesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processVariableValueEquals(SAMPLE_VAR_NAME.toLowerCase(), (Object)SAMPLE_VAR_VALUE);
    }

    @Test
    public void testProcessVariableValueNotEqualsIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", SAMPLE_VAR_NAME);
        variableJson.put("operator", "neq");
        variableJson.put("value", SAMPLE_VAR_VALUE.toLowerCase());
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("processVariables", variables);
        json.put("variableValuesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableValuesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processVariableValueNotEquals(SAMPLE_VAR_NAME, (Object)SAMPLE_VAR_VALUE.toLowerCase());
    }

    @Test
    public void testProcessVariableValueLikeIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", SAMPLE_VAR_NAME);
        variableJson.put("operator", "like");
        variableJson.put("value", SAMPLE_VAR_VALUE.toLowerCase());
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("processVariables", variables);
        json.put("variableValuesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableValuesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processVariableValueLike(SAMPLE_VAR_NAME, SAMPLE_VAR_VALUE.toLowerCase());
    }

    @Test
    public void testCaseVariableParameters() {
        String variableName = SAMPLE_VAR_NAME;
        String variableValue = SAMPLE_VAR_VALUE;
        String queryValue = variableName + "_eq_" + variableValue;
        RestAssured.given().queryParam("caseInstanceVariables", new Object[]{queryValue}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).caseInstanceVariableValueEquals(variableName, (Object)variableValue);
        Mockito.reset((Object[])new TaskQuery[]{this.mockQuery});
        queryValue = variableName + "_eq_" + variableValue;
        RestAssured.given().queryParam("caseInstanceVariables", new Object[]{queryValue}).queryParam("variableValuesIgnoreCase", new Object[]{true}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableValuesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).caseInstanceVariableValueEquals(variableName, (Object)variableValue);
        Mockito.reset((Object[])new TaskQuery[]{this.mockQuery});
        RestAssured.given().queryParam("caseInstanceVariables", new Object[]{queryValue}).queryParam("variableNamesIgnoreCase", new Object[]{true}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableNamesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).caseInstanceVariableValueEquals(variableName, (Object)variableValue);
        Mockito.reset((Object[])new TaskQuery[]{this.mockQuery});
        RestAssured.given().queryParam("caseInstanceVariables", new Object[]{queryValue}).queryParam("variableNamesIgnoreCase", new Object[]{true}).queryParam("variableValuesIgnoreCase", new Object[]{true}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableNamesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableValuesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).caseInstanceVariableValueEquals(variableName, (Object)variableValue);
        queryValue = variableName + "_gt_" + variableValue;
        RestAssured.given().queryParam("caseInstanceVariables", new Object[]{queryValue}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).caseInstanceVariableValueGreaterThan(variableName, (Object)variableValue);
        queryValue = variableName + "_gteq_" + variableValue;
        RestAssured.given().queryParam("caseInstanceVariables", new Object[]{queryValue}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).caseInstanceVariableValueGreaterThanOrEquals(variableName, (Object)variableValue);
        queryValue = variableName + "_lt_" + variableValue;
        RestAssured.given().queryParam("caseInstanceVariables", new Object[]{queryValue}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).caseInstanceVariableValueLessThan(variableName, (Object)variableValue);
        queryValue = variableName + "_lteq_" + variableValue;
        RestAssured.given().queryParam("caseInstanceVariables", new Object[]{queryValue}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).caseInstanceVariableValueLessThanOrEquals(variableName, (Object)variableValue);
        queryValue = variableName + "_like_" + variableValue;
        RestAssured.given().queryParam("caseInstanceVariables", new Object[]{queryValue}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).caseInstanceVariableValueLike(variableName, variableValue);
        Mockito.reset((Object[])new TaskQuery[]{this.mockQuery});
        queryValue = variableName + "_like_" + variableValue;
        RestAssured.given().queryParam("caseInstanceVariables", new Object[]{queryValue}).queryParam("variableValuesIgnoreCase", new Object[]{true}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableValuesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).caseInstanceVariableValueLike(variableName, variableValue);
        queryValue = variableName + "_neq_" + variableValue;
        RestAssured.given().queryParam("caseInstanceVariables", new Object[]{queryValue}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).caseInstanceVariableValueNotEquals(variableName, (Object)variableValue);
        Mockito.reset((Object[])new TaskQuery[]{this.mockQuery});
        queryValue = variableName + "_neq_" + variableValue;
        RestAssured.given().queryParam("caseInstanceVariables", new Object[]{queryValue}).queryParam("variableValuesIgnoreCase", new Object[]{true}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableValuesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).caseInstanceVariableValueNotEquals(variableName, (Object)variableValue);
    }

    @Test
    public void testCaseInstanceVariableValueEqualsIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", SAMPLE_VAR_NAME);
        variableJson.put("operator", "eq");
        variableJson.put("value", SAMPLE_VAR_VALUE.toLowerCase());
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("caseInstanceVariables", variables);
        json.put("variableValuesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableValuesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).caseInstanceVariableValueEquals(SAMPLE_VAR_NAME, (Object)SAMPLE_VAR_VALUE.toLowerCase());
    }

    @Test
    public void testCaseInstanceVariableNameEqualsIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", SAMPLE_VAR_NAME.toLowerCase());
        variableJson.put("operator", "eq");
        variableJson.put("value", SAMPLE_VAR_VALUE);
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("caseInstanceVariables", variables);
        json.put("variableNamesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableNamesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).caseInstanceVariableValueEquals(SAMPLE_VAR_NAME.toLowerCase(), (Object)SAMPLE_VAR_VALUE);
        Mockito.reset((Object[])new TaskQuery[]{this.mockQuery});
        json.put("variableValuesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableNamesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableValuesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).caseInstanceVariableValueEquals(SAMPLE_VAR_NAME.toLowerCase(), (Object)SAMPLE_VAR_VALUE);
    }

    @Test
    public void testCaseInstanceVariableValueNotEqualsIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", SAMPLE_VAR_NAME);
        variableJson.put("operator", "neq");
        variableJson.put("value", SAMPLE_VAR_VALUE.toLowerCase());
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("caseInstanceVariables", variables);
        json.put("variableValuesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableValuesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).caseInstanceVariableValueNotEquals(SAMPLE_VAR_NAME, (Object)SAMPLE_VAR_VALUE.toLowerCase());
    }

    @Test
    public void testCaseInstanceVariableValueLikeIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", SAMPLE_VAR_NAME);
        variableJson.put("operator", "like");
        variableJson.put("value", SAMPLE_VAR_VALUE.toLowerCase());
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("caseInstanceVariables", variables);
        json.put("variableValuesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).matchVariableValuesIgnoreCase();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).caseInstanceVariableValueLike(SAMPLE_VAR_NAME, SAMPLE_VAR_VALUE.toLowerCase());
    }

    @Test
    public void testMultipleVariableParameters() {
        String variableName1 = SAMPLE_VAR_NAME;
        String variableValue1 = SAMPLE_VAR_VALUE;
        String variableParameter1 = variableName1 + "_eq_" + variableValue1;
        String variableName2 = "anotherVarName";
        String variableValue2 = "anotherVarValue";
        String variableParameter2 = variableName2 + "_neq_" + variableValue2;
        String queryValue = variableParameter1 + "," + variableParameter2;
        RestAssured.given().queryParam("taskVariables", new Object[]{queryValue}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskVariableValueEquals(variableName1, (Object)variableValue1);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskVariableValueNotEquals(variableName2, (Object)variableValue2);
    }

    @Test
    public void testMultipleVariableParametersAsPost() {
        String variableName = SAMPLE_VAR_NAME;
        String variableValue = SAMPLE_VAR_VALUE;
        String anotherVariableName = "anotherVarName";
        Integer anotherVariableValue = 30;
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", variableName);
        variableJson.put("operator", "eq");
        variableJson.put("value", variableValue);
        HashMap<String, Object> anotherVariableJson = new HashMap<String, Object>();
        anotherVariableJson.put("name", anotherVariableName);
        anotherVariableJson.put("operator", "neq");
        anotherVariableJson.put("value", anotherVariableValue);
        ArrayList<HashMap<String, Object>> variables = new ArrayList<HashMap<String, Object>>();
        variables.add(variableJson);
        variables.add(anotherVariableJson);
        HashMap<String, ArrayList<HashMap<String, Object>>> json = new HashMap<String, ArrayList<HashMap<String, Object>>>();
        json.put("taskVariables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskVariableValueEquals(variableName, (Object)variableValue);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskVariableValueNotEquals((String)Matchers.eq((Object)anotherVariableName), Matchers.argThat((Matcher)EqualsPrimitiveValue.numberValue(anotherVariableValue)));
    }

    @Test
    public void testMultipleProcessVariableParameters() {
        String variableName1 = SAMPLE_VAR_NAME;
        String variableValue1 = SAMPLE_VAR_VALUE;
        String variableParameter1 = variableName1 + "_eq_" + variableValue1;
        String variableName2 = "anotherVarName";
        String variableValue2 = "anotherVarValue";
        String variableParameter2 = variableName2 + "_neq_" + variableValue2;
        String queryValue = variableParameter1 + "," + variableParameter2;
        RestAssured.given().queryParam("processVariables", new Object[]{queryValue}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processVariableValueEquals(variableName1, (Object)variableValue1);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processVariableValueNotEquals(variableName2, (Object)variableValue2);
    }

    @Test
    public void testMultipleProcessVariableParametersAsPost() {
        String variableName = SAMPLE_VAR_NAME;
        String variableValue = SAMPLE_VAR_VALUE;
        String anotherVariableName = "anotherVarName";
        Integer anotherVariableValue = 30;
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", variableName);
        variableJson.put("operator", "eq");
        variableJson.put("value", variableValue);
        HashMap<String, Object> anotherVariableJson = new HashMap<String, Object>();
        anotherVariableJson.put("name", anotherVariableName);
        anotherVariableJson.put("operator", "neq");
        anotherVariableJson.put("value", anotherVariableValue);
        ArrayList<HashMap<String, Object>> variables = new ArrayList<HashMap<String, Object>>();
        variables.add(variableJson);
        variables.add(anotherVariableJson);
        HashMap<String, ArrayList<HashMap<String, Object>>> json = new HashMap<String, ArrayList<HashMap<String, Object>>>();
        json.put("processVariables", variables);
        RestAssured.given().header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processVariableValueEquals(variableName, (Object)variableValue);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processVariableValueNotEquals((String)Matchers.eq((Object)anotherVariableName), Matchers.argThat((Matcher)EqualsPrimitiveValue.numberValue(anotherVariableValue)));
    }

    @Test
    public void testMultipleCaseVariableParameters() {
        String variableName1 = SAMPLE_VAR_NAME;
        String variableValue1 = SAMPLE_VAR_VALUE;
        String variableParameter1 = variableName1 + "_eq_" + variableValue1;
        String variableName2 = "anotherVarName";
        String variableValue2 = "anotherVarValue";
        String variableParameter2 = variableName2 + "_neq_" + variableValue2;
        String queryValue = variableParameter1 + "," + variableParameter2;
        RestAssured.given().queryParam("caseInstanceVariables", new Object[]{queryValue}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).caseInstanceVariableValueEquals(variableName1, (Object)variableValue1);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).caseInstanceVariableValueNotEquals(variableName2, (Object)variableValue2);
    }

    @Test
    public void testMultipleCaseVariableParametersAsPost() {
        String variableName = SAMPLE_VAR_NAME;
        String variableValue = SAMPLE_VAR_VALUE;
        String anotherVariableName = "anotherVarName";
        Integer anotherVariableValue = 30;
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", variableName);
        variableJson.put("operator", "eq");
        variableJson.put("value", variableValue);
        HashMap<String, Object> anotherVariableJson = new HashMap<String, Object>();
        anotherVariableJson.put("name", anotherVariableName);
        anotherVariableJson.put("operator", "neq");
        anotherVariableJson.put("value", anotherVariableValue);
        ArrayList<HashMap<String, Object>> variables = new ArrayList<HashMap<String, Object>>();
        variables.add(variableJson);
        variables.add(anotherVariableJson);
        HashMap<String, ArrayList<HashMap<String, Object>>> json = new HashMap<String, ArrayList<HashMap<String, Object>>>();
        json.put("caseInstanceVariables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header("accept", (Object)"application/json", new Object[0]).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).caseInstanceVariableValueEquals(variableName, (Object)variableValue);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).caseInstanceVariableValueNotEquals((String)Matchers.eq((Object)anotherVariableName), Matchers.argThat((Matcher)EqualsPrimitiveValue.numberValue(anotherVariableValue)));
    }

    @Test
    public void testCompletePostParameters() {
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        Map<String, String> stringQueryParameters = this.getCompleteStringQueryParameters();
        Map<String, Integer> intQueryParameters = this.getCompleteIntQueryParameters();
        Map<String, Boolean> booleanQueryParameters = this.getCompleteBooleanQueryParameters();
        Map<String, String[]> stringArrayQueryParameters = this.getCompleteStringArrayQueryParameters();
        queryParameters.putAll(stringQueryParameters);
        queryParameters.putAll(intQueryParameters);
        queryParameters.putAll(booleanQueryParameters);
        queryParameters.putAll(stringArrayQueryParameters);
        ArrayList<String> candidateGroups = new ArrayList<String>();
        candidateGroups.add("boss");
        candidateGroups.add("worker");
        queryParameters.put("candidateGroups", candidateGroups);
        queryParameters.put("includeAssignedTasks", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(TASK_QUERY_URL, new Object[0]);
        this.verifyStringParameterQueryInvocations();
        this.verifyIntegerParameterQueryInvocations();
        this.verifyStringArrayParametersInvocations();
        this.verifyBooleanParameterQueryInvocation();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).includeAssignedTasks();
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskCandidateGroupIn((List)Matchers.argThat((Matcher)new EqualsList(candidateGroups)));
    }

    @Test
    public void testQueryCount() {
        RestAssured.given().header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).body("count", org.hamcrest.Matchers.equalTo((Object)1), new Object[0]).when().get(TASK_COUNT_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).count();
    }

    @Test
    public void testQueryCountForPost() {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).body("count", org.hamcrest.Matchers.equalTo((Object)1), new Object[0]).when().post(TASK_COUNT_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).count();
    }

    @Test
    public void testQueryWithExpressions() {
        String testExpression = "${'test-%s'}";
        ValueGenerator generator = new ValueGenerator(testExpression);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("assigneeExpression", generator.getValue("assigneeExpression"));
        params.put("assigneeLikeExpression", generator.getValue("assigneeLikeExpression"));
        params.put("ownerExpression", generator.getValue("ownerExpression"));
        params.put("involvedUserExpression", generator.getValue("involvedUserExpression"));
        params.put("candidateUserExpression", generator.getValue("candidateUserExpression"));
        params.put("candidateGroupExpression", generator.getValue("candidateGroupExpression"));
        params.put("candidateGroupsExpression", generator.getValue("candidateGroupsExpression"));
        params.put("createdBeforeExpression", generator.getValue("createdBeforeExpression"));
        params.put("createdOnExpression", generator.getValue("createdOnExpression"));
        params.put("createdAfterExpression", generator.getValue("createdAfterExpression"));
        params.put("dueBeforeExpression", generator.getValue("dueBeforeExpression"));
        params.put("dueDateExpression", generator.getValue("dueDateExpression"));
        params.put("dueAfterExpression", generator.getValue("dueAfterExpression"));
        params.put("followUpBeforeExpression", generator.getValue("followUpBeforeExpression"));
        params.put("followUpDateExpression", generator.getValue("followUpDateExpression"));
        params.put("followUpAfterExpression", generator.getValue("followUpAfterExpression"));
        params.put("processInstanceBusinessKeyExpression", generator.getValue("processInstanceBusinessKeyExpression"));
        params.put("processInstanceBusinessKeyLikeExpression", generator.getValue("processInstanceBusinessKeyLikeExpression"));
        RestAssured.given().header(ACCEPT_JSON_HEADER).queryParams(params).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        this.verifyExpressionMocks(generator);
        Mockito.reset((Object[])new TaskQuery[]{this.mockQuery});
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header(ACCEPT_JSON_HEADER).body(params).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(TASK_QUERY_URL, new Object[0]);
        this.verifyExpressionMocks(generator);
    }

    protected void verifyExpressionMocks(ValueGenerator generator) {
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskAssigneeExpression(generator.getValue("assigneeExpression"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskAssigneeLikeExpression(generator.getValue("assigneeLikeExpression"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskOwnerExpression(generator.getValue("ownerExpression"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskInvolvedUserExpression(generator.getValue("involvedUserExpression"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskCandidateUserExpression(generator.getValue("candidateUserExpression"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskCandidateGroupExpression(generator.getValue("candidateGroupExpression"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskCandidateGroupInExpression(generator.getValue("candidateGroupsExpression"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskCreatedBeforeExpression(generator.getValue("createdBeforeExpression"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskCreatedOnExpression(generator.getValue("createdOnExpression"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).taskCreatedAfterExpression(generator.getValue("createdAfterExpression"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).dueBeforeExpression(generator.getValue("dueBeforeExpression"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).dueDateExpression(generator.getValue("dueDateExpression"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).dueAfterExpression(generator.getValue("dueAfterExpression"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).followUpBeforeExpression(generator.getValue("followUpBeforeExpression"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).followUpDateExpression(generator.getValue("followUpDateExpression"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).followUpAfterExpression(generator.getValue("followUpAfterExpression"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processInstanceBusinessKeyExpression(generator.getValue("processInstanceBusinessKeyExpression"));
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).processInstanceBusinessKeyLikeExpression(generator.getValue("processInstanceBusinessKeyLikeExpression"));
    }

    @Test
    public void testQueryWithCandidateUsers() {
        RestAssured.given().queryParam("withCandidateUsers", new Object[]{true}).accept("application/json").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).withCandidateUsers();
    }

    @Test
    public void testQueryWithoutCandidateUsers() {
        RestAssured.given().queryParam("withoutCandidateUsers", new Object[]{true}).accept("application/json").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery)).withoutCandidateUsers();
    }

    @Test
    public void testNeverQueryWithCandidateUsers() {
        RestAssured.given().queryParam("withCandidateUsers", new Object[]{false}).accept("application/json").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery, (VerificationMode)Mockito.never())).withCandidateUsers();
    }

    @Test
    public void testNeverQueryWithoutCandidateUsers() {
        RestAssured.given().queryParam("withoutCandidateUsers", new Object[]{false}).accept("application/json").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery, (VerificationMode)Mockito.never())).withoutCandidateUsers();
    }

    @Test
    public void testNeverQueryWithCandidateGroups() {
        RestAssured.given().queryParam("withCandidateGroups", new Object[]{false}).accept("application/json").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery, (VerificationMode)Mockito.never())).withCandidateGroups();
    }

    @Test
    public void testNeverQueryWithoutCandidateGroups() {
        RestAssured.given().queryParam("withoutCandidateGroups", new Object[]{false}).accept("application/json").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_QUERY_URL, new Object[0]);
        ((TaskQuery)Mockito.verify((Object)this.mockQuery, (VerificationMode)Mockito.never())).withoutCandidateGroups();
    }

    @Test
    public void testOrQuery() {
        TaskQueryDto queryDto = TaskQueryDto.fromQuery((Query)new TaskQueryImpl().or().taskName("aName").taskDescription("aDescription").endOr());
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header(ACCEPT_JSON_HEADER).body((Object)queryDto).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(TASK_QUERY_URL, new Object[0]);
        ArgumentCaptor argument = ArgumentCaptor.forClass(TaskQueryImpl.class);
        ((TaskQueryImpl)Mockito.verify((Object)((TaskQueryImpl)this.mockQuery))).addOrQuery((TaskQueryImpl)argument.capture());
        TestCase.assertEquals((String)"aName", (String)((TaskQueryImpl)argument.getValue()).getName());
        TestCase.assertEquals((String)"aDescription", (String)((TaskQueryImpl)argument.getValue()).getDescription());
    }
}

