/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.helper;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.dmn.engine.DmnDecisionResult;
import org.camunda.bpm.dmn.engine.DmnDecisionResultEntries;
import org.camunda.bpm.engine.rest.helper.MockDecisionResultBuilder;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class MockDecisionResultEntriesBuilder {
    protected final MockDecisionResultBuilder mockDecisionResultBuilder;
    protected Map<String, TypedValue> entries = new HashMap<String, TypedValue>();

    public MockDecisionResultEntriesBuilder(MockDecisionResultBuilder mockDecisionResultBuilder) {
        this.mockDecisionResultBuilder = mockDecisionResultBuilder;
    }

    public MockDecisionResultEntriesBuilder entry(String key, TypedValue value) {
        this.entries.put(key, value);
        return this;
    }

    public MockDecisionResultBuilder endResultEntries() {
        SimpleDecisionResultEntries resultEntires = new SimpleDecisionResultEntries(this.entries);
        this.mockDecisionResultBuilder.addResultEntries(resultEntires);
        return this.mockDecisionResultBuilder;
    }

    public MockDecisionResultEntriesBuilder resultEntries() {
        return this.endResultEntries().resultEntries();
    }

    public DmnDecisionResult build() {
        return this.endResultEntries().build();
    }

    protected static class SimpleDecisionResultEntries
    extends HashMap<String, Object>
    implements DmnDecisionResultEntries {
        private static final long serialVersionUID = 1L;
        protected final Map<String, TypedValue> typedEntries;

        public SimpleDecisionResultEntries(Map<String, TypedValue> entries) {
            super(SimpleDecisionResultEntries.asEntryMap(entries));
            this.typedEntries = entries;
        }

        private static Map<? extends String, ?> asEntryMap(Map<String, TypedValue> typedValueMap) {
            HashMap<String, Object> entryMap = new HashMap<String, Object>();
            for (Map.Entry<String, TypedValue> entry : typedValueMap.entrySet()) {
                entryMap.put(entry.getKey(), entry.getValue().getValue());
            }
            return entryMap;
        }

        public <T> T getFirstEntry() {
            throw new UnsupportedOperationException();
        }

        public <T> T getSingleEntry() {
            throw new UnsupportedOperationException();
        }

        public <T> T getEntry(String name) {
            return (T)this.typedEntries.get(name).getValue();
        }

        public <T extends TypedValue> T getEntryTyped(String name) {
            return (T)this.typedEntries.get(name);
        }

        public <T extends TypedValue> T getFirstEntryTyped() {
            throw new UnsupportedOperationException();
        }

        public <T extends TypedValue> T getSingleEntryTyped() {
            throw new UnsupportedOperationException();
        }

        public Map<String, Object> getEntryMap() {
            throw new UnsupportedOperationException();
        }

        public Map<String, TypedValue> getEntryMapTyped() {
            throw new UnsupportedOperationException();
        }
    }
}

