/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.history.HistoricIncidentQuery;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class HistoricIncidentRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORY_INCIDENT_QUERY_URL = "/rest-test/history/incident";
    protected static final String HISTORY_INCIDENT_COUNT_QUERY_URL = "/rest-test/history/incident/count";
    private HistoricIncidentQuery mockedQuery;

    @Before
    public void setUpRuntimeData() {
        this.mockedQuery = this.setUpMockHistoricIncidentQuery(MockProvider.createMockHistoricIncidents());
    }

    private HistoricIncidentQuery setUpMockHistoricIncidentQuery(List<HistoricIncident> mockedHistoricIncidents) {
        HistoricIncidentQuery mockedHistoricIncidentQuery = (HistoricIncidentQuery)Mockito.mock(HistoricIncidentQuery.class);
        Mockito.when((Object)mockedHistoricIncidentQuery.list()).thenReturn(mockedHistoricIncidents);
        Mockito.when((Object)mockedHistoricIncidentQuery.count()).thenReturn((Object)mockedHistoricIncidents.size());
        Mockito.when((Object)processEngine.getHistoryService().createHistoricIncidentQuery()).thenReturn((Object)mockedHistoricIncidentQuery);
        return mockedHistoricIncidentQuery;
    }

    @Test
    public void testEmptyQuery() {
        String queryKey = "";
        RestAssured.given().queryParam("processInstanceId", new Object[]{queryKey}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_INCIDENT_QUERY_URL, new Object[0]);
    }

    @Test
    public void testNoParametersQuery() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_INCIDENT_QUERY_URL, new Object[0]);
        ((HistoricIncidentQuery)Mockito.verify((Object)this.mockedQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testInvalidSortingOptions() {
        this.executeAndVerifySorting("anInvalidSortByOption", "asc", Response.Status.BAD_REQUEST);
        this.executeAndVerifySorting("processInstanceId", "anInvalidSortOrderOption", Response.Status.BAD_REQUEST);
    }

    protected void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(HISTORY_INCIDENT_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORY_INCIDENT_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortingParameters() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("incidentId", "asc", Response.Status.OK);
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).orderByIncidentId();
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("incidentId", "desc", Response.Status.OK);
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).orderByIncidentId();
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("incidentMessage", "asc", Response.Status.OK);
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).orderByIncidentId();
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("incidentMessage", "desc", Response.Status.OK);
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).orderByIncidentId();
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("createTime", "asc", Response.Status.OK);
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).orderByCreateTime();
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("createTime", "desc", Response.Status.OK);
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).orderByCreateTime();
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("endTime", "asc", Response.Status.OK);
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).orderByCreateTime();
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("endTime", "desc", Response.Status.OK);
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).orderByEndTime();
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("incidentType", "asc", Response.Status.OK);
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).orderByIncidentType();
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("incidentType", "desc", Response.Status.OK);
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).orderByIncidentType();
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("executionId", "asc", Response.Status.OK);
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).orderByExecutionId();
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("executionId", "desc", Response.Status.OK);
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).orderByExecutionId();
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("activityId", "asc", Response.Status.OK);
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).orderByActivityId();
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("activityId", "desc", Response.Status.OK);
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).orderByActivityId();
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processInstanceId", "asc", Response.Status.OK);
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceId();
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processInstanceId", "desc", Response.Status.OK);
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceId();
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processDefinitionId", "asc", Response.Status.OK);
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionId();
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processDefinitionId", "desc", Response.Status.OK);
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionId();
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("causeIncidentId", "asc", Response.Status.OK);
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).orderByCauseIncidentId();
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("causeIncidentId", "desc", Response.Status.OK);
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).orderByCauseIncidentId();
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("rootCauseIncidentId", "asc", Response.Status.OK);
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).orderByRootCauseIncidentId();
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("rootCauseIncidentId", "desc", Response.Status.OK);
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).orderByRootCauseIncidentId();
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("configuration", "asc", Response.Status.OK);
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).orderByConfiguration();
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("configuration", "desc", Response.Status.OK);
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).orderByConfiguration();
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "asc", Response.Status.OK);
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "desc", Response.Status.OK);
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("incidentState", "asc", Response.Status.OK);
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).orderByIncidentState();
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("incidentState", "desc", Response.Status.OK);
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).orderByIncidentState();
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).desc();
    }

    @Test
    public void testSuccessfulPagination() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_INCIDENT_QUERY_URL, new Object[0]);
        ((HistoricIncidentQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, maxResults);
    }

    @Test
    public void testMissingFirstResultParameter() {
        int maxResults = 10;
        RestAssured.given().queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_INCIDENT_QUERY_URL, new Object[0]);
        ((HistoricIncidentQuery)Mockito.verify((Object)this.mockedQuery)).listPage(0, maxResults);
    }

    @Test
    public void testMissingMaxResultsParameter() {
        int firstResult = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_INCIDENT_QUERY_URL, new Object[0]);
        ((HistoricIncidentQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, Integer.MAX_VALUE);
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(HISTORY_INCIDENT_COUNT_QUERY_URL, new Object[0]);
        ((HistoricIncidentQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testSimpleHistoricTaskInstanceQuery() {
        Response response = (Response)RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_INCIDENT_QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List incidents = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one incident returned.", (long)1L, (long)incidents.size());
        Assert.assertNotNull((String)"The returned incident should not be null.", incidents.get(0));
        String returnedId = JsonPath.from((String)content).getString("[0].id");
        String returnedProcessDefinitionKey = JsonPath.from((String)content).getString("[0].processDefinitionKey");
        String returnedProcessDefinitionId = JsonPath.from((String)content).getString("[0].processDefinitionId");
        String returnedProcessInstanceId = JsonPath.from((String)content).getString("[0].processInstanceId");
        String returnedExecutionId = JsonPath.from((String)content).getString("[0].executionId");
        Date returnedCreateTime = DateTimeUtil.parseDate((String)JsonPath.from((String)content).getString("[0].createTime"));
        Date returnedEndTime = DateTimeUtil.parseDate((String)JsonPath.from((String)content).getString("[0].endTime"));
        String returnedIncidentType = JsonPath.from((String)content).getString("[0].incidentType");
        String returnedActivityId = JsonPath.from((String)content).getString("[0].activityId");
        String returnedCauseIncidentId = JsonPath.from((String)content).getString("[0].causeIncidentId");
        String returnedRootCauseIncidentId = JsonPath.from((String)content).getString("[0].rootCauseIncidentId");
        String returnedConfiguration = JsonPath.from((String)content).getString("[0].configuration");
        String returnedIncidentMessage = JsonPath.from((String)content).getString("[0].incidentMessage");
        Boolean returnedIncidentOpen = JsonPath.from((String)content).getBoolean("[0].open");
        Boolean returnedIncidentDeleted = JsonPath.from((String)content).getBoolean("[0].deleted");
        Boolean returnedIncidentResolved = JsonPath.from((String)content).getBoolean("[0].resolved");
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedJobDefinitionId = JsonPath.from((String)content).getString("[0].jobDefinitionId");
        Date returnedRemovalTime = DateTimeUtil.parseDate((String)JsonPath.from((String)content).getString("[0].removalTime"));
        String returnedRootProcessInstanceId = JsonPath.from((String)content).getString("[0].rootProcessInstanceId");
        Assert.assertEquals((Object)"anIncidentId", (Object)returnedId);
        Assert.assertEquals((Object)"aProcInstId", (Object)returnedProcessInstanceId);
        Assert.assertEquals((Object)DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HIST_INCIDENT_CREATE_TIME), (Object)returnedCreateTime);
        Assert.assertEquals((Object)DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HIST_INCIDENT_END_TIME), (Object)returnedEndTime);
        Assert.assertEquals((Object)"anExecutionId", (Object)returnedExecutionId);
        Assert.assertEquals((Object)"aProcDefId", (Object)returnedProcessDefinitionId);
        Assert.assertEquals((Object)"aProcDefKey", (Object)returnedProcessDefinitionKey);
        Assert.assertEquals((Object)"anIncidentType", (Object)returnedIncidentType);
        Assert.assertEquals((Object)"anActivityId", (Object)returnedActivityId);
        Assert.assertEquals((Object)"aCauseIncidentId", (Object)returnedCauseIncidentId);
        Assert.assertEquals((Object)"aRootCauseIncidentId", (Object)returnedRootCauseIncidentId);
        Assert.assertEquals((Object)"aConfiguration", (Object)returnedConfiguration);
        Assert.assertEquals((Object)"anIncidentMessage", (Object)returnedIncidentMessage);
        Assert.assertEquals((Object)false, (Object)returnedIncidentOpen);
        Assert.assertEquals((Object)false, (Object)returnedIncidentDeleted);
        Assert.assertEquals((Object)true, (Object)returnedIncidentResolved);
        Assert.assertEquals((Object)"aTenantId", (Object)returnedTenantId);
        Assert.assertEquals((Object)"aJobDefId", (Object)returnedJobDefinitionId);
        Assert.assertEquals((Object)DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HIST_INCIDENT_REMOVAL_TIME), (Object)returnedRemovalTime);
        Assert.assertEquals((Object)"aRootProcInstId", (Object)returnedRootProcessInstanceId);
    }

    @Test
    public void testQueryByIncidentId() {
        String incidentId = "anIncidentId";
        RestAssured.given().queryParam("incidentId", new Object[]{incidentId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_INCIDENT_QUERY_URL, new Object[0]);
        ((HistoricIncidentQuery)Mockito.verify((Object)this.mockedQuery)).incidentId(incidentId);
    }

    @Test
    public void testQueryByIncidentType() {
        String incidentType = "anIncidentType";
        RestAssured.given().queryParam("incidentType", new Object[]{incidentType}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_INCIDENT_QUERY_URL, new Object[0]);
        ((HistoricIncidentQuery)Mockito.verify((Object)this.mockedQuery)).incidentType(incidentType);
    }

    @Test
    public void testQueryByIncidentMessage() {
        String incidentMessage = "anIncidentMessage";
        RestAssured.given().queryParam("incidentMessage", new Object[]{incidentMessage}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_INCIDENT_QUERY_URL, new Object[0]);
        ((HistoricIncidentQuery)Mockito.verify((Object)this.mockedQuery)).incidentMessage(incidentMessage);
    }

    @Test
    public void testQueryByProcessDefinitionId() {
        String processDefinitionId = "aProcDefId";
        RestAssured.given().queryParam("processDefinitionId", new Object[]{processDefinitionId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_INCIDENT_QUERY_URL, new Object[0]);
        ((HistoricIncidentQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionId(processDefinitionId);
    }

    @Test
    public void testQueryByProcessDefinitionKey() {
        String key1 = "foo";
        String key2 = "bar";
        RestAssured.given().queryParam("processDefinitionKeyIn", new Object[]{key1 + "," + key2}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_INCIDENT_QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).processDefinitionKeyIn(new String[]{"foo", "bar"});
        ((HistoricIncidentQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testQueryByProcessInstanceId() {
        String processInstanceId = "aProcInstId";
        RestAssured.given().queryParam("processInstanceId", new Object[]{processInstanceId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_INCIDENT_QUERY_URL, new Object[0]);
        ((HistoricIncidentQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceId(processInstanceId);
    }

    @Test
    public void testQueryByExecutionId() {
        String executionId = "anExecutionId";
        RestAssured.given().queryParam("executionId", new Object[]{executionId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_INCIDENT_QUERY_URL, new Object[0]);
        ((HistoricIncidentQuery)Mockito.verify((Object)this.mockedQuery)).executionId(executionId);
    }

    @Test
    public void testQueryByActivityId() {
        String activityId = "anActivityId";
        RestAssured.given().queryParam("activityId", new Object[]{activityId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_INCIDENT_QUERY_URL, new Object[0]);
        ((HistoricIncidentQuery)Mockito.verify((Object)this.mockedQuery)).activityId(activityId);
    }

    @Test
    public void testQueryByCauseIncidentId() {
        String causeIncidentId = "aCauseIncidentId";
        RestAssured.given().queryParam("causeIncidentId", new Object[]{causeIncidentId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_INCIDENT_QUERY_URL, new Object[0]);
        ((HistoricIncidentQuery)Mockito.verify((Object)this.mockedQuery)).causeIncidentId(causeIncidentId);
    }

    @Test
    public void testQueryByRootCauseIncidentId() {
        String rootCauseIncidentId = "aRootCauseIncidentId";
        RestAssured.given().queryParam("rootCauseIncidentId", new Object[]{rootCauseIncidentId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_INCIDENT_QUERY_URL, new Object[0]);
        ((HistoricIncidentQuery)Mockito.verify((Object)this.mockedQuery)).rootCauseIncidentId(rootCauseIncidentId);
    }

    @Test
    public void testQueryByConfiguration() {
        String configuration = "aConfiguration";
        RestAssured.given().queryParam("configuration", new Object[]{configuration}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_INCIDENT_QUERY_URL, new Object[0]);
        ((HistoricIncidentQuery)Mockito.verify((Object)this.mockedQuery)).configuration(configuration);
    }

    @Test
    public void testQueryByHistoryConfiguration() {
        String historyConfiguration = "aHistoryConfiguration";
        RestAssured.given().queryParam("historyConfiguration", new Object[]{historyConfiguration}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_INCIDENT_QUERY_URL, new Object[0]);
        ((HistoricIncidentQuery)Mockito.verify((Object)this.mockedQuery)).historyConfiguration(historyConfiguration);
    }

    @Test
    public void testQueryByOpen() {
        RestAssured.given().queryParam("open", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_INCIDENT_QUERY_URL, new Object[0]);
        ((HistoricIncidentQuery)Mockito.verify((Object)this.mockedQuery)).open();
    }

    @Test
    public void testQueryByResolved() {
        RestAssured.given().queryParam("resolved", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_INCIDENT_QUERY_URL, new Object[0]);
        ((HistoricIncidentQuery)Mockito.verify((Object)this.mockedQuery)).resolved();
    }

    @Test
    public void testQueryByDeleted() {
        RestAssured.given().queryParam("deleted", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_INCIDENT_QUERY_URL, new Object[0]);
        ((HistoricIncidentQuery)Mockito.verify((Object)this.mockedQuery)).deleted();
    }

    @Test
    public void testQueryByTenantIds() {
        this.mockedQuery = this.setUpMockHistoricIncidentQuery(Arrays.asList(MockProvider.createMockHistoricIncident("aTenantId"), MockProvider.createMockHistoricIncident("anotherTenantId")));
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId,anotherTenantId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_INCIDENT_QUERY_URL, new Object[0]);
        ((HistoricIncidentQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((HistoricIncidentQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List incidents = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)incidents).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testQueryWithoutTenantIdQueryParameter() {
        this.mockedQuery = this.setUpMockHistoricIncidentQuery(Collections.singletonList(MockProvider.createMockHistoricIncident(null)));
        Response response = (Response)RestAssured.given().queryParam("withoutTenantId", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_INCIDENT_QUERY_URL, new Object[0]);
        ((HistoricIncidentQuery)Mockito.verify((Object)this.mockedQuery)).withoutTenantId();
        ((HistoricIncidentQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(1);
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        Assertions.assertThat((String)returnedTenantId).isEqualTo(null);
    }

    @Test
    public void testQueryByJobDefinitionIds() {
        String jobDefinitionIds = "aJobDefId,aNonExistingJobDefId";
        RestAssured.given().queryParam("jobDefinitionIdIn", new Object[]{jobDefinitionIds}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_INCIDENT_QUERY_URL, new Object[0]);
        ((HistoricIncidentQuery)Mockito.verify((Object)this.mockedQuery)).jobDefinitionIdIn(new String[]{"aJobDefId", "aNonExistingJobDefId"});
        ((HistoricIncidentQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }
}

