/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricJobLogQuery;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.converter.BooleanConverter;
import org.camunda.bpm.engine.rest.dto.converter.LongConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringArrayConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringListConverter;

public class HistoricJobLogQueryDto
extends AbstractQueryDto<HistoricJobLogQuery> {
    protected static final String SORT_BY_TIMESTAMP = "timestamp";
    protected static final String SORT_BY_JOB_ID = "jobId";
    protected static final String SORT_BY_JOB_DUE_DATE = "jobDueDate";
    protected static final String SORT_BY_JOB_RETRIES = "jobRetries";
    protected static final String SORT_BY_JOB_PRIORITY = "jobPriority";
    protected static final String SORT_BY_JOB_DEFINITION_ID = "jobDefinitionId";
    protected static final String SORT_BY_ACTIVITY_ID = "activityId";
    protected static final String SORT_BY_EXECUTION_ID = "executionId";
    protected static final String SORT_BY_PROCESS_INSTANCE_ID = "processInstanceId";
    protected static final String SORT_BY_PROCESS_DEFINITION_ID = "processDefinitionId";
    protected static final String SORT_BY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    protected static final String SORT_BY_DEPLOYMENT_ID = "deploymentId";
    protected static final String SORT_PARTIALLY_BY_OCCURRENCE = "occurrence";
    protected static final String SORT_BY_TENANT_ID = "tenantId";
    protected static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String id;
    protected String jobId;
    protected String jobExceptionMessage;
    protected String jobDefinitionId;
    protected String jobDefinitionType;
    protected String jobDefinitionConfiguration;
    protected String[] activityIds;
    protected String[] executionIds;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String deploymentId;
    protected Boolean creationLog;
    protected Boolean failureLog;
    protected Boolean successLog;
    protected Boolean deletionLog;
    protected Long jobPriorityHigherThanOrEquals;
    protected Long jobPriorityLowerThanOrEquals;
    protected List<String> tenantIds;
    protected Boolean withoutTenantId;

    public HistoricJobLogQueryDto() {
    }

    public HistoricJobLogQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="logId")
    public void setLogId(String id) {
        this.id = id;
    }

    @CamundaQueryParam(value="jobId")
    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    @CamundaQueryParam(value="jobExceptionMessage")
    public void setJobExceptionMessage(String jobExceptionMessage) {
        this.jobExceptionMessage = jobExceptionMessage;
    }

    @CamundaQueryParam(value="jobDefinitionId")
    public void setJobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
    }

    @CamundaQueryParam(value="jobDefinitionType")
    public void setJobDefinitionType(String jobDefinitionType) {
        this.jobDefinitionType = jobDefinitionType;
    }

    @CamundaQueryParam(value="jobDefinitionConfiguration")
    public void setJobDefinitionConfiguration(String jobDefinitionConfiguration) {
        this.jobDefinitionConfiguration = jobDefinitionConfiguration;
    }

    @CamundaQueryParam(value="activityIdIn", converter=StringArrayConverter.class)
    public void setActivityIdIn(String[] activityIds) {
        this.activityIds = activityIds;
    }

    @CamundaQueryParam(value="executionIdIn", converter=StringArrayConverter.class)
    public void setExecutionIdIn(String[] executionIds) {
        this.executionIds = executionIds;
    }

    @CamundaQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @CamundaQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @CamundaQueryParam(value="processDefinitionKey")
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @CamundaQueryParam(value="deploymentId")
    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    @CamundaQueryParam(value="creationLog", converter=BooleanConverter.class)
    public void setCreationLog(Boolean creationLog) {
        this.creationLog = creationLog;
    }

    @CamundaQueryParam(value="failureLog", converter=BooleanConverter.class)
    public void setFailureLog(Boolean failureLog) {
        this.failureLog = failureLog;
    }

    @CamundaQueryParam(value="successLog", converter=BooleanConverter.class)
    public void setSuccessLog(Boolean successLog) {
        this.successLog = successLog;
    }

    @CamundaQueryParam(value="deletionLog", converter=BooleanConverter.class)
    public void setDeletionLog(Boolean deletionLog) {
        this.deletionLog = deletionLog;
    }

    @CamundaQueryParam(value="jobPriorityHigherThanOrEquals", converter=LongConverter.class)
    public void setJobPriorityHigherThanOrEquals(Long jobPriorityHigherThanOrEquals) {
        this.jobPriorityHigherThanOrEquals = jobPriorityHigherThanOrEquals;
    }

    @CamundaQueryParam(value="jobPriorityLowerThanOrEquals", converter=LongConverter.class)
    public void setJobPriorityLowerThanOrEquals(Long jobPriorityLowerThanOrEquals) {
        this.jobPriorityLowerThanOrEquals = jobPriorityLowerThanOrEquals;
    }

    @CamundaQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @CamundaQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected HistoricJobLogQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricJobLogQuery();
    }

    @Override
    protected void applyFilters(HistoricJobLogQuery query) {
        if (this.id != null) {
            query.logId(this.id);
        }
        if (this.jobId != null) {
            query.jobId(this.jobId);
        }
        if (this.jobExceptionMessage != null) {
            query.jobExceptionMessage(this.jobExceptionMessage);
        }
        if (this.jobDefinitionId != null) {
            query.jobDefinitionId(this.jobDefinitionId);
        }
        if (this.jobDefinitionType != null) {
            query.jobDefinitionType(this.jobDefinitionType);
        }
        if (this.jobDefinitionConfiguration != null) {
            query.jobDefinitionConfiguration(this.jobDefinitionConfiguration);
        }
        if (this.activityIds != null && this.activityIds.length > 0) {
            query.activityIdIn(this.activityIds);
        }
        if (this.executionIds != null && this.executionIds.length > 0) {
            query.executionIdIn(this.executionIds);
        }
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.processDefinitionKey != null) {
            query.processDefinitionKey(this.processDefinitionKey);
        }
        if (this.deploymentId != null) {
            query.deploymentId(this.deploymentId);
        }
        if (this.creationLog != null && this.creationLog.booleanValue()) {
            query.creationLog();
        }
        if (this.failureLog != null && this.failureLog.booleanValue()) {
            query.failureLog();
        }
        if (this.successLog != null && this.successLog.booleanValue()) {
            query.successLog();
        }
        if (this.deletionLog != null && this.deletionLog.booleanValue()) {
            query.deletionLog();
        }
        if (this.jobPriorityLowerThanOrEquals != null) {
            query.jobPriorityLowerThanOrEquals(this.jobPriorityLowerThanOrEquals.longValue());
        }
        if (this.jobPriorityHigherThanOrEquals != null) {
            query.jobPriorityHigherThanOrEquals(this.jobPriorityHigherThanOrEquals.longValue());
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
    }

    @Override
    protected void applySortBy(HistoricJobLogQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_TIMESTAMP)) {
            query.orderByTimestamp();
        } else if (sortBy.equals(SORT_BY_JOB_ID)) {
            query.orderByJobId();
        } else if (sortBy.equals(SORT_BY_JOB_DUE_DATE)) {
            query.orderByJobDueDate();
        } else if (sortBy.equals(SORT_BY_JOB_RETRIES)) {
            query.orderByJobRetries();
        } else if (sortBy.equals(SORT_BY_JOB_PRIORITY)) {
            query.orderByJobPriority();
        } else if (sortBy.equals(SORT_BY_JOB_DEFINITION_ID)) {
            query.orderByJobDefinitionId();
        } else if (sortBy.equals(SORT_BY_ACTIVITY_ID)) {
            query.orderByActivityId();
        } else if (sortBy.equals(SORT_BY_EXECUTION_ID)) {
            query.orderByExecutionId();
        } else if (sortBy.equals(SORT_BY_PROCESS_INSTANCE_ID)) {
            query.orderByProcessInstanceId();
        } else if (sortBy.equals(SORT_BY_PROCESS_DEFINITION_ID)) {
            query.orderByProcessDefinitionId();
        } else if (sortBy.equals(SORT_BY_PROCESS_DEFINITION_KEY)) {
            query.orderByProcessDefinitionKey();
        } else if (sortBy.equals(SORT_BY_DEPLOYMENT_ID)) {
            query.orderByDeploymentId();
        } else if (sortBy.equals(SORT_PARTIALLY_BY_OCCURRENCE)) {
            query.orderPartiallyByOccurrence();
        } else if (sortBy.equals(SORT_BY_TENANT_ID)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_TIMESTAMP);
        VALID_SORT_BY_VALUES.add(SORT_BY_JOB_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_JOB_DUE_DATE);
        VALID_SORT_BY_VALUES.add(SORT_BY_JOB_RETRIES);
        VALID_SORT_BY_VALUES.add(SORT_BY_JOB_PRIORITY);
        VALID_SORT_BY_VALUES.add(SORT_BY_JOB_DEFINITION_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_ACTIVITY_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_EXECUTION_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_KEY);
        VALID_SORT_BY_VALUES.add(SORT_BY_DEPLOYMENT_ID);
        VALID_SORT_BY_VALUES.add(SORT_PARTIALLY_BY_OCCURRENCE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
    }
}

