/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.CleanableHistoricProcessInstanceReport;
import org.camunda.bpm.engine.history.CleanableHistoricProcessInstanceReportResult;
import org.camunda.bpm.engine.history.HistoricActivityStatistics;
import org.camunda.bpm.engine.history.HistoricActivityStatisticsQuery;
import org.camunda.bpm.engine.impl.HistoricActivityStatisticsQueryImpl;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.history.CleanableHistoricProcessInstanceReportDto;
import org.camunda.bpm.engine.rest.dto.history.CleanableHistoricProcessInstanceReportResultDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricActivityStatisticsDto;
import org.camunda.bpm.engine.rest.history.HistoricProcessDefinitionRestService;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.rest.impl.history.HistoricActivityStatisticsQueryDto;

public class HistoricProcessDefinitionRestServiceImpl
extends AbstractRestProcessEngineAware
implements HistoricProcessDefinitionRestService {
    public HistoricProcessDefinitionRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        super(processEngine.getName(), objectMapper);
    }

    @Override
    public List<HistoricActivityStatisticsDto> getHistoricActivityStatistics(UriInfo uriInfo, String processDefinitionId) {
        HistoricActivityStatisticsQueryDto queryDto = new HistoricActivityStatisticsQueryDto(this.getObjectMapper(), processDefinitionId, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)queryDto.toQuery(this.processEngine);
        ArrayList<HistoricActivityStatisticsDto> result = new ArrayList<HistoricActivityStatisticsDto>();
        List statistics = ((HistoricActivityStatisticsQueryImpl)query).unboundedResultList();
        for (HistoricActivityStatistics currentStatistics : statistics) {
            result.add(HistoricActivityStatisticsDto.fromHistoricActivityStatistics(currentStatistics));
        }
        return result;
    }

    @Override
    public List<CleanableHistoricProcessInstanceReportResultDto> getCleanableHistoricProcessInstanceReport(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        CleanableHistoricProcessInstanceReportDto queryDto = new CleanableHistoricProcessInstanceReportDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        CleanableHistoricProcessInstanceReport query = (CleanableHistoricProcessInstanceReport)queryDto.toQuery(this.processEngine);
        List<CleanableHistoricProcessInstanceReportResult> reportResult = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        return CleanableHistoricProcessInstanceReportResultDto.convert(reportResult);
    }

    private List<CleanableHistoricProcessInstanceReportResult> executePaginatedQuery(CleanableHistoricProcessInstanceReport query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    @Override
    public CountResultDto getCleanableHistoricProcessInstanceReportCount(UriInfo uriInfo) {
        CleanableHistoricProcessInstanceReportDto queryDto = new CleanableHistoricProcessInstanceReportDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        queryDto.setObjectMapper(this.objectMapper);
        CleanableHistoricProcessInstanceReport query = (CleanableHistoricProcessInstanceReport)queryDto.toQuery(this.processEngine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

