/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.runtime;

import java.util.List;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.rest.dto.SuspensionStateDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricProcessInstanceQueryDto;
import org.camunda.bpm.engine.rest.dto.runtime.ProcessInstanceQueryDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.runtime.UpdateProcessInstanceSuspensionStateBuilder;
import org.camunda.bpm.engine.runtime.UpdateProcessInstanceSuspensionStateSelectBuilder;
import org.camunda.bpm.engine.runtime.UpdateProcessInstanceSuspensionStateTenantBuilder;
import org.camunda.bpm.engine.runtime.UpdateProcessInstancesSuspensionStateBuilder;

public class ProcessInstanceSuspensionStateDto
extends SuspensionStateDto {
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected List<String> processInstanceIds;
    protected ProcessInstanceQueryDto processInstanceQuery;
    protected HistoricProcessInstanceQueryDto historicProcessInstanceQuery;
    protected String processDefinitionTenantId;
    protected boolean processDefinitionWithoutTenantId;

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public List<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public void setProcessInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
    }

    public ProcessInstanceQueryDto getProcessInstanceQuery() {
        return this.processInstanceQuery;
    }

    public void setProcessInstanceQuery(ProcessInstanceQueryDto processInstanceQuery) {
        this.processInstanceQuery = processInstanceQuery;
    }

    public void setHistoricProcessInstanceQuery(HistoricProcessInstanceQueryDto historicProcessInstanceQuery) {
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
    }

    public HistoricProcessInstanceQueryDto getHistoricProcessInstanceQuery() {
        return this.historicProcessInstanceQuery;
    }

    public void setProcessDefinitionTenantId(String processDefinitionTenantId) {
        this.processDefinitionTenantId = processDefinitionTenantId;
    }

    public boolean getProcessDefinitionWithoutTenantId() {
        return this.processDefinitionWithoutTenantId;
    }

    public void setProcessDefinitionWithoutTenantId(boolean processDefinitionWithoutTenantId) {
        this.processDefinitionWithoutTenantId = processDefinitionWithoutTenantId;
    }

    @Override
    public void updateSuspensionState(ProcessEngine engine) {
        int params = this.parameterCount(this.processInstanceId, this.processDefinitionId, this.processDefinitionKey);
        int syncParams = this.parameterCount(this.processInstanceIds, this.processInstanceQuery, this.historicProcessInstanceQuery);
        if (params >= 1 && syncParams >= 1) {
            String message = "Choose either a single processInstance with processInstanceId, processDefinitionId or processDefinitionKey or a group of processInstances with processInstanceIds, procesInstanceQuery or historicProcessInstanceQuery.";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
        if (params > 1) {
            String message = "Only one of processInstanceId, processDefinitionId or processDefinitionKey should be set to update the suspension state.";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
        if (params == 0 && syncParams == 0) {
            String message = "Either processInstanceId, processDefinitionId or processDefinitionKey should be set to update the suspension state.";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
        UpdateProcessInstanceSuspensionStateBuilder updateSuspensionStateBuilder = null;
        if (params == 1) {
            updateSuspensionStateBuilder = this.createUpdateSuspensionStateBuilder(engine);
        } else if (syncParams >= 1) {
            updateSuspensionStateBuilder = this.createUpdateSuspensionStateGroupBuilder(engine);
        }
        if (this.getSuspended()) {
            updateSuspensionStateBuilder.suspend();
        } else {
            updateSuspensionStateBuilder.activate();
        }
    }

    public Batch updateSuspensionStateAsync(ProcessEngine engine) {
        int params = this.parameterCount(this.processInstanceIds, this.processInstanceQuery, this.historicProcessInstanceQuery);
        if (params == 0) {
            String message = "Either processInstanceIds, processInstanceQuery or historicProcessInstanceQuery should be set to update the suspension state.";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
        UpdateProcessInstancesSuspensionStateBuilder updateSuspensionStateBuilder = this.createUpdateSuspensionStateGroupBuilder(engine);
        if (this.getSuspended()) {
            return updateSuspensionStateBuilder.suspendAsync();
        }
        return updateSuspensionStateBuilder.activateAsync();
    }

    protected UpdateProcessInstanceSuspensionStateBuilder createUpdateSuspensionStateBuilder(ProcessEngine engine) {
        UpdateProcessInstanceSuspensionStateSelectBuilder selectBuilder = engine.getRuntimeService().updateProcessInstanceSuspensionState();
        if (this.processInstanceId != null) {
            return selectBuilder.byProcessInstanceId(this.processInstanceId);
        }
        if (this.processDefinitionId != null) {
            return selectBuilder.byProcessDefinitionId(this.processDefinitionId);
        }
        UpdateProcessInstanceSuspensionStateTenantBuilder tenantBuilder = selectBuilder.byProcessDefinitionKey(this.processDefinitionKey);
        if (this.processDefinitionTenantId != null) {
            tenantBuilder.processDefinitionTenantId(this.processDefinitionTenantId);
        } else if (this.processDefinitionWithoutTenantId) {
            tenantBuilder.processDefinitionWithoutTenantId();
        }
        return tenantBuilder;
    }

    protected UpdateProcessInstancesSuspensionStateBuilder createUpdateSuspensionStateGroupBuilder(ProcessEngine engine) {
        UpdateProcessInstanceSuspensionStateSelectBuilder selectBuilder = engine.getRuntimeService().updateProcessInstanceSuspensionState();
        UpdateProcessInstancesSuspensionStateBuilder groupBuilder = null;
        if (this.processInstanceIds != null) {
            groupBuilder = selectBuilder.byProcessInstanceIds(this.processInstanceIds);
        }
        if (this.processInstanceQuery != null) {
            if (groupBuilder == null) {
                groupBuilder = selectBuilder.byProcessInstanceQuery((ProcessInstanceQuery)this.processInstanceQuery.toQuery(engine));
            } else {
                groupBuilder.byProcessInstanceQuery((ProcessInstanceQuery)this.processInstanceQuery.toQuery(engine));
            }
        }
        if (this.historicProcessInstanceQuery != null) {
            if (groupBuilder == null) {
                groupBuilder = selectBuilder.byHistoricProcessInstanceQuery((HistoricProcessInstanceQuery)this.historicProcessInstanceQuery.toQuery(engine));
            } else {
                groupBuilder.byHistoricProcessInstanceQuery((HistoricProcessInstanceQuery)this.historicProcessInstanceQuery.toQuery(engine));
            }
        }
        return groupBuilder;
    }

    protected int parameterCount(Object ... o) {
        int count = 0;
        for (Object o1 : o) {
            count += o1 != null ? 1 : 0;
        }
        return count;
    }
}

