/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.hal.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.rest.cache.Cache;
import org.camunda.bpm.engine.rest.hal.Hal;
import org.camunda.bpm.engine.rest.hal.HalLinkResolver;
import org.camunda.bpm.engine.rest.hal.HalResource;

public abstract class HalCachingLinkResolver
implements HalLinkResolver {
    @Override
    public List<HalResource<?>> resolveLinks(String[] linkedIds, ProcessEngine processEngine) {
        Cache cache = this.getCache();
        if (cache == null) {
            return this.resolveNotCachedLinks(linkedIds, processEngine);
        }
        ArrayList<String> notCachedLinkedIds = new ArrayList<String>();
        List<HalResource<?>> resolvedResources = this.resolveCachedLinks(linkedIds, cache, notCachedLinkedIds);
        if (!notCachedLinkedIds.isEmpty()) {
            List<HalResource<?>> notCachedResources = this.resolveNotCachedLinks(notCachedLinkedIds.toArray(new String[notCachedLinkedIds.size()]), processEngine);
            resolvedResources.addAll(notCachedResources);
            this.putIntoCache(notCachedResources);
        }
        this.sortResolvedResources(resolvedResources);
        return resolvedResources;
    }

    protected void sortResolvedResources(List<HalResource<?>> resolvedResources) {
        Comparator<HalResource<?>> comparator = this.getResourceComparator();
        if (comparator != null) {
            Collections.sort(resolvedResources, comparator);
        }
    }

    protected Cache getCache() {
        return Hal.getInstance().getHalRelationCache(this.getHalResourceClass());
    }

    protected List<HalResource<?>> resolveCachedLinks(String[] linkedIds, Cache cache, List<String> notCachedLinkedIds) {
        ArrayList resolvedResources = new ArrayList();
        for (String linkedId : linkedIds) {
            HalResource resource = (HalResource)cache.get(linkedId);
            if (resource != null) {
                resolvedResources.add(resource);
                continue;
            }
            notCachedLinkedIds.add(linkedId);
        }
        return resolvedResources;
    }

    protected void putIntoCache(List<HalResource<?>> notCachedResources) {
        Cache cache = this.getCache();
        for (HalResource<?> notCachedResource : notCachedResources) {
            cache.put(this.getResourceId(notCachedResource), notCachedResource);
        }
    }

    protected abstract Class<?> getHalResourceClass();

    protected Comparator<HalResource<?>> getResourceComparator() {
        return null;
    }

    protected abstract List<HalResource<?>> resolveNotCachedLinks(String[] var1, ProcessEngine var2);

    protected abstract String getResourceId(HalResource<?> var1);
}

