/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.management.MetricIntervalValue;
import org.camunda.bpm.engine.management.MetricsQuery;
import org.camunda.bpm.engine.rest.MetricsRestService;
import org.camunda.bpm.engine.rest.dto.converter.DateConverter;
import org.camunda.bpm.engine.rest.dto.converter.IntegerConverter;
import org.camunda.bpm.engine.rest.dto.converter.LongConverter;
import org.camunda.bpm.engine.rest.dto.metrics.MetricsIntervalResultDto;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.rest.sub.metrics.MetricsResource;
import org.camunda.bpm.engine.rest.sub.metrics.MetricsResourceImpl;

public class MetricsRestServiceImpl
extends AbstractRestProcessEngineAware
implements MetricsRestService {
    public static final String QUERY_PARAM_NAME = "name";
    public static final String QUERY_PARAM_REPORTER = "reporter";
    public static final String QUERY_PARAM_START_DATE = "startDate";
    public static final String QUERY_PARAM_END_DATE = "endDate";
    public static final String QUERY_PARAM_FIRST_RESULT = "firstResult";
    public static final String QUERY_PARAM_MAX_RESULTS = "maxResults";
    public static final String QUERY_PARAM_INTERVAL = "interval";
    public static final String QUERY_PARAM_AGG_BY_REPORTER = "aggregateByReporter";

    public MetricsRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public MetricsResource getMetrics(String name) {
        return new MetricsResourceImpl(name, this.processEngine, this.objectMapper);
    }

    @Override
    public List<MetricsIntervalResultDto> interval(UriInfo uriInfo) {
        List metrics;
        MultivaluedMap queryParameters = uriInfo.getQueryParameters();
        MetricsQuery query = this.processEngine.getManagementService().createMetricsQuery().name((String)queryParameters.getFirst((Object)QUERY_PARAM_NAME)).reporter((String)queryParameters.getFirst((Object)QUERY_PARAM_REPORTER));
        this.applyQueryParams(query, (MultivaluedMap<String, String>)queryParameters);
        LongConverter longConverter = new LongConverter();
        longConverter.setObjectMapper(this.objectMapper);
        if (queryParameters.getFirst((Object)QUERY_PARAM_INTERVAL) != null) {
            long interval = longConverter.convertQueryParameterToType((String)queryParameters.getFirst((Object)QUERY_PARAM_INTERVAL));
            metrics = query.interval(interval);
        } else {
            metrics = query.interval();
        }
        return this.convertToDtos(metrics);
    }

    protected void applyQueryParams(MetricsQuery query, MultivaluedMap<String, String> queryParameters) {
        DateConverter dateConverter = new DateConverter();
        dateConverter.setObjectMapper(this.objectMapper);
        if (queryParameters.getFirst((Object)QUERY_PARAM_START_DATE) != null) {
            Date startDate = dateConverter.convertQueryParameterToType((String)queryParameters.getFirst((Object)QUERY_PARAM_START_DATE));
            query.startDate(startDate);
        }
        if (queryParameters.getFirst((Object)QUERY_PARAM_END_DATE) != null) {
            Date endDate = dateConverter.convertQueryParameterToType((String)queryParameters.getFirst((Object)QUERY_PARAM_END_DATE));
            query.endDate(endDate);
        }
        IntegerConverter intConverter = new IntegerConverter();
        intConverter.setObjectMapper(this.objectMapper);
        if (queryParameters.getFirst((Object)QUERY_PARAM_FIRST_RESULT) != null) {
            int firstResult = intConverter.convertQueryParameterToType((String)queryParameters.getFirst((Object)QUERY_PARAM_FIRST_RESULT));
            query.offset(firstResult);
        }
        if (queryParameters.getFirst((Object)QUERY_PARAM_MAX_RESULTS) != null) {
            int maxResults = intConverter.convertQueryParameterToType((String)queryParameters.getFirst((Object)QUERY_PARAM_MAX_RESULTS));
            query.limit(maxResults);
        }
        if (queryParameters.getFirst((Object)QUERY_PARAM_AGG_BY_REPORTER) != null) {
            query.aggregateByReporter();
        }
    }

    protected List<MetricsIntervalResultDto> convertToDtos(List<MetricIntervalValue> metrics) {
        ArrayList<MetricsIntervalResultDto> intervalMetrics = new ArrayList<MetricsIntervalResultDto>();
        for (MetricIntervalValue m : metrics) {
            intervalMetrics.add(new MetricsIntervalResultDto(m));
        }
        return intervalMetrics;
    }
}

