/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricActivityInstanceQuery;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricActivityInstanceDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricActivityInstanceQueryDto;
import org.camunda.bpm.engine.rest.history.HistoricActivityInstanceRestService;
import org.camunda.bpm.engine.rest.sub.history.HistoricActivityInstanceResource;
import org.camunda.bpm.engine.rest.sub.history.impl.HistoricActivityInstanceResourceImpl;

public class HistoricActivityInstanceRestServiceImpl
implements HistoricActivityInstanceRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoricActivityInstanceRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    @Override
    public HistoricActivityInstanceResource getHistoricCaseInstance(String activityInstanceId) {
        return new HistoricActivityInstanceResourceImpl(this.processEngine, activityInstanceId);
    }

    @Override
    public List<HistoricActivityInstanceDto> getHistoricActivityInstances(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        HistoricActivityInstanceQueryDto queryHistoricActivityInstanceDto = new HistoricActivityInstanceQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryHistoricActivityInstances(queryHistoricActivityInstanceDto, firstResult, maxResults);
    }

    @Override
    public List<HistoricActivityInstanceDto> queryHistoricActivityInstances(HistoricActivityInstanceQueryDto queryDto, Integer firstResult, Integer maxResults) {
        queryDto.setObjectMapper(this.objectMapper);
        HistoricActivityInstanceQuery query = (HistoricActivityInstanceQuery)queryDto.toQuery(this.processEngine);
        List<HistoricActivityInstance> matchingHistoricActivityInstances = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        ArrayList<HistoricActivityInstanceDto> historicActivityInstanceResults = new ArrayList<HistoricActivityInstanceDto>();
        for (HistoricActivityInstance historicActivityInstance : matchingHistoricActivityInstances) {
            HistoricActivityInstanceDto resultHistoricActivityInstance = new HistoricActivityInstanceDto();
            HistoricActivityInstanceDto.fromHistoricActivityInstance(resultHistoricActivityInstance, historicActivityInstance);
            historicActivityInstanceResults.add(resultHistoricActivityInstance);
        }
        return historicActivityInstanceResults;
    }

    private List<HistoricActivityInstance> executePaginatedQuery(HistoricActivityInstanceQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    @Override
    public CountResultDto getHistoricActivityInstancesCount(UriInfo uriInfo) {
        HistoricActivityInstanceQueryDto queryDto = new HistoricActivityInstanceQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryHistoricActivityInstancesCount(queryDto);
    }

    @Override
    public CountResultDto queryHistoricActivityInstancesCount(HistoricActivityInstanceQueryDto queryDto) {
        queryDto.setObjectMapper(this.objectMapper);
        HistoricActivityInstanceQuery query = (HistoricActivityInstanceQuery)queryDto.toQuery(this.processEngine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

