/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.ConditionEvaluationBuilderImpl;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.VariablesBuilder;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.runtime.ConditionEvaluationBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public class ConditionRestServiceTest
extends AbstractRestServiceTest {
    protected static final String CONDITION_URL = "/rest-test/condition";
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    private RuntimeService runtimeServiceMock;
    private ConditionEvaluationBuilder conditionEvaluationBuilderMock;
    private List<ProcessInstance> processInstancesMock;

    @Before
    public void setupMocks() {
        this.runtimeServiceMock = (RuntimeService)Mockito.mock(RuntimeService.class);
        Mockito.when((Object)processEngine.getRuntimeService()).thenReturn((Object)this.runtimeServiceMock);
        this.conditionEvaluationBuilderMock = (ConditionEvaluationBuilder)Mockito.mock(ConditionEvaluationBuilderImpl.class);
        Mockito.when((Object)this.runtimeServiceMock.createConditionEvaluation()).thenReturn((Object)this.conditionEvaluationBuilderMock);
        Mockito.when((Object)this.conditionEvaluationBuilderMock.processDefinitionId(org.mockito.Matchers.anyString())).thenReturn((Object)this.conditionEvaluationBuilderMock);
        Mockito.when((Object)this.conditionEvaluationBuilderMock.processInstanceBusinessKey(org.mockito.Matchers.anyString())).thenReturn((Object)this.conditionEvaluationBuilderMock);
        Mockito.when((Object)this.conditionEvaluationBuilderMock.setVariables((Map)org.mockito.Matchers.any())).thenReturn((Object)this.conditionEvaluationBuilderMock);
        Mockito.when((Object)this.conditionEvaluationBuilderMock.setVariable(org.mockito.Matchers.anyString(), org.mockito.Matchers.any())).thenReturn((Object)this.conditionEvaluationBuilderMock);
        this.processInstancesMock = MockProvider.createAnotherMockProcessInstanceList();
        Mockito.when((Object)this.conditionEvaluationBuilderMock.evaluateStartConditions()).thenReturn(this.processInstancesMock);
    }

    @Test
    public void testConditionEvaluationOnlyVariables() {
        HashMap<String, Map<String, Object>> parameters = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable("foo", "bar").getVariables();
        parameters.put("variables", variables);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CONDITION_URL, new Object[0]);
        Assert.assertNotNull((Object)response);
        String content = response.asString();
        Assert.assertTrue((!content.isEmpty() ? 1 : 0) != 0);
        this.checkResult(content);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createConditionEvaluation();
        HashMap<String, String> expectedVariables = new HashMap<String, String>();
        expectedVariables.put("foo", "bar");
        ((ConditionEvaluationBuilder)Mockito.verify((Object)this.conditionEvaluationBuilderMock)).setVariables(expectedVariables);
        ((ConditionEvaluationBuilder)Mockito.verify((Object)this.conditionEvaluationBuilderMock)).evaluateStartConditions();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.conditionEvaluationBuilderMock});
    }

    @Test
    public void testConditionEvaluationWithProcessDefinition() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Map<String, Object> variables = VariablesBuilder.create().variable("foo", "bar").getVariables();
        parameters.put("variables", variables);
        parameters.put("processDefinitionId", "aProcDefId");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CONDITION_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createConditionEvaluation();
        ((ConditionEvaluationBuilder)Mockito.verify((Object)this.conditionEvaluationBuilderMock)).processDefinitionId((String)org.mockito.Matchers.eq((Object)"aProcDefId"));
        ((ConditionEvaluationBuilder)Mockito.verify((Object)this.conditionEvaluationBuilderMock)).evaluateStartConditions();
    }

    @Test
    public void testConditionEvaluationWithBusinessKey() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Map<String, Object> variables = VariablesBuilder.create().variable("foo", "bar").getVariables();
        parameters.put("variables", variables);
        parameters.put("businessKey", "aKey");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CONDITION_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createConditionEvaluation();
        ((ConditionEvaluationBuilder)Mockito.verify((Object)this.conditionEvaluationBuilderMock)).processInstanceBusinessKey((String)org.mockito.Matchers.eq((Object)"aKey"));
    }

    @Test
    public void testConditionEvaluationWithTenantId() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Map<String, Object> variables = VariablesBuilder.create().variable("foo", "bar").getVariables();
        parameters.put("variables", variables);
        parameters.put("tenantId", "aTenantId");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CONDITION_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createConditionEvaluation();
        ((ConditionEvaluationBuilder)Mockito.verify((Object)this.conditionEvaluationBuilderMock)).tenantId("aTenantId");
        ((ConditionEvaluationBuilder)Mockito.verify((Object)this.conditionEvaluationBuilderMock)).evaluateStartConditions();
    }

    @Test
    public void testConditionEvaluationWithoutTenantId() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Map<String, Object> variables = VariablesBuilder.create().variable("foo", "bar").getVariables();
        parameters.put("variables", variables);
        parameters.put("withoutTenantId", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CONDITION_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createConditionEvaluation();
        ((ConditionEvaluationBuilder)Mockito.verify((Object)this.conditionEvaluationBuilderMock)).withoutTenantId();
        ((ConditionEvaluationBuilder)Mockito.verify((Object)this.conditionEvaluationBuilderMock)).evaluateStartConditions();
    }

    @Test
    public void testConditionEvaluationFailingInvalidTenantParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Map<String, Object> variables = VariablesBuilder.create().variable("foo", "bar").getVariables();
        parameters.put("variables", variables);
        parameters.put("tenantId", "aTenantId");
        parameters.put("withoutTenantId", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Parameter 'tenantId' cannot be used together with parameter 'withoutTenantId'."), new Object[0]).when().post(CONDITION_URL, new Object[0]);
    }

    @Test
    public void testConditionEvaluationThrowsAuthorizationException() {
        HashMap<String, Map<String, Object>> parameters = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable("foo", "bar").getVariables();
        parameters.put("variables", variables);
        String message = "expected exception";
        ((ConditionEvaluationBuilder)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.conditionEvaluationBuilderMock)).evaluateStartConditions();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(CONDITION_URL, new Object[0]);
    }

    protected void checkResult(String content) {
        Assert.assertEquals((Object)"aProcInstId", (Object)JsonPath.from((String)content).get("[0].id"));
        Assert.assertEquals((Object)"aProcDefId", (Object)JsonPath.from((String)content).get("[0].definitionId"));
        Assert.assertEquals((Object)"anotherId", (Object)JsonPath.from((String)content).get("[1].id"));
        Assert.assertEquals((Object)"aProcDefId", (Object)JsonPath.from((String)content).get("[1].definitionId"));
    }
}

