/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import java.util.Date;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.management.MetricsQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.DateTimeUtils;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MetricsRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    public static final String METRICS_URL = "/rest-test/metrics";
    public static final String SINGLE_METER_URL = "/rest-test/metrics/{name}";
    public static final String SUM_URL = "/rest-test/metrics/{name}/sum";
    protected ManagementService managementServiceMock;
    private MetricsQuery meterQueryMock;

    @Before
    public void setUpRuntimeData() {
        this.managementServiceMock = (ManagementService)Mockito.mock(ManagementService.class);
        Mockito.when((Object)processEngine.getManagementService()).thenReturn((Object)this.managementServiceMock);
        this.meterQueryMock = MockProvider.createMockMeterQuery();
        Mockito.when((Object)this.managementServiceMock.createMetricsQuery()).thenReturn((Object)this.meterQueryMock);
    }

    @Test
    public void testGetInterval() {
        Mockito.when((Object)this.meterQueryMock.interval()).thenReturn(MockProvider.createMockMetricIntervalResult());
        RestAssured.given().then().expect().body("[0].name", org.hamcrest.Matchers.equalTo((Object)"metricName"), new Object[0]).body("[0].timestamp", org.hamcrest.Matchers.equalTo((Object)DateTimeUtils.withTimezone(new Date(2700000L))), new Object[0]).body("[0].reporter", org.hamcrest.Matchers.equalTo((Object)"REPORTER"), new Object[0]).body("[0].value", org.hamcrest.Matchers.equalTo((Object)23), new Object[0]).body("[1].name", org.hamcrest.Matchers.equalTo((Object)"metricName"), new Object[0]).body("[1].timestamp", org.hamcrest.Matchers.equalTo((Object)DateTimeUtils.withTimezone(new Date(1800000L))), new Object[0]).body("[1].reporter", org.hamcrest.Matchers.equalTo((Object)"REPORTER"), new Object[0]).body("[1].value", org.hamcrest.Matchers.equalTo((Object)22), new Object[0]).body("[2].name", org.hamcrest.Matchers.equalTo((Object)"metricName"), new Object[0]).body("[2].timestamp", org.hamcrest.Matchers.equalTo((Object)DateTimeUtils.withTimezone(new Date(900000L))), new Object[0]).body("[2].reporter", org.hamcrest.Matchers.equalTo((Object)"REPORTER"), new Object[0]).body("[2].value", org.hamcrest.Matchers.equalTo((Object)21), new Object[0]).statusCode(Response.Status.OK.getStatusCode()).when().get(METRICS_URL, new Object[0]);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).name(null);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).reporter(null);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock, (VerificationMode)Mockito.times((int)1))).interval();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.meterQueryMock});
    }

    @Test
    public void testGetIntervalByName() {
        RestAssured.given().queryParam("name", new Object[]{"metricName"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(METRICS_URL, new Object[0]);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).name("metricName");
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).reporter(null);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock, (VerificationMode)Mockito.times((int)1))).interval();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.meterQueryMock});
    }

    @Test
    public void testGetIntervalByReporter() {
        RestAssured.given().queryParam("reporter", new Object[]{"REPORTER"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(METRICS_URL, new Object[0]);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).name(null);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).reporter("REPORTER");
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock, (VerificationMode)Mockito.times((int)1))).interval();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.meterQueryMock});
    }

    @Test
    public void testGetIntervalWithOffset() {
        RestAssured.given().queryParam("firstResult", new Object[]{10}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(METRICS_URL, new Object[0]);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).name(null);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).reporter(null);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).offset(10);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock, (VerificationMode)Mockito.times((int)1))).interval();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.meterQueryMock});
    }

    @Test
    public void testGetIntervalWithLimit() {
        RestAssured.given().queryParam("maxResults", new Object[]{10}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(METRICS_URL, new Object[0]);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).name(null);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).reporter(null);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).limit(10);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock, (VerificationMode)Mockito.times((int)1))).interval();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.meterQueryMock});
    }

    @Test
    public void testGetIntervalAggregation() {
        RestAssured.given().queryParam("aggregateByReporter", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(METRICS_URL, new Object[0]);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).name(null);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).reporter(null);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).aggregateByReporter();
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock, (VerificationMode)Mockito.times((int)1))).interval();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.meterQueryMock});
    }

    @Test
    public void testGetIntervalWithStartDate() {
        RestAssured.given().queryParam("startDate", new Object[]{DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.format(new Date(0L))}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(METRICS_URL, new Object[0]);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).name(null);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).reporter(null);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).startDate(new Date(0L));
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock, (VerificationMode)Mockito.times((int)1))).interval();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.meterQueryMock});
    }

    @Test
    public void testGetIntervalWithEndDate() {
        RestAssured.given().queryParam("endDate", new Object[]{DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.format(new Date(900000L))}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(METRICS_URL, new Object[0]);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).name(null);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).reporter(null);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).endDate(new Date(900000L));
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock, (VerificationMode)Mockito.times((int)1))).interval();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.meterQueryMock});
    }

    @Test
    public void testGetIntervalWithCustomInterval() {
        RestAssured.given().queryParam("interval", new Object[]{300}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(METRICS_URL, new Object[0]);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).name(null);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).reporter(null);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock, (VerificationMode)Mockito.times((int)1))).interval(300L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.meterQueryMock});
    }

    @Test
    public void testGetIntervalWithAll() {
        RestAssured.given().queryParam("name", new Object[]{"metricName"}).queryParam("reporter", new Object[]{"REPORTER"}).queryParam("maxResults", new Object[]{10}).queryParam("firstResult", new Object[]{10}).queryParam("startDate", new Object[]{DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.format(new Date(0L))}).queryParam("endDate", new Object[]{DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.format(new Date(900000L))}).queryParam("aggregateByReporter", new Object[]{true}).queryParam("interval", new Object[]{300}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(METRICS_URL, new Object[0]);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).name("metricName");
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).reporter("REPORTER");
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).offset(10);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).limit(10);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).startDate(new Date(0L));
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).endDate(new Date(900000L));
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).aggregateByReporter();
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock, (VerificationMode)Mockito.times((int)1))).interval(300L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.meterQueryMock});
    }

    @Test
    public void testGetSum() {
        Mockito.when((Object)this.meterQueryMock.sum()).thenReturn((Object)10L);
        RestAssured.given().pathParam("name", (Object)"activity-instance-start").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("result", org.hamcrest.Matchers.equalTo((Object)10), new Object[0]).when().get(SUM_URL, new Object[0]);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).name("activity-instance-start");
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock, (VerificationMode)Mockito.times((int)1))).sum();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.meterQueryMock});
    }

    @Test
    public void testGetSumWithTimestamps() {
        Mockito.when((Object)this.meterQueryMock.sum()).thenReturn((Object)10L);
        RestAssured.given().pathParam("name", (Object)"activity-instance-start").queryParam("startDate", new Object[]{MockProvider.EXAMPLE_METRICS_START_DATE}).queryParam("endDate", new Object[]{MockProvider.EXAMPLE_METRICS_END_DATE}).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("result", org.hamcrest.Matchers.equalTo((Object)10), new Object[0]).when().get(SUM_URL, new Object[0]);
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).name("activity-instance-start");
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).startDate((Date)Matchers.any(Date.class));
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock)).endDate((Date)Matchers.any(Date.class));
        ((MetricsQuery)Mockito.verify((Object)this.meterQueryMock, (VerificationMode)Mockito.times((int)1))).sum();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.meterQueryMock});
    }

    @Test
    public void testGetSumWithInvalidTimestamp() {
        Mockito.when((Object)this.meterQueryMock.sum()).thenReturn((Object)10L);
        RestAssured.given().pathParam("name", (Object)"activity-instance-start").queryParam("startDate", new Object[]{"INVALID-TIME-STAMP"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(SUM_URL, new Object[0]);
    }
}

