/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.history.HistoricDetailQuery;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.helper.MockHistoricVariableUpdateBuilder;
import org.camunda.bpm.engine.rest.helper.MockObjectValue;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.helper.VariableTypeHelper;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.FileValue;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class HistoricDetailRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORIC_DETAIL_RESOURCE_URL = "/rest-test/history/detail";
    protected static final String HISTORIC_DETAIL_URL = "/rest-test/history/detail/{id}";
    protected static final String VARIABLE_INSTANCE_BINARY_DATA_URL = "/rest-test/history/detail/{id}/data";
    protected HistoryService historyServiceMock;
    protected HistoricDetailQuery historicDetailQueryMock;

    @Before
    public void setupTestData() {
        this.historyServiceMock = (HistoryService)Mockito.mock(HistoryService.class);
        this.historicDetailQueryMock = (HistoricDetailQuery)Mockito.mock(HistoricDetailQuery.class);
        Mockito.when((Object)processEngine.getHistoryService()).thenReturn((Object)this.historyServiceMock);
        Mockito.when((Object)this.historyServiceMock.createHistoricDetailQuery()).thenReturn((Object)this.historicDetailQueryMock);
    }

    @Test
    public void testGetSingleDetail() {
        MockHistoricVariableUpdateBuilder builder = MockProvider.mockHistoricVariableUpdate();
        HistoricVariableUpdate detailMock = builder.build();
        Mockito.when((Object)this.historicDetailQueryMock.detailId(detailMock.getId())).thenReturn((Object)this.historicDetailQueryMock);
        Mockito.when((Object)this.historicDetailQueryMock.disableBinaryFetching()).thenReturn((Object)this.historicDetailQueryMock);
        Mockito.when((Object)this.historicDetailQueryMock.disableCustomObjectDeserialization()).thenReturn((Object)this.historicDetailQueryMock);
        Mockito.when((Object)this.historicDetailQueryMock.singleResult()).thenReturn((Object)detailMock);
        RestAssured.given().pathParam("id", (Object)"aHistoricVariableUpdateId").then().expect().statusCode(Response.Status.OK.getStatusCode()).and().body("id", CoreMatchers.equalTo((Object)builder.getId()), new Object[0]).body("variableName", CoreMatchers.equalTo((Object)builder.getName()), new Object[0]).body("variableInstanceId", CoreMatchers.equalTo((Object)builder.getVariableInstanceId()), new Object[0]).body("variableType", CoreMatchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName(builder.getTypedValue().getType())), new Object[0]).body("value", CoreMatchers.equalTo((Object)builder.getValue()), new Object[0]).body("processDefinitionKey", CoreMatchers.equalTo((Object)builder.getProcessDefinitionKey()), new Object[0]).body("processDefinitionId", CoreMatchers.equalTo((Object)builder.getProcessDefinitionId()), new Object[0]).body("processInstanceId", CoreMatchers.equalTo((Object)builder.getProcessInstanceId()), new Object[0]).body("errorMessage", CoreMatchers.equalTo((Object)builder.getErrorMessage()), new Object[0]).body("activityInstanceId", CoreMatchers.equalTo((Object)builder.getActivityInstanceId()), new Object[0]).body("revision", CoreMatchers.equalTo((Object)builder.getRevision()), new Object[0]).body("time", CoreMatchers.equalTo((Object)builder.getTime()), new Object[0]).body("taskId", CoreMatchers.equalTo((Object)builder.getTaskId()), new Object[0]).body("executionId", CoreMatchers.equalTo((Object)builder.getExecutionId()), new Object[0]).body("caseDefinitionKey", CoreMatchers.equalTo((Object)builder.getCaseDefinitionKey()), new Object[0]).body("caseDefinitionId", CoreMatchers.equalTo((Object)builder.getCaseDefinitionId()), new Object[0]).body("caseInstanceId", CoreMatchers.equalTo((Object)builder.getCaseInstanceId()), new Object[0]).body("caseExecutionId", CoreMatchers.equalTo((Object)builder.getCaseExecutionId()), new Object[0]).body("tenantId", CoreMatchers.equalTo((Object)builder.getTenantId()), new Object[0]).when().get(HISTORIC_DETAIL_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.historicDetailQueryMock, (VerificationMode)Mockito.times((int)1))).disableBinaryFetching();
    }

    @Test
    public void testGetSingleVariableUpdateDeserialized() {
        MockObjectValue serializedValue = MockObjectValue.fromObjectValue((ObjectValue)Variables.objectValue((Object)"a value").serializationDataFormat("aDataFormat").create()).objectTypeName("aTypeName");
        MockHistoricVariableUpdateBuilder builder = MockProvider.mockHistoricVariableUpdate().typedValue((TypedValue)serializedValue);
        HistoricVariableUpdate variableInstanceMock = builder.build();
        Mockito.when((Object)this.historicDetailQueryMock.detailId(variableInstanceMock.getId())).thenReturn((Object)this.historicDetailQueryMock);
        Mockito.when((Object)this.historicDetailQueryMock.disableBinaryFetching()).thenReturn((Object)this.historicDetailQueryMock);
        Mockito.when((Object)this.historicDetailQueryMock.singleResult()).thenReturn((Object)variableInstanceMock);
        RestAssured.given().pathParam("id", (Object)builder.getId()).then().expect().statusCode(Response.Status.OK.getStatusCode()).and().body("id", CoreMatchers.equalTo((Object)builder.getId()), new Object[0]).body("variableName", CoreMatchers.equalTo((Object)builder.getName()), new Object[0]).body("variableInstanceId", CoreMatchers.equalTo((Object)builder.getVariableInstanceId()), new Object[0]).body("variableType", CoreMatchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName(builder.getTypedValue().getType())), new Object[0]).body("value", CoreMatchers.equalTo((Object)"a value"), new Object[0]).body("valueInfo.serializationDataFormat", CoreMatchers.equalTo((Object)"aDataFormat"), new Object[0]).body("valueInfo.objectTypeName", CoreMatchers.equalTo((Object)"aTypeName"), new Object[0]).body("initial", CoreMatchers.equalTo((Object)false), new Object[0]).body("processDefinitionKey", CoreMatchers.equalTo((Object)builder.getProcessDefinitionKey()), new Object[0]).body("processDefinitionId", CoreMatchers.equalTo((Object)builder.getProcessDefinitionId()), new Object[0]).body("processInstanceId", CoreMatchers.equalTo((Object)builder.getProcessInstanceId()), new Object[0]).body("errorMessage", CoreMatchers.equalTo((Object)builder.getErrorMessage()), new Object[0]).body("activityInstanceId", CoreMatchers.equalTo((Object)builder.getActivityInstanceId()), new Object[0]).body("revision", CoreMatchers.equalTo((Object)builder.getRevision()), new Object[0]).body("time", CoreMatchers.equalTo((Object)builder.getTime()), new Object[0]).body("taskId", CoreMatchers.equalTo((Object)builder.getTaskId()), new Object[0]).body("executionId", CoreMatchers.equalTo((Object)builder.getExecutionId()), new Object[0]).body("caseDefinitionKey", CoreMatchers.equalTo((Object)builder.getCaseDefinitionKey()), new Object[0]).body("caseDefinitionId", CoreMatchers.equalTo((Object)builder.getCaseDefinitionId()), new Object[0]).body("caseInstanceId", CoreMatchers.equalTo((Object)builder.getCaseInstanceId()), new Object[0]).body("caseExecutionId", CoreMatchers.equalTo((Object)builder.getCaseExecutionId()), new Object[0]).body("tenantId", CoreMatchers.equalTo((Object)builder.getTenantId()), new Object[0]).when().get(HISTORIC_DETAIL_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.historicDetailQueryMock, (VerificationMode)Mockito.times((int)1))).disableBinaryFetching();
        ((HistoricDetailQuery)Mockito.verify((Object)this.historicDetailQueryMock, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testGetSingleVariableUpdateSerialized() {
        ObjectValue serializedValue = (ObjectValue)Variables.serializedObjectValue((String)"a serialized value").serializationDataFormat("aDataFormat").objectTypeName("aTypeName").create();
        MockHistoricVariableUpdateBuilder builder = MockProvider.mockHistoricVariableUpdate().typedValue((TypedValue)serializedValue);
        HistoricVariableUpdate variableInstanceMock = builder.build();
        Mockito.when((Object)this.historicDetailQueryMock.detailId(variableInstanceMock.getId())).thenReturn((Object)this.historicDetailQueryMock);
        Mockito.when((Object)this.historicDetailQueryMock.disableBinaryFetching()).thenReturn((Object)this.historicDetailQueryMock);
        Mockito.when((Object)this.historicDetailQueryMock.disableCustomObjectDeserialization()).thenReturn((Object)this.historicDetailQueryMock);
        Mockito.when((Object)this.historicDetailQueryMock.singleResult()).thenReturn((Object)variableInstanceMock);
        RestAssured.given().pathParam("id", (Object)builder.getId()).queryParam("deserializeValue", new Object[]{false}).then().expect().statusCode(Response.Status.OK.getStatusCode()).and().body("id", CoreMatchers.equalTo((Object)builder.getId()), new Object[0]).body("variableName", CoreMatchers.equalTo((Object)builder.getName()), new Object[0]).body("variableInstanceId", CoreMatchers.equalTo((Object)builder.getVariableInstanceId()), new Object[0]).body("variableType", CoreMatchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName(builder.getTypedValue().getType())), new Object[0]).body("value", CoreMatchers.equalTo((Object)"a serialized value"), new Object[0]).body("valueInfo.serializationDataFormat", CoreMatchers.equalTo((Object)"aDataFormat"), new Object[0]).body("valueInfo.objectTypeName", CoreMatchers.equalTo((Object)"aTypeName"), new Object[0]).body("initial", CoreMatchers.equalTo((Object)false), new Object[0]).body("processDefinitionKey", CoreMatchers.equalTo((Object)builder.getProcessDefinitionKey()), new Object[0]).body("processDefinitionId", CoreMatchers.equalTo((Object)builder.getProcessDefinitionId()), new Object[0]).body("processInstanceId", CoreMatchers.equalTo((Object)builder.getProcessInstanceId()), new Object[0]).body("errorMessage", CoreMatchers.equalTo((Object)builder.getErrorMessage()), new Object[0]).body("activityInstanceId", CoreMatchers.equalTo((Object)builder.getActivityInstanceId()), new Object[0]).body("revision", CoreMatchers.equalTo((Object)builder.getRevision()), new Object[0]).body("time", CoreMatchers.equalTo((Object)builder.getTime()), new Object[0]).body("taskId", CoreMatchers.equalTo((Object)builder.getTaskId()), new Object[0]).body("executionId", CoreMatchers.equalTo((Object)builder.getExecutionId()), new Object[0]).body("caseDefinitionKey", CoreMatchers.equalTo((Object)builder.getCaseDefinitionKey()), new Object[0]).body("caseDefinitionId", CoreMatchers.equalTo((Object)builder.getCaseDefinitionId()), new Object[0]).body("caseInstanceId", CoreMatchers.equalTo((Object)builder.getCaseInstanceId()), new Object[0]).body("caseExecutionId", CoreMatchers.equalTo((Object)builder.getCaseExecutionId()), new Object[0]).body("tenantId", CoreMatchers.equalTo((Object)builder.getTenantId()), new Object[0]).when().get(HISTORIC_DETAIL_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.historicDetailQueryMock, (VerificationMode)Mockito.times((int)1))).disableBinaryFetching();
        ((HistoricDetailQuery)Mockito.verify((Object)this.historicDetailQueryMock, (VerificationMode)Mockito.times((int)1))).disableCustomObjectDeserialization();
    }

    @Test
    public void testGetSingleVariableInstanceForBinaryVariable() {
        MockHistoricVariableUpdateBuilder builder = MockProvider.mockHistoricVariableUpdate();
        HistoricVariableUpdate detailMock = builder.typedValue((TypedValue)Variables.byteArrayValue(null)).build();
        Mockito.when((Object)this.historicDetailQueryMock.detailId(detailMock.getId())).thenReturn((Object)this.historicDetailQueryMock);
        Mockito.when((Object)this.historicDetailQueryMock.disableBinaryFetching()).thenReturn((Object)this.historicDetailQueryMock);
        Mockito.when((Object)this.historicDetailQueryMock.disableCustomObjectDeserialization()).thenReturn((Object)this.historicDetailQueryMock);
        Mockito.when((Object)this.historicDetailQueryMock.singleResult()).thenReturn((Object)detailMock);
        RestAssured.given().pathParam("id", (Object)"aHistoricVariableUpdateId").then().expect().statusCode(Response.Status.OK.getStatusCode()).and().body("id", CoreMatchers.equalTo((Object)builder.getId()), new Object[0]).body("variableName", CoreMatchers.equalTo((Object)builder.getName()), new Object[0]).body("variableInstanceId", CoreMatchers.equalTo((Object)builder.getVariableInstanceId()), new Object[0]).body("variableType", CoreMatchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName(builder.getTypedValue().getType())), new Object[0]).body("value", CoreMatchers.equalTo((Object)builder.getValue()), new Object[0]).body("processDefinitionKey", CoreMatchers.equalTo((Object)builder.getProcessDefinitionKey()), new Object[0]).body("processDefinitionId", CoreMatchers.equalTo((Object)builder.getProcessDefinitionId()), new Object[0]).body("processInstanceId", CoreMatchers.equalTo((Object)builder.getProcessInstanceId()), new Object[0]).body("errorMessage", CoreMatchers.equalTo((Object)builder.getErrorMessage()), new Object[0]).body("activityInstanceId", CoreMatchers.equalTo((Object)builder.getActivityInstanceId()), new Object[0]).body("revision", CoreMatchers.equalTo((Object)builder.getRevision()), new Object[0]).body("time", CoreMatchers.equalTo((Object)builder.getTime()), new Object[0]).body("taskId", CoreMatchers.equalTo((Object)builder.getTaskId()), new Object[0]).body("executionId", CoreMatchers.equalTo((Object)builder.getExecutionId()), new Object[0]).body("caseDefinitionKey", CoreMatchers.equalTo((Object)builder.getCaseDefinitionKey()), new Object[0]).body("caseDefinitionId", CoreMatchers.equalTo((Object)builder.getCaseDefinitionId()), new Object[0]).body("caseInstanceId", CoreMatchers.equalTo((Object)builder.getCaseInstanceId()), new Object[0]).body("caseExecutionId", CoreMatchers.equalTo((Object)builder.getCaseExecutionId()), new Object[0]).body("tenantId", CoreMatchers.equalTo((Object)builder.getTenantId()), new Object[0]).when().get(HISTORIC_DETAIL_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.historicDetailQueryMock, (VerificationMode)Mockito.times((int)1))).disableBinaryFetching();
    }

    @Test
    public void testGetNonExistingVariableInstance() {
        String nonExistingId = "nonExistingId";
        Mockito.when((Object)this.historicDetailQueryMock.detailId(nonExistingId)).thenReturn((Object)this.historicDetailQueryMock);
        Mockito.when((Object)this.historicDetailQueryMock.disableBinaryFetching()).thenReturn((Object)this.historicDetailQueryMock);
        Mockito.when((Object)this.historicDetailQueryMock.disableCustomObjectDeserialization()).thenReturn((Object)this.historicDetailQueryMock);
        Mockito.when((Object)this.historicDetailQueryMock.singleResult()).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)nonExistingId).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(CoreMatchers.containsString((String)"Historic detail with Id 'nonExistingId' does not exist."), new Matcher[0]).when().get(HISTORIC_DETAIL_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.historicDetailQueryMock, (VerificationMode)Mockito.times((int)1))).disableBinaryFetching();
    }

    @Test
    public void testBinaryDataForBinaryVariable() {
        byte[] byteContent = "some bytes".getBytes();
        MockHistoricVariableUpdateBuilder builder = MockProvider.mockHistoricVariableUpdate();
        HistoricVariableUpdate detailMock = builder.typedValue((TypedValue)Variables.byteArrayValue((byte[])byteContent)).build();
        Mockito.when((Object)this.historicDetailQueryMock.detailId(detailMock.getId())).thenReturn((Object)this.historicDetailQueryMock);
        Mockito.when((Object)this.historicDetailQueryMock.disableCustomObjectDeserialization()).thenReturn((Object)this.historicDetailQueryMock);
        Mockito.when((Object)this.historicDetailQueryMock.singleResult()).thenReturn((Object)detailMock);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aHistoricVariableUpdateId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.BINARY.toString()).when().get(VARIABLE_INSTANCE_BINARY_DATA_URL, new Object[0]);
        byte[] responseBytes = response.getBody().asByteArray();
        Assert.assertEquals((Object)new String(byteContent), (Object)new String(responseBytes));
        ((HistoricDetailQuery)Mockito.verify((Object)this.historicDetailQueryMock, (VerificationMode)Mockito.never())).disableBinaryFetching();
    }

    @Test
    public void testBinaryDataForFileVariable() {
        String filename = "test.txt";
        byte[] byteContent = "test".getBytes();
        String encoding = "UTF-8";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).file(byteContent).mimeType(ContentType.TEXT.toString()).encoding(encoding).create();
        MockHistoricVariableUpdateBuilder builder = MockProvider.mockHistoricVariableUpdate();
        HistoricVariableUpdate detailMock = builder.typedValue((TypedValue)variableValue).build();
        Mockito.when((Object)this.historicDetailQueryMock.detailId(detailMock.getId())).thenReturn((Object)this.historicDetailQueryMock);
        Mockito.when((Object)this.historicDetailQueryMock.disableCustomObjectDeserialization()).thenReturn((Object)this.historicDetailQueryMock);
        Mockito.when((Object)this.historicDetailQueryMock.singleResult()).thenReturn((Object)detailMock);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aHistoricVariableUpdateId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body(Matchers.is((Matcher)CoreMatchers.equalTo((Object)new String(byteContent))), new Matcher[0]).and().header("Content-Disposition", "attachment; filename=" + filename).when().get(VARIABLE_INSTANCE_BINARY_DATA_URL, new Object[0]);
        String contentType = response.getContentType();
        Assert.assertThat((Object)contentType, (Matcher)Matchers.is((Matcher)CoreMatchers.either((Matcher)CoreMatchers.equalTo((Object)(ContentType.TEXT.toString() + "; charset=UTF-8"))).or(CoreMatchers.equalTo((Object)(ContentType.TEXT.toString() + ";charset=UTF-8")))));
        ((HistoricDetailQuery)Mockito.verify((Object)this.historicDetailQueryMock, (VerificationMode)Mockito.never())).disableBinaryFetching();
    }

    @Test
    public void testBinaryDataForNonBinaryVariable() {
        HistoricVariableUpdate detailMock = MockProvider.createMockHistoricVariableUpdate();
        Mockito.when((Object)this.historicDetailQueryMock.detailId(detailMock.getId())).thenReturn((Object)this.historicDetailQueryMock);
        Mockito.when((Object)this.historicDetailQueryMock.disableCustomObjectDeserialization()).thenReturn((Object)this.historicDetailQueryMock);
        Mockito.when((Object)this.historicDetailQueryMock.singleResult()).thenReturn((Object)detailMock);
        RestAssured.given().pathParam("id", (Object)"aHistoricVariableUpdateId").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body(CoreMatchers.containsString((String)"Value of variable with id aHistoricVariableUpdateId is not a binary value"), new Matcher[0]).when().get(VARIABLE_INSTANCE_BINARY_DATA_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.historicDetailQueryMock, (VerificationMode)Mockito.never())).disableBinaryFetching();
    }

    @Test
    public void testGetBinaryDataForNonExistingVariableInstance() {
        String nonExistingId = "nonExistingId";
        Mockito.when((Object)this.historicDetailQueryMock.detailId(nonExistingId)).thenReturn((Object)this.historicDetailQueryMock);
        Mockito.when((Object)this.historicDetailQueryMock.disableCustomObjectDeserialization()).thenReturn((Object)this.historicDetailQueryMock);
        Mockito.when((Object)this.historicDetailQueryMock.singleResult()).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)nonExistingId).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(CoreMatchers.containsString((String)("Historic detail with Id '" + nonExistingId + "' does not exist")), new Matcher[0]).when().get(VARIABLE_INSTANCE_BINARY_DATA_URL, new Object[0]);
        ((HistoricDetailQuery)Mockito.verify((Object)this.historicDetailQueryMock, (VerificationMode)Mockito.never())).disableBinaryFetching();
    }

    @Test
    public void testGetBinaryDataForNullFileVariable() {
        String filename = "test.txt";
        byte[] byteContent = null;
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).file(byteContent).mimeType(ContentType.TEXT.toString()).create();
        MockHistoricVariableUpdateBuilder builder = MockProvider.mockHistoricVariableUpdate();
        HistoricVariableUpdate detailMock = builder.typedValue((TypedValue)variableValue).build();
        Mockito.when((Object)this.historicDetailQueryMock.detailId(detailMock.getId())).thenReturn((Object)this.historicDetailQueryMock);
        Mockito.when((Object)this.historicDetailQueryMock.disableCustomObjectDeserialization()).thenReturn((Object)this.historicDetailQueryMock);
        Mockito.when((Object)this.historicDetailQueryMock.singleResult()).thenReturn((Object)detailMock);
        RestAssured.given().pathParam("id", (Object)"aHistoricVariableUpdateId").then().expect().statusCode(Response.Status.OK.getStatusCode()).and().contentType(ContentType.TEXT).and().body(Matchers.is((Matcher)CoreMatchers.equalTo((Object)new String())), new Matcher[0]).when().get(VARIABLE_INSTANCE_BINARY_DATA_URL, new Object[0]);
    }
}

