/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.history.DurationReportResult;
import org.camunda.bpm.engine.history.HistoricProcessInstanceReport;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.query.PeriodUnit;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.converter.ReportResultToCsvConverter;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public class HistoricProcessInstanceRestServiceReportTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORIC_PROCESS_INSTANCE_REPORT_URL = "/rest-test/history/process-instance/report";
    protected HistoricProcessInstanceReport mockedReportQuery;

    @Before
    public void setUpRuntimeData() {
        this.mockedReportQuery = this.setUpMockHistoricProcessInstanceReportQuery();
    }

    private HistoricProcessInstanceReport setUpMockHistoricProcessInstanceReportQuery() {
        HistoricProcessInstanceReport mockedReportQuery = (HistoricProcessInstanceReport)Mockito.mock(HistoricProcessInstanceReport.class);
        Mockito.when((Object)mockedReportQuery.processDefinitionIdIn(new String[]{org.mockito.Matchers.anyString()})).thenReturn((Object)mockedReportQuery);
        Mockito.when((Object)mockedReportQuery.processDefinitionKeyIn(new String[]{org.mockito.Matchers.anyString()})).thenReturn((Object)mockedReportQuery);
        Mockito.when((Object)mockedReportQuery.startedAfter((Date)org.mockito.Matchers.any(Date.class))).thenReturn((Object)mockedReportQuery);
        Mockito.when((Object)mockedReportQuery.startedBefore((Date)org.mockito.Matchers.any(Date.class))).thenReturn((Object)mockedReportQuery);
        List<DurationReportResult> durationReportByMonth = MockProvider.createMockHistoricProcessInstanceDurationReportByMonth();
        Mockito.when((Object)mockedReportQuery.duration(PeriodUnit.MONTH)).thenReturn(durationReportByMonth);
        List<DurationReportResult> durationReportByQuarter = MockProvider.createMockHistoricProcessInstanceDurationReportByQuarter();
        Mockito.when((Object)mockedReportQuery.duration(PeriodUnit.QUARTER)).thenReturn(durationReportByQuarter);
        Mockito.when((Object)mockedReportQuery.duration(null)).thenThrow(new Throwable[]{new NotValidException("periodUnit is null")});
        Mockito.when((Object)processEngine.getHistoryService().createHistoricProcessInstanceReport()).thenReturn((Object)mockedReportQuery);
        return mockedReportQuery;
    }

    @Test
    public void testEmptyReportByMonth() {
        RestAssured.given().queryParam("reportType", new Object[]{"duration"}).queryParam("periodUnit", new Object[]{"month"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_PROCESS_INSTANCE_REPORT_URL, new Object[0]);
        ((HistoricProcessInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).duration(PeriodUnit.MONTH);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedReportQuery});
    }

    @Test
    public void testEmptyReportByQuarter() {
        RestAssured.given().queryParam("reportType", new Object[]{"duration"}).queryParam("periodUnit", new Object[]{"quarter"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_PROCESS_INSTANCE_REPORT_URL, new Object[0]);
        ((HistoricProcessInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).duration(PeriodUnit.QUARTER);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedReportQuery});
    }

    @Test
    public void testInvalidReportType() {
        RestAssured.given().queryParam("reportType", new Object[]{"abc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Cannot set query parameter 'reportType' to value 'abc'"), new Object[0]).when().get(HISTORIC_PROCESS_INSTANCE_REPORT_URL, new Object[0]);
    }

    @Test
    public void testInvalidPeriodUnit() {
        RestAssured.given().queryParam("periodUnit", new Object[]{"abc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Cannot set query parameter 'periodUnit' to value 'abc'"), new Object[0]).when().get(HISTORIC_PROCESS_INSTANCE_REPORT_URL, new Object[0]);
    }

    @Test
    public void testMissingReportType() {
        RestAssured.given().then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Unknown report type null"), new Object[0]).when().get(HISTORIC_PROCESS_INSTANCE_REPORT_URL, new Object[0]);
    }

    @Test
    public void testMissingPeriodUnit() {
        RestAssured.given().queryParam("reportType", new Object[]{"duration"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"periodUnit is null"), new Object[0]).when().get(HISTORIC_PROCESS_INSTANCE_REPORT_URL, new Object[0]);
    }

    @Test
    public void testMissingAuthorization() {
        String message = "not authorized";
        Mockito.when((Object)this.mockedReportQuery.duration(PeriodUnit.MONTH)).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().queryParam("reportType", new Object[]{"duration"}).queryParam("periodUnit", new Object[]{"month"}).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)message), new Object[0]).when().get(HISTORIC_PROCESS_INSTANCE_REPORT_URL, new Object[0]);
    }

    @Test
    public void testDurationReportByMonth() {
        Response response = (Response)RestAssured.given().queryParam("periodUnit", new Object[]{"month"}).queryParam("reportType", new Object[]{"duration"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_PROCESS_INSTANCE_REPORT_URL, new Object[0]);
        String content = response.asString();
        List reports = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one report returned.", (long)1L, (long)reports.size());
        Assert.assertNotNull((String)"The returned report should not be null.", reports.get(0));
        long returnedAvg = JsonPath.from((String)content).getLong("[0].average");
        long returnedMax = JsonPath.from((String)content).getLong("[0].maximum");
        long returnedMin = JsonPath.from((String)content).getLong("[0].minimum");
        int returnedPeriod = JsonPath.from((String)content).getInt("[0].period");
        String returnedPeriodUnit = JsonPath.from((String)content).getString("[0].periodUnit");
        Assert.assertEquals((long)10L, (long)returnedAvg);
        Assert.assertEquals((long)15L, (long)returnedMax);
        Assert.assertEquals((long)5L, (long)returnedMin);
        Assert.assertEquals((long)1L, (long)returnedPeriod);
        Assert.assertEquals((Object)PeriodUnit.MONTH.toString(), (Object)returnedPeriodUnit);
    }

    @Test
    public void testDurationReportByQuarter() {
        Response response = (Response)RestAssured.given().queryParam("periodUnit", new Object[]{"quarter"}).queryParam("reportType", new Object[]{"duration"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_PROCESS_INSTANCE_REPORT_URL, new Object[0]);
        String content = response.asString();
        List reports = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one report returned.", (long)1L, (long)reports.size());
        Assert.assertNotNull((String)"The returned report should not be null.", reports.get(0));
        long returnedAvg = JsonPath.from((String)content).getLong("[0].average");
        long returnedMax = JsonPath.from((String)content).getLong("[0].maximum");
        long returnedMin = JsonPath.from((String)content).getLong("[0].minimum");
        int returnedPeriod = JsonPath.from((String)content).getInt("[0].period");
        String returnedPeriodUnit = JsonPath.from((String)content).getString("[0].periodUnit");
        Assert.assertEquals((long)10L, (long)returnedAvg);
        Assert.assertEquals((long)15L, (long)returnedMax);
        Assert.assertEquals((long)5L, (long)returnedMin);
        Assert.assertEquals((long)1L, (long)returnedPeriod);
        Assert.assertEquals((Object)PeriodUnit.QUARTER.toString(), (Object)returnedPeriodUnit);
    }

    @Test
    public void testListParameters() {
        String aProcDefId = "anProcDefId";
        String anotherProcDefId = "anotherProcDefId";
        String aProcDefKey = "anProcDefKey";
        String anotherProcDefKey = "anotherProcDefKey";
        RestAssured.given().queryParam("periodUnit", new Object[]{"month"}).queryParam("reportType", new Object[]{"duration"}).queryParam("processDefinitionIdIn", new Object[]{aProcDefId + "," + anotherProcDefId}).queryParam("processDefinitionKeyIn", new Object[]{aProcDefKey + "," + anotherProcDefKey}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_PROCESS_INSTANCE_REPORT_URL, new Object[0]);
        ((HistoricProcessInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).processDefinitionIdIn(new String[]{aProcDefId, anotherProcDefId});
        ((HistoricProcessInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).processDefinitionKeyIn(new String[]{aProcDefKey, anotherProcDefKey});
        ((HistoricProcessInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).duration(PeriodUnit.MONTH);
    }

    @Test
    public void testHistoricBeforeAndAfterStartTimeQuery() {
        RestAssured.given().queryParam("periodUnit", new Object[]{"month"}).queryParam("reportType", new Object[]{"duration"}).queryParam("startedBefore", new Object[]{MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_STARTED_BEFORE}).queryParam("startedAfter", new Object[]{MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_STARTED_AFTER}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_PROCESS_INSTANCE_REPORT_URL, new Object[0]);
        this.verifyStringStartParameterQueryInvocations();
    }

    @Test
    public void testEmptyCsvReportByMonth() {
        RestAssured.given().queryParam("reportType", new Object[]{"duration"}).queryParam("periodUnit", new Object[]{"month"}).accept("text/csv").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("text/csv").header("Content-Disposition", "attachment; filename=process-instance-report.csv").when().get(HISTORIC_PROCESS_INSTANCE_REPORT_URL, new Object[0]);
        ((HistoricProcessInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).duration(PeriodUnit.MONTH);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedReportQuery});
    }

    @Test
    public void testEmptyCsvReportByQuarter() {
        RestAssured.given().queryParam("reportType", new Object[]{"duration"}).queryParam("periodUnit", new Object[]{"quarter"}).accept("text/csv").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("text/csv").header("Content-Disposition", "attachment; filename=process-instance-report.csv").when().get(HISTORIC_PROCESS_INSTANCE_REPORT_URL, new Object[0]);
        ((HistoricProcessInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).duration(PeriodUnit.QUARTER);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedReportQuery});
    }

    @Test
    public void testCsvInvalidReportType() {
        RestAssured.given().queryParam("reportType", new Object[]{"abc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Cannot set query parameter 'reportType' to value 'abc'"), new Object[0]).when().get(HISTORIC_PROCESS_INSTANCE_REPORT_URL, new Object[0]);
    }

    @Test
    public void testCsvInvalidPeriodUnit() {
        RestAssured.given().queryParam("periodUnit", new Object[]{"abc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Cannot set query parameter 'periodUnit' to value 'abc'"), new Object[0]).when().get(HISTORIC_PROCESS_INSTANCE_REPORT_URL, new Object[0]);
    }

    @Test
    public void testCsvMissingReportType() {
        RestAssured.given().then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Unknown report type null"), new Object[0]).when().get(HISTORIC_PROCESS_INSTANCE_REPORT_URL, new Object[0]);
    }

    @Test
    public void testCsvMissingPeriodUnit() {
        RestAssured.given().queryParam("reportType", new Object[]{"duration"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"periodUnit is null"), new Object[0]).when().get(HISTORIC_PROCESS_INSTANCE_REPORT_URL, new Object[0]);
    }

    @Test
    public void testCsvMissingAuthorization() {
        String message = "not authorized";
        Mockito.when((Object)this.mockedReportQuery.duration(PeriodUnit.MONTH)).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().queryParam("reportType", new Object[]{"duration"}).queryParam("periodUnit", new Object[]{"month"}).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)message), new Object[0]).when().get(HISTORIC_PROCESS_INSTANCE_REPORT_URL, new Object[0]);
    }

    @Test
    public void testCsvDurationReportByMonth() {
        Response response = (Response)RestAssured.given().queryParam("reportType", new Object[]{"duration"}).queryParam("periodUnit", new Object[]{"month"}).accept("text/csv").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("text/csv").header("Content-Disposition", "attachment; filename=process-instance-report.csv").when().get(HISTORIC_PROCESS_INSTANCE_REPORT_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertTrue((boolean)responseContent.contains(ReportResultToCsvConverter.DURATION_HEADER));
        Assert.assertTrue((boolean)responseContent.contains(PeriodUnit.MONTH.toString()));
        Assert.assertTrue((boolean)responseContent.contains(String.valueOf(10L)));
        Assert.assertTrue((boolean)responseContent.contains(String.valueOf(5L)));
        Assert.assertTrue((boolean)responseContent.contains(String.valueOf(15L)));
    }

    @Test
    public void testCsvDurationReportByQuarter() {
        Response response = (Response)RestAssured.given().queryParam("reportType", new Object[]{"duration"}).queryParam("periodUnit", new Object[]{"quarter"}).accept("text/csv").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("text/csv").header("Content-Disposition", "attachment; filename=process-instance-report.csv").when().get(HISTORIC_PROCESS_INSTANCE_REPORT_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertTrue((boolean)responseContent.contains(ReportResultToCsvConverter.DURATION_HEADER));
        Assert.assertTrue((boolean)responseContent.contains(PeriodUnit.QUARTER.toString()));
        Assert.assertTrue((boolean)responseContent.contains(String.valueOf(10L)));
        Assert.assertTrue((boolean)responseContent.contains(String.valueOf(5L)));
        Assert.assertTrue((boolean)responseContent.contains(String.valueOf(15L)));
    }

    @Test
    public void testApplicationCsvDurationReportByMonth() {
        Response response = (Response)RestAssured.given().queryParam("reportType", new Object[]{"duration"}).queryParam("periodUnit", new Object[]{"month"}).accept("application/csv").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/csv").header("Content-Disposition", "attachment; filename=process-instance-report.csv").when().get(HISTORIC_PROCESS_INSTANCE_REPORT_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertTrue((boolean)responseContent.contains(ReportResultToCsvConverter.DURATION_HEADER));
        Assert.assertTrue((boolean)responseContent.contains(PeriodUnit.MONTH.toString()));
        Assert.assertTrue((boolean)responseContent.contains(String.valueOf(10L)));
        Assert.assertTrue((boolean)responseContent.contains(String.valueOf(5L)));
        Assert.assertTrue((boolean)responseContent.contains(String.valueOf(15L)));
    }

    @Test
    public void testApplicationCsvDurationReportByQuarter() {
        Response response = (Response)RestAssured.given().queryParam("reportType", new Object[]{"duration"}).queryParam("periodUnit", new Object[]{"quarter"}).accept("application/csv").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/csv").header("Content-Disposition", "attachment; filename=process-instance-report.csv").when().get(HISTORIC_PROCESS_INSTANCE_REPORT_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertTrue((boolean)responseContent.contains(ReportResultToCsvConverter.DURATION_HEADER));
        Assert.assertTrue((boolean)responseContent.contains(PeriodUnit.QUARTER.toString()));
        Assert.assertTrue((boolean)responseContent.contains(String.valueOf(10L)));
        Assert.assertTrue((boolean)responseContent.contains(String.valueOf(5L)));
        Assert.assertTrue((boolean)responseContent.contains(String.valueOf(15L)));
    }

    @Test
    public void testCsvListParameters() {
        String aProcDefId = "anProcDefId";
        String anotherProcDefId = "anotherProcDefId";
        String aProcDefKey = "anProcDefKey";
        String anotherProcDefKey = "anotherProcDefKey";
        RestAssured.given().queryParam("periodUnit", new Object[]{"month"}).queryParam("reportType", new Object[]{"duration"}).queryParam("processDefinitionIdIn", new Object[]{aProcDefId + "," + anotherProcDefId}).queryParam("processDefinitionKeyIn", new Object[]{aProcDefKey + "," + anotherProcDefKey}).accept("text/csv").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("text/csv").header("Content-Disposition", "attachment; filename=process-instance-report.csv").when().get(HISTORIC_PROCESS_INSTANCE_REPORT_URL, new Object[0]);
        ((HistoricProcessInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).processDefinitionIdIn(new String[]{aProcDefId, anotherProcDefId});
        ((HistoricProcessInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).processDefinitionKeyIn(new String[]{aProcDefKey, anotherProcDefKey});
        ((HistoricProcessInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).duration(PeriodUnit.MONTH);
    }

    @Test
    public void testCsvHistoricBeforeAndAfterStartTimeQuery() {
        RestAssured.given().queryParam("periodUnit", new Object[]{"month"}).queryParam("reportType", new Object[]{"duration"}).queryParam("startedBefore", new Object[]{MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_STARTED_BEFORE}).queryParam("startedAfter", new Object[]{MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_STARTED_AFTER}).accept("text/csv").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("text/csv").header("Content-Disposition", "attachment; filename=process-instance-report.csv").when().get(HISTORIC_PROCESS_INSTANCE_REPORT_URL, new Object[0]);
        this.verifyStringStartParameterQueryInvocations();
    }

    private Map<String, String> getCompleteStartDateAsStringQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("startedAfter", MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_STARTED_AFTER);
        parameters.put("startedBefore", MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_STARTED_BEFORE);
        return parameters;
    }

    private void verifyStringStartParameterQueryInvocations() {
        Map<String, String> startDateParameters = this.getCompleteStartDateAsStringQueryParameters();
        ((HistoricProcessInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).startedBefore(DateTimeUtil.parseDate((String)startDateParameters.get("startedBefore")));
        ((HistoricProcessInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).startedAfter(DateTimeUtil.parseDate((String)startDateParameters.get("startedAfter")));
    }
}

