/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Collections;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.impl.util.ReflectUtil;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinition;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinitionQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public class DecisionRequirementsDefinitionRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String DECISION_REQUIREMENTS_DEFINITION_URL = "/rest-test/decision-requirements-definition";
    protected static final String SINGLE_DECISION_REQUIREMENTS_DEFINITION_ID_URL = "/rest-test/decision-requirements-definition/{id}";
    protected static final String SINGLE_DECISION_REQUIREMENTS_DEFINITION_KEY_URL = "/rest-test/decision-requirements-definition/key/{key}";
    protected static final String SINGLE_DECISION_REQUIREMENTS_DEFINITION_KEY_AND_TENANT_ID_URL = "/rest-test/decision-requirements-definition/key/{key}/tenant-id/{tenant-id}";
    protected static final String XML_DEFINITION_URL = "/rest-test/decision-requirements-definition/{id}/xml";
    protected static final String DIAGRAM_DEFINITION_URL = "/rest-test/decision-requirements-definition/{id}/diagram";
    protected RepositoryService repositoryServiceMock;
    protected DecisionRequirementsDefinitionQuery decisionRequirementsDefinitionQueryMock;
    protected DecisionService decisionServiceMock;

    @Before
    public void setUpRuntime() throws FileNotFoundException, URISyntaxException {
        DecisionRequirementsDefinition mockDecisionRequirementsDefinition = MockProvider.createMockDecisionRequirementsDefinition();
        this.setUpRuntimeData(mockDecisionRequirementsDefinition);
        this.decisionServiceMock = (DecisionService)Mockito.mock(DecisionService.class);
        Mockito.when((Object)processEngine.getDecisionService()).thenReturn((Object)this.decisionServiceMock);
    }

    @Test
    public void decisionRequirementsDefinitionRetrievalById() {
        RestAssured.given().pathParam("id", (Object)"aDecisionRequirementsDefinitionId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"aDecisionRequirementsDefinitionId"), new Object[0]).body("key", Matchers.equalTo((Object)"aDecisionRequirementsDefinitionKey"), new Object[0]).body("category", Matchers.equalTo((Object)"aDecisionRequirementsDefinitionCategory"), new Object[0]).body("name", Matchers.equalTo((Object)"aDecisionRequirementsDefinitionName"), new Object[0]).body("deploymentId", Matchers.equalTo((Object)"aDeploymentId"), new Object[0]).body("version", Matchers.equalTo((Object)1), new Object[0]).body("resource", Matchers.equalTo((Object)"aDecisionRequirementsDefinitionResourceName"), new Object[0]).body("tenantId", Matchers.equalTo(null), new Object[0]).when().get(SINGLE_DECISION_REQUIREMENTS_DEFINITION_ID_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).getDecisionRequirementsDefinition("aDecisionRequirementsDefinitionId");
    }

    @Test
    public void nonExistingDecisionRequirementsDefinitionRetrieval() {
        String nonExistingId = "aNonExistingDefinitionId";
        Mockito.when((Object)this.repositoryServiceMock.getDecisionRequirementsDefinition((String)org.mockito.Matchers.eq((Object)nonExistingId))).thenThrow(new Throwable[]{new ProcessEngineException("No matching decision requirements definition")});
        RestAssured.given().pathParam("id", (Object)"aNonExistingDefinitionId").then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"No matching decision requirements definition"), new Object[0]).when().get(SINGLE_DECISION_REQUIREMENTS_DEFINITION_ID_URL, new Object[0]);
    }

    @Test
    public void decisionRequirementsDefinitionRetrievalByKey() {
        RestAssured.given().pathParam("key", (Object)"aDecisionRequirementsDefinitionKey").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"aDecisionRequirementsDefinitionId"), new Object[0]).body("key", Matchers.equalTo((Object)"aDecisionRequirementsDefinitionKey"), new Object[0]).body("category", Matchers.equalTo((Object)"aDecisionRequirementsDefinitionCategory"), new Object[0]).body("name", Matchers.equalTo((Object)"aDecisionRequirementsDefinitionName"), new Object[0]).body("deploymentId", Matchers.equalTo((Object)"aDeploymentId"), new Object[0]).body("version", Matchers.equalTo((Object)1), new Object[0]).body("resource", Matchers.equalTo((Object)"aDecisionRequirementsDefinitionResourceName"), new Object[0]).body("tenantId", Matchers.equalTo(null), new Object[0]).when().get(SINGLE_DECISION_REQUIREMENTS_DEFINITION_KEY_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).getDecisionRequirementsDefinition("aDecisionRequirementsDefinitionId");
    }

    @Test
    public void decisionRequirementsDefinitionRetrievalByNonExistingKey() {
        String nonExistingKey = "aNonExistingRequirementsDefinitionKey";
        Mockito.when((Object)this.repositoryServiceMock.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionKey(nonExistingKey)).thenReturn((Object)this.decisionRequirementsDefinitionQueryMock);
        Mockito.when((Object)this.decisionRequirementsDefinitionQueryMock.singleResult()).thenReturn(null);
        RestAssured.given().pathParam("key", (Object)nonExistingKey).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("No matching decision requirements definition with key: " + nonExistingKey)), new Object[0]).when().get(SINGLE_DECISION_REQUIREMENTS_DEFINITION_KEY_URL, new Object[0]);
    }

    @Test
    public void decisionRequirementsDefinitionRetrievalByKeyAndTenantId() throws FileNotFoundException, URISyntaxException {
        DecisionRequirementsDefinition mockDefinition = MockProvider.mockDecisionRequirementsDefinition().tenantId("aTenantId").build();
        this.setUpRuntimeData(mockDefinition);
        RestAssured.given().pathParam("key", (Object)"aDecisionRequirementsDefinitionKey").pathParam("tenant-id", (Object)"aTenantId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"aDecisionRequirementsDefinitionId"), new Object[0]).body("key", Matchers.equalTo((Object)"aDecisionRequirementsDefinitionKey"), new Object[0]).body("category", Matchers.equalTo((Object)"aDecisionRequirementsDefinitionCategory"), new Object[0]).body("name", Matchers.equalTo((Object)"aDecisionRequirementsDefinitionName"), new Object[0]).body("deploymentId", Matchers.equalTo((Object)"aDeploymentId"), new Object[0]).body("version", Matchers.equalTo((Object)1), new Object[0]).body("resource", Matchers.equalTo((Object)"aDecisionRequirementsDefinitionResourceName"), new Object[0]).body("tenantId", Matchers.equalTo((Object)"aTenantId"), new Object[0]).when().get(SINGLE_DECISION_REQUIREMENTS_DEFINITION_KEY_AND_TENANT_ID_URL, new Object[0]);
        ((DecisionRequirementsDefinitionQuery)Mockito.verify((Object)this.decisionRequirementsDefinitionQueryMock)).tenantIdIn(new String[]{"aTenantId"});
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).getDecisionRequirementsDefinition("aDecisionRequirementsDefinitionId");
    }

    @Test
    public void nonExistingDecisionRequirementsDefinitionRetrievalByKeyAndTenantId() {
        String nonExistingKey = "aNonExistingDecisionDefinitionRequirementsDefinitionKey";
        String nonExistingTenantId = "aNonExistingTenantId";
        Mockito.when((Object)this.repositoryServiceMock.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionKey(nonExistingKey)).thenReturn((Object)this.decisionRequirementsDefinitionQueryMock);
        Mockito.when((Object)this.decisionRequirementsDefinitionQueryMock.singleResult()).thenReturn(null);
        RestAssured.given().pathParam("key", (Object)nonExistingKey).pathParam("tenant-id", (Object)nonExistingTenantId).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("No matching decision requirements definition with key: " + nonExistingKey + " and tenant-id: " + nonExistingTenantId)), new Object[0]).when().get(SINGLE_DECISION_REQUIREMENTS_DEFINITION_KEY_AND_TENANT_ID_URL, new Object[0]);
    }

    @Test
    public void decisionRequirementsDefinitionDmnXmlRetrieval() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDecisionRequirementsDefinitionId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(XML_DEFINITION_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertTrue((boolean)responseContent.contains("aDecisionRequirementsDefinitionId"));
        Assert.assertTrue((boolean)responseContent.contains("<?xml"));
    }

    @Test
    public void decisionRequirementsDiagramRetrieval() throws FileNotFoundException, URISyntaxException {
        byte[] actual = ((Response)RestAssured.given().pathParam("id", (Object)"aDecisionRequirementsDefinitionId").expect().statusCode(Response.Status.OK.getStatusCode()).contentType("image/png").header("Content-Disposition", "attachment; filename=\"aResourceName.png\"").when().get(DIAGRAM_DEFINITION_URL, new Object[0])).getBody().asByteArray();
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).getDecisionRequirementsDefinition("aDecisionRequirementsDefinitionId");
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).getDecisionRequirementsDiagram("aDecisionRequirementsDefinitionId");
        byte[] expected = IoUtil.readInputStream((InputStream)new FileInputStream(this.getFile()), (String)"decision requirements diagram");
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    protected void setUpRuntimeData(DecisionRequirementsDefinition mockDecisionRequirementsDefinition) throws FileNotFoundException, URISyntaxException {
        this.repositoryServiceMock = (RepositoryService)Mockito.mock(RepositoryService.class);
        Mockito.when((Object)processEngine.getRepositoryService()).thenReturn((Object)this.repositoryServiceMock);
        Mockito.when((Object)this.repositoryServiceMock.getDecisionRequirementsDefinition((String)org.mockito.Matchers.eq((Object)"aDecisionRequirementsDefinitionId"))).thenReturn((Object)mockDecisionRequirementsDefinition);
        Mockito.when((Object)this.repositoryServiceMock.getDecisionRequirementsModel((String)org.mockito.Matchers.eq((Object)"aDecisionRequirementsDefinitionId"))).thenReturn((Object)this.createMockDecisionRequirementsDefinitionDmnXml());
        Mockito.when((Object)this.repositoryServiceMock.getDecisionRequirementsDiagram("aDecisionRequirementsDefinitionId")).thenReturn((Object)this.createMockDecisionRequirementsDiagram());
        this.decisionRequirementsDefinitionQueryMock = (DecisionRequirementsDefinitionQuery)Mockito.mock(DecisionRequirementsDefinitionQuery.class);
        Mockito.when((Object)this.decisionRequirementsDefinitionQueryMock.decisionRequirementsDefinitionKey("aDecisionRequirementsDefinitionKey")).thenReturn((Object)this.decisionRequirementsDefinitionQueryMock);
        Mockito.when((Object)this.decisionRequirementsDefinitionQueryMock.tenantIdIn(new String[]{org.mockito.Matchers.anyString()})).thenReturn((Object)this.decisionRequirementsDefinitionQueryMock);
        Mockito.when((Object)this.decisionRequirementsDefinitionQueryMock.withoutTenantId()).thenReturn((Object)this.decisionRequirementsDefinitionQueryMock);
        Mockito.when((Object)this.decisionRequirementsDefinitionQueryMock.latestVersion()).thenReturn((Object)this.decisionRequirementsDefinitionQueryMock);
        Mockito.when((Object)this.decisionRequirementsDefinitionQueryMock.singleResult()).thenReturn((Object)mockDecisionRequirementsDefinition);
        Mockito.when((Object)this.decisionRequirementsDefinitionQueryMock.list()).thenReturn(Collections.singletonList(mockDecisionRequirementsDefinition));
        Mockito.when((Object)this.repositoryServiceMock.createDecisionRequirementsDefinitionQuery()).thenReturn((Object)this.decisionRequirementsDefinitionQueryMock);
    }

    protected InputStream createMockDecisionRequirementsDefinitionDmnXml() {
        InputStream dmnXmlInputStream = ReflectUtil.getResourceAsStream((String)"decisions/decision-requirements-model.dmn");
        Assert.assertNotNull((Object)dmnXmlInputStream);
        return dmnXmlInputStream;
    }

    protected FileInputStream createMockDecisionRequirementsDiagram() throws URISyntaxException, FileNotFoundException {
        File file = this.getFile();
        return new FileInputStream(file);
    }

    protected File getFile() throws URISyntaxException {
        return this.getFile("/decisions/decision-requirements-diagram.png");
    }
}

