/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.helper;

import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.mockito.Mockito;

public class MockVariableInstanceBuilder {
    protected String id;
    protected String name;
    protected TypedValue typedValue;
    protected String processDefinitionId;
    protected String processInstanceId;
    protected String executionId;
    protected String caseInstanceId;
    protected String caseExecutionId;
    protected String taskId;
    protected String batchId;
    protected String activityInstanceId;
    protected String tenantId;
    protected String errorMessage;

    public MockVariableInstanceBuilder id(String id) {
        this.id = id;
        return this;
    }

    public MockVariableInstanceBuilder name(String name) {
        this.name = name;
        return this;
    }

    public MockVariableInstanceBuilder typedValue(TypedValue value) {
        this.typedValue = value;
        return this;
    }

    public MockVariableInstanceBuilder processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    public MockVariableInstanceBuilder processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    public MockVariableInstanceBuilder executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    public MockVariableInstanceBuilder caseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    public MockVariableInstanceBuilder caseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
        return this;
    }

    public MockVariableInstanceBuilder taskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    public MockVariableInstanceBuilder batchId(String batchId) {
        this.batchId = batchId;
        return this;
    }

    public MockVariableInstanceBuilder activityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
        return this;
    }

    public MockVariableInstanceBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public MockVariableInstanceBuilder errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.typedValue.getValue();
    }

    public TypedValue getTypedValue() {
        return this.typedValue;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public String getCaseExecutionId() {
        return this.caseExecutionId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getBatchId() {
        return this.batchId;
    }

    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getTypeName() {
        return this.typedValue.getType().getName();
    }

    public VariableInstance build() {
        VariableInstance mockVariable = (VariableInstance)Mockito.mock(VariableInstance.class);
        return this.build(mockVariable);
    }

    public VariableInstanceEntity buildEntity() {
        VariableInstanceEntity mockVariable = (VariableInstanceEntity)Mockito.mock(VariableInstanceEntity.class);
        if (this.taskId != null) {
            Mockito.when((Object)mockVariable.getVariableScopeId()).thenReturn((Object)this.taskId);
        } else if (this.executionId != null) {
            Mockito.when((Object)mockVariable.getVariableScopeId()).thenReturn((Object)this.executionId);
        } else {
            Mockito.when((Object)mockVariable.getVariableScopeId()).thenReturn((Object)this.caseExecutionId);
        }
        return this.build(mockVariable);
    }

    protected <T extends VariableInstance> T build(T mockVariable) {
        Mockito.when((Object)mockVariable.getId()).thenReturn((Object)this.id);
        Mockito.when((Object)mockVariable.getName()).thenReturn((Object)this.name);
        Mockito.when((Object)mockVariable.getTypeName()).thenReturn((Object)this.typedValue.getType().getName());
        if (ObjectValue.class.isAssignableFrom(this.typedValue.getClass())) {
            ObjectValue objectValue = (ObjectValue)this.typedValue;
            if (objectValue.isDeserialized()) {
                Mockito.when((Object)mockVariable.getValue()).thenReturn(this.typedValue.getValue());
            } else {
                Mockito.when((Object)mockVariable.getValue()).thenReturn(null);
            }
        } else {
            Mockito.when((Object)mockVariable.getValue()).thenReturn(this.typedValue.getValue());
        }
        Mockito.when((Object)mockVariable.getTypedValue()).thenReturn((Object)this.typedValue);
        Mockito.when((Object)mockVariable.getProcessDefinitionId()).thenReturn((Object)this.processDefinitionId);
        Mockito.when((Object)mockVariable.getProcessInstanceId()).thenReturn((Object)this.processInstanceId);
        Mockito.when((Object)mockVariable.getExecutionId()).thenReturn((Object)this.executionId);
        Mockito.when((Object)mockVariable.getCaseInstanceId()).thenReturn((Object)this.caseInstanceId);
        Mockito.when((Object)mockVariable.getCaseExecutionId()).thenReturn((Object)this.caseExecutionId);
        Mockito.when((Object)mockVariable.getTaskId()).thenReturn((Object)this.taskId);
        Mockito.when((Object)mockVariable.getBatchId()).thenReturn((Object)this.batchId);
        Mockito.when((Object)mockVariable.getActivityInstanceId()).thenReturn((Object)this.activityInstanceId);
        Mockito.when((Object)mockVariable.getTenantId()).thenReturn((Object)this.tenantId);
        Mockito.when((Object)mockVariable.getErrorMessage()).thenReturn((Object)this.errorMessage);
        return mockVariable;
    }
}

