/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.helper.variable;

import org.camunda.bpm.engine.rest.helper.variable.EqualsTypedValue;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.hamcrest.Description;

public class EqualsObjectValue
extends EqualsTypedValue<EqualsObjectValue> {
    protected String serializationFormat;
    protected String objectTypeName;
    protected String serializedValue;
    protected Object value;
    protected boolean isDeserialized = false;

    public EqualsObjectValue() {
        this.type = ValueType.OBJECT;
    }

    public EqualsObjectValue serializationFormat(String serializationFormat) {
        this.serializationFormat = serializationFormat;
        return this;
    }

    public EqualsObjectValue objectTypeName(String objectTypeName) {
        this.objectTypeName = objectTypeName;
        return this;
    }

    public EqualsObjectValue value(Object value) {
        this.value = value;
        return this;
    }

    public EqualsObjectValue isDeserialized() {
        this.isDeserialized = true;
        return this;
    }

    public EqualsObjectValue serializedValue(String serializedValue) {
        this.serializedValue = serializedValue;
        return this;
    }

    @Override
    public boolean matches(Object argument) {
        if (!super.matches(argument)) {
            return false;
        }
        if (!ObjectValue.class.isAssignableFrom(argument.getClass())) {
            return false;
        }
        ObjectValue objectValue = (ObjectValue)argument;
        if (this.isDeserialized) {
            if (!objectValue.isDeserialized()) {
                return false;
            }
            if (this.value == null ? objectValue.getValue() != null : !this.value.equals(objectValue.getValue())) {
                return false;
            }
        } else {
            if (objectValue.isDeserialized()) {
                return false;
            }
            if (this.serializationFormat == null ? objectValue.getSerializationDataFormat() != null : !this.serializationFormat.equals(objectValue.getSerializationDataFormat())) {
                return false;
            }
            if (this.objectTypeName == null ? objectValue.getObjectTypeName() != null : !this.objectTypeName.equals(objectValue.getObjectTypeName())) {
                return false;
            }
            if (this.serializedValue == null ? objectValue.getValueSerialized() != null : !this.serializedValue.equals(objectValue.getValueSerialized())) {
                return false;
            }
        }
        return true;
    }

    public static EqualsObjectValue objectValueMatcher() {
        return new EqualsObjectValue();
    }

    public void describeTo(Description description) {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(": ");
        sb.append("serializedValue=");
        sb.append(this.serializedValue);
        sb.append(", objectTypeName=");
        sb.append(this.objectTypeName);
        sb.append(", serializationFormat=");
        sb.append(this.serializationFormat);
        sb.append(", isDeserialized=false");
        description.appendText(sb.toString());
    }
}

