/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.helper.variable;

import java.util.Arrays;
import java.util.Date;
import org.camunda.bpm.engine.rest.helper.variable.EqualsTypedValue;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.PrimitiveValue;
import org.hamcrest.Description;

public class EqualsPrimitiveValue
extends EqualsTypedValue<EqualsPrimitiveValue> {
    protected Object value;

    public EqualsPrimitiveValue value(Object value) {
        this.value = value;
        return this;
    }

    @Override
    public boolean matches(Object argument) {
        if (!super.matches(argument)) {
            return false;
        }
        if (!PrimitiveValue.class.isAssignableFrom(argument.getClass())) {
            return false;
        }
        PrimitiveValue primitveValue = (PrimitiveValue)argument;
        return !(this.value == null ? primitveValue.getValue() != null : !this.matchesValues(primitveValue.getValue()));
    }

    protected boolean matchesValues(Object otherValue) {
        if (this.value instanceof byte[]) {
            if (!(otherValue instanceof byte[])) {
                return false;
            }
            byte[] byteValue = (byte[])this.value;
            byte[] otherByteValue = (byte[])otherValue;
            return Arrays.equals(byteValue, otherByteValue);
        }
        if (this.type == ValueType.NUMBER) {
            if (!(otherValue instanceof Number)) {
                return false;
            }
            Number thisNumer = (Number)this.value;
            Number otherNumber = (Number)otherValue;
            return thisNumer.doubleValue() == otherNumber.doubleValue();
        }
        return this.value.equals(otherValue);
    }

    public static EqualsPrimitiveValue primitiveValueMatcher() {
        return new EqualsPrimitiveValue();
    }

    public static EqualsPrimitiveValue integerValue(Integer value) {
        return ((EqualsPrimitiveValue)((Object)new EqualsPrimitiveValue().type((ValueType)ValueType.INTEGER))).value(value);
    }

    public static EqualsPrimitiveValue stringValue(String value) {
        return ((EqualsPrimitiveValue)((Object)new EqualsPrimitiveValue().type((ValueType)ValueType.STRING))).value(value);
    }

    public static EqualsPrimitiveValue booleanValue(Boolean value) {
        return ((EqualsPrimitiveValue)((Object)new EqualsPrimitiveValue().type((ValueType)ValueType.BOOLEAN))).value(value);
    }

    public static EqualsPrimitiveValue shortValue(Short value) {
        return ((EqualsPrimitiveValue)((Object)new EqualsPrimitiveValue().type((ValueType)ValueType.SHORT))).value(value);
    }

    public static EqualsPrimitiveValue doubleValue(Double value) {
        return ((EqualsPrimitiveValue)((Object)new EqualsPrimitiveValue().type((ValueType)ValueType.DOUBLE))).value(value);
    }

    public static EqualsPrimitiveValue longValue(Long value) {
        return ((EqualsPrimitiveValue)((Object)new EqualsPrimitiveValue().type((ValueType)ValueType.LONG))).value(value);
    }

    public static EqualsPrimitiveValue bytesValue(byte[] value) {
        return ((EqualsPrimitiveValue)((Object)new EqualsPrimitiveValue().type((ValueType)ValueType.BYTES))).value(value);
    }

    public static EqualsPrimitiveValue dateValue(Date value) {
        return ((EqualsPrimitiveValue)((Object)new EqualsPrimitiveValue().type((ValueType)ValueType.DATE))).value(value);
    }

    public static EqualsPrimitiveValue numberValue(Number value) {
        return ((EqualsPrimitiveValue)((Object)new EqualsPrimitiveValue().type((ValueType)ValueType.NUMBER))).value(value);
    }

    public void describeTo(Description description) {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(": ");
        sb.append("value=");
        sb.append(this.value);
        sb.append(", type=");
        sb.append(this.type);
        description.appendText(sb.toString());
    }
}

