/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.history.SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder;
import org.camunda.bpm.engine.history.SetRemovalTimeToHistoricProcessInstancesBuilder;
import org.camunda.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.batch.BatchDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricProcessInstanceQueryDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.JsonPathUtil;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class HistoricProcessInstanceRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String DELETE_REASON = "deleteReason";
    protected static final String TEST_DELETE_REASON = "test";
    protected static final String FAIL_IF_NOT_EXISTS = "failIfNotExists";
    protected static final String HISTORIC_PROCESS_INSTANCE_URL = "/rest-test/history/process-instance";
    protected static final String HISTORIC_SINGLE_PROCESS_INSTANCE_URL = "/rest-test/history/process-instance/{id}";
    protected static final String DELETE_HISTORIC_PROCESS_INSTANCES_ASYNC_URL = "/rest-test/history/process-instance/delete";
    protected static final String SET_REMOVAL_TIME_HISTORIC_PROCESS_INSTANCES_ASYNC_URL = "/rest-test/history/process-instance/set-removal-time";
    protected static final String HISTORIC_SINGLE_PROCESS_INSTANCE_VARIABLES_URL = "/rest-test/history/process-instance/{id}/variable-instances";
    private HistoryService historyServiceMock;

    @Before
    public void setUpRuntimeData() {
        this.historyServiceMock = (HistoryService)Mockito.mock(HistoryService.class);
        Mockito.when((Object)processEngine.getHistoryService()).thenReturn((Object)this.historyServiceMock);
    }

    @Test
    public void testGetSingleInstance() {
        HistoricProcessInstance mockInstance = MockProvider.createMockHistoricProcessInstance();
        HistoricProcessInstanceQuery sampleInstanceQuery = (HistoricProcessInstanceQuery)Mockito.mock(HistoricProcessInstanceQuery.class);
        Mockito.when((Object)this.historyServiceMock.createHistoricProcessInstanceQuery()).thenReturn((Object)sampleInstanceQuery);
        Mockito.when((Object)sampleInstanceQuery.processInstanceId("aProcInstId")).thenReturn((Object)sampleInstanceQuery);
        Mockito.when((Object)sampleInstanceQuery.singleResult()).thenReturn((Object)mockInstance);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aProcInstId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_SINGLE_PROCESS_INSTANCE_URL, new Object[0]);
        String content = response.asString();
        String returnedProcessInstanceId = JsonPath.from((String)content).getString("id");
        String returnedProcessInstanceBusinessKey = JsonPath.from((String)content).getString("businessKey");
        String returnedProcessDefinitionId = JsonPath.from((String)content).getString("processDefinitionId");
        String returnedProcessDefinitionKey = JsonPath.from((String)content).getString("processDefinitionKey");
        String returnedStartTime = JsonPath.from((String)content).getString("startTime");
        String returnedEndTime = JsonPath.from((String)content).getString("endTime");
        long returnedDurationInMillis = JsonPath.from((String)content).getLong("durationInMillis");
        String returnedStartUserId = JsonPath.from((String)content).getString("startUserId");
        String returnedStartActivityId = JsonPath.from((String)content).getString("startActivityId");
        String returnedDeleteReason = JsonPath.from((String)content).getString(DELETE_REASON);
        String returnedSuperProcessInstanceId = JsonPath.from((String)content).getString("superProcessInstanceId");
        String returnedSuperCaseInstanceId = JsonPath.from((String)content).getString("superCaseInstanceId");
        String returnedCaseInstanceId = JsonPath.from((String)content).getString("caseInstanceId");
        String returnedTenantId = JsonPath.from((String)content).getString("tenantId");
        String returnedState = JsonPath.from((String)content).getString("state");
        Assert.assertEquals((Object)"aProcInstId", (Object)returnedProcessInstanceId);
        Assert.assertEquals((Object)"aKey", (Object)returnedProcessInstanceBusinessKey);
        Assert.assertEquals((Object)"aProcDefId", (Object)returnedProcessDefinitionId);
        Assert.assertEquals((Object)"aKey", (Object)returnedProcessDefinitionKey);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_START_TIME, (Object)returnedStartTime);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_END_TIME, (Object)returnedEndTime);
        Assert.assertEquals((long)2000L, (long)returnedDurationInMillis);
        Assert.assertEquals((Object)"aStartUserId", (Object)returnedStartUserId);
        Assert.assertEquals((Object)"aStartActivityId", (Object)returnedStartActivityId);
        Assert.assertEquals((Object)"aDeleteReason", (Object)returnedDeleteReason);
        Assert.assertEquals((Object)"aSuperProcessInstanceId", (Object)returnedSuperProcessInstanceId);
        Assert.assertEquals((Object)"aSuperCaseInstanceId", (Object)returnedSuperCaseInstanceId);
        Assert.assertEquals((Object)"aCaseInstanceId", (Object)returnedCaseInstanceId);
        Assert.assertEquals((Object)"aTenantId", (Object)returnedTenantId);
        Assert.assertEquals((Object)"aState", (Object)returnedState);
    }

    @Test
    public void testGetNonExistingProcessInstance() {
        HistoricProcessInstanceQuery sampleInstanceQuery = (HistoricProcessInstanceQuery)Mockito.mock(HistoricProcessInstanceQuery.class);
        Mockito.when((Object)this.historyServiceMock.createHistoricProcessInstanceQuery()).thenReturn((Object)sampleInstanceQuery);
        Mockito.when((Object)sampleInstanceQuery.processInstanceId(org.mockito.Matchers.anyString())).thenReturn((Object)sampleInstanceQuery);
        Mockito.when((Object)sampleInstanceQuery.singleResult()).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"aNonExistingInstanceId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Historic process instance with id aNonExistingInstanceId does not exist"), new Object[0]).when().get(HISTORIC_SINGLE_PROCESS_INSTANCE_URL, new Object[0]);
    }

    @Test
    public void testDeleteProcessInstance() {
        RestAssured.given().pathParam("id", (Object)"aProcInstId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(HISTORIC_SINGLE_PROCESS_INSTANCE_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.historyServiceMock)).deleteHistoricProcessInstance("aProcInstId");
    }

    @Test
    public void testDeleteNonExistingProcessInstance() {
        ((HistoryService)Mockito.doThrow((Throwable)new ProcessEngineException("expected exception")).when((Object)this.historyServiceMock)).deleteHistoricProcessInstance(org.mockito.Matchers.anyString());
        RestAssured.given().pathParam("id", (Object)"aProcInstId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Historic process instance with id aProcInstId does not exist"), new Object[0]).when().delete(HISTORIC_SINGLE_PROCESS_INSTANCE_URL, new Object[0]);
    }

    @Test
    public void testDeleteNonExistingProcessInstanceIfExists() {
        RestAssured.given().pathParam("id", (Object)"aProcInstId").queryParam(FAIL_IF_NOT_EXISTS, new Object[]{false}).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(HISTORIC_SINGLE_PROCESS_INSTANCE_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.historyServiceMock)).deleteHistoricProcessInstanceIfExists("aProcInstId");
    }

    @Test
    public void testDeleteProcessInstanceThrowsAuthorizationException() {
        String message = "expected exception";
        ((HistoryService)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.historyServiceMock)).deleteHistoricProcessInstance(org.mockito.Matchers.anyString());
        RestAssured.given().pathParam("id", (Object)"aProcInstId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().delete(HISTORIC_SINGLE_PROCESS_INSTANCE_URL, new Object[0]);
    }

    @Test
    public void testDeleteAsync() {
        List<String> ids = Arrays.asList("aProcInstId");
        Batch batchEntity = MockProvider.createMockBatch();
        Mockito.when((Object)this.historyServiceMock.deleteHistoricProcessInstancesAsync(org.mockito.Matchers.anyListOf(String.class), (HistoricProcessInstanceQuery)org.mockito.Matchers.any(HistoricProcessInstanceQuery.class), org.mockito.Matchers.anyString())).thenReturn((Object)batchEntity);
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        messageBodyJson.put("historicProcessInstanceIds", ids);
        messageBodyJson.put(DELETE_REASON, TEST_DELETE_REASON);
        Response response = (Response)RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(DELETE_HISTORIC_PROCESS_INSTANCES_ASYNC_URL, new Object[0]);
        this.verifyBatchJson(response.asString());
        ((HistoryService)Mockito.verify((Object)this.historyServiceMock, (VerificationMode)Mockito.times((int)1))).deleteHistoricProcessInstancesAsync((List)org.mockito.Matchers.eq(ids), (HistoricProcessInstanceQuery)org.mockito.Matchers.eq((Object)null), (String)org.mockito.Matchers.eq((Object)TEST_DELETE_REASON));
    }

    @Test
    public void testDeleteAsyncWithQuery() {
        Batch batchEntity = MockProvider.createMockBatch();
        Mockito.when((Object)this.historyServiceMock.deleteHistoricProcessInstancesAsync(org.mockito.Matchers.anyListOf(String.class), (HistoricProcessInstanceQuery)org.mockito.Matchers.any(HistoricProcessInstanceQuery.class), org.mockito.Matchers.anyString())).thenReturn((Object)batchEntity);
        HashMap<String, String> messageBodyJson = new HashMap<String, String>();
        messageBodyJson.put(DELETE_REASON, TEST_DELETE_REASON);
        HistoricProcessInstanceQueryDto query = new HistoricProcessInstanceQueryDto();
        messageBodyJson.put("historicProcessInstanceQuery", (String)query);
        Response response = (Response)RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(DELETE_HISTORIC_PROCESS_INSTANCES_ASYNC_URL, new Object[0]);
        this.verifyBatchJson(response.asString());
        ((HistoryService)Mockito.verify((Object)this.historyServiceMock, (VerificationMode)Mockito.times((int)1))).deleteHistoricProcessInstancesAsync((List)org.mockito.Matchers.eq((Object)null), (HistoricProcessInstanceQuery)org.mockito.Matchers.any(HistoricProcessInstanceQuery.class), (String)Mockito.eq((Object)TEST_DELETE_REASON));
    }

    @Test
    public void testDeleteAsyncWithBadRequestQuery() {
        ((HistoryService)Mockito.doThrow((Throwable)new BadUserRequestException("process instance ids are empty")).when((Object)this.historyServiceMock)).deleteHistoricProcessInstancesAsync((List)org.mockito.Matchers.eq((Object)null), (HistoricProcessInstanceQuery)org.mockito.Matchers.eq((Object)null), org.mockito.Matchers.anyString());
        HashMap<String, String> messageBodyJson = new HashMap<String, String>();
        messageBodyJson.put(DELETE_REASON, TEST_DELETE_REASON);
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(DELETE_HISTORIC_PROCESS_INSTANCES_ASYNC_URL, new Object[0]);
    }

    @Test
    public void testDeleteAllVariablesByProcessInstanceId() {
        RestAssured.given().pathParam("id", (Object)"aProcessInstanceId").expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(HISTORIC_SINGLE_PROCESS_INSTANCE_VARIABLES_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.historyServiceMock)).deleteHistoricVariableInstancesByProcessInstanceId("aProcessInstanceId");
    }

    @Test
    public void testDeleteAllVariablesForNonExistingProcessInstance() {
        ((HistoryService)Mockito.doThrow((Throwable)new NotFoundException("No historic process instance found with id: 'NON_EXISTING_ID'")).when((Object)this.historyServiceMock)).deleteHistoricVariableInstancesByProcessInstanceId("NON_EXISTING_ID");
        RestAssured.given().pathParam("id", (Object)"NON_EXISTING_ID").expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(Matchers.containsString((String)"No historic process instance found with id: 'NON_EXISTING_ID'"), new Matcher[0]).when().delete(HISTORIC_SINGLE_PROCESS_INSTANCE_VARIABLES_URL, new Object[0]);
    }

    @Test
    public void shouldSetRemovalTime_ByIds() {
        SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder builderMock = (SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder)Mockito.mock(SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.historyServiceMock.setRemovalTimeToHistoricProcessInstances()).thenReturn((Object)builderMock);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("historicProcessInstanceIds", Collections.singletonList("aProcessInstanceId"));
        payload.put("calculatedRemovalTime", true);
        RestAssured.given().contentType(ContentType.JSON).body(payload).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(SET_REMOVAL_TIME_HISTORIC_PROCESS_INSTANCES_ASYNC_URL, new Object[0]);
        SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder builder = this.historyServiceMock.setRemovalTimeToHistoricProcessInstances();
        ((SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder)Mockito.verify((Object)builder)).calculatedRemovalTime();
        ((SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder)Mockito.verify((Object)builder)).byIds(new String[]{"aProcessInstanceId"});
        ((SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder)Mockito.verify((Object)builder)).byQuery(null);
        ((SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder)Mockito.verify((Object)builder)).executeAsync();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{builder});
    }

    @Test
    public void shouldSetRemovalTime_ByQuery() {
        SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder builderMock = (SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder)Mockito.mock(SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.historyServiceMock.setRemovalTimeToHistoricProcessInstances()).thenReturn((Object)builderMock);
        HistoricProcessInstanceQuery query = (HistoricProcessInstanceQuery)Mockito.mock(HistoricProcessInstanceQueryImpl.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.historyServiceMock.createHistoricProcessInstanceQuery()).thenReturn((Object)query);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("calculatedRemovalTime", true);
        payload.put("historicProcessInstanceQuery", Collections.singletonMap("processDefinitionId", "aProcessDefinitionId"));
        RestAssured.given().contentType(ContentType.JSON).body(payload).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(SET_REMOVAL_TIME_HISTORIC_PROCESS_INSTANCES_ASYNC_URL, new Object[0]);
        SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder builder = this.historyServiceMock.setRemovalTimeToHistoricProcessInstances();
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)query)).processDefinitionId("aProcessDefinitionId");
        ((SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder)Mockito.verify((Object)builder)).calculatedRemovalTime();
        ((SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder)Mockito.verify((Object)builder)).byIds(null);
        ((SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder)Mockito.verify((Object)builder)).byQuery(query);
        ((SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder)Mockito.verify((Object)builder)).executeAsync();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{builder});
    }

    @Test
    public void shouldSetRemovalTime_Absolute() {
        Date removalTime = new Date();
        SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder builderMock = (SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder)Mockito.mock(SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.historyServiceMock.setRemovalTimeToHistoricProcessInstances()).thenReturn((Object)builderMock);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("historicProcessInstanceIds", Collections.singletonList("aProcessInstanceId"));
        payload.put("absoluteRemovalTime", removalTime);
        RestAssured.given().contentType(ContentType.JSON).body(payload).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(SET_REMOVAL_TIME_HISTORIC_PROCESS_INSTANCES_ASYNC_URL, new Object[0]);
        SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder builder = this.historyServiceMock.setRemovalTimeToHistoricProcessInstances();
        ((SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder)Mockito.verify((Object)builder)).absoluteRemovalTime(removalTime);
        ((SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder)Mockito.verify((Object)builder)).byIds(new String[]{"aProcessInstanceId"});
        ((SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder)Mockito.verify((Object)builder)).byQuery(null);
        ((SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder)Mockito.verify((Object)builder)).executeAsync();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{builder});
    }

    @Test
    public void shouldNotSetRemovalTime_Absolute() {
        SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder builderMock = (SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder)Mockito.mock(SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.historyServiceMock.setRemovalTimeToHistoricProcessInstances()).thenReturn((Object)builderMock);
        HashMap<String, List<String>> payload = new HashMap<String, List<String>>();
        payload.put("historicProcessInstanceIds", Collections.singletonList("aProcessInstanceId"));
        payload.put("absoluteRemovalTime", null);
        RestAssured.given().contentType(ContentType.JSON).body(payload).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(SET_REMOVAL_TIME_HISTORIC_PROCESS_INSTANCES_ASYNC_URL, new Object[0]);
        SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder builder = this.historyServiceMock.setRemovalTimeToHistoricProcessInstances();
        ((SetRemovalTimeToHistoricProcessInstancesBuilder)Mockito.verify((Object)builder)).byIds(new String[]{"aProcessInstanceId"});
        ((SetRemovalTimeToHistoricProcessInstancesBuilder)Mockito.verify((Object)builder)).byQuery(null);
        ((SetRemovalTimeToHistoricProcessInstancesBuilder)Mockito.verify((Object)builder)).executeAsync();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{builder});
    }

    @Test
    public void shouldClearRemovalTime() {
        SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder builderMock = (SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder)Mockito.mock(SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.historyServiceMock.setRemovalTimeToHistoricProcessInstances()).thenReturn((Object)builderMock);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("historicProcessInstanceIds", Collections.singletonList("aProcessInstanceId"));
        payload.put("clearedRemovalTime", true);
        RestAssured.given().contentType(ContentType.JSON).body(payload).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(SET_REMOVAL_TIME_HISTORIC_PROCESS_INSTANCES_ASYNC_URL, new Object[0]);
        SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder builder = this.historyServiceMock.setRemovalTimeToHistoricProcessInstances();
        ((SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder)Mockito.verify((Object)builder)).clearedRemovalTime();
        ((SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder)Mockito.verify((Object)builder)).byIds(new String[]{"aProcessInstanceId"});
        ((SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder)Mockito.verify((Object)builder)).byQuery(null);
        ((SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder)Mockito.verify((Object)builder)).executeAsync();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{builder});
    }

    @Test
    public void shouldSetRemovalTime_Response() {
        SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder builderMock = (SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder)Mockito.mock(SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.historyServiceMock.setRemovalTimeToHistoricProcessInstances()).thenReturn((Object)builderMock);
        Batch batchEntity = MockProvider.createMockBatch();
        Mockito.when((Object)builderMock.executeAsync()).thenReturn((Object)batchEntity);
        Response response = (Response)RestAssured.given().contentType(ContentType.JSON).body(Collections.emptyMap()).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(SET_REMOVAL_TIME_HISTORIC_PROCESS_INSTANCES_ASYNC_URL, new Object[0]);
        this.verifyBatchJson(response.asString());
    }

    @Test
    public void shouldSetRemovalTime_ThrowBadUserException() {
        SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder builderMock = (SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder)Mockito.mock(SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.historyServiceMock.setRemovalTimeToHistoricProcessInstances()).thenReturn((Object)builderMock);
        ((SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder)Mockito.doThrow(BadUserRequestException.class).when((Object)builderMock)).executeAsync();
        RestAssured.given().contentType(ContentType.JSON).body(Collections.emptyMap()).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(SET_REMOVAL_TIME_HISTORIC_PROCESS_INSTANCES_ASYNC_URL, new Object[0]);
    }

    @Test
    public void testOrQuery() {
        HistoricProcessInstanceQueryImpl mockedQuery = (HistoricProcessInstanceQueryImpl)Mockito.mock(HistoricProcessInstanceQueryImpl.class);
        Mockito.when((Object)this.historyServiceMock.createHistoricProcessInstanceQuery()).thenReturn((Object)mockedQuery);
        String payload = "{ \"orQueries\": [{\"processDefinitionKey\": \"aKey\", \"processInstanceBusinessKey\": \"aBusinessKey\"}] }";
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).header(ACCEPT_JSON_HEADER).body(payload).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_URL, new Object[0]);
        ArgumentCaptor argument = ArgumentCaptor.forClass(HistoricProcessInstanceQueryImpl.class);
        ((HistoricProcessInstanceQueryImpl)Mockito.verify((Object)mockedQuery)).addOrQuery((HistoricProcessInstanceQueryImpl)argument.capture());
        Assertions.assertThat((String)((HistoricProcessInstanceQueryImpl)argument.getValue()).getProcessDefinitionKey()).isEqualTo((Object)"aKey");
        Assertions.assertThat((String)((HistoricProcessInstanceQueryImpl)argument.getValue()).getBusinessKey()).isEqualTo((Object)"aBusinessKey");
    }

    protected void verifyBatchJson(String batchJson) {
        BatchDto batch = (BatchDto)JsonPathUtil.from(batchJson).getObject("", BatchDto.class);
        Assert.assertNotNull((String)"The returned batch should not be null.", (Object)batch);
        Assert.assertEquals((Object)"aBatchId", (Object)batch.getId());
        Assert.assertEquals((Object)"aBatchType", (Object)batch.getType());
        Assert.assertEquals((long)10L, (long)batch.getTotalJobs());
        Assert.assertEquals((long)11L, (long)batch.getBatchJobsPerSeed());
        Assert.assertEquals((long)12L, (long)batch.getInvocationsPerBatchJob());
        Assert.assertEquals((Object)"aSeedJobDefinitionId", (Object)batch.getSeedJobDefinitionId());
        Assert.assertEquals((Object)"aMonitorJobDefinitionId", (Object)batch.getMonitorJobDefinitionId());
        Assert.assertEquals((Object)"aBatchJobDefinitionId", (Object)batch.getBatchJobDefinitionId());
        Assert.assertEquals((Object)"aTenantId", (Object)batch.getTenantId());
    }
}

