/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockHistoricVariableInstanceBuilder;
import org.camunda.bpm.engine.rest.helper.MockObjectValue;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.helper.VariableTypeHelper;
import org.camunda.bpm.engine.rest.util.OrderingBuilder;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.SerializationDataFormat;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class HistoricVariableInstanceRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL = "/rest-test/history/variable-instance";
    protected static final String HISTORIC_VARIABLE_INSTANCE_COUNT_RESOURCE_URL = "/rest-test/history/variable-instance/count";
    protected HistoricVariableInstanceQuery mockedQuery;
    protected HistoricVariableInstance mockInstance;
    protected MockHistoricVariableInstanceBuilder mockInstanceBuilder;

    @Before
    public void setUpRuntimeData() {
        this.mockInstanceBuilder = MockProvider.mockHistoricVariableInstance();
        this.mockInstance = this.mockInstanceBuilder.build();
        ArrayList<HistoricVariableInstance> mocks = new ArrayList<HistoricVariableInstance>();
        mocks.add(this.mockInstance);
        this.mockedQuery = this.setUpMockHistoricVariableInstanceQuery(mocks);
    }

    private HistoricVariableInstanceQuery setUpMockHistoricVariableInstanceQuery(List<HistoricVariableInstance> mockedHistoricVariableInstances) {
        HistoricVariableInstanceQuery mockedHistoricVariableInstanceQuery = (HistoricVariableInstanceQuery)Mockito.mock(HistoricVariableInstanceQuery.class);
        Mockito.when((Object)mockedHistoricVariableInstanceQuery.list()).thenReturn(mockedHistoricVariableInstances);
        Mockito.when((Object)mockedHistoricVariableInstanceQuery.count()).thenReturn((Object)mockedHistoricVariableInstances.size());
        Mockito.when((Object)processEngine.getHistoryService().createHistoricVariableInstanceQuery()).thenReturn((Object)mockedHistoricVariableInstanceQuery);
        return mockedHistoricVariableInstanceQuery;
    }

    @Test
    public void testEmptyQuery() {
        String queryKey = "";
        RestAssured.given().queryParam("processInstanceId", new Object[]{queryKey}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testNoParametersQuery() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testNoParametersQueryDisableObjectDeserialization() {
        RestAssured.given().queryParam("deserializeValues", new Object[]{false}).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableCustomObjectDeserialization();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testNoParametersQueryAsPost() {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testNoParametersQueryAsPostDisableObjectDeserialization() {
        RestAssured.given().queryParam("deserializeValues", new Object[]{false}).contentType(POST_JSON_CONTENT_TYPE).body("{}").expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableCustomObjectDeserialization();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testInvalidSortingOptions() {
        this.executeAndVerifySorting("anInvalidSortByOption", "asc", Response.Status.BAD_REQUEST);
        this.executeAndVerifySorting("instanceId", "anInvalidSortOrderOption", Response.Status.BAD_REQUEST);
    }

    protected void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"instanceId"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSortingParameters() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("instanceId", "asc", Response.Status.OK);
        ((HistoricVariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceId();
        ((HistoricVariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("variableName", "desc", Response.Status.OK);
        ((HistoricVariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByVariableName();
        ((HistoricVariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "asc", Response.Status.OK);
        ((HistoricVariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((HistoricVariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "desc", Response.Status.OK);
        ((HistoricVariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((HistoricVariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
    }

    @Test
    public void testSecondarySortingAsPost() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        HashMap<String, List<Map<String, Object>>> json = new HashMap<String, List<Map<String, Object>>>();
        json.put("sorting", OrderingBuilder.create().orderBy("instanceId").desc().orderBy("variableName").asc().getJson());
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceId();
        ((HistoricVariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        ((HistoricVariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByVariableName();
        ((HistoricVariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
    }

    @Test
    public void testSuccessfulPagination() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, maxResults);
    }

    @Test
    public void testMissingFirstResultParameter() {
        int maxResults = 10;
        RestAssured.given().queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(0, maxResults);
    }

    @Test
    public void testMissingMaxResultsParameter() {
        int firstResult = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, Integer.MAX_VALUE);
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", CoreMatchers.equalTo((Object)1), new Object[0]).when().get(HISTORIC_VARIABLE_INSTANCE_COUNT_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testQueryCountForPost() {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").expect().body("count", CoreMatchers.equalTo((Object)1), new Object[0]).when().post(HISTORIC_VARIABLE_INSTANCE_COUNT_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testVariableNameLikeQuery() {
        String variableNameLike = "aVariableNameLike";
        RestAssured.given().queryParam("variableNameLike", new Object[]{variableNameLike}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricVariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).variableNameLike(variableNameLike);
        ((HistoricVariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testVariableNameLikeQueryIgnoreCase() {
        String variableNameLike = "aVariableNameLike";
        RestAssured.given().queryParam("variableNameLike", new Object[]{variableNameLike}).queryParam("variableNamesIgnoreCase", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableNameLike(variableNameLike);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableNamesIgnoreCase();
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testHistoricVariableQueryByVariableTypeIn() {
        String aVariableType = "string";
        String anotherVariableType = "integer";
        RestAssured.given().queryParam("variableTypeIn", new Object[]{aVariableType + "," + anotherVariableType}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableTypeIn(new String[]{aVariableType, anotherVariableType});
    }

    @Test
    public void testHistoricVariableQueryByVariableTypeInAsPost() {
        String aVariableType = "string";
        String anotherVariableType = "integer";
        ArrayList<String> variableTypeIn = new ArrayList<String>();
        variableTypeIn.add(aVariableType);
        variableTypeIn.add(anotherVariableType);
        HashMap<String, ArrayList<String>> json = new HashMap<String, ArrayList<String>>();
        json.put("variableTypeIn", variableTypeIn);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableTypeIn(new String[]{aVariableType, anotherVariableType});
    }

    @Test
    public void testSimpleHistoricVariableQuery() {
        String processInstanceId = "aProcInstId";
        RestAssured.given().queryParam("processInstanceId", new Object[]{processInstanceId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).and().body("size()", Matchers.is((Object)1), new Object[0]).body("[0].id", CoreMatchers.equalTo((Object)this.mockInstanceBuilder.getId()), new Object[0]).body("[0].name", CoreMatchers.equalTo((Object)this.mockInstanceBuilder.getName()), new Object[0]).body("[0].type", CoreMatchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName(this.mockInstanceBuilder.getTypedValue().getType())), new Object[0]).body("[0].value", CoreMatchers.equalTo((Object)this.mockInstanceBuilder.getValue()), new Object[0]).body("[0].processDefinitionKey", CoreMatchers.equalTo((Object)this.mockInstanceBuilder.getProcessDefinitionKey()), new Object[0]).body("[0].processDefinitionId", CoreMatchers.equalTo((Object)this.mockInstanceBuilder.getProcessDefinitionId()), new Object[0]).body("[0].processInstanceId", CoreMatchers.equalTo((Object)this.mockInstanceBuilder.getProcessInstanceId()), new Object[0]).body("[0].executionId", CoreMatchers.equalTo((Object)this.mockInstanceBuilder.getExecutionId()), new Object[0]).body("[0].errorMessage", CoreMatchers.equalTo((Object)this.mockInstanceBuilder.getErrorMessage()), new Object[0]).body("[0].activityInstanceId", CoreMatchers.equalTo((Object)this.mockInstanceBuilder.getActivityInstanceId()), new Object[0]).body("[0].caseDefinitionKey", CoreMatchers.equalTo((Object)this.mockInstanceBuilder.getCaseDefinitionKey()), new Object[0]).body("[0].caseDefinitionId", CoreMatchers.equalTo((Object)this.mockInstanceBuilder.getCaseDefinitionId()), new Object[0]).body("[0].caseInstanceId", CoreMatchers.equalTo((Object)this.mockInstanceBuilder.getCaseInstanceId()), new Object[0]).body("[0].caseExecutionId", CoreMatchers.equalTo((Object)this.mockInstanceBuilder.getCaseExecutionId()), new Object[0]).body("[0].taskId", CoreMatchers.equalTo((Object)this.mockInstanceBuilder.getTaskId()), new Object[0]).body("[0].tenantId", CoreMatchers.equalTo((Object)this.mockInstanceBuilder.getTenantId()), new Object[0]).body("[0].createTime", CoreMatchers.equalTo((Object)MockProvider.EXAMPLE_HISTORIC_VARIABLE_INSTANCE_CREATE_TIME), new Object[0]).body("[0].removalTime", CoreMatchers.equalTo((Object)MockProvider.EXAMPLE_HISTORIC_VARIABLE_INSTANCE_REMOVAL_TIME), new Object[0]).body("[0].rootProcessInstanceId", CoreMatchers.equalTo((Object)this.mockInstanceBuilder.getRootProcessInstanceId()), new Object[0]).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricVariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).processInstanceId(processInstanceId);
        ((HistoricVariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testSerializableVariableInstanceRetrieval() {
        MockHistoricVariableInstanceBuilder builder = MockProvider.mockHistoricVariableInstance().typedValue((TypedValue)MockObjectValue.fromObjectValue((ObjectValue)Variables.objectValue((Object)"a serialized value").serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).create()).objectTypeName(String.class.getName()));
        ArrayList<HistoricVariableInstance> mockInstances = new ArrayList<HistoricVariableInstance>();
        mockInstances.add(builder.build());
        this.mockedQuery = this.setUpMockHistoricVariableInstanceQuery(mockInstances);
        RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).and().body("[0].type", CoreMatchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName((ValueType)ValueType.OBJECT)), new Object[0]).body("[0].value", CoreMatchers.equalTo((Object)"a serialized value"), new Object[0]).body("[0].valueInfo.objectTypeName", CoreMatchers.equalTo((Object)String.class.getName()), new Object[0]).body("[0].valueInfo.serializationDataFormat", CoreMatchers.equalTo((Object)Variables.SerializationDataFormats.JAVA.getName()), new Object[0]).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testSpinVariableInstanceRetrieval() {
        MockHistoricVariableInstanceBuilder builder = MockProvider.mockHistoricVariableInstance().typedValue(Variables.serializedObjectValue((String)"aSpinSerializedValue").serializationDataFormat("aDataFormat").objectTypeName("aRootType").create());
        ArrayList<HistoricVariableInstance> mockInstances = new ArrayList<HistoricVariableInstance>();
        mockInstances.add(builder.build());
        this.mockedQuery = this.setUpMockHistoricVariableInstanceQuery(mockInstances);
        RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).and().body("size()", Matchers.is((Object)1), new Object[0]).body("[0].type", CoreMatchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName((ValueType)ValueType.OBJECT)), new Object[0]).body("[0].value", CoreMatchers.equalTo((Object)"aSpinSerializedValue"), new Object[0]).body("[0].valueInfo.objectTypeName", CoreMatchers.equalTo((Object)"aRootType"), new Object[0]).body("[0].valueInfo.serializationDataFormat", CoreMatchers.equalTo((Object)"aDataFormat"), new Object[0]).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testAdditionalParametersExcludingVariables() {
        Map<String, String> stringQueryParameters = this.getCompleteStringQueryParameters();
        RestAssured.given().queryParams(stringQueryParameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyStringParameterQueryInvocations();
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    private Map<String, String> getCompleteStringQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("processInstanceId", "aVariableInstanceProcInstId");
        parameters.put("variableName", "aVariableInstanceName");
        parameters.put("variableValue", (String)MockProvider.EXAMPLE_PRIMITIVE_VARIABLE_VALUE.getValue());
        return parameters;
    }

    private void verifyStringParameterQueryInvocations() {
        Map<String, String> stringQueryParameters = this.getCompleteStringQueryParameters();
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceId(stringQueryParameters.get("processInstanceId"));
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableName(stringQueryParameters.get("variableName"));
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(stringQueryParameters.get("variableName"), (Object)stringQueryParameters.get("variableValue"));
    }

    @Test
    public void testVariableNameAndValueQuery() {
        String variableName = "aVariableInstanceName";
        String variableValue = (String)MockProvider.EXAMPLE_PRIMITIVE_VARIABLE_VALUE.getValue();
        RestAssured.given().queryParam("variableName", new Object[]{variableName}).queryParam("variableValue", new Object[]{variableValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).and().body("size()", Matchers.is((Object)1), new Object[0]).body("[0].name", CoreMatchers.equalTo((Object)"aVariableInstanceName"), new Object[0]).body("[0].value", CoreMatchers.equalTo((Object)MockProvider.EXAMPLE_PRIMITIVE_VARIABLE_VALUE.getValue()), new Object[0]).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricVariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).variableValueEquals(variableName, (Object)variableValue);
        ((HistoricVariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testVariableNameAndValueIgnoreCaseQuery() {
        String variableName = "aVariableInstanceName";
        String variableValue = (String)MockProvider.EXAMPLE_PRIMITIVE_VARIABLE_VALUE.getValue();
        RestAssured.given().queryParam("variableName", new Object[]{variableName}).queryParam("variableNamesIgnoreCase", new Object[]{true}).queryParam("variableValue", new Object[]{variableValue}).queryParam("variableValuesIgnoreCase", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).and().body("size()", Matchers.is((Object)1), new Object[0]).body("[0].name", CoreMatchers.equalTo((Object)"aVariableInstanceName"), new Object[0]).body("[0].value", CoreMatchers.equalTo((Object)MockProvider.EXAMPLE_PRIMITIVE_VARIABLE_VALUE.getValue()), new Object[0]).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName, (Object)variableValue);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableNamesIgnoreCase();
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableValuesIgnoreCase();
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testVariableValueQuery_BadRequest() {
        RestAssured.given().queryParam("variableValue", new Object[]{MockProvider.EXAMPLE_PRIMITIVE_VARIABLE_VALUE}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Only a single variable value parameter specified: variable name and value are required to be able to query after a specific variable value."), new Object[0]).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testHistoricVariableQueryByExecutionIdsAndTaskIds() {
        String anExecutionId = "anExecutionId";
        String anotherExecutionId = "anotherExecutionId";
        String aTaskId = "aTaskId";
        String anotherTaskId = "anotherTaskId";
        RestAssured.given().queryParam("executionIdIn", new Object[]{anExecutionId + "," + anotherExecutionId}).queryParam("taskIdIn", new Object[]{aTaskId + "," + anotherTaskId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).executionIdIn(new String[]{anExecutionId, anotherExecutionId});
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskIdIn(new String[]{aTaskId, anotherTaskId});
    }

    @Test
    public void testHistoricVariableQueryByExecutionIdsAndTaskIdsAsPost() {
        String anExecutionId = "anExecutionId";
        String anotherExecutionId = "anotherExecutionId";
        ArrayList<String> executionIdIn = new ArrayList<String>();
        executionIdIn.add(anExecutionId);
        executionIdIn.add(anotherExecutionId);
        String aTaskId = "aTaskId";
        String anotherTaskId = "anotherTaskId";
        ArrayList<String> taskIdIn = new ArrayList<String>();
        taskIdIn.add(aTaskId);
        taskIdIn.add(anotherTaskId);
        HashMap<String, ArrayList<String>> json = new HashMap<String, ArrayList<String>>();
        json.put("executionIdIn", executionIdIn);
        json.put("taskIdIn", taskIdIn);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).executionIdIn(new String[]{anExecutionId, anotherExecutionId});
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskIdIn(new String[]{aTaskId, anotherTaskId});
    }

    @Test
    public void testHistoricVariableQueryByProcessInstanceIdIn() {
        String aProcessInstanceId = "aProcessInstanceId";
        String anotherProcessInstanceId = "anotherProcessInstanceId";
        RestAssured.given().queryParam("processInstanceIdIn", new Object[]{aProcessInstanceId + "," + anotherProcessInstanceId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceIdIn(new String[]{aProcessInstanceId, anotherProcessInstanceId});
    }

    @Test
    public void testHistoricVariableQueryByProcessInstanceIdInAsPOST() {
        String aProcessInstanceId = "aProcessInstanceId";
        String anotherProcessInstanceId = "anotherProcessInstanceId";
        ArrayList<String> processInstanceIdIn = new ArrayList<String>();
        processInstanceIdIn.add(aProcessInstanceId);
        processInstanceIdIn.add(anotherProcessInstanceId);
        processInstanceIdIn.add(null);
        HashMap<String, ArrayList<String>> json = new HashMap<String, ArrayList<String>>();
        json.put("processInstanceIdIn", processInstanceIdIn);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceIdIn(new String[]{aProcessInstanceId, anotherProcessInstanceId, null});
    }

    @Test
    public void testHistoricVariableQueryByActivityInstanceIds() {
        String anActivityInstanceId = "anActivityInstanceId";
        String anotherActivityInstanceId = "anotherActivityInstanceId";
        RestAssured.given().queryParam("activityInstanceIdIn", new Object[]{anActivityInstanceId + "," + anotherActivityInstanceId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).activityInstanceIdIn(new String[]{anActivityInstanceId, anotherActivityInstanceId});
    }

    @Test
    public void testHistoricVariableQueryByActivityInstanceIdsAsPost() {
        String anActivityInstanceId = "anActivityInstanceId";
        String anotherActivityInstanceId = "anotherActivityInstanceId";
        ArrayList<String> activityInstanceIdIn = new ArrayList<String>();
        activityInstanceIdIn.add(anActivityInstanceId);
        activityInstanceIdIn.add(anotherActivityInstanceId);
        HashMap<String, ArrayList<String>> json = new HashMap<String, ArrayList<String>>();
        json.put("activityInstanceIdIn", activityInstanceIdIn);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).activityInstanceIdIn(new String[]{anActivityInstanceId, anotherActivityInstanceId});
    }

    @Test
    public void testHistoricVariableQueryByCaseInstanceId() {
        RestAssured.given().queryParam("caseInstanceId", new Object[]{"aCaseInstId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceId("aCaseInstId");
    }

    @Test
    public void testHistoricVariableQueryByCaseInstanceIdAsPost() {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("caseInstanceId", "aCaseInstId");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceId("aCaseInstId");
    }

    @Test
    public void testHistoricVariableQueryByCaseExecutionIds() {
        String caseExecutionIds = "aCaseExecutionId,anotherCaseExecutionId";
        RestAssured.given().queryParam("caseExecutionIdIn", new Object[]{caseExecutionIds}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseExecutionIdIn(new String[]{"aCaseExecutionId", "anotherCaseExecutionId"});
    }

    @Test
    public void testHistoricVariableQueryByCaseExecutionIdsAsPost() {
        HashMap<String, List<String>> json = new HashMap<String, List<String>>();
        json.put("caseExecutionIdIn", Arrays.asList("aCaseExecutionId", "anotherCaseExecutionId"));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseExecutionIdIn(new String[]{"aCaseExecutionId", "anotherCaseExecutionId"});
    }

    @Test
    public void testTenantIdListParameter() {
        this.mockedQuery = this.setUpMockHistoricVariableInstanceQuery(this.createMockHistoricVariableInstancesTwoTenants());
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId,anotherTenantId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List executions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)executions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testTenantIdListPostParameter() {
        this.mockedQuery = this.setUpMockHistoricVariableInstanceQuery(this.createMockHistoricVariableInstancesTwoTenants());
        HashMap<String, String[]> queryParameters = new HashMap<String, String[]>();
        queryParameters.put("tenantIdIn", "aTenantId,anotherTenantId".split(","));
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List executions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)executions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testQueryFilterWithoutTenantIdParameter() {
        HistoricVariableInstance historicVariableInstance = MockProvider.mockHistoricVariableInstance(null).build();
        this.mockedQuery = this.setUpMockHistoricVariableInstanceQuery(Collections.singletonList(historicVariableInstance));
        Response response = (Response)RestAssured.given().queryParam("withoutTenantId", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).withoutTenantId();
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(1);
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        Assertions.assertThat((String)returnedTenantId).isEqualTo(null);
    }

    @Test
    public void testQueryFilterWithoutTenantIdPostParameter() {
        HistoricVariableInstance historicVariableInstance = MockProvider.mockHistoricVariableInstance(null).build();
        this.mockedQuery = this.setUpMockHistoricVariableInstanceQuery(Collections.singletonList(historicVariableInstance));
        Map<String, Boolean> queryParameters = Collections.singletonMap("withoutTenantId", true);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).withoutTenantId();
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(1);
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        Assertions.assertThat((String)returnedTenantId).isEqualTo(null);
    }

    @Test
    public void testHistoricVariableQueryByCaseActivityIds() {
        String caseExecutionIds = "aCaseActivityId,anotherCaseActivityId";
        RestAssured.given().queryParam("caseActivityIdIn", new Object[]{caseExecutionIds}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseActivityIdIn(new String[]{"aCaseActivityId", "anotherCaseActivityId"});
    }

    @Test
    public void testHistoricVariableQueryByCaseActivityIdsAsPost() {
        HashMap<String, List<String>> json = new HashMap<String, List<String>>();
        json.put("caseActivityIdIn", Arrays.asList("aCaseActivityId", "anotherCaseActivityId"));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseActivityIdIn(new String[]{"aCaseActivityId", "anotherCaseActivityId"});
    }

    @Test
    public void testIncludeDeletedVariables() {
        Mockito.when((Object)this.mockedQuery.includeDeleted()).thenReturn((Object)this.mockedQuery);
        RestAssured.given().queryParam("includeDeleted", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).includeDeleted();
    }

    @Test
    public void testHistoricVariableQueryByProcessDefinitionIdAsPost() {
        Mockito.when((Object)this.mockedQuery.processDefinitionId(org.mockito.Matchers.anyString())).thenReturn((Object)this.mockedQuery);
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("processDefinitionId", "aProcDefId");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionId("aProcDefId");
    }

    @Test
    public void testHistoricVariableQueryByProcessDefinitionId() {
        Mockito.when((Object)this.mockedQuery.processDefinitionId(org.mockito.Matchers.anyString())).thenReturn((Object)this.mockedQuery);
        RestAssured.given().queryParameter("processDefinitionId", new Object[]{"aProcDefId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionId("aProcDefId");
    }

    @Test
    public void testHistoricVariableQueryByProcessDefinitionKeyAsPost() {
        Mockito.when((Object)this.mockedQuery.processDefinitionKey(org.mockito.Matchers.anyString())).thenReturn((Object)this.mockedQuery);
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("processDefinitionKey", "aKey");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionKey("aKey");
    }

    @Test
    public void testHistoricVariableQueryByProcessDefinitionKey() {
        Mockito.when((Object)this.mockedQuery.processDefinitionKey(org.mockito.Matchers.anyString())).thenReturn((Object)this.mockedQuery);
        RestAssured.given().queryParameter("processDefinitionKey", new Object[]{"aKey"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionKey("aKey");
    }

    private List<HistoricVariableInstance> createMockHistoricVariableInstancesTwoTenants() {
        return Arrays.asList(MockProvider.mockHistoricVariableInstance("aTenantId").build(), MockProvider.mockHistoricVariableInstance("anotherTenantId").build());
    }

    @Test
    public void testHistoricVariableQueryByVariableNameAndValueIgnoreCaseAsPost() {
        Mockito.when((Object)this.mockedQuery.processDefinitionKey(org.mockito.Matchers.anyString())).thenReturn((Object)this.mockedQuery);
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("variableName", "aVariableName");
        json.put("variableValue", "aVariableValue");
        json.put("variableNamesIgnoreCase", true);
        json.put("variableValuesIgnoreCase", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableNamesIgnoreCase();
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableValuesIgnoreCase();
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableName("aVariableName");
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals("aVariableName", (Object)"aVariableValue");
    }

    @Test
    public void testHistoricVariableQueryByVariableNameLikeIgnoreCaseAsPost() {
        Mockito.when((Object)this.mockedQuery.processDefinitionKey(org.mockito.Matchers.anyString())).thenReturn((Object)this.mockedQuery);
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("variableNameLike", "aVariableName");
        json.put("variableNamesIgnoreCase", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableNamesIgnoreCase();
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableNameLike("aVariableName");
    }
}

