/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.filter;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class EmptyBodyFilter
implements Filter {
    protected static final Pattern CONTENT_TYPE_JSON_PATTERN = Pattern.compile("^application\\/json((;)(.*)?)?$", 2);

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        boolean isContentTypeJson = CONTENT_TYPE_JSON_PATTERN.matcher(req.getContentType() == null ? "" : req.getContentType()).find();
        if (isContentTypeJson) {
            final PushbackInputStream requestBody = new PushbackInputStream((InputStream)req.getInputStream());
            int firstByte = requestBody.read();
            final boolean isBodyEmpty = firstByte == -1;
            requestBody.unread(firstByte);
            HttpServletRequestWrapper wrappedRequest = new HttpServletRequestWrapper((HttpServletRequest)req){

                public ServletInputStream getInputStream() throws IOException {
                    return new ServletInputStream(){
                        InputStream inputStream;
                        {
                            this.inputStream = isBodyEmpty ? new ByteArrayInputStream("{}".getBytes(Charset.forName("UTF-8"))) : requestBody;
                        }

                        public int read() throws IOException {
                            return this.inputStream.read();
                        }

                        public int available() throws IOException {
                            return this.inputStream.available();
                        }

                        public void close() throws IOException {
                            this.inputStream.close();
                        }

                        public synchronized void mark(int readlimit) {
                            this.inputStream.mark(readlimit);
                        }

                        public synchronized void reset() throws IOException {
                            this.inputStream.reset();
                        }

                        public boolean markSupported() {
                            return this.inputStream.markSupported();
                        }
                    };
                }

                public BufferedReader getReader() throws IOException {
                    return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
                }
            };
            chain.doFilter((ServletRequest)wrappedRequest, resp);
        } else {
            chain.doFilter(req, resp);
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

