/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.repository.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.dmn.engine.DmnDecisionResult;
import org.camunda.bpm.dmn.engine.DmnDecisionResultEntries;
import org.camunda.bpm.dmn.engine.DmnEngineException;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.rest.dto.HistoryTimeToLiveDto;
import org.camunda.bpm.engine.rest.dto.VariableValueDto;
import org.camunda.bpm.engine.rest.dto.dmn.EvaluateDecisionDto;
import org.camunda.bpm.engine.rest.dto.repository.DecisionDefinitionDiagramDto;
import org.camunda.bpm.engine.rest.dto.repository.DecisionDefinitionDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.sub.repository.DecisionDefinitionResource;
import org.camunda.bpm.engine.rest.sub.repository.impl.ProcessDefinitionResourceImpl;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class DecisionDefinitionResourceImpl
implements DecisionDefinitionResource {
    protected ProcessEngine engine;
    protected String decisionDefinitionId;
    protected String rootResourcePath;
    protected ObjectMapper objectMapper;

    public DecisionDefinitionResourceImpl(ProcessEngine engine, String decisionDefinitionId, String rootResourcePath, ObjectMapper objectMapper) {
        this.engine = engine;
        this.decisionDefinitionId = decisionDefinitionId;
        this.rootResourcePath = rootResourcePath;
        this.objectMapper = objectMapper;
    }

    @Override
    public DecisionDefinitionDto getDecisionDefinition() {
        RepositoryService repositoryService = this.engine.getRepositoryService();
        DecisionDefinition definition = null;
        try {
            definition = repositoryService.getDecisionDefinition(this.decisionDefinitionId);
        }
        catch (NotFoundException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, (Exception)((Object)e), e.getMessage());
        }
        catch (NotValidException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), e.getMessage());
        }
        catch (ProcessEngineException e) {
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e));
        }
        return DecisionDefinitionDto.fromDecisionDefinition(definition);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DecisionDefinitionDiagramDto getDecisionDefinitionDmnXml() {
        DecisionDefinitionDiagramDto decisionDefinitionDiagramDto;
        InputStream decisionModelInputStream = null;
        try {
            decisionModelInputStream = this.engine.getRepositoryService().getDecisionModel(this.decisionDefinitionId);
            byte[] decisionModel = IoUtil.readInputStream((InputStream)decisionModelInputStream, (String)"decisionModelDmnXml");
            decisionDefinitionDiagramDto = DecisionDefinitionDiagramDto.create(this.decisionDefinitionId, new String(decisionModel, "UTF-8"));
        }
        catch (NotFoundException e) {
            try {
                throw new InvalidRequestException(Response.Status.NOT_FOUND, (Exception)((Object)e), e.getMessage());
                catch (NotValidException e2) {
                    throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e2), e2.getMessage());
                }
                catch (ProcessEngineException e3) {
                    throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e3));
                }
                catch (UnsupportedEncodingException e4) {
                    throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e4);
                }
            }
            catch (Throwable throwable) {
                IoUtil.closeSilently(decisionModelInputStream);
                throw throwable;
            }
        }
        IoUtil.closeSilently((Closeable)decisionModelInputStream);
        return decisionDefinitionDiagramDto;
    }

    @Override
    public Response getDecisionDefinitionDiagram() {
        DecisionDefinition definition = this.engine.getRepositoryService().getDecisionDefinition(this.decisionDefinitionId);
        InputStream decisionDiagram = this.engine.getRepositoryService().getDecisionDiagram(this.decisionDefinitionId);
        if (decisionDiagram == null) {
            return Response.noContent().build();
        }
        String fileName = definition.getDiagramResourceName();
        return Response.ok((Object)decisionDiagram).header("Content-Disposition", (Object)("attachment; filename=\"" + fileName + "\"")).type(ProcessDefinitionResourceImpl.getMediaTypeForFileSuffix(fileName)).build();
    }

    @Override
    public List<Map<String, VariableValueDto>> evaluateDecision(UriInfo context, EvaluateDecisionDto parameters) {
        DecisionService decisionService = this.engine.getDecisionService();
        VariableMap variables = VariableValueDto.toMap(parameters.getVariables(), this.engine, this.objectMapper);
        try {
            DmnDecisionResult decisionResult = decisionService.evaluateDecisionById(this.decisionDefinitionId).variables((Map)variables).evaluate();
            return this.createDecisionResultDto(decisionResult);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (NotFoundException e) {
            String errorMessage = String.format("Cannot evaluate decision %s: %s", this.decisionDefinitionId, e.getMessage());
            throw new InvalidRequestException(Response.Status.NOT_FOUND, (Exception)((Object)e), errorMessage);
        }
        catch (NotValidException e) {
            String errorMessage = String.format("Cannot evaluate decision %s: %s", this.decisionDefinitionId, e.getMessage());
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), errorMessage);
        }
        catch (ProcessEngineException e) {
            String errorMessage = String.format("Cannot evaluate decision %s: %s", this.decisionDefinitionId, e.getMessage());
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), errorMessage);
        }
        catch (DmnEngineException e) {
            String errorMessage = String.format("Cannot evaluate decision %s: %s", this.decisionDefinitionId, e.getMessage());
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), errorMessage);
        }
    }

    @Override
    public void updateHistoryTimeToLive(HistoryTimeToLiveDto historyTimeToLiveDto) {
        this.engine.getRepositoryService().updateDecisionDefinitionHistoryTimeToLive(this.decisionDefinitionId, historyTimeToLiveDto.getHistoryTimeToLive());
    }

    protected List<Map<String, VariableValueDto>> createDecisionResultDto(DmnDecisionResult decisionResult) {
        ArrayList<Map<String, VariableValueDto>> dto = new ArrayList<Map<String, VariableValueDto>>();
        for (DmnDecisionResultEntries entries : decisionResult) {
            Map<String, VariableValueDto> resultEntriesDto = this.createResultEntriesDto(entries);
            dto.add(resultEntriesDto);
        }
        return dto;
    }

    protected Map<String, VariableValueDto> createResultEntriesDto(DmnDecisionResultEntries entries) {
        VariableMap variableMap = Variables.createVariables();
        for (String key : entries.keySet()) {
            TypedValue typedValue = entries.getEntryTyped(key);
            variableMap.putValueTyped(key, typedValue);
        }
        return VariableValueDto.fromMap(variableMap);
    }
}

