/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.metrics;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.management.MetricsQuery;
import org.camunda.bpm.engine.rest.dto.converter.DateConverter;
import org.camunda.bpm.engine.rest.dto.metrics.MetricsResultDto;
import org.camunda.bpm.engine.rest.sub.metrics.MetricsResource;

public class MetricsResourceImpl
implements MetricsResource {
    protected String metricsName;
    protected ProcessEngine processEngine;
    protected ObjectMapper objectMapper;

    public MetricsResourceImpl(String metricsName, ProcessEngine processEngine, ObjectMapper objectMapper) {
        this.metricsName = metricsName;
        this.processEngine = processEngine;
        this.objectMapper = objectMapper;
    }

    @Override
    public MetricsResultDto sum(UriInfo uriInfo) {
        MultivaluedMap queryParameters = uriInfo.getQueryParameters();
        DateConverter dateConverter = new DateConverter();
        dateConverter.setObjectMapper(this.objectMapper);
        Long result = null;
        if ("unique-task-workers".equals(this.metricsName)) {
            result = this.processEngine.getManagementService().getUniqueTaskWorkerCount(this.extractStartDate((MultivaluedMap<String, String>)queryParameters, dateConverter), this.extractEndDate((MultivaluedMap<String, String>)queryParameters, dateConverter));
        } else {
            MetricsQuery query = this.processEngine.getManagementService().createMetricsQuery().name(this.metricsName);
            this.applyQueryParams((MultivaluedMap<String, String>)queryParameters, dateConverter, query);
            result = query.sum();
        }
        return new MetricsResultDto(result);
    }

    protected void applyQueryParams(MultivaluedMap<String, String> queryParameters, DateConverter dateConverter, MetricsQuery query) {
        Date startDate = this.extractStartDate(queryParameters, dateConverter);
        Date endDate = this.extractEndDate(queryParameters, dateConverter);
        if (startDate != null) {
            query.startDate(startDate);
        }
        if (endDate != null) {
            query.endDate(endDate);
        }
    }

    protected Date extractEndDate(MultivaluedMap<String, String> queryParameters, DateConverter dateConverter) {
        if (queryParameters.getFirst((Object)"endDate") != null) {
            return dateConverter.convertQueryParameterToType((String)queryParameters.getFirst((Object)"endDate"));
        }
        return null;
    }

    protected Date extractStartDate(MultivaluedMap<String, String> queryParameters, DateConverter dateConverter) {
        if (queryParameters.getFirst((Object)"startDate") != null) {
            return dateConverter.convertQueryParameterToType((String)queryParameters.getFirst((Object)"startDate"));
        }
        return null;
    }
}

