/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.management.SchemaLogEntry;
import org.camunda.bpm.engine.management.SchemaLogQuery;
import org.camunda.bpm.engine.rest.SchemaLogRestService;
import org.camunda.bpm.engine.rest.dto.SchemaLogEntryDto;
import org.camunda.bpm.engine.rest.dto.SchemaLogQueryDto;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;

public class SchemaLogRestServiceImpl
extends AbstractRestProcessEngineAware
implements SchemaLogRestService {
    public SchemaLogRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public List<SchemaLogEntryDto> getSchemaLog(Request request, UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        return this.querySchemaLog(new SchemaLogQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters()), firstResult, maxResults);
    }

    @Override
    public List<SchemaLogEntryDto> querySchemaLog(SchemaLogQueryDto dto, Integer firstResult, Integer maxResults) {
        SchemaLogQuery query = (SchemaLogQuery)dto.toQuery(this.processEngine);
        List<SchemaLogEntry> schemaLogEntries = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        return SchemaLogEntryDto.fromSchemaLogEntries(schemaLogEntries);
    }

    protected List<SchemaLogEntry> executePaginatedQuery(SchemaLogQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }
}

