/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinitionQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.DateTimeUtils;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class DecisionDefinitionRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String DECISION_DEFINITION_QUERY_URL = "/rest-test/decision-definition";
    protected static final String DECISION_DEFINITION_COUNT_QUERY_URL = "/rest-test/decision-definition/count";
    private DecisionDefinitionQuery mockedQuery;

    @Before
    public void setUpRuntime() {
        this.mockedQuery = this.createMockDecisionDefinitionQuery(MockProvider.createMockDecisionDefinitions());
    }

    private DecisionDefinitionQuery createMockDecisionDefinitionQuery(List<DecisionDefinition> mockedDefinitions) {
        DecisionDefinitionQuery sampleDefinitionsQuery = (DecisionDefinitionQuery)Mockito.mock(DecisionDefinitionQuery.class);
        Mockito.when((Object)sampleDefinitionsQuery.list()).thenReturn(mockedDefinitions);
        Mockito.when((Object)sampleDefinitionsQuery.count()).thenReturn((Object)mockedDefinitions.size());
        Mockito.when((Object)processEngine.getRepositoryService().createDecisionDefinitionQuery()).thenReturn((Object)sampleDefinitionsQuery);
        return sampleDefinitionsQuery;
    }

    @Test
    public void testEmptyQuery() {
        RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DECISION_DEFINITION_QUERY_URL, new Object[0]);
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testInvalidNumericParameter() {
        String anInvalidIntegerQueryParam = "aString";
        RestAssured.given().queryParam("version", new Object[]{anInvalidIntegerQueryParam}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Cannot set query parameter 'version' to value 'aString': Cannot convert value aString to java type java.lang.Integer"), new Object[0]).when().get(DECISION_DEFINITION_QUERY_URL, new Object[0]);
    }

    @Test
    public void testInvalidBooleanParameter() {
        String anInvalidBooleanQueryParam = "neitherTrueNorFalse";
        RestAssured.given().queryParam("active", new Object[]{anInvalidBooleanQueryParam}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DECISION_DEFINITION_QUERY_URL, new Object[0]);
    }

    @Test
    public void testInvalidSortingOptions() {
        this.executeAndVerifySorting("anInvalidSortByOption", "asc", Response.Status.BAD_REQUEST);
        this.executeAndVerifySorting("id", "anInvalidSortOrderOption", Response.Status.BAD_REQUEST);
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"id"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(DECISION_DEFINITION_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(DECISION_DEFINITION_QUERY_URL, new Object[0]);
    }

    protected void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(DECISION_DEFINITION_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortingParameters() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("id", "asc", Response.Status.OK);
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByDecisionDefinitionId();
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("name", "asc", Response.Status.OK);
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByDecisionDefinitionName();
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("version", "asc", Response.Status.OK);
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByDecisionDefinitionVersion();
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("key", "asc", Response.Status.OK);
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByDecisionDefinitionKey();
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("category", "asc", Response.Status.OK);
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByDecisionDefinitionCategory();
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("deploymentId", "asc", Response.Status.OK);
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByDeploymentId();
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("deployTime", "asc", Response.Status.OK);
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByDeploymentTime();
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "asc", Response.Status.OK);
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("decisionRequirementsDefinitionKey", "asc", Response.Status.OK);
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByDecisionRequirementsDefinitionKey();
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("id", "desc", Response.Status.OK);
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByDecisionDefinitionId();
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("name", "desc", Response.Status.OK);
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByDecisionDefinitionName();
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("version", "desc", Response.Status.OK);
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByDecisionDefinitionVersion();
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("key", "desc", Response.Status.OK);
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByDecisionDefinitionKey();
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("category", "desc", Response.Status.OK);
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByDecisionDefinitionCategory();
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("deploymentId", "desc", Response.Status.OK);
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByDeploymentId();
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("deployTime", "desc", Response.Status.OK);
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByDeploymentTime();
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "desc", Response.Status.OK);
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("versionTag", "asc", Response.Status.OK);
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByVersionTag();
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("versionTag", "desc", Response.Status.OK);
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByVersionTag();
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("decisionRequirementsDefinitionKey", "desc", Response.Status.OK);
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByDecisionRequirementsDefinitionKey();
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
    }

    @Test
    public void testSuccessfulPagination() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DECISION_DEFINITION_QUERY_URL, new Object[0]);
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, maxResults);
    }

    @Test
    public void testMissingFirstResultParameter() {
        int maxResults = 10;
        RestAssured.given().queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DECISION_DEFINITION_QUERY_URL, new Object[0]);
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).listPage(0, maxResults);
    }

    @Test
    public void testMissingMaxResultsParameter() {
        int firstResult = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DECISION_DEFINITION_QUERY_URL, new Object[0]);
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, Integer.MAX_VALUE);
    }

    @Test
    public void testDecisionDefinitionRetrieval() {
        Response response = (Response)RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DECISION_DEFINITION_QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List decisionDefinitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)decisionDefinitions).hasSize(1);
        Assertions.assertThat((Map)((Map)decisionDefinitions.get(0))).isNotNull();
        String returnedId = JsonPath.from((String)content).getString("[0].id");
        String returnedKey = JsonPath.from((String)content).getString("[0].key");
        String returnedCategory = JsonPath.from((String)content).getString("[0].category");
        String returnedName = JsonPath.from((String)content).getString("[0].name");
        int returnedVersion = JsonPath.from((String)content).getInt("[0].version");
        String returnedResource = JsonPath.from((String)content).getString("[0].resource");
        String returnedDeploymentId = JsonPath.from((String)content).getString("[0].deploymentId");
        String returnedDecisionRequirementsDefinitionId = JsonPath.from((String)content).getString("[0].decisionRequirementsDefinitionId");
        String returnedDecisionRequirementsDefinitionKey = JsonPath.from((String)content).getString("[0].decisionRequirementsDefinitionKey");
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        Assertions.assertThat((String)returnedId).isEqualTo((Object)"aDecisionDefinitionId");
        Assertions.assertThat((String)returnedKey).isEqualTo((Object)"aDecisionDefinitionKey");
        Assertions.assertThat((String)returnedCategory).isEqualTo((Object)"aDecisionDefinitionCategory");
        Assertions.assertThat((String)returnedName).isEqualTo((Object)"aDecisionDefinitionName");
        Assertions.assertThat((int)returnedVersion).isEqualTo(1);
        Assertions.assertThat((String)returnedResource).isEqualTo((Object)"aDecisionDefinitionResourceName");
        Assertions.assertThat((String)returnedDeploymentId).isEqualTo((Object)"aDeploymentId");
        Assertions.assertThat((String)returnedDecisionRequirementsDefinitionId).isEqualTo((Object)"aDecisionRequirementsDefinitionId");
        Assertions.assertThat((String)returnedDecisionRequirementsDefinitionKey).isEqualTo((Object)"aDecisionRequirementsDefinitionKey");
        Assertions.assertThat((String)returnedTenantId).isEqualTo(null);
    }

    @Test
    public void testDecisionDefinitionRetrievalByList() {
        this.mockedQuery = this.createMockDecisionDefinitionQuery(MockProvider.createMockTwoDecisionDefinitions());
        Response response = (Response)RestAssured.given().queryParam("decisionDefinitionIdIn", new Object[]{"aDecisionDefinitionId,anotherDecisionDefinitionId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DECISION_DEFINITION_QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).decisionDefinitionIdIn(new String[]{"aDecisionDefinitionId", "anotherDecisionDefinitionId"});
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(2);
        String returnedDefinitionId1 = JsonPath.from((String)content).getString("[0].id");
        String returnedDefinitionId2 = JsonPath.from((String)content).getString("[1].id");
        Assertions.assertThat((String)returnedDefinitionId1).isEqualTo((Object)"aDecisionDefinitionId");
        Assertions.assertThat((String)returnedDefinitionId2).isEqualTo((Object)"anotherDecisionDefinitionId");
    }

    @Test
    public void testDecisionDefinitionRetrievalByEmptyList() {
        RestAssured.given().queryParam("decisionDefinitionIdIn", new Object[]{""}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DECISION_DEFINITION_QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery, Mockito.never())).decisionDefinitionIdIn((String[])org.mockito.Matchers.anyVararg());
        ((DecisionDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testAdditionalParameters() {
        Map<String, String> queryParameters = this.getCompleteQueryParameters();
        RestAssured.given().queryParams(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DECISION_DEFINITION_QUERY_URL, new Object[0]);
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).decisionDefinitionId(queryParameters.get("decisionDefinitionId"));
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).decisionDefinitionCategory(queryParameters.get("category"));
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).decisionDefinitionCategoryLike(queryParameters.get("categoryLike"));
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).decisionDefinitionName(queryParameters.get("name"));
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).decisionDefinitionNameLike(queryParameters.get("nameLike"));
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).deploymentId(queryParameters.get("deploymentId"));
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).decisionDefinitionKey(queryParameters.get("key"));
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).decisionDefinitionKeyLike(queryParameters.get("keyLike"));
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).decisionDefinitionVersion(Integer.valueOf(Integer.parseInt(queryParameters.get("version"))));
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).latestVersion();
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).decisionDefinitionResourceName(queryParameters.get("resourceName"));
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).decisionDefinitionResourceNameLike(queryParameters.get("resourceNameLike"));
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).decisionRequirementsDefinitionId(queryParameters.get("decisionRequirementsDefinitionId"));
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).decisionRequirementsDefinitionKey(queryParameters.get("decisionRequirementsDefinitionKey"));
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).versionTag(queryParameters.get("versionTag"));
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).versionTagLike(queryParameters.get("versionTagLike"));
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).withoutDecisionRequirementsDefinition();
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).deployedAfter(DateTimeUtil.parseDate((String)queryParameters.get("deployedAfter")));
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).deployedAt(DateTimeUtil.parseDate((String)queryParameters.get("deployedAt")));
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testDecisionDefinitionTenantIdList() {
        List<DecisionDefinition> decisionDefinitions = Arrays.asList(MockProvider.mockDecisionDefinition().tenantId("aTenantId").build(), MockProvider.mockDecisionDefinition().id("anotherCaseDefnitionId").tenantId("anotherTenantId").build());
        this.mockedQuery = this.createMockDecisionDefinitionQuery(decisionDefinitions);
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId,anotherTenantId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DECISION_DEFINITION_QUERY_URL, new Object[0]);
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testDecisionDefinitionWithoutTenantId() {
        Response response = (Response)RestAssured.given().queryParam("withoutTenantId", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DECISION_DEFINITION_QUERY_URL, new Object[0]);
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).withoutTenantId();
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(1);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo(null);
    }

    @Test
    public void testDecisionDefinitionTenantIdIncludeDefinitionsWithoutTenantid() {
        List<DecisionDefinition> decisionDefinitions = Arrays.asList(MockProvider.mockDecisionDefinition().tenantId(null).build(), MockProvider.mockDecisionDefinition().tenantId("aTenantId").build());
        this.mockedQuery = this.createMockDecisionDefinitionQuery(decisionDefinitions);
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId"}).queryParam("includeDecisionDefinitionsWithoutTenantId", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DECISION_DEFINITION_QUERY_URL, new Object[0]);
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId"});
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).includeDecisionDefinitionsWithoutTenantId();
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo(null);
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"aTenantId");
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(DECISION_DEFINITION_COUNT_QUERY_URL, new Object[0]);
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testDecisionDefinitionVersionTag() {
        List<DecisionDefinition> decisionDefinitions = Arrays.asList(MockProvider.mockDecisionDefinition().versionTag("aVersionTag").build(), MockProvider.mockDecisionDefinition().id("anotherDecisionDefinitionId").versionTag("anotherVersionTag").build());
        this.mockedQuery = this.createMockDecisionDefinitionQuery(decisionDefinitions);
        RestAssured.given().queryParam("versionTag", new Object[]{"aVersionTag"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DECISION_DEFINITION_QUERY_URL, new Object[0]);
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).versionTag("aVersionTag");
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testQueryByDeployTimeAfter() {
        String deployTime = DateTimeUtils.withTimezone("2020-03-27T00:00:00");
        Date date = DateTimeUtil.parseDate((String)deployTime);
        RestAssured.given().queryParam("deployedAfter", new Object[]{deployTime}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DECISION_DEFINITION_QUERY_URL, new Object[0]);
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).deployedAfter(date);
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testQueryByDeployTimeAt() {
        String deployTime = DateTimeUtils.withTimezone("2020-03-27T00:00:00");
        Date date = DateTimeUtil.parseDate((String)deployTime);
        RestAssured.given().queryParam("deployedAt", new Object[]{deployTime}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DECISION_DEFINITION_QUERY_URL, new Object[0]);
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).deployedAt(date);
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    private Map<String, String> getCompleteQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("decisionDefinitionId", "anId");
        parameters.put("category", "cat");
        parameters.put("categoryLike", "catlike");
        parameters.put("name", "name");
        parameters.put("nameLike", "namelike");
        parameters.put("deploymentId", "depId");
        parameters.put("deployedAfter", DateTimeUtils.withTimezone("2020-03-27T00:00:00"));
        parameters.put("deployedAt", DateTimeUtils.withTimezone("2020-03-27T00:00:00"));
        parameters.put("key", "key");
        parameters.put("keyLike", "keylike");
        parameters.put("version", "1");
        parameters.put("latestVersion", "true");
        parameters.put("resourceName", "res");
        parameters.put("resourceNameLike", "resLike");
        parameters.put("decisionRequirementsDefinitionId", "aDecisionRequirementsDefinitionId");
        parameters.put("decisionRequirementsDefinitionKey", "aDecisionRequirementsDefinitionKey");
        parameters.put("withoutDecisionRequirementsDefinition", "true");
        parameters.put("versionTag", "semVer");
        parameters.put("versionTagLike", "semVerLike");
        return parameters;
    }
}

