/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.camunda.bpm.engine.FilterService;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.filter.FilterQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class FilterRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String FILTER_QUERY_URL = "/rest-test/filter";
    protected static final String SINGLE_FILTER_URL = "/rest-test/filter/{id}";
    protected static final String FILTER_COUNT_QUERY_URL = "/rest-test/filter/count";
    protected FilterQuery mockedQuery;
    protected Filter mockedFilter;
    protected int mockedFilterItemCount;
    protected Filter anotherMockedFilter;
    protected int anotherMockedFilterItemCount;

    @Before
    public void setUpRuntimeData() {
        this.mockedQuery = MockProvider.createMockFilterQuery();
        this.mockedFilter = MockProvider.createMockFilter("aFilterId");
        this.mockedFilterItemCount = 13;
        this.anotherMockedFilter = MockProvider.createMockFilter("anotherFilterId");
        this.anotherMockedFilterItemCount = 42;
        FilterService filterService = processEngine.getFilterService();
        Mockito.when((Object)filterService.createFilterQuery()).thenReturn((Object)this.mockedQuery);
        Mockito.when((Object)filterService.getFilter((String)org.mockito.Matchers.eq((Object)"aFilterId"))).thenReturn((Object)this.mockedFilter);
        Mockito.when((Object)filterService.count((String)org.mockito.Matchers.eq((Object)"aFilterId"))).thenReturn((Object)this.mockedFilterItemCount);
        Mockito.when((Object)filterService.getFilter((String)org.mockito.Matchers.eq((Object)"anotherFilterId"))).thenReturn((Object)this.anotherMockedFilter);
        Mockito.when((Object)filterService.count((String)org.mockito.Matchers.eq((Object)"anotherFilterId"))).thenReturn((Object)this.anotherMockedFilterItemCount);
    }

    @Test
    public void testEmptyQuery() {
        String queryFilterId = "";
        RestAssured.given().queryParam("filterId", new Object[]{queryFilterId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(FILTER_QUERY_URL, new Object[0]);
        ((FilterQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testNoParametersQuery() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(FILTER_QUERY_URL, new Object[0]);
        ((FilterQuery)Mockito.verify((Object)this.mockedQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testCountyQuery() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)2), new Object[0]).when().get(FILTER_COUNT_QUERY_URL, new Object[0]);
        ((FilterQuery)Mockito.verify((Object)this.mockedQuery)).count();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testFilterRetrieval() {
        Response response = (Response)RestAssured.given().queryParam("filterId", new Object[]{"aFilterId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(FILTER_QUERY_URL, new Object[0]);
        this.verifyFilterMock(response);
    }

    @Test
    public void testMultipleParameters() {
        RestAssured.given().queryParams(this.getQueryParameters()).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(FILTER_QUERY_URL, new Object[0]);
        this.verifyQueryMockMultipleParameters();
    }

    @Test
    public void testInvalidSortingOptions() {
        this.executeAndVerifySorting("anInvalidSortByOption", "asc", Response.Status.BAD_REQUEST);
        this.executeAndVerifySorting("filterId", "anInvalidSortOrderOption", Response.Status.BAD_REQUEST);
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"filterId"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(FILTER_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(FILTER_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSuccessfulPagination() {
        this.executeAndVerifyPagination(0, 10, Response.Status.OK);
    }

    @Test
    public void testMissingFirstResultParameter() {
        this.executeAndVerifyPagination(null, 10, Response.Status.OK);
    }

    @Test
    public void testMissingMaxResultsParameter() {
        this.executeAndVerifyPagination(0, null, Response.Status.OK);
    }

    @Test
    public void testSingleFilterWithItemCount() {
        RestAssured.given().pathParam("id", (Object)"aFilterId").queryParam("itemCount", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("containsKey('itemCount')", Matchers.is((Object)true), new Object[0]).body("itemCount", Matchers.equalTo((Object)this.mockedFilterItemCount), new Object[0]).when().get(SINGLE_FILTER_URL, new Object[0]);
    }

    @Test
    public void testSingleFilterWithoutItemCount() {
        RestAssured.given().pathParam("id", (Object)"aFilterId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("containsKey('itemCount')", Matchers.is((Object)false), new Object[0]).when().get(SINGLE_FILTER_URL, new Object[0]);
    }

    @Test
    public void testFilterQueryWithItemCount() {
        RestAssured.given().queryParam("itemCount", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("$.size", Matchers.equalTo((Object)2), new Object[0]).body("any { it.containsKey('itemCount') }", Matchers.is((Object)true), new Object[0]).body("[0].itemCount", Matchers.equalTo((Object)this.mockedFilterItemCount), new Object[0]).body("[1].itemCount", Matchers.equalTo((Object)this.anotherMockedFilterItemCount), new Object[0]).when().get(FILTER_QUERY_URL, new Object[0]);
    }

    @Test
    public void testFilterQueryWithoutItemCount() {
        RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).body("$.size", Matchers.equalTo((Object)2), new Object[0]).body("any { it.containsKey('itemCount') }", Matchers.is((Object)false), new Object[0]).when().get(FILTER_QUERY_URL, new Object[0]);
    }

    protected Map<String, String> getQueryParameters() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("filterId", "aFilterId");
        params.put("resourceType", "Task");
        params.put("name", "aFilterName");
        params.put("nameLike", "aFilterName");
        params.put("owner", "aFilterOwner");
        return params;
    }

    protected void verifyFilterMock(Response response) {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((FilterQuery)inOrder.verify((Object)this.mockedQuery)).filterId("aFilterId");
        ((FilterQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List filters = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)filters).hasSize(2);
        Assertions.assertThat((Map)((Map)filters.get(0))).isNotNull();
        String returnedFilterId = JsonPath.from((String)content).getString("[0].id");
        String returnedResourceType = JsonPath.from((String)content).getString("[0].resourceType");
        String returnedName = JsonPath.from((String)content).getString("[0].name");
        String returnedOwner = JsonPath.from((String)content).getString("[0].owner");
        Map returnedQuery = (Map)JsonPath.from((String)content).getJsonObject("[0].query");
        Map returnedProperties = (Map)JsonPath.from((String)content).getJsonObject("[0].properties");
        HashMap<String, String> expectedVariable = new HashMap<String, String>();
        expectedVariable.put("name", "foo");
        expectedVariable.put("value", "bar");
        expectedVariable.put("operator", "eq");
        Assertions.assertThat((String)returnedFilterId).isEqualTo((Object)"aFilterId");
        Assertions.assertThat((String)returnedResourceType).isEqualTo((Object)"Task");
        Assertions.assertThat((String)returnedName).isEqualTo((Object)"aFilterName");
        Assertions.assertThat((String)returnedOwner).isEqualTo((Object)"aFilterOwner");
        Assertions.assertThat(returnedQuery.get("name")).isEqualTo((Object)MockProvider.EXAMPLE_FILTER_QUERY_DTO.getName());
        ((ListAssert)Assertions.assertThat((List)((List)returnedQuery.get("processVariables"))).hasSize(1)).containsExactly((Object[])new Map[]{expectedVariable});
        ((ListAssert)Assertions.assertThat((List)((List)returnedQuery.get("taskVariables"))).hasSize(1)).containsExactly((Object[])new Map[]{expectedVariable});
        ((ListAssert)Assertions.assertThat((List)((List)returnedQuery.get("caseInstanceVariables"))).hasSize(1)).containsExactly((Object[])new Map[]{expectedVariable});
        Assertions.assertThat((Map)returnedProperties).isEqualTo(MockProvider.EXAMPLE_FILTER_PROPERTIES);
        Assertions.assertThat((Map)((Map)filters.get(1))).isNotNull();
        returnedFilterId = JsonPath.from((String)content).getString("[1].id");
        returnedResourceType = JsonPath.from((String)content).getString("[1].resourceType");
        returnedName = JsonPath.from((String)content).getString("[1].name");
        returnedOwner = JsonPath.from((String)content).getString("[1].owner");
        returnedQuery = (Map)JsonPath.from((String)content).getJsonObject("[1].query");
        returnedProperties = (Map)JsonPath.from((String)content).getJsonObject("[1].properties");
        Assertions.assertThat((String)returnedFilterId).isEqualTo((Object)"anotherFilterId");
        Assertions.assertThat((String)returnedResourceType).isEqualTo((Object)"Task");
        Assertions.assertThat((String)returnedName).isEqualTo((Object)"aFilterName");
        Assertions.assertThat((String)returnedOwner).isEqualTo((Object)"aFilterOwner");
        Assertions.assertThat(returnedQuery.get("name")).isEqualTo((Object)MockProvider.EXAMPLE_FILTER_QUERY_DTO.getName());
        Assertions.assertThat((Map)returnedProperties).isEqualTo(MockProvider.EXAMPLE_FILTER_PROPERTIES);
    }

    protected void verifyQueryMockMultipleParameters() {
        ((FilterQuery)Mockito.verify((Object)this.mockedQuery)).filterId("aFilterId");
        ((FilterQuery)Mockito.verify((Object)this.mockedQuery)).filterResourceType("Task");
        ((FilterQuery)Mockito.verify((Object)this.mockedQuery)).filterName("aFilterName");
        ((FilterQuery)Mockito.verify((Object)this.mockedQuery)).filterNameLike("aFilterName");
        ((FilterQuery)Mockito.verify((Object)this.mockedQuery)).filterOwner("aFilterOwner");
    }

    protected void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sortBy", sortBy);
        params.put("sortOrder", sortOrder);
        RestAssured.given().queryParams(params).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(FILTER_QUERY_URL, new Object[0]);
        if (expectedStatus.equals((Object)Response.Status.OK)) {
            this.verifyQueryMockSorting(sortBy, sortOrder);
        }
    }

    protected void verifyQueryMockSorting(String sortBy, String sortOrder) {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        if (sortBy.equals("filterId")) {
            ((FilterQuery)inOrder.verify((Object)this.mockedQuery)).orderByFilterId();
        } else if (sortBy.equals("resourceType")) {
            ((FilterQuery)inOrder.verify((Object)this.mockedQuery)).orderByFilterResourceType();
        } else if (sortBy.equals("name")) {
            ((FilterQuery)inOrder.verify((Object)this.mockedQuery)).orderByFilterName();
        } else if (sortBy.equals("owner")) {
            ((FilterQuery)inOrder.verify((Object)this.mockedQuery)).orderByFilterOwner();
        }
        if (sortOrder.equals("asc")) {
            ((FilterQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        } else if (sortOrder.equals("desc")) {
            ((FilterQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        }
    }

    protected void executeAndVerifyPagination(Integer firstResult, Integer maxResults, Response.Status expectedStatus) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (firstResult != null) {
            params.put("firstResult", firstResult.toString());
        }
        if (maxResults != null) {
            params.put("maxResults", maxResults.toString());
        }
        RestAssured.given().queryParams(params).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(FILTER_QUERY_URL, new Object[0]);
        this.verifyQueryMockPagination(firstResult, maxResults);
    }

    protected void verifyQueryMockPagination(Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        ((FilterQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult.intValue(), maxResults.intValue());
    }
}

