/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.GroupQuery;
import org.camunda.bpm.engine.impl.identity.Authentication;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.identity.GroupDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class GroupRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String SERVICE_URL = "/rest-test/group";
    protected static final String GROUP_URL = "/rest-test/group/{id}";
    protected static final String GROUP_MEMBERS_URL = "/rest-test/group/{id}/members";
    protected static final String GROUP_MEMBER_URL = "/rest-test/group/{id}/members/{userId}";
    protected static final String GROUP_CREATE_URL = "/rest-test/group/create";
    protected IdentityService identityServiceMock;
    protected AuthorizationService authorizationServiceMock;
    protected ProcessEngineConfiguration processEngineConfigurationMock;

    @Before
    public void setupGroupData() {
        this.identityServiceMock = (IdentityService)Mockito.mock(IdentityService.class);
        this.authorizationServiceMock = (AuthorizationService)Mockito.mock(AuthorizationService.class);
        this.processEngineConfigurationMock = (ProcessEngineConfiguration)Mockito.mock(ProcessEngineConfiguration.class);
        Mockito.when((Object)processEngine.getIdentityService()).thenReturn((Object)this.identityServiceMock);
        Mockito.when((Object)processEngine.getAuthorizationService()).thenReturn((Object)this.authorizationServiceMock);
        Mockito.when((Object)processEngine.getProcessEngineConfiguration()).thenReturn((Object)this.processEngineConfigurationMock);
    }

    @Test
    public void testGetSingleGroup() {
        Group sampleGroup = MockProvider.createMockGroup();
        GroupQuery sampleGroupQuery = (GroupQuery)Mockito.mock(GroupQuery.class);
        Mockito.when((Object)this.identityServiceMock.createGroupQuery()).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)sampleGroupQuery.groupId("groupId1")).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)sampleGroupQuery.singleResult()).thenReturn((Object)sampleGroup);
        RestAssured.given().pathParam("id", (Object)"groupId1").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"groupId1"), new Object[0]).body("name", Matchers.equalTo((Object)"group1"), new Object[0]).when().get(GROUP_URL, new Object[0]);
    }

    @Test
    public void testUserRestServiceOptions() {
        String fullAuthorizationUrl = "http://localhost:" + PORT + "/rest-test" + "/group";
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().then().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"list"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)(fullAuthorizationUrl + "/count")), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"count"), new Object[0]).body("links[2].href", Matchers.equalTo((Object)(fullAuthorizationUrl + "/create")), new Object[0]).body("links[2].method", Matchers.equalTo((Object)"POST"), new Object[0]).body("links[2].rel", Matchers.equalTo((Object)"create"), new Object[0]).when().options(SERVICE_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentAuthentication();
    }

    @Test
    public void testUserRestServiceOptionsWithAuthorizationDisabled() {
        String fullAuthorizationUrl = "http://localhost:" + PORT + "/rest-test" + "/group";
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)false);
        RestAssured.given().then().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"list"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)(fullAuthorizationUrl + "/count")), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"count"), new Object[0]).body("links[2].href", Matchers.equalTo((Object)(fullAuthorizationUrl + "/create")), new Object[0]).body("links[2].method", Matchers.equalTo((Object)"POST"), new Object[0]).body("links[2].rel", Matchers.equalTo((Object)"create"), new Object[0]).when().options(SERVICE_URL, new Object[0]);
        this.verifyNoAuthorizationCheckPerformed();
    }

    @Test
    public void testGroupResourceOptionsUnauthenticated() {
        String fullGroupUrl = "http://localhost:" + PORT + "/rest-test" + "/group/" + "groupId1";
        Group sampleGroup = MockProvider.createMockGroup();
        GroupQuery sampleGroupQuery = (GroupQuery)Mockito.mock(GroupQuery.class);
        Mockito.when((Object)this.identityServiceMock.createGroupQuery()).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)sampleGroupQuery.groupId("groupId1")).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)sampleGroupQuery.singleResult()).thenReturn((Object)sampleGroup);
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"groupId1").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullGroupUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"self"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)fullGroupUrl), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"DELETE"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"delete"), new Object[0]).body("links[2].href", Matchers.equalTo((Object)fullGroupUrl), new Object[0]).body("links[2].method", Matchers.equalTo((Object)"PUT"), new Object[0]).body("links[2].rel", Matchers.equalTo((Object)"update"), new Object[0]).when().options(GROUP_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)2))).getCurrentAuthentication();
    }

    @Test
    public void testGroupResourceOptionsUnauthorized() {
        String fullGroupUrl = "http://localhost:" + PORT + "/rest-test" + "/group/" + "groupId1";
        Authentication authentication = new Authentication("userId", null);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.GROUP, "groupId1")).thenReturn((Object)false);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.UPDATE, (Resource)Resources.GROUP, "groupId1")).thenReturn((Object)false);
        Group sampleGroup = MockProvider.createMockGroup();
        GroupQuery sampleGroupQuery = (GroupQuery)Mockito.mock(GroupQuery.class);
        Mockito.when((Object)this.identityServiceMock.createGroupQuery()).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)sampleGroupQuery.groupId("groupId1")).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)sampleGroupQuery.singleResult()).thenReturn((Object)sampleGroup);
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"groupId1").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullGroupUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"self"), new Object[0]).body("links[1]", Matchers.nullValue(), new Object[0]).body("links[2]", Matchers.nullValue(), new Object[0]).when().options(GROUP_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)2))).getCurrentAuthentication();
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.GROUP, "groupId1");
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.UPDATE, (Resource)Resources.GROUP, "groupId1");
    }

    @Test
    public void testGroupResourceOptionsAuthorized() {
        String fullGroupUrl = "http://localhost:" + PORT + "/rest-test" + "/group/" + "groupId1";
        Authentication authentication = new Authentication("userId", null);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.GROUP, "groupId1")).thenReturn((Object)true);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.UPDATE, (Resource)Resources.GROUP, "groupId1")).thenReturn((Object)false);
        Group sampleGroup = MockProvider.createMockGroup();
        GroupQuery sampleGroupQuery = (GroupQuery)Mockito.mock(GroupQuery.class);
        Mockito.when((Object)this.identityServiceMock.createGroupQuery()).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)sampleGroupQuery.groupId("groupId1")).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)sampleGroupQuery.singleResult()).thenReturn((Object)sampleGroup);
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"groupId1").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullGroupUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"self"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)fullGroupUrl), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"DELETE"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"delete"), new Object[0]).body("links[2]", Matchers.nullValue(), new Object[0]).when().options(GROUP_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)2))).getCurrentAuthentication();
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.GROUP, "groupId1");
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.UPDATE, (Resource)Resources.GROUP, "groupId1");
    }

    @Test
    public void testGroupResourceOptionsWithAuthorizationDisabled() {
        String fullGroupUrl = "http://localhost:" + PORT + "/rest-test" + "/group/" + "groupId1";
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)false);
        RestAssured.given().pathParam("id", (Object)"groupId1").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullGroupUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"self"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)fullGroupUrl), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"DELETE"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"delete"), new Object[0]).body("links[2].href", Matchers.equalTo((Object)fullGroupUrl), new Object[0]).body("links[2].method", Matchers.equalTo((Object)"PUT"), new Object[0]).body("links[2].rel", Matchers.equalTo((Object)"update"), new Object[0]).when().options(GROUP_URL, new Object[0]);
        this.verifyNoAuthorizationCheckPerformed();
    }

    @Test
    public void testGroupMembersResourceOptions() {
        String fullMembersUrl = "http://localhost:" + PORT + "/rest-test" + "/group/" + "groupId1" + "/members";
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"groupId1").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullMembersUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"DELETE"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"delete"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)fullMembersUrl), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"PUT"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"create"), new Object[0]).when().options(GROUP_MEMBERS_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)2))).getCurrentAuthentication();
    }

    @Test
    public void testGroupMembersResourceOptionsAuthorized() {
        String fullMembersUrl = "http://localhost:" + PORT + "/rest-test" + "/group/" + "groupId1" + "/members";
        Authentication authentication = new Authentication("userId", null);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.GROUP_MEMBERSHIP, "groupId1")).thenReturn((Object)true);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.CREATE, (Resource)Resources.GROUP_MEMBERSHIP, "groupId1")).thenReturn((Object)true);
        Group sampleGroup = MockProvider.createMockGroup();
        GroupQuery sampleGroupQuery = (GroupQuery)Mockito.mock(GroupQuery.class);
        Mockito.when((Object)this.identityServiceMock.createGroupQuery()).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)sampleGroupQuery.groupId("groupId1")).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)sampleGroupQuery.singleResult()).thenReturn((Object)sampleGroup);
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"groupId1").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullMembersUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"DELETE"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"delete"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)fullMembersUrl), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"PUT"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"create"), new Object[0]).when().options(GROUP_MEMBERS_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)2))).getCurrentAuthentication();
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.GROUP_MEMBERSHIP, "groupId1");
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.CREATE, (Resource)Resources.GROUP_MEMBERSHIP, "groupId1");
    }

    @Test
    public void testGroupMembersResourceOptionsUnauthorized() {
        Authentication authentication = new Authentication("userId", null);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.GROUP_MEMBERSHIP, "groupId1")).thenReturn((Object)false);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.CREATE, (Resource)Resources.GROUP_MEMBERSHIP, "groupId1")).thenReturn((Object)false);
        Group sampleGroup = MockProvider.createMockGroup();
        GroupQuery sampleGroupQuery = (GroupQuery)Mockito.mock(GroupQuery.class);
        Mockito.when((Object)this.identityServiceMock.createGroupQuery()).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)sampleGroupQuery.groupId("groupId1")).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)sampleGroupQuery.singleResult()).thenReturn((Object)sampleGroup);
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"groupId1").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("links[0]", Matchers.nullValue(), new Object[0]).body("links[1]", Matchers.nullValue(), new Object[0]).when().options(GROUP_MEMBERS_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)2))).getCurrentAuthentication();
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.GROUP_MEMBERSHIP, "groupId1");
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.CREATE, (Resource)Resources.GROUP_MEMBERSHIP, "groupId1");
    }

    @Test
    public void testGroupMembersResourceOptionsWithAuthorizationDisabled() {
        String fullMembersUrl = "http://localhost:" + PORT + "/rest-test" + "/group/" + "groupId1" + "/members";
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)false);
        RestAssured.given().pathParam("id", (Object)"groupId1").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullMembersUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"DELETE"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"delete"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)fullMembersUrl), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"PUT"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"create"), new Object[0]).when().options(GROUP_MEMBERS_URL, new Object[0]);
        this.verifyNoAuthorizationCheckPerformed();
    }

    @Test
    public void testGetNonExistingGroup() {
        GroupQuery sampleGroupQuery = (GroupQuery)Mockito.mock(GroupQuery.class);
        Mockito.when((Object)this.identityServiceMock.createGroupQuery()).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)sampleGroupQuery.groupId(org.mockito.Matchers.anyString())).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)sampleGroupQuery.singleResult()).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"aNonExistingGroup").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Group with id aNonExistingGroup does not exist"), new Object[0]).when().get(GROUP_URL, new Object[0]);
    }

    @Test
    public void testDeleteGroup() {
        RestAssured.given().pathParam("id", (Object)"groupId1").expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(GROUP_URL, new Object[0]);
    }

    @Test
    public void testDeleteNonExistingGroup() {
        RestAssured.given().pathParam("id", (Object)"non-existing").expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(GROUP_URL, new Object[0]);
    }

    @Test
    public void testDeleteGroupThrowsAuthorizationException() {
        String message = "expected exception";
        ((IdentityService)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.identityServiceMock)).deleteGroup("groupId1");
        RestAssured.given().pathParam("id", (Object)"groupId1").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().delete(GROUP_URL, new Object[0]);
    }

    @Test
    public void testUpdateExistingGroup() {
        Group initialGroup = MockProvider.createMockGroup();
        Group groupUpdate = MockProvider.createMockGroupUpdate();
        GroupQuery sampleGroupQuery = (GroupQuery)Mockito.mock(GroupQuery.class);
        Mockito.when((Object)this.identityServiceMock.createGroupQuery()).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)sampleGroupQuery.groupId("groupId1")).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)sampleGroupQuery.singleResult()).thenReturn((Object)initialGroup);
        RestAssured.given().pathParam("id", (Object)"groupId1").body((Object)GroupDto.fromGroup((Group)groupUpdate)).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(GROUP_URL, new Object[0]);
        ((Group)Mockito.verify((Object)initialGroup)).setName(groupUpdate.getName());
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock)).saveGroup(initialGroup);
    }

    @Test
    public void testUpdateNonExistingGroup() {
        Group groupUpdate = MockProvider.createMockGroupUpdate();
        GroupQuery sampleGroupQuery = (GroupQuery)Mockito.mock(GroupQuery.class);
        Mockito.when((Object)this.identityServiceMock.createGroupQuery()).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)sampleGroupQuery.groupId("aNonExistingGroup")).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)sampleGroupQuery.singleResult()).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"aNonExistingGroup").body((Object)GroupDto.fromGroup((Group)groupUpdate)).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Group with id aNonExistingGroup does not exist"), new Object[0]).when().put(GROUP_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.never())).saveGroup((Group)org.mockito.Matchers.any(Group.class));
    }

    @Test
    public void testUpdateGroupThrowsAuthorizationException() {
        Group initialGroup = MockProvider.createMockGroup();
        Group groupUpdate = MockProvider.createMockGroupUpdate();
        GroupQuery sampleGroupQuery = (GroupQuery)Mockito.mock(GroupQuery.class);
        Mockito.when((Object)this.identityServiceMock.createGroupQuery()).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)sampleGroupQuery.groupId("groupId1")).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)sampleGroupQuery.singleResult()).thenReturn((Object)initialGroup);
        String message = "exception expected";
        ((IdentityService)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.identityServiceMock)).saveGroup((Group)org.mockito.Matchers.any(Group.class));
        RestAssured.given().pathParam("id", (Object)"groupId1").body((Object)GroupDto.fromGroup((Group)groupUpdate)).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().put(GROUP_URL, new Object[0]);
        ((Group)Mockito.verify((Object)initialGroup)).setName(groupUpdate.getName());
    }

    @Test
    public void testGroupCreate() {
        Group newGroup = MockProvider.createMockGroup();
        Mockito.when((Object)this.identityServiceMock.newGroup("groupId1")).thenReturn((Object)newGroup);
        RestAssured.given().body((Object)GroupDto.fromGroup((Group)newGroup)).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(GROUP_CREATE_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock)).newGroup("groupId1");
        ((Group)Mockito.verify((Object)newGroup)).setName("group1");
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock)).saveGroup(newGroup);
    }

    @Test
    public void testGroupCreateExistingFails() {
        Group newGroup = MockProvider.createMockGroup();
        Mockito.when((Object)this.identityServiceMock.newGroup("groupId1")).thenReturn((Object)newGroup);
        ((IdentityService)Mockito.doThrow((Throwable)new ProcessEngineException("")).when((Object)this.identityServiceMock)).saveGroup(newGroup);
        RestAssured.given().body((Object)GroupDto.fromGroup((Group)newGroup)).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).when().post(GROUP_CREATE_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock)).newGroup("groupId1");
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock)).saveGroup(newGroup);
    }

    @Test
    public void testGroupCreateThrowsAuthorizationException() {
        Group newGroup = MockProvider.createMockGroup();
        String message = "exception expected";
        Mockito.when((Object)this.identityServiceMock.newGroup(newGroup.getId())).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().body((Object)GroupDto.fromGroup((Group)newGroup)).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(GROUP_CREATE_URL, new Object[0]);
    }

    @Test
    public void testSaveGroupThrowsAuthorizationException() {
        Group newGroup = MockProvider.createMockGroup();
        String message = "exception expected";
        Mockito.when((Object)this.identityServiceMock.newGroup(newGroup.getId())).thenReturn((Object)newGroup);
        ((IdentityService)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.identityServiceMock)).saveGroup(newGroup);
        RestAssured.given().body((Object)GroupDto.fromGroup((Group)newGroup)).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(GROUP_CREATE_URL, new Object[0]);
    }

    @Test
    public void testCreateGroupMember() {
        RestAssured.given().pathParam("id", (Object)"groupId1").pathParam("userId", (Object)"userId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(GROUP_MEMBER_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock)).createMembership("userId", "groupId1");
    }

    @Test
    public void testCreateGroupMemberThrowsAuthorizationException() {
        String message = "expected exception";
        ((IdentityService)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.identityServiceMock)).createMembership("userId", "groupId1");
        RestAssured.given().pathParam("id", (Object)"groupId1").pathParam("userId", (Object)"userId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().put(GROUP_MEMBER_URL, new Object[0]);
    }

    @Test
    public void testDeleteGroupMember() {
        RestAssured.given().pathParam("id", (Object)"groupId1").pathParam("userId", (Object)"userId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(GROUP_MEMBER_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock)).deleteMembership("userId", "groupId1");
    }

    @Test
    public void testDeleteGroupMemberThrowsAuthorizationException() {
        String message = "expected exception";
        ((IdentityService)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.identityServiceMock)).deleteMembership("userId", "groupId1");
        RestAssured.given().pathParam("id", (Object)"groupId1").pathParam("userId", (Object)"userId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().delete(GROUP_MEMBER_URL, new Object[0]);
    }

    @Test
    public void testReadOnlyGroupCreateFails() {
        Group newGroup = MockProvider.createMockGroup();
        Mockito.when((Object)this.identityServiceMock.isReadOnly()).thenReturn((Object)true);
        RestAssured.given().body((Object)GroupDto.fromGroup((Group)newGroup)).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Identity service implementation is read-only."), new Object[0]).when().post(GROUP_CREATE_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.never())).newGroup("groupId1");
    }

    @Test
    public void testReadOnlyGroupUpdateFails() {
        Group groupUdpdate = MockProvider.createMockGroup();
        Mockito.when((Object)this.identityServiceMock.isReadOnly()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"groupId1").body((Object)GroupDto.fromGroup((Group)groupUdpdate)).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Identity service implementation is read-only."), new Object[0]).when().put(GROUP_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.never())).saveGroup(groupUdpdate);
    }

    @Test
    public void testReadOnlyGroupDeleteFails() {
        Mockito.when((Object)this.identityServiceMock.isReadOnly()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"groupId1").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Identity service implementation is read-only."), new Object[0]).when().delete(GROUP_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.never())).deleteGroup("groupId1");
    }

    @Test
    public void testReadOnlyCreateGroupMemberFails() {
        Mockito.when((Object)this.identityServiceMock.isReadOnly()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"groupId1").pathParam("userId", (Object)"userId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Identity service implementation is read-only."), new Object[0]).when().put(GROUP_MEMBER_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.never())).createMembership("userId", "groupId1");
    }

    @Test
    public void testReadOnlyGroupMemberDeleteFails() {
        Mockito.when((Object)this.identityServiceMock.isReadOnly()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"groupId1").pathParam("userId", (Object)"userId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Identity service implementation is read-only."), new Object[0]).when().delete(GROUP_MEMBER_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.never())).deleteMembership("userId", "groupId1");
    }

    protected void verifyNoAuthorizationCheckPerformed() {
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)0))).getCurrentAuthentication();
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)0))).isUserAuthorized(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyListOf(String.class), (Permission)org.mockito.Matchers.any(Permission.class), (Resource)org.mockito.Matchers.any(Resource.class));
    }
}

