/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.MismatchingMessageCorrelationException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.helper.EqualsMap;
import org.camunda.bpm.engine.rest.helper.ErrorMessageHelper;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.helper.VariableTypeHelper;
import org.camunda.bpm.engine.rest.util.VariablesBuilder;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.runtime.MessageCorrelationBuilder;
import org.camunda.bpm.engine.runtime.MessageCorrelationResult;
import org.camunda.bpm.engine.runtime.MessageCorrelationResultType;
import org.camunda.bpm.engine.runtime.MessageCorrelationResultWithVariables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MessageRestServiceTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String MESSAGE_URL = "/rest-test/message";
    private RuntimeService runtimeServiceMock;
    private MessageCorrelationBuilder messageCorrelationBuilderMock;
    private MessageCorrelationResult executionResult;
    private MessageCorrelationResult procInstanceResult;
    private List<MessageCorrelationResult> executionResultList;
    private List<MessageCorrelationResult> procInstanceResultList;
    private List<MessageCorrelationResult> mixedResultList;
    private MessageCorrelationResultWithVariables executionResultWithVariables;
    private List<MessageCorrelationResultWithVariables> execResultWithVariablesList;

    @Before
    public void setupMocks() {
        this.runtimeServiceMock = (RuntimeService)Mockito.mock(RuntimeService.class);
        Mockito.when((Object)processEngine.getRuntimeService()).thenReturn((Object)this.runtimeServiceMock);
        this.messageCorrelationBuilderMock = (MessageCorrelationBuilder)Mockito.mock(MessageCorrelationBuilder.class);
        Mockito.when((Object)this.runtimeServiceMock.createMessageCorrelation(Matchers.anyString())).thenReturn((Object)this.messageCorrelationBuilderMock);
        Mockito.when((Object)this.messageCorrelationBuilderMock.processInstanceId(Matchers.anyString())).thenReturn((Object)this.messageCorrelationBuilderMock);
        Mockito.when((Object)this.messageCorrelationBuilderMock.processInstanceBusinessKey(Matchers.anyString())).thenReturn((Object)this.messageCorrelationBuilderMock);
        Mockito.when((Object)this.messageCorrelationBuilderMock.processInstanceVariableEquals(Matchers.anyString(), Matchers.any())).thenReturn((Object)this.messageCorrelationBuilderMock);
        Mockito.when((Object)this.messageCorrelationBuilderMock.setVariables((Map)Matchers.any())).thenReturn((Object)this.messageCorrelationBuilderMock);
        Mockito.when((Object)this.messageCorrelationBuilderMock.setVariable(Matchers.anyString(), Matchers.any())).thenReturn((Object)this.messageCorrelationBuilderMock);
        this.executionResult = MockProvider.createMessageCorrelationResult(MessageCorrelationResultType.Execution);
        this.procInstanceResult = MockProvider.createMessageCorrelationResult(MessageCorrelationResultType.ProcessDefinition);
        this.executionResultList = MockProvider.createMessageCorrelationResultList(MessageCorrelationResultType.Execution);
        this.procInstanceResultList = MockProvider.createMessageCorrelationResultList(MessageCorrelationResultType.ProcessDefinition);
        this.mixedResultList = new ArrayList<MessageCorrelationResult>(this.executionResultList);
        this.mixedResultList.addAll(this.procInstanceResultList);
        this.executionResultWithVariables = MockProvider.createMessageCorrelationResultWithVariables(MessageCorrelationResultType.Execution);
        this.execResultWithVariablesList = new ArrayList<MessageCorrelationResultWithVariables>();
        this.execResultWithVariablesList.add(this.executionResultWithVariables);
    }

    @Test
    public void testFullMessageCorrelation() {
        Object value;
        String name;
        String messageName = "aMessageName";
        String businessKey = "aBusinessKey";
        Map<String, Object> variables = VariablesBuilder.create().variable("aKey", "aValue").getVariables();
        Map<String, Object> variablesLocal = VariablesBuilder.create().variable("aKeyLocal", "aValueLocal").getVariables();
        Map<String, Object> correlationKeys = VariablesBuilder.create().variable("aKey", "aValue").variable("anotherKey", 1).variable("aThirdKey", true).getVariables();
        Map<String, Object> localCorrelationKeys = VariablesBuilder.create().variable("aLocalKey", "aValue").variable("anotherLocalKey", 1).variable("aThirdLocalKey", false).getVariables();
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("correlationKeys", correlationKeys);
        messageParameters.put("localCorrelationKeys", localCorrelationKeys);
        messageParameters.put("processVariables", variables);
        messageParameters.put("processVariablesLocal", variablesLocal);
        messageParameters.put("businessKey", businessKey);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(MESSAGE_URL, new Object[0]);
        HashMap<String, Object> expectedCorrelationKeys = new HashMap<String, Object>();
        expectedCorrelationKeys.put("aKey", "aValue");
        expectedCorrelationKeys.put("anotherKey", 1);
        expectedCorrelationKeys.put("aThirdKey", true);
        HashMap<String, Object> expectedLocalCorrelationKeys = new HashMap<String, Object>();
        expectedLocalCorrelationKeys.put("aLocalKey", "aValue");
        expectedLocalCorrelationKeys.put("anotherLocalKey", 1);
        expectedLocalCorrelationKeys.put("aThirdLocalKey", false);
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put("aKey", "aValue");
        HashMap<String, Object> expectedVariablesLocal = new HashMap<String, Object>();
        expectedVariablesLocal.put("aKeyLocal", "aValueLocal");
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createMessageCorrelation((String)Matchers.eq((Object)messageName));
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).processInstanceBusinessKey((String)Matchers.eq((Object)businessKey));
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).setVariables((Map)Matchers.argThat((Matcher)new EqualsMap(expectedVariables)));
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).setVariablesLocal((Map)Matchers.argThat((Matcher)new EqualsMap(expectedVariablesLocal)));
        for (Map.Entry expectedKey : expectedCorrelationKeys.entrySet()) {
            name = (String)expectedKey.getKey();
            value = expectedKey.getValue();
            ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).processInstanceVariableEquals(name, value);
        }
        for (Map.Entry expectedLocalKey : expectedLocalCorrelationKeys.entrySet()) {
            name = (String)expectedLocalKey.getKey();
            value = expectedLocalKey.getValue();
            ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).localVariableEquals(name, value);
        }
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).correlateWithResult();
    }

    @Test
    public void testFullMessageCorrelationWithExecutionResult() {
        Mockito.when((Object)this.messageCorrelationBuilderMock.correlateWithResult()).thenReturn((Object)this.executionResult);
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("resultEnabled", true);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().contentType(ContentType.JSON).statusCode(Response.Status.OK.getStatusCode()).when().post(MESSAGE_URL, new Object[0]);
        Assert.assertNotNull((Object)response);
        String content = response.asString();
        Assert.assertTrue((!content.isEmpty() ? 1 : 0) != 0);
        this.checkExecutionResult(content, 0);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createMessageCorrelation((String)Matchers.eq((Object)messageName));
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).correlateWithResult();
    }

    protected void checkExecutionResult(String content, int idx) {
        String resultType = JsonPath.from((String)content).get("[" + idx + "].resultType").toString();
        Assert.assertEquals((Object)MessageCorrelationResultType.Execution.name(), (Object)resultType);
        Assert.assertEquals((Object)"anExecutionId", (Object)JsonPath.from((String)content).get("[" + idx + "].execution.id"));
        Assert.assertEquals((Object)"aProcInstId", (Object)JsonPath.from((String)content).get("[" + idx + "].execution.processInstanceId"));
        Assert.assertNull((Object)JsonPath.from((String)content).get("[" + idx + "].processInstance"));
    }

    @Test
    public void testFullMessageCorrelationWithProcessDefinitionResult() {
        Mockito.when((Object)this.messageCorrelationBuilderMock.correlateWithResult()).thenReturn((Object)this.procInstanceResult);
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("resultEnabled", true);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().contentType(ContentType.JSON).statusCode(Response.Status.OK.getStatusCode()).when().post(MESSAGE_URL, new Object[0]);
        Assert.assertNotNull((Object)response);
        String content = response.asString();
        Assert.assertTrue((!content.isEmpty() ? 1 : 0) != 0);
        this.checkProcessInstanceResult(content, 0);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createMessageCorrelation((String)Matchers.eq((Object)messageName));
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).correlateWithResult();
    }

    protected void checkProcessInstanceResult(String content, int idx) {
        String resultType = (String)JsonPath.from((String)content).get("[" + idx + "].resultType");
        junit.framework.Assert.assertEquals((String)MessageCorrelationResultType.ProcessDefinition.name(), (String)resultType);
        junit.framework.Assert.assertEquals((String)"aProcInstId", (String)((String)JsonPath.from((String)content).get("[" + idx + "].processInstance.id")));
        junit.framework.Assert.assertEquals((String)"aProcDefId", (String)((String)JsonPath.from((String)content).get("[" + idx + "].processInstance.definitionId")));
        junit.framework.Assert.assertNull((Object)JsonPath.from((String)content).get("[" + idx + "].execution"));
    }

    @Test
    public void testFullMessageCorrelationAll() {
        Object value;
        String name;
        String messageName = "aMessageName";
        String businessKey = "aBusinessKey";
        Map<String, Object> variables = VariablesBuilder.create().variable("aKey", "aValue").getVariables();
        Map<String, Object> variablesLocal = VariablesBuilder.create().variable("aKeyLocal", "aValueLocal").getVariables();
        Map<String, Object> correlationKeys = VariablesBuilder.create().variable("aKey", "aValue").variable("anotherKey", 1).variable("aThirdKey", true).getVariables();
        Map<String, Object> localCorrelationKeys = VariablesBuilder.create().variable("aLocalKey", "aValue").variable("anotherLocalKey", 1).variable("aThirdLocalKey", false).getVariables();
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("correlationKeys", correlationKeys);
        messageParameters.put("localCorrelationKeys", localCorrelationKeys);
        messageParameters.put("processVariables", variables);
        messageParameters.put("processVariablesLocal", variablesLocal);
        messageParameters.put("businessKey", businessKey);
        messageParameters.put("all", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(MESSAGE_URL, new Object[0]);
        HashMap<String, Object> expectedCorrelationKeys = new HashMap<String, Object>();
        expectedCorrelationKeys.put("aKey", "aValue");
        expectedCorrelationKeys.put("anotherKey", 1);
        expectedCorrelationKeys.put("aThirdKey", true);
        HashMap<String, Object> expectedLocalCorrelationKeys = new HashMap<String, Object>();
        expectedLocalCorrelationKeys.put("aLocalKey", "aValue");
        expectedLocalCorrelationKeys.put("anotherLocalKey", 1);
        expectedLocalCorrelationKeys.put("aThirdLocalKey", false);
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put("aKey", "aValue");
        HashMap<String, Object> expectedVariablesLocal = new HashMap<String, Object>();
        expectedVariablesLocal.put("aKeyLocal", "aValueLocal");
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createMessageCorrelation((String)Matchers.eq((Object)messageName));
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).processInstanceBusinessKey((String)Matchers.eq((Object)businessKey));
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).setVariables((Map)Matchers.argThat((Matcher)new EqualsMap(expectedVariables)));
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).setVariablesLocal((Map)Matchers.argThat((Matcher)new EqualsMap(expectedVariablesLocal)));
        for (Map.Entry expectedKey : expectedCorrelationKeys.entrySet()) {
            name = (String)expectedKey.getKey();
            value = expectedKey.getValue();
            ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).processInstanceVariableEquals(name, value);
        }
        for (Map.Entry expectedLocalKey : expectedLocalCorrelationKeys.entrySet()) {
            name = (String)expectedLocalKey.getKey();
            value = expectedLocalKey.getValue();
            ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).localVariableEquals(name, value);
        }
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).correlateAllWithResult();
    }

    @Test
    public void testFullMessageCorrelationAllWithExecutionResult() {
        Mockito.when((Object)this.messageCorrelationBuilderMock.correlateAllWithResult()).thenReturn(this.executionResultList);
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("all", true);
        messageParameters.put("resultEnabled", true);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().contentType(ContentType.JSON).statusCode(Response.Status.OK.getStatusCode()).when().post(MESSAGE_URL, new Object[0]);
        Assert.assertNotNull((Object)response);
        String content = response.asString();
        Assert.assertTrue((!content.isEmpty() ? 1 : 0) != 0);
        List results = JsonPath.from((String)content).getList("");
        Assert.assertEquals((long)2L, (long)results.size());
        for (int i = 0; i < 2; ++i) {
            this.checkExecutionResult(content, i);
        }
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createMessageCorrelation((String)Matchers.eq((Object)messageName));
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).correlateAllWithResult();
    }

    @Test
    public void testFullMessageCorrelationAllWithProcessInstanceResult() {
        Mockito.when((Object)this.messageCorrelationBuilderMock.correlateAllWithResult()).thenReturn(this.procInstanceResultList);
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("all", true);
        messageParameters.put("resultEnabled", true);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().contentType(ContentType.JSON).statusCode(Response.Status.OK.getStatusCode()).when().post(MESSAGE_URL, new Object[0]);
        Assert.assertNotNull((Object)response);
        String content = response.asString();
        Assert.assertTrue((!content.isEmpty() ? 1 : 0) != 0);
        List results = JsonPath.from((String)content).getList("");
        Assert.assertEquals((long)2L, (long)results.size());
        for (int i = 0; i < 2; ++i) {
            this.checkProcessInstanceResult(content, i);
        }
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createMessageCorrelation((String)Matchers.eq((Object)messageName));
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).correlateAllWithResult();
    }

    @Test
    public void testFullMessageCorrelationAllWithMixedResult() {
        Mockito.when((Object)this.messageCorrelationBuilderMock.correlateAllWithResult()).thenReturn(this.mixedResultList);
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("all", true);
        messageParameters.put("resultEnabled", true);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().contentType(ContentType.JSON).statusCode(Response.Status.OK.getStatusCode()).when().post(MESSAGE_URL, new Object[0]);
        Assert.assertNotNull((Object)response);
        String content = response.asString();
        Assert.assertTrue((!content.isEmpty() ? 1 : 0) != 0);
        List results = JsonPath.from((String)content).getList("");
        Assert.assertEquals((long)4L, (long)results.size());
        for (int i = 0; i < 2; ++i) {
            String resultType = (String)JsonPath.from((String)content).get("[" + i + "].resultType");
            Assert.assertNotNull((Object)resultType);
            if (resultType.equals(MessageCorrelationResultType.Execution.name())) {
                this.checkExecutionResult(content, i);
                continue;
            }
            this.checkProcessInstanceResult(content, i);
        }
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createMessageCorrelation((String)Matchers.eq((Object)messageName));
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).correlateAllWithResult();
    }

    @Test
    public void testFullMessageCorrelationAllWithNoResult() {
        Mockito.when((Object)this.messageCorrelationBuilderMock.correlateAllWithResult()).thenReturn(this.mixedResultList);
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("all", true);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(MESSAGE_URL, new Object[0]);
        Assert.assertNotNull((Object)response);
        String content = response.asString();
        Assert.assertTrue((boolean)content.isEmpty());
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createMessageCorrelation((String)Matchers.eq((Object)messageName));
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).correlateAllWithResult();
    }

    @Test
    public void testMessageNameOnlyCorrelation() {
        String messageName = "aMessageName";
        HashMap<String, String> messageParameters = new HashMap<String, String>();
        messageParameters.put("messageName", messageName);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(MESSAGE_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createMessageCorrelation((String)Matchers.eq((Object)messageName));
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).correlateWithResult();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.messageCorrelationBuilderMock});
    }

    @Test
    public void testMessageNameAndBusinessKeyCorrelation() {
        String messageName = "aMessageName";
        String businessKey = "aBusinessKey";
        HashMap<String, String> messageParameters = new HashMap<String, String>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("businessKey", businessKey);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(MESSAGE_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createMessageCorrelation((String)Matchers.eq((Object)messageName));
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).processInstanceBusinessKey((String)Matchers.eq((Object)businessKey));
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).correlateWithResult();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.messageCorrelationBuilderMock});
    }

    @Test
    public void testMessageNameAndBusinessKeyCorrelationAll() {
        String messageName = "aMessageName";
        String businessKey = "aBusinessKey";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("businessKey", businessKey);
        messageParameters.put("all", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(MESSAGE_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createMessageCorrelation((String)Matchers.eq((Object)messageName));
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).processInstanceBusinessKey((String)Matchers.eq((Object)businessKey));
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).correlateAllWithResult();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.messageCorrelationBuilderMock});
    }

    @Test
    public void testMismatchingCorrelation() {
        String messageName = "aMessage";
        ((MessageCorrelationBuilder)Mockito.doThrow((Throwable)new MismatchingMessageCorrelationException(messageName, "Expected exception: cannot correlate")).when((Object)this.messageCorrelationBuilderMock)).correlateWithResult();
        HashMap<String, String> messageParameters = new HashMap<String, String>();
        messageParameters.put("messageName", messageName);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.containsString((String)"Expected exception: cannot correlate"), new Object[0]).when().post(MESSAGE_URL, new Object[0]);
    }

    @Test
    public void testFailingInstantiation() {
        String messageName = "aMessage";
        ((MessageCorrelationBuilder)Mockito.doThrow((Throwable)new ProcessEngineException("Expected exception")).when((Object)this.messageCorrelationBuilderMock)).correlateWithResult();
        HashMap<String, String> messageParameters = new HashMap<String, String>();
        messageParameters.put("messageName", messageName);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)"Expected exception"), new Object[0]).when().post(MESSAGE_URL, new Object[0]);
    }

    @Test
    public void testNoMessageNameCorrelation() {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)"No message name supplied"), new Object[0]).when().post(MESSAGE_URL, new Object[0]);
    }

    @Test
    public void testMessageCorrelationWithTenantId() {
        String messageName = "aMessageName";
        HashMap<String, String> messageParameters = new HashMap<String, String>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("tenantId", "aTenantId");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(MESSAGE_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createMessageCorrelation((String)Matchers.eq((Object)messageName));
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).tenantId("aTenantId");
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).correlateWithResult();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.messageCorrelationBuilderMock});
    }

    @Test
    public void testMessageCorrelationWithoutTenantId() {
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("withoutTenantId", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(MESSAGE_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createMessageCorrelation((String)Matchers.eq((Object)messageName));
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).withoutTenantId();
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).correlateWithResult();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.messageCorrelationBuilderMock});
    }

    @Test
    public void testFailingInvalidTenantParameters() {
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("tenantId", "aTenantId");
        messageParameters.put("withoutTenantId", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)"Parameter 'tenantId' cannot be used together with parameter 'withoutTenantId'."), new Object[0]).when().post(MESSAGE_URL, new Object[0]);
    }

    @Test
    public void testFailingDueToUnparseableIntegerInCorrelationKeys() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Integer";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("correlationKeys", variableJson);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)("Cannot deliver message: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Integer.class))), new Object[0]).when().post(MESSAGE_URL, new Object[0]);
    }

    @Test
    public void testFailingDueToUnparseableIntegerInLocalCorrelationKeys() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Integer";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("localCorrelationKeys", variableJson);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)("Cannot deliver message: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Integer.class))), new Object[0]).when().post(MESSAGE_URL, new Object[0]);
    }

    @Test
    public void testFailingDueToUnparseableShortInCorrelationKeys() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Short";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("correlationKeys", variableJson);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)("Cannot deliver message: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Short.class))), new Object[0]).when().post(MESSAGE_URL, new Object[0]);
    }

    @Test
    public void testFailingDueToUnparseableShortInLocalCorrelationKeys() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Short";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("localCorrelationKeys", variableJson);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)("Cannot deliver message: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Short.class))), new Object[0]).when().post(MESSAGE_URL, new Object[0]);
    }

    @Test
    public void testFailingDueToUnparseableLongInCorrelationKeys() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Long";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("correlationKeys", variableJson);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)("Cannot deliver message: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Long.class))), new Object[0]).when().post(MESSAGE_URL, new Object[0]);
    }

    @Test
    public void testFailingDueToUnparseableLongInLocalCorrelationKeys() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Long";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("localCorrelationKeys", variableJson);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)("Cannot deliver message: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Long.class))), new Object[0]).when().post(MESSAGE_URL, new Object[0]);
    }

    @Test
    public void testFailingDueToUnparseableDoubleInCorrelationKeys() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Double";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("correlationKeys", variableJson);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)("Cannot deliver message: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Double.class))), new Object[0]).when().post(MESSAGE_URL, new Object[0]);
    }

    @Test
    public void testFailingDueToUnparseableDoubleInLocalCorrelationKeys() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Double";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("localCorrelationKeys", variableJson);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)("Cannot deliver message: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Double.class))), new Object[0]).when().post(MESSAGE_URL, new Object[0]);
    }

    @Test
    public void testFailingDueToUnparseableDateInCorrelationKeys() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Date";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("correlationKeys", variableJson);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)("Cannot deliver message: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Date.class))), new Object[0]).when().post(MESSAGE_URL, new Object[0]);
    }

    @Test
    public void testFailingDueToUnparseableDateInLocalCorrelationKeys() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Date";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("localCorrelationKeys", variableJson);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)("Cannot deliver message: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Date.class))), new Object[0]).when().post(MESSAGE_URL, new Object[0]);
    }

    @Test
    public void testFailingDueToNotSupportedTypeInCorrelationKeys() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "X";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("correlationKeys", variableJson);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)"Cannot deliver message: Unsupported value type 'X'"), new Object[0]).when().post(MESSAGE_URL, new Object[0]);
    }

    @Test
    public void testFailingDueToNotSupportedTypeInLocalCorrelationKeys() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "X";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("localCorrelationKeys", variableJson);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)"Cannot deliver message: Unsupported value type 'X'"), new Object[0]).when().post(MESSAGE_URL, new Object[0]);
    }

    @Test
    public void testFailingDueToUnparseableIntegerInProcessVariables() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Integer";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("processVariables", variableJson);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)("Cannot deliver message: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Integer.class))), new Object[0]).when().post(MESSAGE_URL, new Object[0]);
    }

    @Test
    public void testFailingDueToUnparseableShortInProcessVariables() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Short";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("processVariables", variableJson);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)("Cannot deliver message: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Short.class))), new Object[0]).when().post(MESSAGE_URL, new Object[0]);
    }

    @Test
    public void testFailingDueToUnparseableLongInProcessVariables() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Long";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("processVariables", variableJson);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)("Cannot deliver message: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Long.class))), new Object[0]).when().post(MESSAGE_URL, new Object[0]);
    }

    @Test
    public void testFailingDueToUnparseableDoubleInProcessVariables() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Double";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("processVariables", variableJson);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)("Cannot deliver message: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Double.class))), new Object[0]).when().post(MESSAGE_URL, new Object[0]);
    }

    @Test
    public void testFailingDueToUnparseableDateInProcessVariables() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Date";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("processVariables", variableJson);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)("Cannot deliver message: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Date.class))), new Object[0]).when().post(MESSAGE_URL, new Object[0]);
    }

    @Test
    public void testFailingDueToNotSupportedTypeInProcessVariables() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "X";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("processVariables", variableJson);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)"Cannot deliver message: Unsupported value type 'X'"), new Object[0]).when().post(MESSAGE_URL, new Object[0]);
    }

    @Test
    public void testFailingDueToUnparseableIntegerInProcessVariablesLocal() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Integer";
        Map<String, Object> variableLocalJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("processVariablesLocal", variableLocalJson);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)("Cannot deliver message: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Integer.class))), new Object[0]).when().post(MESSAGE_URL, new Object[0]);
    }

    @Test
    public void testFailingDueToNotSupportedTypeInProcessVariablesLocal() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "X";
        Map<String, Object> variableLocalJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("processVariablesLocal", variableLocalJson);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)"Cannot deliver message: Unsupported value type 'X'"), new Object[0]).when().post(MESSAGE_URL, new Object[0]);
    }

    @Test
    public void testFailingDueToUnparseableDateInProcessVariablesLocal() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Date";
        Map<String, Object> variableLocalJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("processVariablesLocal", variableLocalJson);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)("Cannot deliver message: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Date.class))), new Object[0]).when().post(MESSAGE_URL, new Object[0]);
    }

    @Test
    public void testCorrelateThrowsAuthorizationException() {
        String messageName = "aMessageName";
        HashMap<String, String> messageParameters = new HashMap<String, String>();
        messageParameters.put("messageName", messageName);
        String message = "expected exception";
        ((MessageCorrelationBuilder)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.messageCorrelationBuilderMock)).correlateWithResult();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", org.hamcrest.Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)message), new Object[0]).when().post(MESSAGE_URL, new Object[0]);
    }

    @Test
    public void testcorrelateAllThrowsAuthorizationException() {
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("all", true);
        String message = "expected exception";
        ((MessageCorrelationBuilder)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.messageCorrelationBuilderMock)).correlateAllWithResult();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", org.hamcrest.Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)message), new Object[0]).when().post(MESSAGE_URL, new Object[0]);
    }

    @Test
    public void testMessageCorrelationWithProcessInstanceId() {
        String messageName = "aMessageName";
        HashMap<String, String> messageParameters = new HashMap<String, String>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("processInstanceId", "aProcInstId");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(MESSAGE_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createMessageCorrelation((String)Matchers.eq((Object)messageName));
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).processInstanceId((String)Matchers.eq((Object)"aProcInstId"));
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).correlateWithResult();
    }

    @Test
    public void testMessageCorrelationWithoutBusinessKey() {
        Mockito.when((Object)this.messageCorrelationBuilderMock.processInstanceBusinessKey(null)).thenThrow(new Throwable[]{new NullValueException()});
        String messageName = "aMessageName";
        HashMap<String, String> messageParameters = new HashMap<String, String>();
        messageParameters.put("messageName", messageName);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(MESSAGE_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createMessageCorrelation((String)Matchers.eq((Object)messageName));
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock, (VerificationMode)Mockito.never())).processInstanceBusinessKey(Matchers.anyString());
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).correlateWithResult();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.messageCorrelationBuilderMock});
    }

    @Test
    public void testCorrelationWithVariablesInResult() {
        Mockito.when((Object)this.messageCorrelationBuilderMock.correlateWithResultAndVariables(false)).thenReturn((Object)this.executionResultWithVariables);
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("resultEnabled", true);
        messageParameters.put("variablesInResultEnabled", true);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().contentType(ContentType.JSON).statusCode(Response.Status.OK.getStatusCode()).when().post(MESSAGE_URL, new Object[0]);
        Assert.assertNotNull((Object)response);
        String content = response.asString();
        Assert.assertTrue((!content.isEmpty() ? 1 : 0) != 0);
        this.checkVariablesInResult(content, 0);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createMessageCorrelation((String)Matchers.eq((Object)messageName));
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).correlateWithResultAndVariables(false);
    }

    @Test
    public void testCorrelationAllWithVariablesInResult() {
        Mockito.when((Object)this.messageCorrelationBuilderMock.correlateAllWithResultAndVariables(false)).thenReturn(this.execResultWithVariablesList);
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("all", true);
        messageParameters.put("resultEnabled", true);
        messageParameters.put("variablesInResultEnabled", true);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().contentType(ContentType.JSON).statusCode(Response.Status.OK.getStatusCode()).when().post(MESSAGE_URL, new Object[0]);
        Assert.assertNotNull((Object)response);
        String content = response.asString();
        Assert.assertTrue((!content.isEmpty() ? 1 : 0) != 0);
        List results = JsonPath.from((String)content).getList("");
        Assert.assertEquals((long)1L, (long)results.size());
        this.checkVariablesInResult(content, 0);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createMessageCorrelation((String)Matchers.eq((Object)messageName));
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.messageCorrelationBuilderMock)).correlateAllWithResultAndVariables(false);
    }

    @Test
    public void testFailingCorrelationWithVariablesInResultDueToDisabledResult() {
        String messageName = "aMessageName";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("resultEnabled", false);
        messageParameters.put("variablesInResultEnabled", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).then().expect().contentType(ContentType.JSON).statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)"Parameter 'variablesInResultEnabled' cannot be used without 'resultEnabled' set to true."), new Object[0]).when().post(MESSAGE_URL, new Object[0]);
    }

    protected void checkVariablesInResult(String content, int idx) {
        List<String> variableNames = Arrays.asList("aVariableInstanceName", "aDeserializedVariableInstanceName");
        for (String variableName : variableNames) {
            String variablePath = "[" + idx + "].variables." + variableName;
            Assert.assertEquals((Object)"application/json", JsonPath.from((String)content).getMap(variablePath + ".valueInfo").get("serializationDataFormat"));
            Assert.assertEquals((Object)"aSerializedValue", (Object)JsonPath.from((String)content).get(variablePath + ".value"));
            Assert.assertEquals((Object)VariableTypeHelper.toExpectedValueTypeName((ValueType)ValueType.OBJECT), (Object)JsonPath.from((String)content).get(variablePath + ".type"));
        }
        Assert.assertEquals((Object)ArrayList.class.getName(), JsonPath.from((String)content).getMap("[" + idx + "].variables." + "aVariableInstanceName" + ".valueInfo").get("objectTypeName"));
        Assert.assertEquals((Object)Object.class.getName(), JsonPath.from((String)content).getMap("[" + idx + "].variables." + "aDeserializedVariableInstanceName" + ".valueInfo").get("objectTypeName"));
    }
}

