/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.impl.ProcessInstanceQueryImpl;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.runtime.ProcessInstanceQueryDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.ModificationInstructionBuilder;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.runtime.ModificationBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ModificationRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String PROCESS_INSTANCE_URL = "/rest-test/modification";
    protected static final String EXECUTE_MODIFICATION_SYNC_URL = "/rest-test/modification/execute";
    protected static final String EXECUTE_MODIFICATION_ASYNC_URL = "/rest-test/modification/executeAsync";
    protected RuntimeService runtimeServiceMock;
    protected ModificationBuilder modificationBuilderMock;

    @Before
    public void setUpRuntimeData() {
        this.runtimeServiceMock = (RuntimeService)Mockito.mock(RuntimeService.class);
        Mockito.when((Object)processEngine.getRuntimeService()).thenReturn((Object)this.runtimeServiceMock);
        this.modificationBuilderMock = (ModificationBuilder)Mockito.mock(ModificationBuilder.class);
        Mockito.when((Object)this.modificationBuilderMock.cancelAllForActivity(org.mockito.Matchers.anyString())).thenReturn((Object)this.modificationBuilderMock);
        Mockito.when((Object)this.modificationBuilderMock.startAfterActivity(org.mockito.Matchers.anyString())).thenReturn((Object)this.modificationBuilderMock);
        Mockito.when((Object)this.modificationBuilderMock.startBeforeActivity(org.mockito.Matchers.anyString())).thenReturn((Object)this.modificationBuilderMock);
        Mockito.when((Object)this.modificationBuilderMock.startTransition(org.mockito.Matchers.anyString())).thenReturn((Object)this.modificationBuilderMock);
        Mockito.when((Object)this.modificationBuilderMock.processInstanceIds(org.mockito.Matchers.anyListOf(String.class))).thenReturn((Object)this.modificationBuilderMock);
        Batch batchMock = MockProvider.createMockBatch();
        Mockito.when((Object)this.modificationBuilderMock.executeAsync()).thenReturn((Object)batchMock);
        Mockito.when((Object)this.runtimeServiceMock.createModification(org.mockito.Matchers.anyString())).thenReturn((Object)this.modificationBuilderMock);
    }

    @Test
    public void executeModificationSync() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("skipCustomListeners", true);
        json.put("skipIoMappings", true);
        json.put("processDefinitionId", "processDefinitionId");
        json.put("processInstanceIds", Arrays.asList("100", "20"));
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        instructions.add(ModificationInstructionBuilder.cancellation().activityId("activityId").getJson());
        instructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").getJson());
        instructions.add(ModificationInstructionBuilder.startAfter().activityId("activityId").getJson());
        instructions.add(ModificationInstructionBuilder.startTransition().transitionId("transitionId").getJson());
        json.put("instructions", instructions);
        RestAssured.given().contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(EXECUTE_MODIFICATION_SYNC_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createModification("processDefinitionId");
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).processInstanceIds((List)Mockito.eq(Arrays.asList("100", "20")));
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).cancelAllForActivity("activityId");
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).startBeforeActivity("activityId");
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).startAfterActivity("activityId");
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).startTransition("transitionId");
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).skipCustomListeners();
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).skipIoMappings();
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).execute();
    }

    @Test
    public void executeModificationWithNullProcessDefinitionIdAsync() {
        ((ModificationBuilder)Mockito.doThrow((Throwable)new BadUserRequestException("processDefinitionId must be set")).when((Object)this.modificationBuilderMock)).executeAsync();
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("skipCustomListeners", true);
        json.put("skipIoMappings", true);
        json.put("processInstanceIds", Arrays.asList("100", "20"));
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        instructions.add(ModificationInstructionBuilder.cancellation().activityId("activityId").getJson());
        instructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").getJson());
        instructions.add(ModificationInstructionBuilder.startAfter().activityId("activityId").getJson());
        instructions.add(ModificationInstructionBuilder.startTransition().transitionId("transitionId").getJson());
        json.put("instructions", instructions);
        RestAssured.given().contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(EXECUTE_MODIFICATION_ASYNC_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createModification(null);
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).processInstanceIds((List)Mockito.eq(Arrays.asList("100", "20")));
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).cancelAllForActivity("activityId");
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).startBeforeActivity("activityId");
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).startAfterActivity("activityId");
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).startTransition("transitionId");
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).skipCustomListeners();
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).skipIoMappings();
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).executeAsync();
    }

    @Test
    public void executeModificationWithNullProcessDefinitionIdSync() {
        ((ModificationBuilder)Mockito.doThrow((Throwable)new BadUserRequestException("processDefinitionId must be set")).when((Object)this.modificationBuilderMock)).execute();
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("skipCustomListeners", true);
        json.put("skipIoMappings", true);
        json.put("processInstanceIds", Arrays.asList("100", "20"));
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        instructions.add(ModificationInstructionBuilder.cancellation().activityId("activityId").getJson());
        instructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").getJson());
        instructions.add(ModificationInstructionBuilder.startAfter().activityId("activityId").getJson());
        instructions.add(ModificationInstructionBuilder.startTransition().transitionId("transitionId").getJson());
        json.put("instructions", instructions);
        RestAssured.given().contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(EXECUTE_MODIFICATION_SYNC_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createModification(null);
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).processInstanceIds((List)Mockito.eq(Arrays.asList("100", "20")));
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).cancelAllForActivity("activityId");
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).startBeforeActivity("activityId");
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).startAfterActivity("activityId");
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).startTransition("transitionId");
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).skipCustomListeners();
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).skipIoMappings();
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).execute();
    }

    @Test
    public void executeModificationWithNullProcessInstanceIdsSync() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        String message = "Process instance ids is null";
        ((ModificationBuilder)Mockito.doThrow((Throwable)new BadUserRequestException(message)).when((Object)this.modificationBuilderMock)).execute();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        instructions.add(ModificationInstructionBuilder.startAfter().activityId("anActivityId").getJson());
        instructions.add(ModificationInstructionBuilder.startTransition().transitionId("transitionId").getJson());
        json.put("processDefinitionId", "processDefinitionId");
        json.put("instructions", instructions);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("message", CoreMatchers.is((Object)message), new Object[0]).when().post(EXECUTE_MODIFICATION_SYNC_URL, new Object[0]);
    }

    @Test
    public void executeModificationAsync() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        instructions.add(ModificationInstructionBuilder.startTransition().transitionId("transitionId").getJson());
        instructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").getJson());
        instructions.add(ModificationInstructionBuilder.startAfter().activityId("activityId").getJson());
        instructions.add(ModificationInstructionBuilder.cancellation().activityId("activityId").getJson());
        json.put("processDefinitionId", "processDefinitionId");
        json.put("instructions", instructions);
        json.put("processInstanceIds", Arrays.asList("100", "20"));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(EXECUTE_MODIFICATION_ASYNC_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createModification("processDefinitionId");
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).processInstanceIds((List)Mockito.eq(Arrays.asList("100", "20")));
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).cancelAllForActivity("activityId");
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).startBeforeActivity("activityId");
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).startAfterActivity("activityId");
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).startTransition("transitionId");
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).executeAsync();
    }

    @Test
    public void executeModificationWithNullProcessInstanceIdsAsync() {
        HashMap json = new HashMap();
        String message = "Process instance ids is null";
        ((ModificationBuilder)Mockito.doThrow((Throwable)new BadUserRequestException(message)).when((Object)this.modificationBuilderMock)).executeAsync();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        instructions.add(ModificationInstructionBuilder.startAfter().activityId("anActivityId").getJson());
        instructions.add(ModificationInstructionBuilder.startTransition().transitionId("transitionId").getJson());
        json.put("instructions", instructions);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("message", CoreMatchers.is((Object)message), new Object[0]).when().post(EXECUTE_MODIFICATION_ASYNC_URL, new Object[0]);
    }

    @Test
    public void executeModificationWithValidProcessInstanceQuerySync() {
        Mockito.when((Object)this.runtimeServiceMock.createProcessInstanceQuery()).thenReturn((Object)new ProcessInstanceQueryImpl());
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        instructions.add(ModificationInstructionBuilder.startAfter().activityId("activityId").getJson());
        json.put("processDefinitionId", "processDefinitionId");
        ProcessInstanceQueryDto processInstanceQueryDto = new ProcessInstanceQueryDto();
        processInstanceQueryDto.setBusinessKey("foo");
        json.put("processInstanceQuery", processInstanceQueryDto);
        json.put("instructions", instructions);
        RestAssured.given().contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(EXECUTE_MODIFICATION_SYNC_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock, (VerificationMode)Mockito.times((int)1))).createProcessInstanceQuery();
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).startAfterActivity("activityId");
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).processInstanceQuery((ProcessInstanceQuery)processInstanceQueryDto.toQuery(processEngine));
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).execute();
    }

    @Test
    public void executeModificationWithValidProcessInstanceQueryAsync() {
        Mockito.when((Object)this.runtimeServiceMock.createProcessInstanceQuery()).thenReturn((Object)new ProcessInstanceQueryImpl());
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        instructions.add(ModificationInstructionBuilder.startAfter().activityId("activityId").getJson());
        ProcessInstanceQueryDto processInstanceQueryDto = new ProcessInstanceQueryDto();
        processInstanceQueryDto.setBusinessKey("foo");
        json.put("processInstanceQuery", processInstanceQueryDto);
        json.put("instructions", instructions);
        json.put("processDefinitionId", "processDefinitionId");
        RestAssured.given().contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(EXECUTE_MODIFICATION_ASYNC_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock, (VerificationMode)Mockito.times((int)1))).createProcessInstanceQuery();
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).startAfterActivity("activityId");
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).processInstanceQuery((ProcessInstanceQuery)processInstanceQueryDto.toQuery(processEngine));
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).executeAsync();
    }

    @Test
    public void executeModificationWithInvalidProcessInstanceQuerySync() {
        Mockito.when((Object)this.runtimeServiceMock.createProcessInstanceQuery()).thenReturn((Object)new ProcessInstanceQueryImpl());
        HashMap<String, Object> json = new HashMap<String, Object>();
        String message = "Process instance ids is null";
        ((ModificationBuilder)Mockito.doThrow((Throwable)new BadUserRequestException(message)).when((Object)this.modificationBuilderMock)).execute();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        instructions.add(ModificationInstructionBuilder.startAfter().activityId("acivityId").getJson());
        ProcessInstanceQueryDto processInstanceQueryDto = new ProcessInstanceQueryDto();
        processInstanceQueryDto.setBusinessKey("foo");
        json.put("processInstanceQuery", processInstanceQueryDto);
        json.put("instructions", instructions);
        json.put("processDefinitionId", "processDefinitionId");
        RestAssured.given().contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(EXECUTE_MODIFICATION_SYNC_URL, new Object[0]);
    }

    @Test
    public void executeModificationWithInvalidProcessInstanceQueryAsync() {
        Mockito.when((Object)this.runtimeServiceMock.createProcessInstanceQuery()).thenReturn((Object)new ProcessInstanceQueryImpl());
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        instructions.add(ModificationInstructionBuilder.startAfter().activityId("acivityId").getJson());
        ProcessInstanceQueryDto processInstanceQueryDto = new ProcessInstanceQueryDto();
        processInstanceQueryDto.setBusinessKey("foo");
        json.put("processInstanceQuery", processInstanceQueryDto);
        json.put("instructions", instructions);
        json.put("processDefinitionId", "processDefinitionId");
        RestAssured.given().contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(EXECUTE_MODIFICATION_ASYNC_URL, new Object[0]);
    }

    @Test
    public void executeModificationWithNullInstructionsSync() {
        ((ModificationBuilder)Mockito.doThrow((Throwable)new BadUserRequestException("Instructions must be set")).when((Object)this.modificationBuilderMock)).execute();
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("processInstanceIds", Arrays.asList("200", "11"));
        json.put("skipIoMappings", true);
        json.put("processDefinitionId", "processDefinitionId");
        RestAssured.given().contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Instructions must be set"), new Object[0]).when().post(EXECUTE_MODIFICATION_SYNC_URL, new Object[0]);
    }

    @Test
    public void executeModificationWithNullInstructionsAsync() {
        ((ModificationBuilder)Mockito.doThrow((Throwable)new BadUserRequestException("Instructions must be set")).when((Object)this.modificationBuilderMock)).executeAsync();
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("processInstanceIds", Arrays.asList("200", "11"));
        json.put("skipIoMappings", true);
        json.put("processDefinitionId", "processDefinitionId");
        RestAssured.given().contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Instructions must be set"), new Object[0]).when().post(EXECUTE_MODIFICATION_ASYNC_URL, new Object[0]);
    }

    @Test
    public void executeModificationThrowsAuthorizationException() {
        String message = "expected exception";
        ((ModificationBuilder)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.modificationBuilderMock)).executeAsync();
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        instructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").getJson());
        instructions.add(ModificationInstructionBuilder.startAfter().activityId("activityId").getJson());
        json.put("instructions", instructions);
        json.put("processInstanceIds", Arrays.asList("200", "323"));
        json.put("processDefinitionId", "processDefinitionId");
        RestAssured.given().contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(EXECUTE_MODIFICATION_ASYNC_URL, new Object[0]);
    }

    @Test
    public void executeInvalidModificationForStartAfterSync() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        json.put("skipIoMappings", true);
        json.put("processInstanceIds", Arrays.asList("200", "100"));
        instructions.add(ModificationInstructionBuilder.startAfter().getJson());
        json.put("instructions", instructions);
        json.put("processDefinitionId", "processDefinitionId");
        RestAssured.given().contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"For instruction type 'startAfterActivity': 'activityId' must be set"), new Object[0]).when().post(EXECUTE_MODIFICATION_SYNC_URL, new Object[0]);
    }

    @Test
    public void executeInvalidModificationForStartAfterAsync() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        json.put("skipIoMappings", true);
        json.put("processInstanceIds", Arrays.asList("200", "100"));
        instructions.add(ModificationInstructionBuilder.startAfter().getJson());
        json.put("instructions", instructions);
        json.put("processDefinitionId", "processDefinitionId");
        RestAssured.given().contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"For instruction type 'startAfterActivity': 'activityId' must be set"), new Object[0]).when().post(EXECUTE_MODIFICATION_ASYNC_URL, new Object[0]);
    }

    @Test
    public void executeInvalidModificationForStartBeforeSync() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        json.put("skipIoMappings", true);
        json.put("processInstanceIds", Arrays.asList("200", "100"));
        instructions.add(ModificationInstructionBuilder.startBefore().getJson());
        json.put("instructions", instructions);
        json.put("processDefinitionId", "processDefinitionId");
        RestAssured.given().contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"For instruction type 'startBeforeActivity': 'activityId' must be set"), new Object[0]).when().post(EXECUTE_MODIFICATION_SYNC_URL, new Object[0]);
    }

    @Test
    public void executeInvalidModificationForStartBeforeAsync() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        json.put("skipIoMappings", true);
        json.put("processInstanceIds", Arrays.asList("200", "100"));
        instructions.add(ModificationInstructionBuilder.startBefore().getJson());
        json.put("instructions", instructions);
        json.put("processDefinitionId", "processDefinitionId");
        RestAssured.given().contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"For instruction type 'startBeforeActivity': 'activityId' must be set"), new Object[0]).when().post(EXECUTE_MODIFICATION_ASYNC_URL, new Object[0]);
    }

    @Test
    public void executeInvalidModificationForStartTransitionSync() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        json.put("skipIoMappings", true);
        json.put("processInstanceIds", Arrays.asList("200", "100"));
        instructions.add(ModificationInstructionBuilder.startTransition().getJson());
        json.put("instructions", instructions);
        json.put("processDefinitionId", "processDefinitionId");
        RestAssured.given().contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"For instruction type 'startTransition': 'transitionId' must be set"), new Object[0]).when().post(EXECUTE_MODIFICATION_SYNC_URL, new Object[0]);
    }

    @Test
    public void executeInvalidModificationForStartTransitionAsync() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        json.put("skipIoMappings", true);
        json.put("processInstanceIds", Arrays.asList("200", "100"));
        instructions.add(ModificationInstructionBuilder.startTransition().getJson());
        json.put("instructions", instructions);
        json.put("processDefinitionId", "processDefinitionId");
        RestAssured.given().contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"For instruction type 'startTransition': 'transitionId' must be set"), new Object[0]).when().post(EXECUTE_MODIFICATION_ASYNC_URL, new Object[0]);
    }

    @Test
    public void executeInvalidModificationForCancelAllSync() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        json.put("skipIoMappings", true);
        json.put("processInstanceIds", Arrays.asList("200", "100"));
        instructions.add(ModificationInstructionBuilder.cancellation().getJson());
        json.put("instructions", instructions);
        json.put("processDefinitionId", "processDefinitionId");
        RestAssured.given().contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"For instruction type 'cancel': 'activityId' must be set"), new Object[0]).when().post(EXECUTE_MODIFICATION_SYNC_URL, new Object[0]);
    }

    @Test
    public void executeInvalidModificationForCancelAllAsync() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        json.put("skipIoMappings", true);
        json.put("processInstanceIds", Arrays.asList("200", "100"));
        instructions.add(ModificationInstructionBuilder.cancellation().getJson());
        json.put("instructions", instructions);
        json.put("processDefinitionId", "processDefinitionId");
        RestAssured.given().contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"For instruction type 'cancel': 'activityId' must be set"), new Object[0]).when().post(EXECUTE_MODIFICATION_ASYNC_URL, new Object[0]);
    }

    @Test
    public void executeCancellationWithActiveFlagSync() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        json.put("skipIoMappings", true);
        json.put("processInstanceIds", Arrays.asList("200", "100"));
        instructions.add(ModificationInstructionBuilder.cancellation().activityId("activityId").cancelCurrentActiveActivityInstances(true).getJson());
        json.put("instructions", instructions);
        json.put("processDefinitionId", "processDefinitionId");
        RestAssured.given().contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(EXECUTE_MODIFICATION_SYNC_URL, new Object[0]);
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).cancelAllForActivity("activityId", true);
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).execute();
    }

    @Test
    public void executeCancellationWithActiveFlagAsync() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        json.put("skipIoMappings", true);
        json.put("processInstanceIds", Arrays.asList("200", "100"));
        instructions.add(ModificationInstructionBuilder.cancellation().activityId("activityId").cancelCurrentActiveActivityInstances(true).getJson());
        json.put("instructions", instructions);
        json.put("processDefinitionId", "processDefinitionId");
        RestAssured.given().contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(EXECUTE_MODIFICATION_ASYNC_URL, new Object[0]);
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).cancelAllForActivity("activityId", true);
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).executeAsync();
    }

    @Test
    public void executeCancellationWithoutActiveFlagSync() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        json.put("skipIoMappings", true);
        json.put("processInstanceIds", Arrays.asList("200", "100"));
        instructions.add(ModificationInstructionBuilder.cancellation().activityId("activityId").cancelCurrentActiveActivityInstances(false).getJson());
        json.put("instructions", instructions);
        json.put("processDefinitionId", "processDefinitionId");
        RestAssured.given().contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(EXECUTE_MODIFICATION_SYNC_URL, new Object[0]);
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).cancelAllForActivity("activityId");
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).execute();
    }

    @Test
    public void executeCancellationWithoutActiveFlagAsync() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        json.put("skipIoMappings", true);
        json.put("processInstanceIds", Arrays.asList("200", "100"));
        instructions.add(ModificationInstructionBuilder.cancellation().activityId("activityId").cancelCurrentActiveActivityInstances(false).getJson());
        json.put("instructions", instructions);
        json.put("processDefinitionId", "processDefinitionId");
        RestAssured.given().contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(EXECUTE_MODIFICATION_ASYNC_URL, new Object[0]);
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).cancelAllForActivity("activityId");
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).executeAsync();
    }

    @Test
    public void executeSyncModificationWithAnnotation() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        json.put("skipIoMappings", true);
        json.put("processInstanceIds", Arrays.asList("200", "100"));
        instructions.add(ModificationInstructionBuilder.cancellation().activityId("activityId").cancelCurrentActiveActivityInstances(false).getJson());
        json.put("instructions", instructions);
        json.put("processDefinitionId", "processDefinitionId");
        json.put("annotation", "anAnnotation");
        RestAssured.given().contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(EXECUTE_MODIFICATION_SYNC_URL, new Object[0]);
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).skipIoMappings();
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).cancelAllForActivity("activityId");
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).setAnnotation("anAnnotation");
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).execute();
    }

    @Test
    public void executeAsyncModificationWithAnnotation() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        json.put("skipCustomListeners", true);
        json.put("processInstanceIds", Arrays.asList("200", "100"));
        instructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").getJson());
        json.put("instructions", instructions);
        json.put("processDefinitionId", "processDefinitionId");
        json.put("annotation", "anAnnotation");
        RestAssured.given().contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(EXECUTE_MODIFICATION_ASYNC_URL, new Object[0]);
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).skipCustomListeners();
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).startBeforeActivity("activityId");
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).setAnnotation("anAnnotation");
        ((ModificationBuilder)Mockito.verify((Object)this.modificationBuilderMock)).executeAsync();
    }
}

