/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.identity.Tenant;
import org.camunda.bpm.engine.identity.TenantQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class TenantRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String QUERY_URL = "/rest-test/tenant";
    protected static final String COUNT_QUERY_URL = "/rest-test/tenant/count";
    private TenantQuery mockQuery;

    @Before
    public void setUpRuntimeData() {
        List<Tenant> tenants = Collections.singletonList(MockProvider.createMockTenant());
        this.mockQuery = this.setUpMockQuery(tenants);
    }

    private TenantQuery setUpMockQuery(List<Tenant> tenants) {
        TenantQuery query = (TenantQuery)Mockito.mock(TenantQuery.class);
        Mockito.when((Object)query.list()).thenReturn(tenants);
        Mockito.when((Object)query.count()).thenReturn((Object)tenants.size());
        Mockito.when((Object)processEngine.getIdentityService().createTenantQuery()).thenReturn((Object)query);
        return query;
    }

    @Test
    public void emptyQuery() {
        String queryKey = "";
        RestAssured.given().queryParam("name", new Object[]{queryKey}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(QUERY_URL, new Object[0]);
    }

    @Test
    public void noParametersQuery() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(QUERY_URL, new Object[0]);
        ((TenantQuery)Mockito.verify((Object)this.mockQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockQuery});
    }

    @Test
    public void tenantRetrieval() {
        String name = "aTenantName";
        Response response = (Response)RestAssured.given().queryParam("name", new Object[]{name}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        ((TenantQuery)inOrder.verify((Object)this.mockQuery)).tenantName(name);
        ((TenantQuery)inOrder.verify((Object)this.mockQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertThat((Object)instances.size(), (Matcher)CoreMatchers.is((Object)1));
        String returnedId = JsonPath.from((String)content).getString("[0].id");
        String returnedName = JsonPath.from((String)content).getString("[0].name");
        Assert.assertThat((Object)returnedId, (Matcher)CoreMatchers.is((Object)"aTenantId"));
        Assert.assertThat((Object)returnedName, (Matcher)CoreMatchers.is((Object)"aTenantName"));
    }

    @Test
    public void completeGetParameters() {
        Map<String, String> queryParameters = this.getCompleteStringQueryParameters();
        RequestSpecification requestSpecification = RestAssured.given().contentType(POST_JSON_CONTENT_TYPE);
        for (Map.Entry<String, String> paramEntry : queryParameters.entrySet()) {
            requestSpecification.parameter(paramEntry.getKey(), new Object[]{paramEntry.getValue()});
        }
        requestSpecification.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(QUERY_URL, new Object[0]);
        ((TenantQuery)Mockito.verify((Object)this.mockQuery)).tenantId("aTenantId");
        ((TenantQuery)Mockito.verify((Object)this.mockQuery)).tenantName("aTenantName");
        ((TenantQuery)Mockito.verify((Object)this.mockQuery)).tenantNameLike("%aTenantName%");
        ((TenantQuery)Mockito.verify((Object)this.mockQuery)).userMember("userId");
        ((TenantQuery)Mockito.verify((Object)this.mockQuery)).groupMember("groupId1");
        ((TenantQuery)Mockito.verify((Object)this.mockQuery)).list();
    }

    private Map<String, String> getCompleteStringQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", "aTenantId");
        parameters.put("name", "aTenantName");
        parameters.put("nameLike", "%aTenantName%");
        parameters.put("userMember", "userId");
        parameters.put("groupMember", "groupId1");
        return parameters;
    }

    @Test
    public void queryByUserIncludingGroups() {
        RestAssured.given().queryParam("userMember", new Object[]{"userId"}).queryParam("includingGroupsOfUser", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(QUERY_URL, new Object[0]);
        ((TenantQuery)Mockito.verify((Object)this.mockQuery)).userMember("userId");
        ((TenantQuery)Mockito.verify((Object)this.mockQuery)).includingGroupsOfUser(true);
        ((TenantQuery)Mockito.verify((Object)this.mockQuery)).list();
    }

    @Test
    public void queryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(COUNT_QUERY_URL, new Object[0]);
        ((TenantQuery)Mockito.verify((Object)this.mockQuery)).count();
    }

    @Test
    public void queryPagination() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(QUERY_URL, new Object[0]);
        ((TenantQuery)Mockito.verify((Object)this.mockQuery)).listPage(firstResult, maxResults);
    }

    @Test
    public void sortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"name"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(QUERY_URL, new Object[0]);
    }

    @Test
    public void sortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(QUERY_URL, new Object[0]);
    }

    @Test
    public void sortById() {
        RestAssured.given().queryParam("sortBy", new Object[]{"id"}).queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        ((TenantQuery)inOrder.verify((Object)this.mockQuery)).orderByTenantId();
        ((TenantQuery)inOrder.verify((Object)this.mockQuery)).asc();
    }

    @Test
    public void sortByName() {
        RestAssured.given().queryParam("sortBy", new Object[]{"name"}).queryParam("sortOrder", new Object[]{"desc"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        ((TenantQuery)inOrder.verify((Object)this.mockQuery)).orderByTenantName();
        ((TenantQuery)inOrder.verify((Object)this.mockQuery)).desc();
    }
}

