/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.history.HistoricIdentityLinkLog;
import org.camunda.bpm.engine.history.HistoricIdentityLinkLogQuery;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class HistoricIdentityLinkLogRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORY_IDENTITY_LINK_QUERY_URL = "/rest-test/history/identity-link-log";
    protected static final String HISTORY_IDENTITY_LINK_COUNT_QUERY_URL = "/rest-test/history/identity-link-log/count";
    private HistoricIdentityLinkLogQuery mockedQuery;

    @Before
    public void setUpRuntimeData() {
        this.mockedQuery = this.setUpMockHistoricIdentityLinkQuery(MockProvider.createMockHistoricIdentityLinks());
    }

    private HistoricIdentityLinkLogQuery setUpMockHistoricIdentityLinkQuery(List<HistoricIdentityLinkLog> mockedHistoricIdentityLinks) {
        HistoricIdentityLinkLogQuery mockedHistoricIdentityLinkQuery = (HistoricIdentityLinkLogQuery)Mockito.mock(HistoricIdentityLinkLogQuery.class);
        Mockito.when((Object)mockedHistoricIdentityLinkQuery.list()).thenReturn(mockedHistoricIdentityLinks);
        Mockito.when((Object)mockedHistoricIdentityLinkQuery.count()).thenReturn((Object)mockedHistoricIdentityLinks.size());
        Mockito.when((Object)processEngine.getHistoryService().createHistoricIdentityLinkLogQuery()).thenReturn((Object)mockedHistoricIdentityLinkQuery);
        return mockedHistoricIdentityLinkQuery;
    }

    @Test
    public void testEmptyQuery() {
        String queryKey = "";
        RestAssured.given().queryParam("userId", new Object[]{queryKey}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_IDENTITY_LINK_QUERY_URL, new Object[0]);
    }

    @Test
    public void testNoParametersQuery() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_IDENTITY_LINK_QUERY_URL, new Object[0]);
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testInvalidSortingOptions() {
        this.executeAndVerifySorting("anInvalidSortByOption", "asc", Response.Status.BAD_REQUEST);
        this.executeAndVerifySorting("processInstanceId", "anInvalidSortOrderOption", Response.Status.BAD_REQUEST);
    }

    @Test
    public void testQueryWithoutTenantIdQueryParameter() {
        this.mockedQuery = this.setUpMockHistoricIdentityLinkQuery(Collections.singletonList(MockProvider.createMockHistoricIdentityLink(null)));
        Response response = (Response)RestAssured.given().queryParam("withoutTenantId", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_IDENTITY_LINK_QUERY_URL, new Object[0]);
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).withoutTenantId();
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(1);
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        Assertions.assertThat((String)returnedTenantId).isEqualTo(null);
    }

    protected void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(HISTORY_IDENTITY_LINK_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORY_IDENTITY_LINK_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortingParameters() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("assignerId", "asc", Response.Status.OK);
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByAssignerId();
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("assignerId", "desc", Response.Status.OK);
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByAssignerId();
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("userId", "asc", Response.Status.OK);
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByUserId();
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("userId", "desc", Response.Status.OK);
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByUserId();
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("groupId", "asc", Response.Status.OK);
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByGroupId();
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("groupId", "desc", Response.Status.OK);
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByGroupId();
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("taskId", "asc", Response.Status.OK);
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByTaskId();
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("taskId", "desc", Response.Status.OK);
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByTaskId();
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("operationType", "asc", Response.Status.OK);
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByOperationType();
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("operationType", "desc", Response.Status.OK);
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByOperationType();
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processDefinitionId", "asc", Response.Status.OK);
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionId();
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processDefinitionId", "desc", Response.Status.OK);
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionId();
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processDefinitionKey", "asc", Response.Status.OK);
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionKey();
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processDefinitionKey", "desc", Response.Status.OK);
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionKey();
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("type", "asc", Response.Status.OK);
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByType();
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("type", "desc", Response.Status.OK);
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByType();
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "asc", Response.Status.OK);
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "desc", Response.Status.OK);
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).desc();
    }

    @Test
    public void testSimpleHistoricIdentityLinkQuery() {
        Response response = (Response)RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_IDENTITY_LINK_QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricIdentityLinkLogQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List identityLinks = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one incident returned.", (long)1L, (long)identityLinks.size());
        Assert.assertNotNull((String)"The returned incident should not be null.", identityLinks.get(0));
        String returnedAssignerId = JsonPath.from((String)content).getString("[0].assignerId");
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedUserId = JsonPath.from((String)content).getString("[0].userId");
        String returnedGroupId = JsonPath.from((String)content).getString("[0].groupId");
        String returnedTaskId = JsonPath.from((String)content).getString("[0].taskId");
        String returnedType = JsonPath.from((String)content).getString("[0].type");
        String returnedProcessDefinitionId = JsonPath.from((String)content).getString("[0].processDefinitionId");
        String returnedProcessDefinitionKey = JsonPath.from((String)content).getString("[0].processDefinitionKey");
        String returnedOperationType = JsonPath.from((String)content).getString("[0].operationType");
        Date loggedDate = DateTimeUtil.parseDate((String)JsonPath.from((String)content).getString("[0].time"));
        Date returnedRemovalTime = DateTimeUtil.parseDate((String)JsonPath.from((String)content).getString("[0].removalTime"));
        String returnedRootProcessInstanceId = JsonPath.from((String)content).getString("[0].rootProcessInstanceId");
        Assert.assertEquals((Object)DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HIST_IDENTITY_LINK_TIME), (Object)loggedDate);
        Assert.assertEquals((Object)"aAssignerId", (Object)returnedAssignerId);
        Assert.assertEquals((Object)"aUserId", (Object)returnedUserId);
        Assert.assertEquals((Object)"aGroupId", (Object)returnedGroupId);
        Assert.assertEquals((Object)"aTaskId", (Object)returnedTaskId);
        Assert.assertEquals((Object)"aProcDefId", (Object)returnedProcessDefinitionId);
        Assert.assertEquals((Object)"aProcDefKey", (Object)returnedProcessDefinitionKey);
        Assert.assertEquals((Object)"assignee", (Object)returnedType);
        Assert.assertEquals((Object)"add", (Object)returnedOperationType);
        Assert.assertEquals((Object)"aTenantId", (Object)returnedTenantId);
        Assert.assertEquals((Object)DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HIST_IDENTITY_LINK_REMOVAL_TIME), (Object)returnedRemovalTime);
        Assert.assertEquals((Object)"aRootProcInstId", (Object)returnedRootProcessInstanceId);
    }

    @Test
    public void testQueryByTenantIds() {
        this.mockedQuery = this.setUpMockHistoricIdentityLinkQuery(Arrays.asList(MockProvider.createMockHistoricIdentityLink("aTenantId"), MockProvider.createMockHistoricIdentityLink("anotherTenantId")));
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId,anotherTenantId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_IDENTITY_LINK_QUERY_URL, new Object[0]);
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List executions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)executions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testSuccessfulPagination() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_IDENTITY_LINK_QUERY_URL, new Object[0]);
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, maxResults);
    }

    @Test
    public void testMissingFirstResultParameter() {
        int maxResults = 10;
        RestAssured.given().queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_IDENTITY_LINK_QUERY_URL, new Object[0]);
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).listPage(0, maxResults);
    }

    @Test
    public void testMissingMaxResultsParameter() {
        int firstResult = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_IDENTITY_LINK_QUERY_URL, new Object[0]);
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, Integer.MAX_VALUE);
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(HISTORY_IDENTITY_LINK_COUNT_QUERY_URL, new Object[0]);
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testQueryByAssignerId() {
        String assignerId = "aAssignerId";
        RestAssured.given().queryParam("assignerId", new Object[]{assignerId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_IDENTITY_LINK_QUERY_URL, new Object[0]);
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).assignerId(assignerId);
    }

    @Test
    public void testQueryByUserId() {
        String userId = "aUserId";
        RestAssured.given().queryParam("userId", new Object[]{userId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_IDENTITY_LINK_QUERY_URL, new Object[0]);
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).userId(userId);
    }

    @Test
    public void testQueryByGroupId() {
        String groupId = "aGroupId";
        RestAssured.given().queryParam("groupId", new Object[]{groupId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_IDENTITY_LINK_QUERY_URL, new Object[0]);
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).groupId(groupId);
    }

    @Test
    public void testQueryByTaskId() {
        String taskId = "aTaskId";
        RestAssured.given().queryParam("taskId", new Object[]{taskId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_IDENTITY_LINK_QUERY_URL, new Object[0]);
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).taskId(taskId);
    }

    @Test
    public void testQueryByProcessDefinitionId() {
        String processDefinitionId = "aProcDefId";
        RestAssured.given().queryParam("processDefinitionId", new Object[]{processDefinitionId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_IDENTITY_LINK_QUERY_URL, new Object[0]);
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionId(processDefinitionId);
    }

    @Test
    public void testQueryByProcessDefinitionKey() {
        String processDefinitionKey = "aProcDefKey";
        RestAssured.given().queryParam("processDefinitionKey", new Object[]{processDefinitionKey}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_IDENTITY_LINK_QUERY_URL, new Object[0]);
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionKey(processDefinitionKey);
    }

    @Test
    public void testQueryByType() {
        String type = "assignee";
        RestAssured.given().queryParam("type", new Object[]{type}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_IDENTITY_LINK_QUERY_URL, new Object[0]);
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).type(type);
    }

    @Test
    public void testQueryByOperationType() {
        String operationType = "add";
        RestAssured.given().queryParam("operationType", new Object[]{operationType}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_IDENTITY_LINK_QUERY_URL, new Object[0]);
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).operationType(operationType);
    }

    @Test
    public void testQueryByDateBefore() {
        Date dateBefore = DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HIST_IDENTITY_LINK_TIME);
        RestAssured.given().queryParam("dateBefore", new Object[]{MockProvider.EXAMPLE_HIST_IDENTITY_LINK_TIME}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_IDENTITY_LINK_QUERY_URL, new Object[0]);
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).dateBefore(dateBefore);
    }

    @Test
    public void testQueryByDateAfter() {
        Date dateAfter = DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HIST_IDENTITY_LINK_TIME);
        RestAssured.given().queryParam("dateAfter", new Object[]{MockProvider.EXAMPLE_HIST_IDENTITY_LINK_TIME}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_IDENTITY_LINK_QUERY_URL, new Object[0]);
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).dateAfter(dateAfter);
    }

    @Test
    public void testQueryByTenantId() {
        String tenantId = "aTenantId";
        RestAssured.given().queryParam("tenantIdIn", new Object[]{tenantId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_IDENTITY_LINK_QUERY_URL, new Object[0]);
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{tenantId});
    }

    @Test
    public void testAdditionalParameters() {
        Map<String, String> stringQueryParameters = this.getCompleteStringQueryParameters();
        RestAssured.given().queryParams(stringQueryParameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_IDENTITY_LINK_QUERY_URL, new Object[0]);
        this.verifyStringParameterQueryInvocations();
    }

    protected Map<String, String> getCompleteStringQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("assignerId", "aAssignerId");
        parameters.put("dateBefore", MockProvider.EXAMPLE_HIST_IDENTITY_LINK_DATE_BEFORE);
        parameters.put("dateAfter", MockProvider.EXAMPLE_HIST_IDENTITY_LINK_DATE_AFTER);
        parameters.put("userId", "aUserId");
        parameters.put("groupId", "aGroupId");
        parameters.put("taskId", "aTaskId");
        parameters.put("processDefinitionId", "aProcDefId");
        parameters.put("processDefinitionKey", "aProcDefKey");
        parameters.put("operationType", "add");
        parameters.put("tenantIdIn", "aTenantId");
        parameters.put("type", "assignee");
        return parameters;
    }

    protected void verifyStringParameterQueryInvocations() {
        Map<String, String> stringQueryParameters = this.getCompleteStringQueryParameters();
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).assignerId(stringQueryParameters.get("assignerId"));
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).userId(stringQueryParameters.get("userId"));
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).groupId(stringQueryParameters.get("groupId"));
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).taskId(stringQueryParameters.get("taskId"));
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).dateBefore(DateTimeUtil.parseDate((String)stringQueryParameters.get("dateBefore")));
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).dateAfter(DateTimeUtil.parseDate((String)stringQueryParameters.get("dateAfter")));
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).type(stringQueryParameters.get("type"));
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).operationType(stringQueryParameters.get("operationType"));
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionId(stringQueryParameters.get("processDefinitionId"));
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionKey(stringQueryParameters.get("processDefinitionKey"));
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{stringQueryParameters.get("tenantIdIn")});
        ((HistoricIdentityLinkLogQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }
}

