/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.util.container;

import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import org.camunda.bpm.engine.rest.util.container.ContainerSpecifics;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TestContainerRule
implements TestRule {
    private static final Logger LOGGER = Logger.getLogger(TestContainerRule.class.getSimpleName());
    protected ContainerSpecifics containerSpecifics;

    public Statement apply(Statement base, Description description) {
        this.lookUpContainerSpecifics();
        TestRule containerSpecificRule = this.containerSpecifics.getTestRule(description.getTestClass());
        return containerSpecificRule.apply(base, description);
    }

    protected void lookUpContainerSpecifics() {
        if (this.containerSpecifics == null) {
            ServiceLoader<ContainerSpecifics> serviceLoader = ServiceLoader.load(ContainerSpecifics.class);
            Iterator<ContainerSpecifics> it = serviceLoader.iterator();
            if (it.hasNext()) {
                ContainerSpecifics containerSpecifics;
                this.containerSpecifics = containerSpecifics = it.next();
                if (it.hasNext()) {
                    LOGGER.warning("There is more than one test runtime container implementation present on the classpath. Using " + containerSpecifics.getClass().getName());
                }
            } else {
                throw new RuntimeException("Could not find container provider SPI that implements " + ContainerSpecifics.class.getName());
            }
        }
    }
}

