/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.util;

import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.telemetry.PlatformTelemetryRegistry;
import org.camunda.bpm.engine.impl.telemetry.TelemetryRegistry;
import org.camunda.bpm.engine.impl.telemetry.dto.LicenseKeyData;
import org.camunda.bpm.engine.rest.spi.ProcessEngineProvider;
import org.camunda.bpm.engine.rest.util.EngineUtil;

public class WebApplicationUtil {
    public static void setApplicationServer(String serverInfo) {
        if (serverInfo != null && !serverInfo.isEmpty() && PlatformTelemetryRegistry.getApplicationServer() == null) {
            PlatformTelemetryRegistry.setApplicationServer((String)serverInfo);
        }
    }

    public static void setLicenseKey(LicenseKeyData licenseKeyData) {
        if (licenseKeyData != null) {
            ProcessEngineProvider processEngineProvider = EngineUtil.getProcessEngineProvider();
            for (String engineName : processEngineProvider.getProcessEngineNames()) {
                TelemetryRegistry telemetryRegistry = WebApplicationUtil.getTelemetryRegistry(processEngineProvider, engineName);
                if (telemetryRegistry == null) continue;
                telemetryRegistry.setLicenseKey(licenseKeyData);
            }
        }
    }

    public static boolean setWebapp(String engineName, String webapp) {
        ProcessEngineProvider processEngineProvider = EngineUtil.getProcessEngineProvider();
        TelemetryRegistry telemetryRegistry = WebApplicationUtil.getTelemetryRegistry(processEngineProvider, engineName);
        if (telemetryRegistry != null) {
            telemetryRegistry.addWebapp(webapp);
            return true;
        }
        return false;
    }

    protected static TelemetryRegistry getTelemetryRegistry(ProcessEngineProvider processEngineProvider, String engineName) {
        ProcessEngine processEngine = processEngineProvider.getProcessEngine(engineName);
        if (processEngine != null) {
            return processEngine.getProcessEngineConfiguration().getTelemetryRegistry();
        }
        return null;
    }
}

