/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.externaltask.ExternalTaskQueryTopicBuilder;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.externaltask.UpdateExternalTaskRetriesBuilder;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.impl.ExternalTaskQueryImpl;
import org.camunda.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoryServiceImpl;
import org.camunda.bpm.engine.impl.ProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.RuntimeServiceImpl;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.externaltask.ExternalTaskQueryDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricProcessInstanceQueryDto;
import org.camunda.bpm.engine.rest.dto.runtime.ProcessInstanceQueryDto;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.helper.EqualsVariableMap;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.helper.variable.EqualsObjectValue;
import org.camunda.bpm.engine.rest.helper.variable.EqualsPrimitiveValue;
import org.camunda.bpm.engine.rest.helper.variable.EqualsUntypedValue;
import org.camunda.bpm.engine.rest.util.VariablesBuilder;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ExternalTaskRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String EXTERNAL_TASK_URL = "/rest-test/external-task";
    protected static final String FETCH_EXTERNAL_TASK_URL = "/rest-test/external-task/fetchAndLock";
    protected static final String SINGLE_EXTERNAL_TASK_URL = "/rest-test/external-task/{id}";
    protected static final String COMPLETE_EXTERNAL_TASK_URL = "/rest-test/external-task/{id}/complete";
    protected static final String GET_EXTERNAL_TASK_ERROR_DETAILS_URL = "/rest-test/external-task/{id}/errorDetails";
    protected static final String HANDLE_EXTERNAL_TASK_FAILURE_URL = "/rest-test/external-task/{id}/failure";
    protected static final String HANDLE_EXTERNAL_TASK_BPMN_ERROR_URL = "/rest-test/external-task/{id}/bpmnError";
    protected static final String UNLOCK_EXTERNAL_TASK_URL = "/rest-test/external-task/{id}/unlock";
    protected static final String RETRIES_EXTERNAL_TASK_URL = "/rest-test/external-task/{id}/retries";
    protected static final String RETRIES_EXTERNAL_TASK_SYNC_URL = "/rest-test/external-task/retries";
    protected static final String RETRIES_EXTERNAL_TASKS_ASYNC_URL = "/rest-test/external-task/retries-async";
    protected static final String PRIORITY_EXTERNAL_TASK_URL = "/rest-test/external-task/{id}/priority";
    protected static final String LOCK_EXTERNAL_TASK = "/rest-test/external-task/{id}/lock";
    protected static final String EXTEND_LOCK_ON_EXTERNAL_TASK = "/rest-test/external-task/{id}/extendLock";
    protected ExternalTaskService externalTaskService;
    protected RuntimeServiceImpl runtimeServiceMock;
    protected HistoryServiceImpl historyServiceMock;
    protected LockedExternalTask lockedExternalTaskMock;
    protected ExternalTaskQueryTopicBuilder fetchTopicBuilder;
    protected ExternalTask externalTaskMock;
    protected ExternalTaskQuery externalTaskQueryMock;
    protected UpdateExternalTaskRetriesBuilder updateRetriesBuilder;

    @Before
    public void setUpRuntimeData() {
        this.externalTaskService = (ExternalTaskService)Mockito.mock(ExternalTaskService.class);
        Mockito.when((Object)processEngine.getExternalTaskService()).thenReturn((Object)this.externalTaskService);
        this.runtimeServiceMock = (RuntimeServiceImpl)Mockito.mock(RuntimeServiceImpl.class);
        Mockito.when((Object)processEngine.getRuntimeService()).thenReturn((Object)this.runtimeServiceMock);
        this.historyServiceMock = (HistoryServiceImpl)Mockito.mock(HistoryServiceImpl.class);
        Mockito.when((Object)processEngine.getHistoryService()).thenReturn((Object)this.historyServiceMock);
        this.lockedExternalTaskMock = MockProvider.createMockLockedExternalTask();
        this.fetchTopicBuilder = (ExternalTaskQueryTopicBuilder)Mockito.mock(ExternalTaskQueryTopicBuilder.class);
        Mockito.when((Object)this.externalTaskService.fetchAndLock(Matchers.anyInt(), (String)Matchers.any(String.class))).thenReturn((Object)this.fetchTopicBuilder);
        Mockito.when((Object)this.externalTaskService.fetchAndLock(Matchers.anyInt(), (String)Matchers.any(String.class), ((Boolean)Matchers.any(Boolean.class)).booleanValue())).thenReturn((Object)this.fetchTopicBuilder);
        Mockito.when((Object)this.fetchTopicBuilder.topic((String)Matchers.any(String.class), Matchers.anyLong())).thenReturn((Object)this.fetchTopicBuilder);
        Mockito.when((Object)this.fetchTopicBuilder.variables(Matchers.anyListOf(String.class))).thenReturn((Object)this.fetchTopicBuilder);
        Mockito.when((Object)this.fetchTopicBuilder.variables((String[])Matchers.any(String[].class))).thenReturn((Object)this.fetchTopicBuilder);
        Mockito.when((Object)this.fetchTopicBuilder.enableCustomObjectDeserialization()).thenReturn((Object)this.fetchTopicBuilder);
        Mockito.when((Object)this.fetchTopicBuilder.localVariables()).thenReturn((Object)this.fetchTopicBuilder);
        Mockito.when((Object)this.fetchTopicBuilder.topic((String)Matchers.any(String.class), Matchers.anyLong())).thenReturn((Object)this.fetchTopicBuilder);
        Mockito.when((Object)this.fetchTopicBuilder.businessKey((String)Matchers.any(String.class))).thenReturn((Object)this.fetchTopicBuilder);
        Mockito.when((Object)this.fetchTopicBuilder.processDefinitionId((String)Matchers.any(String.class))).thenReturn((Object)this.fetchTopicBuilder);
        Mockito.when((Object)this.fetchTopicBuilder.processDefinitionIdIn(new String[]{(String)Matchers.any(String.class)})).thenReturn((Object)this.fetchTopicBuilder);
        Mockito.when((Object)this.fetchTopicBuilder.processDefinitionKey((String)Matchers.any(String.class))).thenReturn((Object)this.fetchTopicBuilder);
        Mockito.when((Object)this.fetchTopicBuilder.processDefinitionKeyIn(new String[]{(String)Matchers.any(String.class)})).thenReturn((Object)this.fetchTopicBuilder);
        Mockito.when((Object)this.fetchTopicBuilder.processInstanceVariableEquals(Matchers.anyMapOf(String.class, Object.class))).thenReturn((Object)this.fetchTopicBuilder);
        Mockito.when((Object)this.fetchTopicBuilder.processDefinitionVersionTag(Matchers.anyString())).thenReturn((Object)this.fetchTopicBuilder);
        Mockito.when((Object)this.fetchTopicBuilder.withoutTenantId()).thenReturn((Object)this.fetchTopicBuilder);
        Mockito.when((Object)this.fetchTopicBuilder.tenantIdIn(new String[]{(String)Matchers.any(String.class)})).thenReturn((Object)this.fetchTopicBuilder);
        Mockito.when((Object)this.fetchTopicBuilder.includeExtensionProperties()).thenReturn((Object)this.fetchTopicBuilder);
        Batch batch = MockProvider.createMockBatch();
        this.updateRetriesBuilder = (UpdateExternalTaskRetriesBuilder)Mockito.mock(UpdateExternalTaskRetriesBuilder.class);
        Mockito.when((Object)this.externalTaskService.updateRetries()).thenReturn((Object)this.updateRetriesBuilder);
        Mockito.when((Object)this.updateRetriesBuilder.externalTaskIds(Matchers.anyListOf(String.class))).thenReturn((Object)this.updateRetriesBuilder);
        Mockito.when((Object)this.updateRetriesBuilder.processInstanceIds(Matchers.anyListOf(String.class))).thenReturn((Object)this.updateRetriesBuilder);
        Mockito.when((Object)this.updateRetriesBuilder.externalTaskQuery((ExternalTaskQuery)Matchers.any(ExternalTaskQuery.class))).thenReturn((Object)this.updateRetriesBuilder);
        Mockito.when((Object)this.updateRetriesBuilder.processInstanceQuery((ProcessInstanceQuery)Matchers.any(ProcessInstanceQuery.class))).thenReturn((Object)this.updateRetriesBuilder);
        Mockito.when((Object)this.updateRetriesBuilder.historicProcessInstanceQuery((HistoricProcessInstanceQuery)Matchers.any(HistoricProcessInstanceQuery.class))).thenReturn((Object)this.updateRetriesBuilder);
        Mockito.when((Object)this.updateRetriesBuilder.setAsync(Matchers.anyInt())).thenReturn((Object)batch);
        this.externalTaskQueryMock = (ExternalTaskQuery)Mockito.mock(ExternalTaskQuery.class);
        Mockito.when((Object)this.externalTaskQueryMock.externalTaskId((String)Matchers.any(String.class))).thenReturn((Object)this.externalTaskQueryMock);
        Mockito.when((Object)this.externalTaskService.createExternalTaskQuery()).thenReturn((Object)this.externalTaskQueryMock);
        this.externalTaskMock = MockProvider.createMockExternalTask();
    }

    @Test
    public void testFetchAndLock() {
        Mockito.when((Object)this.fetchTopicBuilder.execute()).thenReturn(Arrays.asList(this.lockedExternalTaskMock));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("maxTasks", 5);
        parameters.put("workerId", "aWorkerId");
        parameters.put("usePriority", true);
        HashMap<String, Object> topicParameter = new HashMap<String, Object>();
        topicParameter.put("topicName", "aTopicName");
        topicParameter.put("lockDuration", 12354L);
        topicParameter.put("variables", Arrays.asList("aVariableInstanceName"));
        parameters.put("topics", Arrays.asList(topicParameter));
        this.executePost(parameters);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
        ((ExternalTaskService)inOrder.verify((Object)this.externalTaskService)).fetchAndLock(5, "aWorkerId", true);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).topic("aTopicName", 12354L);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).variables(Arrays.asList("aVariableInstanceName"));
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
    }

    @Test
    public void testFetchAndLockWithBusinessKey() {
        Mockito.when((Object)this.fetchTopicBuilder.execute()).thenReturn(Arrays.asList(this.lockedExternalTaskMock));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("maxTasks", 5);
        parameters.put("workerId", "aWorkerId");
        parameters.put("usePriority", true);
        HashMap<String, Object> topicParameter = new HashMap<String, Object>();
        topicParameter.put("topicName", "aTopicName");
        topicParameter.put("businessKey", "aBusinessKey");
        topicParameter.put("lockDuration", 12354L);
        topicParameter.put("variables", Arrays.asList("aVariableInstanceName"));
        parameters.put("topics", Arrays.asList(topicParameter));
        this.executePost(parameters);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
        ((ExternalTaskService)inOrder.verify((Object)this.externalTaskService)).fetchAndLock(5, "aWorkerId", true);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).topic("aTopicName", 12354L);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).businessKey("aBusinessKey");
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).variables(Arrays.asList("aVariableInstanceName"));
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
    }

    @Test
    public void testFetchAndLockWithProcessDefinition() {
        Mockito.when((Object)this.fetchTopicBuilder.execute()).thenReturn(Arrays.asList(this.lockedExternalTaskMock));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("maxTasks", 5);
        parameters.put("workerId", "aWorkerId");
        parameters.put("usePriority", true);
        HashMap<String, Object> topicParameter = new HashMap<String, Object>();
        topicParameter.put("topicName", "aTopicName");
        topicParameter.put("processDefinitionId", "aProcessDefinitionId");
        topicParameter.put("processDefinitionIdIn", Arrays.asList("aProcessDefinitionId"));
        topicParameter.put("processDefinitionKey", "aKey");
        topicParameter.put("processDefinitionKeyIn", Arrays.asList("aKey"));
        topicParameter.put("lockDuration", 12354L);
        parameters.put("topics", Arrays.asList(topicParameter));
        this.executePost(parameters);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
        ((ExternalTaskService)inOrder.verify((Object)this.externalTaskService)).fetchAndLock(5, "aWorkerId", true);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).topic("aTopicName", 12354L);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).processDefinitionId("aProcessDefinitionId");
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).processDefinitionIdIn(new String[]{"aProcessDefinitionId"});
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).processDefinitionKey("aKey");
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).processDefinitionKeyIn(new String[]{"aKey"});
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
    }

    @Test
    public void testFetchAndLockWithVariableValue() {
        Mockito.when((Object)this.fetchTopicBuilder.execute()).thenReturn(Arrays.asList(this.lockedExternalTaskMock));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("maxTasks", 5);
        parameters.put("workerId", "aWorkerId");
        parameters.put("usePriority", true);
        HashMap<String, Object> topicParameter = new HashMap<String, Object>();
        topicParameter.put("topicName", "aTopicName");
        topicParameter.put("businessKey", "aBusinessKey");
        topicParameter.put("lockDuration", 12354L);
        topicParameter.put("variables", Arrays.asList("aVariableInstanceName"));
        HashMap<String, Object> variableValueParameter = new HashMap<String, Object>();
        variableValueParameter.put("aVariableInstanceName", MockProvider.EXAMPLE_PRIMITIVE_VARIABLE_VALUE.getValue());
        topicParameter.put("processVariables", variableValueParameter);
        parameters.put("topics", Arrays.asList(topicParameter));
        this.executePost(parameters);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
        ((ExternalTaskService)inOrder.verify((Object)this.externalTaskService)).fetchAndLock(5, "aWorkerId", true);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).topic("aTopicName", 12354L);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).businessKey("aBusinessKey");
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).variables(Arrays.asList("aVariableInstanceName"));
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).processInstanceVariableEquals(variableValueParameter);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
    }

    @Test
    public void testFetchWithoutVariables() {
        Mockito.when((Object)this.fetchTopicBuilder.execute()).thenReturn(Arrays.asList(this.lockedExternalTaskMock));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("maxTasks", 5);
        parameters.put("workerId", "aWorkerId");
        HashMap<String, Object> topicParameter = new HashMap<String, Object>();
        topicParameter.put("topicName", "aTopicName");
        topicParameter.put("lockDuration", 12354L);
        parameters.put("topics", Arrays.asList(topicParameter));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("[0].id", CoreMatchers.equalTo((Object)"anExternalTaskId"), new Object[0]).when().post(FETCH_EXTERNAL_TASK_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
        ((ExternalTaskService)inOrder.verify((Object)this.externalTaskService)).fetchAndLock(5, "aWorkerId", false);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).topic("aTopicName", 12354L);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
    }

    @Test
    public void testFetchAndLockWithTenant() {
        Mockito.when((Object)this.fetchTopicBuilder.execute()).thenReturn(Arrays.asList(this.lockedExternalTaskMock));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("maxTasks", 5);
        parameters.put("workerId", "aWorkerId");
        parameters.put("usePriority", true);
        HashMap<String, Object> topicParameter = new HashMap<String, Object>();
        topicParameter.put("topicName", "aTopicName");
        topicParameter.put("withoutTenantId", true);
        topicParameter.put("tenantId", "tenant1");
        topicParameter.put("tenantIdIn", Arrays.asList("tenant2"));
        topicParameter.put("lockDuration", 12354L);
        parameters.put("topics", Arrays.asList(topicParameter));
        this.executePost(parameters);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
        ((ExternalTaskService)inOrder.verify((Object)this.externalTaskService)).fetchAndLock(5, "aWorkerId", true);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).topic("aTopicName", 12354L);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).withoutTenantId();
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).tenantIdIn(new String[]{"tenant2"});
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
    }

    @Test
    public void testFetchAndLockByProcessDefinitionVersionTag() {
        Mockito.when((Object)this.fetchTopicBuilder.execute()).thenReturn(Arrays.asList(this.lockedExternalTaskMock));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("maxTasks", 5);
        parameters.put("workerId", "aWorkerId");
        HashMap<String, Object> topicParameter = new HashMap<String, Object>();
        topicParameter.put("topicName", "aTopicName");
        topicParameter.put("lockDuration", 12354L);
        topicParameter.put("processDefinitionVersionTag", "versionTag");
        parameters.put("topics", Arrays.asList(topicParameter));
        this.executePost(parameters);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
        ((ExternalTaskService)inOrder.verify((Object)this.externalTaskService)).fetchAndLock(5, "aWorkerId", false);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).topic("aTopicName", 12354L);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).processDefinitionVersionTag("versionTag");
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
    }

    @Test
    public void testFetchAndLockIncludeExtensionProperties() {
        Mockito.when((Object)this.fetchTopicBuilder.execute()).thenReturn(Arrays.asList(this.lockedExternalTaskMock));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("maxTasks", 5);
        parameters.put("workerId", "aWorkerId");
        HashMap<String, Object> topicParameter = new HashMap<String, Object>();
        topicParameter.put("topicName", "aTopicName");
        topicParameter.put("lockDuration", 12354L);
        topicParameter.put("includeExtensionProperties", true);
        parameters.put("topics", Arrays.asList(topicParameter));
        this.executePost(parameters);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
        ((ExternalTaskService)inOrder.verify((Object)this.externalTaskService)).fetchAndLock(5, "aWorkerId", false);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).topic("aTopicName", 12354L);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).includeExtensionProperties();
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
    }

    @Test
    public void testEnableCustomObjectDeserialization() {
        Mockito.when((Object)this.fetchTopicBuilder.execute()).thenReturn(Arrays.asList(this.lockedExternalTaskMock));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("maxTasks", 5);
        parameters.put("workerId", "aWorkerId");
        HashMap<String, Object> topicParameter = new HashMap<String, Object>();
        topicParameter.put("topicName", "aTopicName");
        topicParameter.put("lockDuration", 12354L);
        topicParameter.put("variables", Arrays.asList("aVariableInstanceName"));
        topicParameter.put("deserializeValues", true);
        parameters.put("topics", Arrays.asList(topicParameter));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(FETCH_EXTERNAL_TASK_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
        ((ExternalTaskService)inOrder.verify((Object)this.externalTaskService)).fetchAndLock(5, "aWorkerId", false);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).topic("aTopicName", 12354L);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).variables(Arrays.asList("aVariableInstanceName"));
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).enableCustomObjectDeserialization();
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
    }

    @Test
    public void testLocalVariables() {
        Mockito.when((Object)this.fetchTopicBuilder.execute()).thenReturn(Arrays.asList(this.lockedExternalTaskMock));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("maxTasks", 5);
        parameters.put("workerId", "aWorkerId");
        HashMap<String, Object> topicParameter = new HashMap<String, Object>();
        topicParameter.put("topicName", "aTopicName");
        topicParameter.put("lockDuration", 12354L);
        topicParameter.put("variables", Arrays.asList("aVariableInstanceName"));
        topicParameter.put("localVariables", true);
        parameters.put("topics", Arrays.asList(topicParameter));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(FETCH_EXTERNAL_TASK_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
        ((ExternalTaskService)inOrder.verify((Object)this.externalTaskService)).fetchAndLock(5, "aWorkerId", false);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).topic("aTopicName", 12354L);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).variables(Arrays.asList("aVariableInstanceName"));
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).localVariables();
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
    }

    @Test
    public void testComplete() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("workerId", "aWorkerId");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(COMPLETE_EXTERNAL_TASK_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).complete("anExternalTaskId", "aWorkerId", null, null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testCompleteWithVariables() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("workerId", "aWorkerId");
        Map<String, Object> variables = VariablesBuilder.create().variable("var1", "val1").variable("var2", (Object)"val2", "String").variable("var3", ValueType.OBJECT.getName(), "val3", "aFormat", "aRootType").getVariables();
        parameters.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(COMPLETE_EXTERNAL_TASK_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).complete((String)Matchers.eq((Object)"anExternalTaskId"), (String)Matchers.eq((Object)"aWorkerId"), (Map)Matchers.argThat((Matcher)EqualsVariableMap.matches().matcher("var1", (Matcher<?>)EqualsUntypedValue.matcher().value("val1")).matcher("var2", (Matcher<?>)EqualsPrimitiveValue.stringValue("val2")).matcher("var3", (Matcher<?>)((EqualsObjectValue)((Object)EqualsObjectValue.objectValueMatcher().type((ValueType)ValueType.OBJECT))).serializedValue("val3").serializationFormat("aFormat").objectTypeName("aRootType"))), (Map)Matchers.eq((Object)null));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testCompleteWithLocalVariables() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("workerId", "aWorkerId");
        Map<String, Object> variables = VariablesBuilder.create().variable("var1", "val1").variable("var2", (Object)"val2", "String").variable("var3", ValueType.OBJECT.getName(), "val3", "aFormat", "aRootType").getVariables();
        parameters.put("localVariables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(COMPLETE_EXTERNAL_TASK_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).complete((String)Matchers.eq((Object)"anExternalTaskId"), (String)Matchers.eq((Object)"aWorkerId"), (Map)Matchers.eq((Object)null), (Map)Matchers.argThat((Matcher)EqualsVariableMap.matches().matcher("var1", (Matcher<?>)EqualsUntypedValue.matcher().value("val1")).matcher("var2", (Matcher<?>)EqualsPrimitiveValue.stringValue("val2")).matcher("var3", (Matcher<?>)((EqualsObjectValue)((Object)EqualsObjectValue.objectValueMatcher().type((ValueType)ValueType.OBJECT))).serializedValue("val3").serializationFormat("aFormat").objectTypeName("aRootType"))));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testCompleteNonExistingTask() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new NotFoundException()).when((Object)this.externalTaskService)).complete((String)Matchers.any(String.class), (String)Matchers.any(String.class), Matchers.anyMapOf(String.class, Object.class), Matchers.anyMapOf(String.class, Object.class));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("workerId", "aWorkerId");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", CoreMatchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"External task with id anExternalTaskId does not exist"), new Object[0]).when().post(COMPLETE_EXTERNAL_TASK_URL, new Object[0]);
    }

    @Test
    public void testCompleteThrowsAuthorizationException() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new AuthorizationException("aMessage")).when((Object)this.externalTaskService)).complete((String)Matchers.any(String.class), (String)Matchers.any(String.class), Matchers.anyMapOf(String.class, Object.class), Matchers.anyMapOf(String.class, Object.class));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("workerId", "aWorkerId");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"aMessage"), new Object[0]).when().post(COMPLETE_EXTERNAL_TASK_URL, new Object[0]);
    }

    @Test
    public void testCompleteThrowsBadUserRequestException() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new BadUserRequestException("aMessage")).when((Object)this.externalTaskService)).complete((String)Matchers.any(String.class), (String)Matchers.any(String.class), Matchers.anyMapOf(String.class, Object.class), Matchers.anyMapOf(String.class, Object.class));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("workerId", "aWorkerId");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"aMessage"), new Object[0]).when().post(COMPLETE_EXTERNAL_TASK_URL, new Object[0]);
    }

    @Test
    public void testUnlock() {
        RestAssured.given().pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(UNLOCK_EXTERNAL_TASK_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).unlock("anExternalTaskId");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testUnlockNonExistingTask() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new NotFoundException()).when((Object)this.externalTaskService)).unlock((String)Matchers.any(String.class));
        RestAssured.given().pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", CoreMatchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"External task with id anExternalTaskId does not exist"), new Object[0]).when().post(UNLOCK_EXTERNAL_TASK_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).unlock("anExternalTaskId");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testUnlockThrowsAuthorizationException() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new AuthorizationException("aMessage")).when((Object)this.externalTaskService)).unlock((String)Matchers.any(String.class));
        RestAssured.given().pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"aMessage"), new Object[0]).when().post(UNLOCK_EXTERNAL_TASK_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).unlock("anExternalTaskId");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testGetErrorDetails() {
        RestAssured.given().pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().get(GET_EXTERNAL_TASK_ERROR_DETAILS_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).getExternalTaskErrorDetails("anExternalTaskId");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testGetErrorDetailsNonExistingTask() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new NotFoundException()).when((Object)this.externalTaskService)).getExternalTaskErrorDetails((String)Matchers.any(String.class));
        RestAssured.given().pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", CoreMatchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"External task with id anExternalTaskId does not exist"), new Object[0]).when().get(GET_EXTERNAL_TASK_ERROR_DETAILS_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).getExternalTaskErrorDetails("anExternalTaskId");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testGetErrorDetailsThrowsAuthorizationException() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new AuthorizationException("aMessage")).when((Object)this.externalTaskService)).getExternalTaskErrorDetails((String)Matchers.any(String.class));
        RestAssured.given().pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"aMessage"), new Object[0]).when().get(GET_EXTERNAL_TASK_ERROR_DETAILS_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).getExternalTaskErrorDetails("anExternalTaskId");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testHandleFailure() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("workerId", "aWorkerId");
        parameters.put("errorMessage", "anErrorMessage");
        parameters.put("retries", 5);
        parameters.put("retryTimeout", 12345);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(HANDLE_EXTERNAL_TASK_FAILURE_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).handleFailure("anExternalTaskId", "aWorkerId", "anErrorMessage", null, 5, 12345L, null, null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testHandleFailureWithStackTrace() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("workerId", "aWorkerId");
        parameters.put("errorMessage", "anErrorMessage");
        parameters.put("errorDetails", "aStackTrace");
        parameters.put("retries", 5);
        parameters.put("retryTimeout", 12345);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(HANDLE_EXTERNAL_TASK_FAILURE_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).handleFailure("anExternalTaskId", "aWorkerId", "anErrorMessage", "aStackTrace", 5, 12345L, null, null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testHandleFailureNonExistingTask() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new NotFoundException()).when((Object)this.externalTaskService)).handleFailure((String)Matchers.any(String.class), (String)Matchers.any(String.class), (String)Matchers.any(String.class), (String)Matchers.any(String.class), Matchers.anyInt(), Matchers.anyLong(), Matchers.anyMap(), Matchers.anyMap());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("workerId", "aWorkerId");
        parameters.put("errorMessage", "anErrorMessage");
        parameters.put("retries", 5);
        parameters.put("retryTimeout", 12345);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", CoreMatchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"External task with id anExternalTaskId does not exist"), new Object[0]).when().post(HANDLE_EXTERNAL_TASK_FAILURE_URL, new Object[0]);
    }

    @Test
    public void testHandleFailureThrowsAuthorizationException() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new AuthorizationException("aMessage")).when((Object)this.externalTaskService)).handleFailure((String)Matchers.any(String.class), (String)Matchers.any(String.class), (String)Matchers.any(String.class), (String)Matchers.any(String.class), Matchers.anyInt(), Matchers.anyLong(), Matchers.anyMap(), Matchers.anyMap());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("workerId", "aWorkerId");
        parameters.put("errorMessage", "anErrorMessage");
        parameters.put("retries", 5);
        parameters.put("retryTimeout", 12345);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"aMessage"), new Object[0]).when().post(HANDLE_EXTERNAL_TASK_FAILURE_URL, new Object[0]);
    }

    @Test
    public void testHandleFailureThrowsBadUserRequestException() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new BadUserRequestException("aMessage")).when((Object)this.externalTaskService)).handleFailure((String)Matchers.any(String.class), (String)Matchers.any(String.class), (String)Matchers.any(String.class), (String)Matchers.any(String.class), Matchers.anyInt(), Matchers.anyLong(), Matchers.anyMap(), Matchers.anyMap());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("workerId", "aWorkerId");
        parameters.put("errorMessage", "anErrorMessage");
        parameters.put("retries", 5);
        parameters.put("retryTimeout", 12345);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"aMessage"), new Object[0]).when().post(HANDLE_EXTERNAL_TASK_FAILURE_URL, new Object[0]);
    }

    @Test
    public void testHandleFailureWithVariables() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("workerId", "aWorkerId");
        parameters.put("errorMessage", "anErrorMessage");
        parameters.put("retries", 5);
        parameters.put("retryTimeout", 12345);
        Map<String, Object> variables = VariablesBuilder.create().variable("var1", "val1").getVariables();
        parameters.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(HANDLE_EXTERNAL_TASK_FAILURE_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).handleFailure((String)Matchers.eq((Object)"anExternalTaskId"), (String)Matchers.eq((Object)"aWorkerId"), (String)Matchers.eq((Object)"anErrorMessage"), (String)Matchers.eq(null), Matchers.eq((int)5), Matchers.eq((long)12345L), (Map)Matchers.argThat((Matcher)EqualsVariableMap.matches().matcher("var1", (Matcher<?>)EqualsUntypedValue.matcher().value("val1"))), (Map)Matchers.eq((Object)null));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testHandleFailureWithLocalVariables() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("workerId", "aWorkerId");
        parameters.put("errorMessage", "anErrorMessage");
        parameters.put("retries", 5);
        parameters.put("retryTimeout", 12345);
        Map<String, Object> localVariables = VariablesBuilder.create().variable("var1", "val1").getVariables();
        parameters.put("localVariables", localVariables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(HANDLE_EXTERNAL_TASK_FAILURE_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).handleFailure((String)Matchers.eq((Object)"anExternalTaskId"), (String)Matchers.eq((Object)"aWorkerId"), (String)Matchers.eq((Object)"anErrorMessage"), (String)Matchers.eq(null), Matchers.eq((int)5), Matchers.eq((long)12345L), (Map)Matchers.eq((Object)null), (Map)Matchers.argThat((Matcher)EqualsVariableMap.matches().matcher("var1", (Matcher<?>)EqualsUntypedValue.matcher().value("val1"))));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testHandleBpmnError() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("workerId", "aWorkerId");
        parameters.put("errorCode", "anErrorCode");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(HANDLE_EXTERNAL_TASK_BPMN_ERROR_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).handleBpmnError("anExternalTaskId", "aWorkerId", "anErrorCode", null, null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testHandleBpmnErrorWithVariables() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("workerId", "aWorkerId");
        parameters.put("errorCode", "anErrorCode");
        parameters.put("errorMessage", "anErrorMessage");
        Map<String, Object> variables = VariablesBuilder.create().variable("var1", "val1").variable("var2", (Object)"val2", "String").variable("var3", ValueType.OBJECT.getName(), "val3", "aFormat", "aRootType").getVariables();
        parameters.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(HANDLE_EXTERNAL_TASK_BPMN_ERROR_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).handleBpmnError((String)Matchers.eq((Object)"anExternalTaskId"), (String)Matchers.eq((Object)"aWorkerId"), (String)Matchers.eq((Object)"anErrorCode"), (String)Matchers.eq((Object)"anErrorMessage"), (Map)Matchers.argThat((Matcher)EqualsVariableMap.matches().matcher("var1", (Matcher<?>)EqualsUntypedValue.matcher().value("val1")).matcher("var2", (Matcher<?>)EqualsPrimitiveValue.stringValue("val2")).matcher("var3", (Matcher<?>)((EqualsObjectValue)((Object)EqualsObjectValue.objectValueMatcher().type((ValueType)ValueType.OBJECT))).serializedValue("val3").serializationFormat("aFormat").objectTypeName("aRootType"))));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testHandleBpmnErrorNonExistingTask() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new NotFoundException()).when((Object)this.externalTaskService)).handleBpmnError((String)Matchers.any(String.class), (String)Matchers.any(String.class), (String)Matchers.any(String.class), (String)Matchers.any(String.class), Matchers.anyMapOf(String.class, Object.class));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("workerId", "aWorkerId");
        parameters.put("errorCode", "errorCode");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", CoreMatchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"External task with id anExternalTaskId does not exist"), new Object[0]).when().post(HANDLE_EXTERNAL_TASK_BPMN_ERROR_URL, new Object[0]);
    }

    @Test
    public void testHandleBpmnErrorThrowsAuthorizationException() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new AuthorizationException("aMessage")).when((Object)this.externalTaskService)).handleBpmnError((String)Matchers.any(String.class), (String)Matchers.any(String.class), (String)Matchers.any(String.class), (String)Matchers.any(String.class), Matchers.anyMapOf(String.class, Object.class));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("workerId", "aWorkerId");
        parameters.put("errorCode", "errorCode");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"aMessage"), new Object[0]).when().post(HANDLE_EXTERNAL_TASK_BPMN_ERROR_URL, new Object[0]);
    }

    @Test
    public void testHandleBpmnErrorThrowsBadUserRequestException() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new BadUserRequestException("aMessage")).when((Object)this.externalTaskService)).handleBpmnError((String)Matchers.any(String.class), (String)Matchers.any(String.class), (String)Matchers.any(String.class), (String)Matchers.any(String.class), Matchers.anyMapOf(String.class, Object.class));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("workerId", "aWorkerId");
        parameters.put("errorCode", "errorCode");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"aMessage"), new Object[0]).when().post(HANDLE_EXTERNAL_TASK_BPMN_ERROR_URL, new Object[0]);
    }

    @Test
    public void testSetRetries() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("retries", "5");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(RETRIES_EXTERNAL_TASK_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).setRetries("anExternalTaskId", 5);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testSetRetriesNonExistingTask() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new NotFoundException()).when((Object)this.externalTaskService)).setRetries((String)Matchers.any(String.class), Matchers.anyInt());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("retries", "5");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", CoreMatchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"External task with id anExternalTaskId does not exist"), new Object[0]).when().put(RETRIES_EXTERNAL_TASK_URL, new Object[0]);
    }

    @Test
    public void testSetRetriesThrowsAuthorizationException() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new AuthorizationException("aMessage")).when((Object)this.externalTaskService)).setRetries((String)Matchers.any(String.class), Matchers.anyInt());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("retries", "5");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"aMessage"), new Object[0]).when().put(RETRIES_EXTERNAL_TASK_URL, new Object[0]);
    }

    @Test
    public void testSetPriority() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("priority", "5");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(PRIORITY_EXTERNAL_TASK_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).setPriority("anExternalTaskId", 5L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testSetPriorityNonExistingTask() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new NotFoundException()).when((Object)this.externalTaskService)).setPriority((String)Matchers.any(String.class), (long)Matchers.anyInt());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("priority", "5");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", CoreMatchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"External task with id anExternalTaskId does not exist"), new Object[0]).when().put(PRIORITY_EXTERNAL_TASK_URL, new Object[0]);
    }

    @Test
    public void testSetPriorityThrowsAuthorizationException() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new AuthorizationException("aMessage")).when((Object)this.externalTaskService)).setPriority((String)Matchers.any(String.class), (long)Matchers.anyInt());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("priority", "5");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"aMessage"), new Object[0]).when().put(PRIORITY_EXTERNAL_TASK_URL, new Object[0]);
    }

    @Test
    public void testGetSingleExternalTask() {
        Mockito.when((Object)((ExternalTask)this.externalTaskQueryMock.singleResult())).thenReturn((Object)this.externalTaskMock);
        RestAssured.given().pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("activityId", CoreMatchers.equalTo((Object)"anActivity"), new Object[0]).body("activityInstanceId", CoreMatchers.equalTo((Object)"anActivityInstanceId"), new Object[0]).body("errorMessage", CoreMatchers.equalTo((Object)"some error"), new Object[0]).body("executionId", CoreMatchers.equalTo((Object)"anExecutionId"), new Object[0]).body("id", CoreMatchers.equalTo((Object)"anExternalTaskId"), new Object[0]).body("lockExpirationTime", CoreMatchers.equalTo((Object)MockProvider.EXTERNAL_TASK_LOCK_EXPIRATION_TIME), new Object[0]).body("processDefinitionId", CoreMatchers.equalTo((Object)"aProcDefId"), new Object[0]).body("processDefinitionKey", CoreMatchers.equalTo((Object)"aKey"), new Object[0]).body("processInstanceId", CoreMatchers.equalTo((Object)"aProcInstId"), new Object[0]).body("retries", CoreMatchers.equalTo((Object)MockProvider.EXTERNAL_TASK_RETRIES), new Object[0]).body("suspended", CoreMatchers.equalTo((Object)true), new Object[0]).body("topicName", CoreMatchers.equalTo((Object)"aTopic"), new Object[0]).body("workerId", CoreMatchers.equalTo((Object)"aWorkerId"), new Object[0]).body("tenantId", CoreMatchers.equalTo((Object)"aTenantId"), new Object[0]).body("priority", CoreMatchers.equalTo((Object)2147484113L), new Object[0]).body("businessKey", CoreMatchers.equalTo((Object)"aKey"), new Object[0]).when().get(SINGLE_EXTERNAL_TASK_URL, new Object[0]);
    }

    @Test
    public void testGetNonExistingExternalTask() {
        Mockito.when((Object)((ExternalTask)this.externalTaskQueryMock.singleResult())).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", CoreMatchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"External task with id anExternalTaskId does not exist"), new Object[0]).when().get(SINGLE_EXTERNAL_TASK_URL, new Object[0]);
    }

    @Test
    public void testSetRetriesForExternalTasksAsync() {
        List<String> externalTaskIds = Arrays.asList("externalTaskId1", "externalTaskId2");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("retries", "5");
        parameters.put("externalTaskIds", externalTaskIds);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(RETRIES_EXTERNAL_TASKS_ASYNC_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).updateRetries();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).externalTaskIds(externalTaskIds);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).processInstanceIds((List)null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).externalTaskQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).processInstanceQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).historicProcessInstanceQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).setAsync(5);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.updateRetriesBuilder});
    }

    @Test
    public void testSetRetriesForExternalTasksSync() {
        List<String> externalTaskIds = Arrays.asList("externalTaskId1", "externalTaskId2");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("retries", "5");
        parameters.put("externalTaskIds", externalTaskIds);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(RETRIES_EXTERNAL_TASKS_ASYNC_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).updateRetries();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).externalTaskIds(externalTaskIds);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).processInstanceIds((List)null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).externalTaskQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).processInstanceQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).historicProcessInstanceQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).setAsync(5);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.updateRetriesBuilder});
    }

    @Test
    public void testSetRetriesForExternalTasksAsyncByProcessInstanceIds() {
        List<String> processInstanceIds = Arrays.asList("123", "456");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("retries", "5");
        parameters.put("processInstanceIds", processInstanceIds);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(RETRIES_EXTERNAL_TASKS_ASYNC_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).updateRetries();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).externalTaskIds((List)null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).processInstanceIds(processInstanceIds);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).externalTaskQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).processInstanceQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).historicProcessInstanceQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).setAsync(5);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.updateRetriesBuilder});
    }

    @Test
    public void testSetRetriesForExternalTasksSyncByProcessInstanceIds() {
        List<String> processInstanceIds = Arrays.asList("123", "456");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("retries", "5");
        parameters.put("processInstanceIds", processInstanceIds);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(RETRIES_EXTERNAL_TASK_SYNC_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).updateRetries();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).externalTaskIds((List)null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).processInstanceIds(processInstanceIds);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).externalTaskQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).processInstanceQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).historicProcessInstanceQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).set(5);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.updateRetriesBuilder});
    }

    @Test
    public void testSetRetriesForExternalTasksWithNullExternalTaskIdsAsync() {
        ((UpdateExternalTaskRetriesBuilder)Mockito.doThrow(BadUserRequestException.class).when((Object)this.updateRetriesBuilder)).setAsync(Matchers.anyInt());
        List externalTaskIds = null;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("retries", "5");
        parameters.put("externalTaskIds", externalTaskIds);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(RETRIES_EXTERNAL_TASKS_ASYNC_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).updateRetries();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).externalTaskIds(externalTaskIds);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).processInstanceIds((List)null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).externalTaskQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).processInstanceQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).historicProcessInstanceQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).setAsync(5);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.updateRetriesBuilder});
    }

    @Test
    public void testSetNegativeRetriesForExternalTasksAsync() {
        ((UpdateExternalTaskRetriesBuilder)Mockito.doThrow(BadUserRequestException.class).when((Object)this.updateRetriesBuilder)).setAsync(Matchers.anyInt());
        List externalTaskIds = null;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("retries", "-5");
        parameters.put("externalTaskIds", externalTaskIds);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(RETRIES_EXTERNAL_TASKS_ASYNC_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).updateRetries();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).externalTaskIds(externalTaskIds);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).processInstanceIds((List)null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).externalTaskQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).processInstanceQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).historicProcessInstanceQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).setAsync(-5);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.updateRetriesBuilder});
    }

    @Test
    public void testSetNullRetriesForExternalTasks() {
        Object externalTaskIds = null;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("retries", null);
        parameters.put("externalTaskIds", externalTaskIds);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().put(RETRIES_EXTERNAL_TASK_SYNC_URL, new Object[0]);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder, (VerificationMode)Mockito.never())).set(Matchers.anyInt());
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(RETRIES_EXTERNAL_TASKS_ASYNC_URL, new Object[0]);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder, (VerificationMode)Mockito.never())).setAsync(Matchers.anyInt());
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().put(RETRIES_EXTERNAL_TASK_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService, (VerificationMode)Mockito.never())).setRetries(Matchers.anyString(), Matchers.anyInt());
    }

    @Test
    public void testSetRetriesForExternalTasksAsyncWithProcessInstanceQuery() {
        Mockito.when((Object)this.runtimeServiceMock.createProcessInstanceQuery()).thenReturn((Object)new ProcessInstanceQueryImpl());
        ProcessInstanceQueryDto processInstanceQuery = new ProcessInstanceQueryDto();
        processInstanceQuery.setProcessDefinitionId("aProcessDefinitionId");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("retries", "5");
        parameters.put("processInstanceQuery", (String)processInstanceQuery);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(RETRIES_EXTERNAL_TASKS_ASYNC_URL, new Object[0]);
        ArgumentCaptor queryCapture = ArgumentCaptor.forClass(ProcessInstanceQuery.class);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).updateRetries();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).externalTaskIds((List)null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).processInstanceIds((List)null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).externalTaskQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).processInstanceQuery((ProcessInstanceQuery)queryCapture.capture());
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).historicProcessInstanceQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).setAsync(5);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.updateRetriesBuilder});
        ProcessInstanceQueryImpl actualQuery = (ProcessInstanceQueryImpl)queryCapture.getValue();
        Assertions.assertThat((Object)actualQuery).isNotNull();
        Assertions.assertThat((String)actualQuery.getProcessDefinitionId()).isEqualTo((Object)"aProcessDefinitionId");
    }

    @Test
    public void testSetRetriesForExternalTasksAsyncWithHistoricProcessInstanceQuery() {
        Mockito.when((Object)this.historyServiceMock.createHistoricProcessInstanceQuery()).thenReturn((Object)new HistoricProcessInstanceQueryImpl());
        HistoricProcessInstanceQueryDto query = new HistoricProcessInstanceQueryDto();
        query.setProcessDefinitionId("aProcessDefinitionId");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("retries", "5");
        parameters.put("historicProcessInstanceQuery", (String)query);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(RETRIES_EXTERNAL_TASKS_ASYNC_URL, new Object[0]);
        ArgumentCaptor queryCapture = ArgumentCaptor.forClass(HistoricProcessInstanceQuery.class);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).updateRetries();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).externalTaskIds((List)null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).processInstanceIds((List)null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).externalTaskQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).processInstanceQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).historicProcessInstanceQuery((HistoricProcessInstanceQuery)queryCapture.capture());
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).setAsync(5);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.updateRetriesBuilder});
        HistoricProcessInstanceQueryImpl actualQuery = (HistoricProcessInstanceQueryImpl)queryCapture.getValue();
        Assertions.assertThat((Object)actualQuery).isNotNull();
        Assertions.assertThat((String)actualQuery.getProcessDefinitionId()).isEqualTo((Object)"aProcessDefinitionId");
    }

    @Test
    public void testSetRetriesWithProcessInstanceQuery() {
        Mockito.when((Object)this.runtimeServiceMock.createProcessInstanceQuery()).thenReturn((Object)new ProcessInstanceQueryImpl());
        ProcessInstanceQueryDto processInstanceQuery = new ProcessInstanceQueryDto();
        processInstanceQuery.setProcessDefinitionId("aProcessDefinitionId");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("retries", "5");
        parameters.put("processInstanceQuery", (String)processInstanceQuery);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(RETRIES_EXTERNAL_TASK_SYNC_URL, new Object[0]);
        ArgumentCaptor queryCapture = ArgumentCaptor.forClass(ProcessInstanceQuery.class);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).updateRetries();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).externalTaskIds((List)null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).processInstanceIds((List)null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).externalTaskQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).processInstanceQuery((ProcessInstanceQuery)queryCapture.capture());
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).historicProcessInstanceQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).set(5);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.updateRetriesBuilder});
        ProcessInstanceQueryImpl actualQuery = (ProcessInstanceQueryImpl)queryCapture.getValue();
        Assertions.assertThat((Object)actualQuery).isNotNull();
        Assertions.assertThat((String)actualQuery.getProcessDefinitionId()).isEqualTo((Object)"aProcessDefinitionId");
    }

    @Test
    public void testSetRetriesWithHistoricProcessInstanceQuery() {
        Mockito.when((Object)this.historyServiceMock.createHistoricProcessInstanceQuery()).thenReturn((Object)new HistoricProcessInstanceQueryImpl());
        HistoricProcessInstanceQueryDto query = new HistoricProcessInstanceQueryDto();
        query.setProcessDefinitionId("aProcessDefinitionId");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("retries", "5");
        parameters.put("historicProcessInstanceQuery", (String)query);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(RETRIES_EXTERNAL_TASK_SYNC_URL, new Object[0]);
        ArgumentCaptor queryCapture = ArgumentCaptor.forClass(HistoricProcessInstanceQuery.class);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).updateRetries();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).externalTaskIds((List)null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).processInstanceIds((List)null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).externalTaskQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).processInstanceQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).historicProcessInstanceQuery((HistoricProcessInstanceQuery)queryCapture.capture());
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).set(5);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.updateRetriesBuilder});
        HistoricProcessInstanceQueryImpl actualQuery = (HistoricProcessInstanceQueryImpl)queryCapture.getValue();
        Assertions.assertThat((Object)actualQuery).isNotNull();
        Assertions.assertThat((String)actualQuery.getProcessDefinitionId()).isEqualTo((Object)"aProcessDefinitionId");
    }

    @Test
    public void testSetRetriesSyncWithExternalTaskQuery() {
        Mockito.when((Object)this.externalTaskService.createExternalTaskQuery()).thenReturn((Object)new ExternalTaskQueryImpl());
        ExternalTaskQueryDto query = new ExternalTaskQueryDto();
        query.setProcessDefinitionId("aProcessDefinitionId");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("retries", "5");
        parameters.put("externalTaskQuery", (String)query);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(RETRIES_EXTERNAL_TASK_SYNC_URL, new Object[0]);
        ArgumentCaptor queryCapture = ArgumentCaptor.forClass(ExternalTaskQuery.class);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).updateRetries();
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).createExternalTaskQuery();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).externalTaskIds((List)null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).processInstanceIds((List)null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).externalTaskQuery((ExternalTaskQuery)queryCapture.capture());
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).processInstanceQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).historicProcessInstanceQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).set(5);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.updateRetriesBuilder});
        ExternalTaskQueryImpl actualQuery = (ExternalTaskQueryImpl)queryCapture.getValue();
        Assertions.assertThat((Object)actualQuery).isNotNull();
        Assertions.assertThat((String)actualQuery.getProcessDefinitionId()).isEqualTo((Object)"aProcessDefinitionId");
    }

    @Test
    public void testSetRetriesAsyncWithExternalTaskQuery() {
        Mockito.when((Object)this.externalTaskService.createExternalTaskQuery()).thenReturn((Object)new ExternalTaskQueryImpl());
        ExternalTaskQueryDto query = new ExternalTaskQueryDto();
        query.setProcessDefinitionId("aProcessDefinitionId");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("retries", "5");
        parameters.put("externalTaskQuery", (String)query);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(RETRIES_EXTERNAL_TASKS_ASYNC_URL, new Object[0]);
        ArgumentCaptor queryCapture = ArgumentCaptor.forClass(ExternalTaskQuery.class);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).updateRetries();
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).createExternalTaskQuery();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).externalTaskIds((List)null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).processInstanceIds((List)null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).externalTaskQuery((ExternalTaskQuery)queryCapture.capture());
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).processInstanceQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).historicProcessInstanceQuery(null);
        ((UpdateExternalTaskRetriesBuilder)Mockito.verify((Object)this.updateRetriesBuilder)).setAsync(5);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.updateRetriesBuilder});
        ExternalTaskQueryImpl actualQuery = (ExternalTaskQueryImpl)queryCapture.getValue();
        Assertions.assertThat((Object)actualQuery).isNotNull();
        Assertions.assertThat((String)actualQuery.getProcessDefinitionId()).isEqualTo((Object)"aProcessDefinitionId");
    }

    @Test
    public void shouldLockExternalTask() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("workerId", "workerId");
        parameters.put("lockDuration", "1000");
        RestAssured.given().pathParam("id", (Object)"anExternalTaskId").contentType(ContentType.JSON).body(parameters).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(LOCK_EXTERNAL_TASK, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).lock("anExternalTaskId", "workerId", 1000L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void shouldFailOnLockExternalTaskWithNegativeLockDuration() {
        ((ExternalTaskService)Mockito.doThrow(BadUserRequestException.class).when((Object)this.externalTaskService)).lock(Matchers.anyString(), Matchers.anyString(), Matchers.anyLong());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("workerId", "workerId");
        parameters.put("lockDuration", -1);
        RestAssured.given().pathParam("id", (Object)"anExternalTaskId").contentType(ContentType.JSON).body(parameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(LOCK_EXTERNAL_TASK, new Object[0]);
    }

    @Test
    public void shouldFailToLockNonexistentExternalTask() {
        ((ExternalTaskService)Mockito.doThrow(NotFoundException.class).when((Object)this.externalTaskService)).lock(Matchers.anyString(), Matchers.anyString(), Matchers.anyLong());
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("workerId", "workerId");
        json.put("lockDuration", 1000);
        RestAssured.given().pathParam("id", (Object)"anExternalTaskId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).when().post(LOCK_EXTERNAL_TASK, new Object[0]);
    }

    @Test
    public void shouldExtendLockOnExternalTask() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("workerId", "workerId");
        parameters.put("newDuration", "1000");
        this.validateExtendLockRequest(parameters, Response.Status.NO_CONTENT.getStatusCode());
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).extendLock("anExternalTaskId", "workerId", 1000L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void shouldFailOnExtendLockOnExternalTaskWithNegativeNewDuration() {
        ((ExternalTaskService)Mockito.doThrow(BadUserRequestException.class).when((Object)this.externalTaskService)).extendLock(Matchers.anyString(), Matchers.anyString(), Matchers.anyLong());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("workerId", "workerId");
        parameters.put("newDuration", -1);
        this.validateExtendLockRequest(parameters, Response.Status.BAD_REQUEST.getStatusCode());
    }

    @Test
    public void shouldFailToExtendLockOnNonexistentExternalTask() {
        ((ExternalTaskService)Mockito.doThrow(NotFoundException.class).when((Object)this.externalTaskService)).extendLock(Matchers.anyString(), Matchers.anyString(), Matchers.anyLong());
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("workerId", "workerId");
        json.put("newDuration", 1000);
        this.validateExtendLockRequest(json, Response.Status.NOT_FOUND.getStatusCode());
    }

    protected void validateExtendLockRequest(Map json, int statusCode) {
        RestAssured.given().pathParam("id", (Object)"anExternalTaskId").contentType(ContentType.JSON).body((Object)json).then().expect().statusCode(statusCode).when().post(EXTEND_LOCK_ON_EXTERNAL_TASK, new Object[0]);
    }

    protected void executePost(Map<String, Object> parameters) {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("[0].id", CoreMatchers.equalTo((Object)"anExternalTaskId"), new Object[0]).body("[0].topicName", CoreMatchers.equalTo((Object)"aTopic"), new Object[0]).body("[0].workerId", CoreMatchers.equalTo((Object)"aWorkerId"), new Object[0]).body("[0].lockExpirationTime", CoreMatchers.equalTo((Object)MockProvider.EXTERNAL_TASK_LOCK_EXPIRATION_TIME), new Object[0]).body("[0].processInstanceId", CoreMatchers.equalTo((Object)"aProcInstId"), new Object[0]).body("[0].executionId", CoreMatchers.equalTo((Object)"anExecutionId"), new Object[0]).body("[0].activityId", CoreMatchers.equalTo((Object)"anActivity"), new Object[0]).body("[0].activityInstanceId", CoreMatchers.equalTo((Object)"anActivityInstanceId"), new Object[0]).body("[0].processDefinitionId", CoreMatchers.equalTo((Object)"aProcDefId"), new Object[0]).body("[0].processDefinitionKey", CoreMatchers.equalTo((Object)"aKey"), new Object[0]).body("[0].tenantId", CoreMatchers.equalTo((Object)"aTenantId"), new Object[0]).body("[0].retries", CoreMatchers.equalTo((Object)MockProvider.EXTERNAL_TASK_RETRIES), new Object[0]).body("[0].errorMessage", CoreMatchers.equalTo((Object)"some error"), new Object[0]).body("[0].priority", CoreMatchers.equalTo((Object)2147484113L), new Object[0]).body("[0].variables.aVariableInstanceName", org.hamcrest.Matchers.notNullValue(), new Object[0]).body("[0].variables.aVariableInstanceName.value", CoreMatchers.equalTo((Object)((String)MockProvider.EXAMPLE_PRIMITIVE_VARIABLE_VALUE.getValue())), new Object[0]).body("[0].variables.aVariableInstanceName.type", CoreMatchers.equalTo((Object)"String"), new Object[0]).when().post(FETCH_EXTERNAL_TASK_URL, new Object[0]);
    }
}

